//
// Timer 0: 1 kHz (1 ms) fr die Abtastung des Encoders
//

#include "timer0.h"

#include <avr/io.h>
#include <avr/interrupt.h>

#include "encoder.h"

void timer0_init(void)
{
  TCCR0 = _BV(WGM01) | _BV(CS01) | _BV(CS00);     // CTC, XTAL / 64
  OCR0 = (uint8_t)(F_CPU / 64000.0 - 0.5);        // 1ms
  TIMSK |= _BV(OCIE0);
}

ISR(TIMER0_COMP_vect)             // 1ms for manual movement
{
  encode_cycle();
}


