
#ifndef _CONFIG_H_
	#define _CONFIG_H_	
	
// Konfiguration des Systems
// -------------------------

	//Taktfrequenz (bei AVR-NET-IO i.d.R. 16MHz
	#define F_CPU 16000000UL	
	
// Netzwerkeinstellungen
// ---------------------
	
	//Default IP des Webservers
	#define MYIP		IP(192,168,0,223)

	//Default Netzwerkmaske
	#define NETMASK		IP(255,255,255,0)

	//Default IP des Routers
	#define ROUTER_IP	IP(192,168,0,1)
	
	//MAC Adresse des Webservers	
	#define MYMAC1	0x00
	#define MYMAC2	0x04
	#define MYMAC3	0xA3
	#define MYMAC4	0x01
	#define MYMAC5	0x11
	#define MYMAC6	0xAA

	//Umrechnung von IP zu unsigned long
	#define IP(a,b,c,d) ((unsigned long)(d)<<24)+((unsigned long)(c)<<16)+((unsigned long)(b)<<8)+a

	//Webserver mit Passwort? (0 == mit Passwort)
	#define HTTP_AUTH_DEFAULT	1

	// AUTH String "USERNAME:PASSWORT" max 14Zeichen
	// fuer Username:Passwort
	#define HTTP_AUTH_STRING "admin:admin"
	
	#define NAMELENGTH 16 
	
	#define NAME1  "Ausgang 1"
	#define NAME2  "Ausgang 2"
	#define NAME3  "Ausgang 3"
	#define NAME4  "Ausgang 4"
	#define NAME5  "Ausgang 5"
	#define NAME6  "Ausgang 6"
	#define NAME7  "Ausgang 7"
	#define NAME8  "Ausgang 8"
	
	//
	#define FLOT	1
	
#endif
