/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich  -  angepasst an AVR-NET-IO durch ** EHB **
 Remarks:
 known Problems: none
 Version:        24.10.2007
 Description:    Webserver Applikation

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der
 GNU General Public License, wie von der Free Software Foundation verffentlicht,
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder
 (nach Ihrer Option) jeder spteren Version.

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 Programm erhalten haben.
 Falls nicht, schreiben Sie an die Free Software Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
------------------------------------------------------------------------------*/
#include "httpd.h"
#include "webpage.h"
#include "stack.h"
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct http_table http_entry[MAX_TCP_ENTRY];

//Hier wird das codierte Passwort aus config.h gespeichert.
unsigned char http_auth_passwort[30];
unsigned char post_in[5] = {'O','U','T','='}; // Start "POST" - Daten
unsigned char post_ready[5] = {'S','U','B','='}; // Ende "POST" -
unsigned char STATUS = 1;
char htm_seite[10];

PROGMEM char http_header1[]={	"HTTP/1.0 200 Document follows\r\n"
								"Server: AVR_Small_Webserver\r\n"
								"Content-Type: text/html\r\n\r\n"};

PROGMEM char http_header2[]={	"HTTP/1.0 200 Document follows\r\n"
								"Server: AVR_Small_Webserver\r\n"
								"Content-Type: image/jpg\r\n\r\n"};

PROGMEM char http_header3[]={	"HTTP/1.0 401 Unauthorized\r\n"
								"Server: AVR_Small_Webserver\r\n"
								"WWW-Authenticate: Basic realm=\"NeedPassword\""
								"\r\nContent-Type: text/html\r\n\r\n"};

//----------------------------------------------------------------------------
//Kein Zugriff Seite bei keinem Passwort
PROGMEM char Page0[] = {"401 Unauthorized%END"};

unsigned char rx_header_end[5] = {"\r\n\r\n\0"};

//----------------------------------------------------------------------------
//Initialisierung des Httpd Testservers
void httpd_init (void)
{
	//HTTP_AUTH_STRING 
	decode_base64((unsigned char*)HTTP_AUTH_STRING,http_auth_passwort);

	//Serverport und Anwendung eintragen
	add_tcp_app (HTTPD_PORT, (void(*)(unsigned char))httpd);
}
   
//----------------------------------------------------------------------------
//http Testserver
void httpd (unsigned char index)
{
    //Verbindung wurde abgebaut!
    if (tcp_entry[index].status & FIN_FLAG)
    {
        return;
    }

	//Allererste Aufruf des Ports fr diese Anwendung
	//HTTPD_Anwendungsstack lschen
	if(tcp_entry[index].app_status==1)
	{
		httpd_stack_clear(index);
	}
	
	//HTTP wurde bei dieser Verbindung zum ersten mal aufgerufen oder
	//HTML Header Retransmission!
	if (tcp_entry[index].app_status <= 2)
	{	
		httpd_header_check (index);
		return;
	}
	
	//Der Header wurde gesendet und mit ACK besttigt (tcp_entry[index].app_status+1)
	//war das HTML Packet fertig, oder mssen weitere Daten gesendet werden, oder Retransmission?
	if (tcp_entry[index].app_status > 2 && tcp_entry[index].app_status < 0xFFFE)
	{
		httpd_data_send (index);
		return;
	}
	
	//Verbindung kann geschlossen werden! Alle HTML Daten wurden gesendet TCP Port kann
	//geschlossen werden (tcp_entry[index].app_status >= 0xFFFE)!!
	if (tcp_entry[index].app_status >= 0xFFFE)
	{
		tcp_entry[index].app_status = 0xFFFE;
		tcp_Port_close(index);
		return;
	}
	return;
}

//----------------------------------------------------------------------------
//HTTPD_STACK lschen
void httpd_stack_clear (unsigned char index)
{
	http_entry[index].http_header_type =0;
	http_entry[index].first_switch = 0;
	http_entry[index].http_auth = HTTP_AUTH_DEFAULT;
	http_entry[index].new_page_pointer = 0;
	http_entry[index].old_page_pointer = 0;
	http_entry[index].post = 0;
	http_entry[index].auth_ptr = http_auth_passwort;
	http_entry[index].post_ptr = post_in; // "OUT" gefunden
	http_entry[index].post_ready_ptr = post_ready; // "SUB" gefunden
	http_entry[index].hdr_end_pointer = rx_header_end;

	return;
}

//----------------------------------------------------------------------------
//Eintreffenden Daten vom Client checken
void httpd_header_check (unsigned char index)
{
	unsigned int a = 0;	// Zhlvariable

	if(strcasestr_P((char*)&eth_buffer[TCP_DATA_START_VAR],PSTR("POST"))!=0) // POST vorhanden?
		{
		http_entry[index].post = 1; // POST enthalten!
		}
	
	//finden der Authorization und das Ende im Header auch ber mehrere Packete hinweg!!	
	if(*http_entry[index].hdr_end_pointer != 0) // Ende-Pointer vorhanden
	{		
		for(a=TCP_DATA_START_VAR;a<(TCP_DATA_END_VAR);a++)
		{	
			if(!http_entry[index].http_auth) // Autorisierung nicht vorhanden?
			{
				if (eth_buffer[a] != *http_entry[index].auth_ptr++)
				{
					http_entry[index].auth_ptr = http_auth_passwort;
				}
				if(*http_entry[index].auth_ptr == 0) 
				{
					http_entry[index].http_auth = 1;
				}
			}
			
			if (eth_buffer[a] != *http_entry[index].hdr_end_pointer++)
			{
				http_entry[index].hdr_end_pointer = rx_header_end;
			}
			
			//Das Headerende wird mit (CR+LF+CR+LF) angezeigt!
			if(*http_entry[index].hdr_end_pointer == 0) 
			{
				break;
			}
		}
	}
	
	//Einzelne Postpacket (z.B. bei firefox)
	if(http_entry[index].http_auth && http_entry[index].post == 1) // Autorisierung + POST OK
	{
		for(a = TCP_DATA_START_VAR;a<(TCP_DATA_END_VAR);a++)
		{	
			//Schaltanweisung finden!
			if (eth_buffer[a] != *http_entry[index].post_ptr++) // "OUT" gefunden ?
			{
				http_entry[index].post_ptr = post_in; // "OUT" gefunden
			}
			
			if(*http_entry[index].post_ptr == 0) // "OUT" gefunden ?
			{
				switch (eth_buffer[a+1])
			  	{
				    case ('A'):						// Ausgang 1
					   	PORTC ^= (1<<PC0);
				    	STATUS ^= (1<<0);
				    break;

				    case ('B'):						// Ausgang 2
						PORTC ^= (1<<PC1);
				    break;
				
				    case ('C'):						// Ausgang 3
						PORTC ^= (1<<PC2);
				    break;
					
					case ('D'):						// Ausgang 4
						PORTC ^= (1<<PC3);
				    break;
					
					case ('E'):						// Ausgang 5
						PORTC ^= (1<<PC4);
				    break;

					case ('F'):						// Ausgang 6
						PORTC ^= (1<<PC5);
				    break;

					case ('G'):						// Ausgang 7
						PORTC ^= (1<<PC6);
				    break;

					case ('H'):						// Ausgang 8
						PORTC ^= (1<<PC7);
				    break;

				} // Ende --> switch (eth_buffer[a+1])

				http_entry[index].post_ptr = post_in; // "OUT" gefunden

				//Schaltanweisung wurde gefunden
			} // Ende --> if(*http_entry[index].post_ptr == 0)

			//Submit schliet die Suche ab!
			if (eth_buffer[a] != *http_entry[index].post_ready_ptr++) // "SUB" gefunden ?
			{
				http_entry[index].post_ready_ptr = post_ready; // "SUB" gefunden
			}

			if(*http_entry[index].post_ready_ptr == 0) // Submit gefunden
			{
				http_entry[index].post = 0;
				break;
			}	// if(*http_entry[index].post_ready_ptr == 0)
		}	// for(a = TCP_DATA_START_VAR;a<(TCP_DATA_END_VAR);a++)
	}	// if(http_entry[index].http_auth && http_entry[index].post == 1)

	//Welche datei wird angefordert? Wird diese in der Flashspeichertabelle gefunden?
	unsigned char page_index = 0;
	
	if (!http_entry[index].new_page_pointer)
	{
		for(a = TCP_DATA_START_VAR+5;a<(TCP_DATA_END_VAR);a++)
		{
			if (eth_buffer[a] == '\r')
			{
				eth_buffer[a] = '\0';
				break;
			}
		}
	
		while(WEBPAGE_TABLE[page_index].filename)
		{
			if (strcasestr((char*)&eth_buffer[TCP_DATA_START_VAR],WEBPAGE_TABLE[page_index].filename)!=0) 
				{
					http_entry[index].http_header_type = 1;
					
					if (strcasestr(WEBPAGE_TABLE[page_index].filename,".jpg")!=0)
					{
						http_entry[index].http_header_type = 1;
					}
					if (strcasestr(WEBPAGE_TABLE[page_index].filename,".gif")!=0)
					{
						http_entry[index].http_header_type = 1;
					}	
					if (strcasestr(WEBPAGE_TABLE[page_index].filename,".htm")!=0)
					{
						http_entry[index].http_header_type = 0;	
					}	
					http_entry[index].new_page_pointer = WEBPAGE_TABLE[page_index].page_pointer;
					break;
				}
			page_index++;
		}
	}

	//Wurde das Ende vom Header nicht erreicht
	//kommen noch weitere Stcke vom Header!
	if ((*http_entry[index].hdr_end_pointer != 0) || (http_entry[index].post == 1))
	{
		//Der Empfang wird Quitiert und es wird auf weiteres Headerstck gewartet
		tcp_entry[index].status =  ACK_FLAG;
		create_new_tcp_packet(0,index);
		//Warten auf weitere Headerpackete
		tcp_entry[index].app_status = 1;
		return;
	}	
	
	//Wurde das Passwort in den ganzen Headerpacketen gefunden?
	//Wenn nicht dann ausfhren und Passwort anfordern!
	if((!http_entry[index].http_auth) && (tcp_entry[index].status&PSH_FLAG) && !PW_OK)
	{	
		//HTTP_AUTH_Header senden!
		http_entry[index].new_page_pointer = Page0;
		memcpy_P((char*)&eth_buffer[TCP_DATA_START_VAR],http_header3,(sizeof(http_header3)-1));
		tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
		create_new_tcp_packet((sizeof(http_header3)-1),index);
		tcp_entry[index].app_status = 2;
		return;
	}
	
	//Standard INDEX.HTM Seite wenn keine andere gefunden wurde
	if (!http_entry[index].new_page_pointer)
	{
		http_entry[index].new_page_pointer = Page1;
		http_entry[index].http_header_type = 0;
	}	
	
	tcp_entry[index].app_status = 2;
	
	//Seiten Header wird gesendet
	if(http_entry[index].http_header_type == 1)
	{
		memcpy_P((char*)&eth_buffer[TCP_DATA_START_VAR],http_header2,(sizeof(http_header2)-1));
        tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
        create_new_tcp_packet((sizeof(http_header2)-1),index);
        return;
	}
     
	if(http_entry[index].http_header_type == 0)
	{
		memcpy_P((char*)&eth_buffer[TCP_DATA_START_VAR],http_header1,(sizeof(http_header1)-1));
        tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
        create_new_tcp_packet((sizeof(http_header1)-1),index);
        return;
	}
    return;
}

//----------------------------------------------------------------------------
//Daten Packete an Client schicken
void httpd_data_send (unsigned char index)
{	
	unsigned int a;
	unsigned char str_len;
	char var_conversion_buffer[CONVERSION_BUFFER_LEN];
	
	//Passwort wurde im Header nicht gefunden
	if(!http_entry[index].http_auth)
	{
		http_entry[index].new_page_pointer = Page0;
	}
	
	//kein Packet empfangen Retransmission des alten Packetes
	if (tcp_entry[index].status == 0) 
	{
		http_entry[index].new_page_pointer = http_entry[index].old_page_pointer;
	}
	http_entry[index].old_page_pointer = http_entry[index].new_page_pointer;

	for (a = 0;a<(MTU_SIZE-(TCP_DATA_START)-150);a++)
	{
		unsigned char b;
		b = pgm_read_byte(http_entry[index].new_page_pointer++);
		eth_buffer[TCP_DATA_START + a] = b;
		
		//Mssen Variablen ins Packet eingesetzt werden?
		if (b == '%')
		{
			if (strncasecmp_P("STATUS",http_entry[index].new_page_pointer,6)==0)
			{
				unsigned char bit = (pgm_read_byte(http_entry[index].new_page_pointer+6)-48);

				b = 0;

				if (PORTC & (1<<bit))
				{
					b = 1;
				}

				if (b)
				{
					strcpy_P(var_conversion_buffer, PSTR("togButtonOn"));
				}
				else
				{
					strcpy_P(var_conversion_buffer, PSTR("togButtonOff"));
				}
							
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a += str_len-1;
				http_entry[index].new_page_pointer = http_entry[index].new_page_pointer+7;
			}
			
			#if FLOT
			//Einsetzen des Port Status %PORTxy durch "checked" wenn Portx.Piny = 1
			//x: A..G  y: 0..7 
			else if (strncasecmp_P("PINA",http_entry[index].new_page_pointer,4)==0)
			{
				unsigned char bit = (pgm_read_byte(http_entry[index].new_page_pointer+4)-48);
				uint8_t b = 0;
				
				b = (PINA & (1<<bit)); //Aktueller Eingangswert wird abgefragt
							
				if(b) {
					strcpy_P(var_conversion_buffer, PSTR("1"));
				}
				else {
					strcpy_P(var_conversion_buffer, PSTR("0"));
				}

				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a += str_len-1;
				http_entry[index].new_page_pointer = http_entry[index].new_page_pointer+5;
			}
			#endif

			//wurde das Ende des Packetes erreicht?
			//Verbindung TCP Port kann beim nchsten ACK geschlossen werden
			//Schleife wird abgebrochen keine Daten mehr!!
			if (strncasecmp_P("END",http_entry[index].new_page_pointer,3)==0)
			{	
				tcp_entry[index].app_status = 0xFFFD;
				break;
			}
		}
	}
	
	//Erzeugte Packet kann nun gesendet werden!
	tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
	create_new_tcp_packet(a,index);
	return;
}
