/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:
 known Problems: none
 Version:        24.10.2007
 Description:    Webserver uvm.

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der
 GNU General Public License, wie von der Free Software Foundation verffentlicht,
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder
 (nach Ihrer Option) jeder spteren Version.

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 Programm erhalten haben.
 Falls nicht, schreiben Sie an die Free Software Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
----------------------------------------------------------------------------*/
#include "config.h"
#include <avr/io.h>
#include "enc28j60.h"
#include "stack.h"
#include "httpd.h"
#include "base64.h"
#include "timer.h"

//----------------------------------------------------------------------------
// Hier startet das Hauptprogramm
// ******************************
int main(void)
{  
	//Konfiguration der Ausgnge bzw. Eingnge
	DDRA = 0xFF;
	DDRC = 0xFF;
	
	#if FLOT
		// PORT A Bit 0,1,2,3 sind Eingnge
		DDRA = 0xF0;
		PORTA= 00; //INPUT Port ohne Pullup Widerstnde
	#endif
	
	//Applikationen starten
	timer_init();
	stack_init();
	httpd_init();

	//Ethernetcard Interrupt enable
	ETH_INT_ENABLE;
	
	//Globale Interrupts einschalten
	sei(); 
		
	//Hauptschlfeife
	// *************
	while(1)
	{
		eth_get_data();
	}
}
