/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:
 known Problems: none
 Version:        24.10.2007
 Description:    Timer Routinen

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der
 GNU General Public License, wie von der Free Software Foundation verffentlicht,
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder
 (nach Ihrer Option) jeder spteren Version.

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 Programm erhalten haben.
 Falls nicht, schreiben Sie an die Free Software Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
------------------------------------------------------------------------------*/
#include <avr/interrupt.h>
#include <avr/io.h>
#include "config.h"
#include "timer.h"

volatile unsigned long time;

//----------------------------------------------------------------------------
//Diese Routine startet und inizialisiert den Timer
void timer_init (void)
{
	TCCR1B |= (1<<WGM12) | (1<<CS10 | 0<<CS11 | 1<<CS12);
	TCNT1 = 0;
	OCR1A = (F_CPU / 1024) - 1;
	TIMSK |= (1 << OCIE1A);
	return;
};

//----------------------------------------------------------------------------
//Timer Interrupt

ISR (TIMER1_COMPA_vect)
{
	//Sekunde um 1 erhhen
	time++;
    if((stack_watchdog++) > WTT)
    {
        stack_watchdog = 0;
        stack_init();
    }
    eth.timer = 1;
	
	if (gp_timer > 0) 
	{
		gp_timer--;
	}
}
