
/*	LCD-Mode
	if LCD_CYRILLIC will be definiert, then Omega- and -character will be loaded to LCD-display
	This is nessesary because the HD44780 has these characters not in non standard character sets.
*/
//#define LCD_CYRILLIC

/*
With Define SWUART_INVERT you can specify, if the software-UART operates normal or invers.
In der normalen Betriebsart sendet der UART in der blichen Logik (Low = 0; High = 1).
n the normal mode the UART sends with usual logik level (Low = 0; High = 1).
You can use this mode for direct connection to a C, or a level converter like MAX232.

With invers mode the UART sends with invers logik (Low = 1, High = 0).
This is the level of a standard RS232 port of a PC.
In most cases the output of the software UART can so be connected to the RxD of a PC.
The specification say, that level -3V to 3V is unspecified, but in most cases it works.
Is a simple but unclean solution.

Is SWUART_INVERT defined, the UART works is inverse mode
*/
//#define SWUART_INVERT

#define TxD PC3	//TxD-Pin of Software-UART; must be at Port C !


#ifdef USE_EEPROM
#define MEM_TEXT EEMEM
#define MEM_read_word(a)  eeprom_read_word(a)
#define MEM_read_byte(a)  eeprom_read_byte(a)
#else
#define MEM_TEXT PROGMEM
#define MEM_read_word(a)  pgm_read_word(a)
#define MEM_read_byte(a)  pgm_read_byte(a)
#endif


// automatic selection of option and parameters for different AVR s
//----------------========----------
#if defined(__AVR_ATmega48__)
//----------------========----------
  #define MCU_STATUS_REG MCUCR
  #define ADC_COMP_CONTROL ADCSRB
  #define TI1_INT_FLAGS TIFR1
  #define DEFAULT_RH_FAKT  856      // mega48 1101 mV
// WITH_SELFTEST enables the selftest fuction 
  #ifdef WITH_SELFTEST
  #warning "ATmega48 does NOT support SELFTEST!"
  #undef WITH_SELFTEST
  #endif
// R_MESS activates the resistor measurement 
  #ifdef R_MESS
  #warning "ATmega48 does NOT support Resistor measuring!"
  #undef R_MESS
  #endif
// C_MESS activates the capacitor measurement 
  #ifdef C_MESS
  #warning "ATmega48 does NOT support Capacity measuring!"
  #undef C_MESS
  #undef WITH_AUTO_REF
  #endif
// WITH_UART activates the output of data with software UART 
  #ifdef WITH_UART
  #warning "no UART support with ATmega48!"
  #undef WITH_UART
  #endif
  #ifdef BAT_CHECK
  #warning "no BAT_CHECK support with ATmega48!"
  #undef BAT_CHECK
  #endif

  #define C_NULL (((52 * F_CPU) / 10000000)+4)
  #define PIN_RM 190
  #define PIN_RP 220

//------------------========----------
#elif defined(__AVR_ATmega88__)
//------------------========----------
  #define MCU_STATUS_REG MCUCR
  #define ADC_COMP_CONTROL ADCSRB
  #define TI1_INT_FLAGS TIFR1
  #define DEFAULT_RH_FAKT  855      // mega88 1102 mV
// LONG_HFE  activates computation of current amplification factor with long variables
  #define LONG_HFE
// KOLLEKTOR_SCHALTUNG activates measurement of current amplification factor also in common collector circuit  (Emitter follower)
  #define KOLLEKTOR_SCHALTUNG

  #define C_NULL (((52 * F_CPU) / 10000000)+4)
  #define PIN_RM 190
  #define PIN_RP 225

//------------------=========----------
#elif defined(__AVR_ATmega168__)
//------------------=========----------
  #define MCU_STATUS_REG MCUCR
  #define ADC_COMP_CONTROL ADCSRB
  #define TI1_INT_FLAGS TIFR1
  #define DEFAULT_RH_FAKT  855      // mega168 1102 mV
// LONG_HFE  activates computation of current amplification factor with long variables
  #define LONG_HFE
// KOLLEKTOR_SCHALTUNG activates measurement of current amplification factor also in common collector circuit  (Emitter follower)
  #define KOLLEKTOR_SCHALTUNG

  #define C_NULL (((55 * F_CPU) / 10000000)+4)
  #define PIN_RM 196
  #define PIN_RP 225

//------------------=========----------
#elif defined(__AVR_ATmega328__)
//------------------=========----------
  #define MCU_STATUS_REG MCUCR
  #define ADC_COMP_CONTROL ADCSRB
  #define TI1_INT_FLAGS TIFR1
  #define DEFAULT_RH_FAKT  855      // mega328 1102 mV
// LONG_HFE  activates computation of current amplification factor with long variables
  #define LONG_HFE
// KOLLEKTOR_SCHALTUNG activates measurement of current amplification factor also in common collector circuit  (Emitter follower)
  #define KOLLEKTOR_SCHALTUNG

  #define C_NULL (((52 * F_CPU) / 10000000)+4)
  #define PIN_RM 200
  #define PIN_RP 220

//------------------=========----------
#else
//                   ATmega8
//------------------=========----------
  #define MCU_STATUS_REG MCUCSR
  #define ADC_COMP_CONTROL SFIOR
  #define TI1_INT_FLAGS TIFR
  #define DEFAULT_RH_FAKT  708      // mega8 1298 mV
// LONG_HFE  activates computation of current amplification factor with long variables
  #define LONG_HFE
// KOLLEKTOR_SCHALTUNG activates measurement of current amplification factor also in common collector circuit  (Emitter follower)
  #define KOLLEKTOR_SCHALTUNG

  #define C_NULL (((46 * F_CPU) / 10000000)+4)
  #define PIN_RM 190
  #define PIN_RP 220
#endif

#ifndef REF_KORR
 #define REF_KORR 0
#endif

#ifdef POWER_OFF
// if POWER OFF function is selected, wait 10s
 #if (POWER_OFF+0) > 2
  #define OFF_WAIT_TIME 3000
 #else
  #define OFF_WAIT_TIME 10000
 #endif
#else
// if POWER OFF function is not selected, wait 3s before repeat measurement
 #define OFF_WAIT_TIME  3000
#endif

