/*----------------------------------------------------------------------------
 * Name:    Blinky.c
 * Purpose: LED Flasher for MCBSTM32F400
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2004-2011 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#include "stm32f4xx.h"                 /* STM32F4xx Definitions              */
#include "LED.h"
#include "GLCD.h"
#include "JOY.h"

uint32_t LEDOn, LEDOff; 

/*----------------------------------------------------------------------------
  SysTick IRQ Handler
 *----------------------------------------------------------------------------*/
void SysTick_Handler (void) {
  static uint32_t ticks;
  
  switch (ticks++) {
    case  0: LEDOn  = 1; break;
    case  5: LEDOff = 1; break;
    case  9: ticks  = 0; break;
    
    default:
      if (ticks > 10) {
        ticks = 0;
      }
  }
}

/*----------------------------------------------------------------------------
  Main function
 *----------------------------------------------------------------------------*/
int main (void) {
  int32_t max_num = LED_Num() - 1;
  int32_t num = 0;
  int32_t dir = 1;
	int32_t d;

  SysTick_Config(SystemCoreClock/100);      /* Generate interrupt each 10 ms  */
  LED_Init();                               /* LED Initialization             */

  for (d=0;d<8000000;d++) {
    if (LEDOn) {
			//IOE_Write(0b1010101010101010);
      LEDOn = 0;
      LED_On (num);                         /* Turn specified LED on          */
    }

    if (LEDOff) {
			//IOE_Write(0b0101010101010101);
      LEDOff = 0;
      LED_Off (num);                        /* Turn specified LED off         */

      num += dir;                           /* Change LED number              */
      
      if (dir == 1 && num == max_num) {
        dir = -1;                           /* Change direction to down       */
      }
      else if (num == 0) {
        dir =  1;                           /* Change direction to up         */
      }
    }
  }
	LED_UnInit();
	
  GLCD_Init();                          /* Graphical Display Init             */
	//GLCD_WindowMax ();
  GLCD_Clear (YELLOW);
  GLCD_SetBackColor  (Blue);
  GLCD_SetTextColor  (White);
  GLCD_DisplayString (0, 0, 1, "    MCBSTM32F400    ");
  GLCD_DisplayString (1, 0, 1, "    Demo Example    ");
  GLCD_SetBackColor  (White);
  GLCD_SetTextColor  (Blue);	
	GLCD_Clear (Blue);
	
	JOY_Init ();
	
	while(1) 
	{
		unsigned short val = 0xaaaa ;
	for (d=0;d<8000000;d++); 
		IOE_Write (val);
	for (d=0;d<8000000;d++); 
		IOE_Write (~val);
	}  
}
