/******************************************************************************/
/* GLCD.h: Graphic LCD function prototypes and defines                        */
/******************************************************************************/
/* This file is part of the uVision/ARM development tools.                    */
/* Copyright (c) 2005-2011 Keil - An ARM Company. All rights reserved.        */
/* This software may only be used under the terms of a valid, current,        */
/* end user licence from KEIL for a compatible version of KEIL software       */
/* development tools. Nothing else gives you the right to use this software.  */
/******************************************************************************/

#ifndef _GLCD_H
#define _GLCD_H

/*------------------------------------------------------------------------------
  Color coding
  GLCD is coded:   15..11 red, 10..5 green, 4..0 blue  (unsigned short)  GLCD_R5, GLCD_G6, GLCD_B5   
  original coding: 17..12 red, 11..6 green, 5..0 blue                    ORG_R6,  ORG_G6,  ORG_B6

  ORG_R1..5 = GLCD_R0..4,  ORG_R0 = GLCD_R4
  ORG_G0..5 = GLCD_G0..5,
  ORG_B1..5 = GLCD_B0..4,  ORG_B0 = GLCD_B4
 *----------------------------------------------------------------------------*/
                            
/* GLCD RGB color definitions                                                 */
#define Black           0x0000      /*   0,   0,   0 */
#define Navy            0x000F      /*   0,   0, 128 */
#define DarkGreen       0x03E0      /*   0, 128,   0 */
#define DarkCyan        0x03EF      /*   0, 128, 128 */
#define Maroon          0x7800      /* 128,   0,   0 */
#define Purple          0x780F      /* 128,   0, 128 */
#define Olive           0x7BE0      /* 128, 128,   0 */
#define LightGrey       0xC618      /* 192, 192, 192 */
#define DarkGrey        0x7BEF      /* 128, 128, 128 */
#define Blue            0x001F      /*   0,   0, 255 */
#define Green           0x07E0      /*   0, 255,   0 */
#define Cyan            0x07FF      /*   0, 255, 255 */
#define Red             0xF800      /* 255,   0,   0 */
#define Magenta         0xF81F      /* 255,   0, 255 */
#define Yellow          0xFFE0      /* 255, 255, 0   */
#define White           0xFFFF      /* 255, 255, 255 */
#define no_bg               0x0001	    //No Color Back Ground
#define BLACK               0x0000
#define WHITE               0xFFFF
#define RED                 0x8000
#define GREEN               0x0400
#define BLUE                0x0010
#define YELLOW           	0xFFF0
#define CYAN                0x0410
#define MAGENTA             0x8010
#define BROWN               0xFC00
#define OLIVE	            0x8400

#define BRIGHT_RED          0xF800
#define BRIGHT_GREEN        0x07E0
#define BRIGHT_BLUE         0x001F
#define BRIGHT_YELLOW       0xFFE0
#define BRIGHT_CYAN         0x07FF
#define BRIGHT_MAGENTA    	0xF81F

#define LIGHT_GRAY          0x8410
#define DARK_GRAY         	0x4208
#define LIGHT_BLUE          0x841F
#define LIGHT_GREEN         0x87F0
#define LIGHT_CYAN          0x87FF
#define LIGHT_RED         	0xFC10
#define LIGHT_MAGENTA      	0xFC1F

#define GRAY0       	    0xE71C
#define GRAY1         	    0xC618
#define GRAY2             	0xA514
#define GRAY3             	0x630C
#define GRAY4            	0x4208
#define GRAY5	            0x2104
#define	GRAY6	          	0x3186	

#define	BLUE0	            0x1086	
#define	BLUE1       		0x3188 
#define	BLUE2          	    0x4314
#define BLUE3         	    0x861C	

#define	CYAN0	            0x3D34
#define	CYAN1               0x1DF7		

#define	GREEN0              0x0200	
#define	GREEN1              0x0208	

//------------ Color For Build Button -------------

#define BT_RED              1
#define BT_GREEN            2
#define BT_BLUE             3
#define	BT_YELLOW          	4
#define BT_WHITE            5
#define BT_CYAN             6
#define BT_MAGENTA      	7
#define BT_BROWN            8

#define BT_LRED             9
#define BT_LGREEN          10
#define BT_LBLUE           11
#define	BT_LYELLOW         12
#define BT_LWHITE          13
#define BT_LCYAN           14
#define BT_LMAGENTA        15
#define BT_LBROWN          16


extern void GLCD_Init           (void);
extern void GLCD_WindowMax      (void);
extern void GLCD_PutPixel       (unsigned int x, unsigned int y);
extern void GLCD_SetTextColor   (unsigned short color);
extern void GLCD_SetBackColor   (unsigned short color);
extern void GLCD_Clear          (unsigned short color);
extern void GLCD_DrawChar       (unsigned int x,  unsigned int y, unsigned int cw, unsigned int ch, unsigned char *c);
extern void GLCD_DisplayChar    (unsigned int ln, unsigned int col, unsigned char fi, unsigned char  c);
extern void GLCD_DisplayString  (unsigned int ln, unsigned int col, unsigned char fi, unsigned char *s);
extern void GLCD_ClearLn        (unsigned int ln, unsigned char fi);
extern void GLCD_Bargraph       (unsigned int x,  unsigned int y, unsigned int w, unsigned int h, unsigned int val);
extern void GLCD_Bitmap         (unsigned int x,  unsigned int y, unsigned int w, unsigned int h, unsigned char *bitmap);
extern void GLCD_ScrollVertical (unsigned int dy);

extern void GLCD_WrCmd          (unsigned char cmd);
extern void GLCD_WrReg          (unsigned char reg, unsigned short val); 

#endif /* _GLCD_H */
