/*-----------------------------------------------------------------------------
 * Name:    JOY.c
 * Purpose: Low level joystick functions
 * Note(s):
 *-----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2004-2011 Keil - An ARM Company. All rights reserved.
 edit: erhardd 4/12
 *----------------------------------------------------------------------------*/
#include "stm32f4xx.h"                  /* STM32F4xx Definitions              */
#include "JOY.h"

#define EXP_BASE   0x60800000UL  // A22 on
#define EXP_Bw     (*((volatile unsigned short *)(EXP_BASE | 0x00020000)))  //A16 on
#define EXP_Ar     (*((volatile unsigned short *) (EXP_BASE)))
#define EXP_CMD		 (*((volatile unsigned short *)(EXP_BASE | 0x00060000)))  //A16 on, A17 on
/* Prototypes 
static uint32_t  IOE_Read  (uint8_t reg, uint8_t *val);
static uint32_t  IOE_Write (uint16_t reg, uint8_t  val);
*/
/*
A1A0RDWRCS     INPUT OPERATION(READ)
0 0 0 1 0 Port A --> Data Bus
0 1 0 1 0 Port B --> Data Bus
1 0 0 1 0 Port C --> Data Bus
1 1 0 1 0 Control Word --> Data Bus

               OUTPUT OPERATION (WRITE)
0 0 1 0 0 Data Bus --> Port A
0 1 1 0 0 Data Bus --> Port B
1 0 1 0 0 Data Bus --> Port C
1 1 1 0 0 Data Bus --> Control

							 DISABLE FUNCTION
X X X X 1 Data Bus --> Three-State
X X 1 1 0 Data Bus --> Three-State
*/

/*-----------------------------------------------------------------------------
 *       JOY_Init:  Initialize joystick
 *                  Joystick is connected to the WS82C55AC controler,
 *                  which is used as a GPIO expander.
 *----------------------------------------------------------------------------*/
void JOY_Init (void) {
 /* int i;
	*/
	 IOE_CMDWrite (0x9898);
	return;
}

/*-----------------------------------------------------------------------------
 *       JOY_Init:  Uninitialize joystick
 *
 * Parameters: (none)
 * Return:     (none)
 *----------------------------------------------------------------------------*/
void JOY_UnInit (void) {
//  IOE_Write (0x03, 0x02);               /* Reset Touch-screen controller      */
}


/*-----------------------------------------------------------------------------
 *       JOY_GetKeys:  Get joystick direction keys state
 *
 * Parameters: (none)
 * Return:     joystick directions bitmask
 *----------------------------------------------------------------------------*/
uint32_t JOY_GetKeys (void) {
  // Read board keyboard inputs 
  //uint8_t reg;
  uint32_t val = 0;
	/*
  if (IOE_Read (0x12, &reg) == 0) {     
    reg = ~reg;

    if (reg & (1 << 3)) {
      val |= JOY_UP;
    }
    if (reg & (1 << 4)) {
      val |= JOY_RIGHT;
    }
    if (reg & (1 << 5)) {
      val |= JOY_LEFT;
    }
    if (reg & (1 << 6)) {
      val |= JOY_DOWN;
    }
    if (reg & (1 << 7)) {
      val |= JOY_CENTER;
    }
  }	*/
  return (val);
	
}


/*-----------------------------------------------------------------------------
 *      IOE_Write:  Write value to the WS82C55AC PortB-register
 *
 *  Parameter:  
 *              val - value to be written
 *
 *  
 *----------------------------------------------------------------------------*/
 void IOE_Write (unsigned short val) { 
		EXP_Bw = val;
}

 void IOE_CMDWrite (unsigned short val) { 
		EXP_CMD = val;
}


/*-----------------------------------------------------------------------------
 *      IOE_Read:  Read data from the WS82C55AC PortA-register
 *
 *  Parameter:  
 *              val - variable where value will be stored
 *
 *  Return: 0 on success, nonzero on error
 *----------------------------------------------------------------------------*/
 unsigned short IOE_Read (void) {		
	
  return (EXP_Ar);									/* return value */
}

/*-----------------------------------------------------------------------------
 * End of file
 *----------------------------------------------------------------------------*/
