/****************************************************************************************************************************************	
* 																																		*
*																									*	
*																													*
* Title:	Entprell.c																																			*
* Software 	Version 2.0																													*
* 																																		*
* for details.																															*
* Chip type           																									*
* Clock frequency     : 
* Programming Date	  : 
*																							*
****************************************************************************************************************************************/




#include "MAIN.h"



void entprell(void)

{
	//extern proto.Proto;
	//Proto.output++;
	static unsigned char ct0, ct1, rpt;
	unsigned char ii; 
	ii = key_state ^ ~KEY_PIN;		
	ct0 = ~( ct0 & ii );			
	ct1 = ct0 ^ (ct1 & ii);		
	ii &= ct0 & ct1;			
	key_state ^= ii;			
	key_press |= key_state & ii;		

	if( (key_state & REPEAT_MASK) == 0 )	
		rpt = REPEAT_START;		
	if( --rpt == 0 )
	{
		rpt = REPEAT_NEXT;			
		key_rpt |= key_state & REPEAT_MASK;
	}

}



unsigned char get_key_press( unsigned char key_mask )
{
	//cli();					// read and clear atomic !
	InterruptT0_D();
	key_mask &= key_press;                        // read key(s)
	key_press ^= key_mask;                        // clear key(s)
	//6();
	InterruptT0_E();
	return key_mask;
}


unsigned char get_key_rpt( unsigned char key_mask )
{
	//cli();					// read and clear atomic !
	InterruptT0_D();
	key_mask &= key_rpt;                        	// read key(s)
	key_rpt ^= key_mask;                        	// clear key(s)
	//sei();
	InterruptT0_E();
	return key_mask;
}


unsigned char get_key_short( unsigned char key_mask )
{
  	//cli();			// read key state and key press atomic !
	InterruptT0_D();
  	return get_key_press( ~key_state & key_mask );
}


unsigned char get_key_long( unsigned char key_mask )
{
  	return get_key_press( get_key_rpt( key_mask ));
}



