
//			Target: ATtiny26
#include "main.h"


void Transmit(void *cData,uint8_t len);



void init( void )
{

  
  suart_init();
}
volatile uint16_t adc_val;
proto  Proto;
 volatile uint8_t	dataRX[20];
volatile uint8_t crc_error ,protoflag;
volatile int analog[4];
int main( void )
{
	init();
	
	PORTA|= (1<<I_TAST);
	DDRA |= (1<<O_POWER)|(1<<O_VLIMIT)|(1<<STX);
	PORTB|=(1<<SRX)|(1<<RESET);
	DDRB |=(1<<O_RUN)|(1<<O_VENTILATOR)|(1<<O_ENABLE_TX);
	TCCR0	|=(1<<CS00)|(1<<CS02);
	//TCNT0 = (unsigned char)(signed short)-(XTAL / 1024 * 10e-3 + 0.5);	// preload for 10ms
	TIMSK	|=(1<<TOIE0);
	//ADMUX 3 4 5 6 Enspricht Kanal
	ADCSR |=(1<<ADEN)|	// Enable Adc
			(1<<ADSC)|	// Start first conversion
			(1<<ADIE)|	// Interrupt Enable
			(1<<ADFR)|
			(1<<ADPS1)|	// Prescaler 64
			(1<<ADPS2);
	ADMUX =3;
  
	sei();
	//uputs( "Hallo Peter\n\r" );
	Proto.len= sizeof(Proto);
	Proto.start=2;
	//Proto.adress= 1;
	for(;;)
	{
		
			
		RxProt(ugetchar());
		if (protoflag &(1<<RxComp))
		{
			//Proto.output= PINA;
			Proto.analog[0]=analog[0];
			Proto.analog[1]=analog[1];
			Proto.analog[2]=analog[2];
			Proto.analog[3]=analog[3];
			Proto.crc = CalcCRC16(&Proto,sizeof(Proto)-1);
			Transmit(&Proto,sizeof(Proto));
			protoflag &= ~(1<<RxComp);
		}
		if( get_key_short( 1<<KEY1 ))
		{
			PORTA ^= 1<<O_POWER;
		}		
		if( get_key_long( 1<<KEY1 ))
		{
			PORTA ^= 1<<O_VLIMIT;
		}	
	}
}
ISR(ADC_vect)
{
	static u32 adc_sum;
	static u8 count,canal=3;
	adc_sum += ADC;

	count++;
	if( count == 0 )
	{			
		analog[canal-3] = adc_sum >> 8;		// average over 256 samples
		adc_sum = 0;
		canal++;
		if (canal>6)
		{
			canal=3;
		}
		ADMUX=canal;
	}
}

ISR(TIMER0_OVF0_vect)
//SIGNAL(SIG_OVERFLOW0)
{
	static uint8_t i;
	TCNT0 = (uint8_t)(int16_t)-(F_CPU / 1024 * 10e-3 + 0.5);  // preload for 10ms
	i++;
	if (i==50)
	{
		i=0;
		PORTB ^=(1<<O_RUN);
		
	}		
	entprell();
	
	
}

void Transmit(void *cData,uint8_t len)
{
	while(len-- > 0)
	{
		uputchar( *(char *)cData);				// shift out data
		cData++;
	}

}