#include <p18F4580.h>
#include <delays.h>
#include "types.h"

#pragma config WDT = OFF
#pragma config OSC = HSPLL  //40MHz

#define WAVE 2
#define PCFG3 3
#define PCFG2 2
#define PCFG1 1
#define PCFG0 0
#define CM2 2
#define CM1 1
#define CM0 0

void delay_ms(uint16_t u16_milliseconds);

void main(void){
  
  CMCON |= ((1<<CM2) & (1<<CM1) & (1<<CM0));   //111 -->Comparator off
  TRISCbits.RC2=0;

  while(1){
    PORTCbits.RC2=1;   
    delay_ms(1);
    PORTCbits.RC2=0;
  }

}

void delay_ms(uint16_t u16_milliseconds){
    uint16_t u16_count = 0;
    if (u16_milliseconds != 0){
      for(u16_count=0; u16_count<u16_milliseconds; u16_count++){
          Delay10KTCYx(1);  //10.000TCY *100ns = 1ms
          u16_count++;
      }
    }
    return 0;
}
