
//			Target: ATtiny26
#include "main.h"


void Transmit(u8 *cData,uint8_t len);



void init( void )
{

  
  suart_init();
}
volatile uint16_t adc_val;
//proto  Proto;
 volatile uint8_t	dataRX[20];
 uint8_t arraytest[16];
volatile uint8_t crc_error ,protoflag;
volatile int analog[4];
int main( void )
{
	init();
	
	PORTA|= (1<<I_TAST);
	DDRA |= (1<<O_POWER)|(1<<O_VLIMIT)|(1<<STX);
	PORTB|=(1<<SRX)|(1<<RESET);
	DDRB |=(1<<O_RUN)|(1<<O_VENTILATOR)|(1<<O_ENABLE_TX);
	TCCR0	|=(1<<CS00)|(1<<CS02);
	//TCNT0 = (unsigned char)(signed short)-(XTAL / 1024 * 10e-3 + 0.5);	// preload for 10ms
	TIMSK	|=(1<<TOIE0);
	//ADMUX 3 4 5 6 Enspricht Kanal
	ADCSR |=(1<<ADEN)|	// Enable Adc
			(1<<ADSC)|	// Start first conversion
			(1<<ADIE)|	// Interrupt Enable
			(1<<ADFR)|
			(1<<ADPS1)|	// Prescaler 64
			(1<<ADPS2);
	ADMUX =3;
  
	sei();
	//uputs( "Hallo Peter\n\r" );
	//Proto.len= sizeof(Proto);
	//Proto.start=2;
	//Proto.adress= 1;
	//Proto.crcerror= 65535;
	//Proto.crc =65535;
	arraytest[0]=1;
	arraytest[1]=2;
	arraytest[2]=3;
	arraytest[3]=4;
	arraytest[4]=5;
	arraytest[5]=6;
	arraytest[6]=7;
	arraytest[7]=8;
	arraytest[8]=9;
	arraytest[9]=10;
	arraytest[10]=11;
	arraytest[11]=12;
	arraytest[12]=13;
	arraytest[13]=14;
	arraytest[14]=15;
	uputchar(8);
	for(;;)
	{
		//_delay_ms(300);
		//uputs( "Hallo Peter\n\r" );
		
		//while( kbhit() )
		//uputchar( ugetchar());
		//
		if( !kbhit())	
		{
			if( get_key_short( 1<<KEY1 ))
			{
				PORTA ^= 1<<O_POWER;
			}		
			if( get_key_long( 1<<KEY1 ))
			{
				PORTA ^= 1<<O_VLIMIT;
			}	
		}
		else
		{
			RxProt(ugetchar());
			if (protoflag &(1<<RxComp))
			{
				
				//Proto.analog[0]=analog[0];
				//Proto.analog[1]=analog[1];
				//Proto.analog[2]=analog[2];
				//Proto.analog[3]=analog[3];
				//if (PORTA &(1<<O_POWER)) Proto.output|=(1<<0);else Proto.output&=~(1<<0);
				//if (PORTA &(1<<O_VLIMIT)) Proto.output|=(1<<1);else Proto.output&=~(1<<1);
				//if (PORTB &(1<<O_VENTILATOR)) Proto.output|=(1<<2);else Proto.output&=~(1<<2);
				//Proto.crc = CalcCRC16(&Proto,13);
				//Transmit(&Proto,sizeof(Proto));
				//uint16_t crc=CalcCRC16(&arraytest,13);
				//arraytest[13] = (crc & 0x00ff);
                //arraytest[14] = (crc >> 8);
				uint8_t i;
				for ( i=0;i<15;i++)
				{
					uputchar(i);
					uputchar(arraytest[i]);
				}
				
				protoflag &= ~(1<<RxComp);
			}
			
		}
		
		
	}
}
ISR(ADC_vect)
{
	static u32 adc_sum;
	static u8 count,canal=3;
	adc_sum += ADC;

	count++;
	if( count == 0 )
	{			
		analog[canal-3] = adc_sum >> 8;		// average over 256 samples
		adc_sum = 0;
		canal++;
		if (canal>6)
		{
			canal=3;
		}
		ADMUX=canal;
	}
}

ISR(TIMER0_OVF0_vect)
//SIGNAL(SIG_OVERFLOW0)
{
	static uint8_t i;
	TCNT0 = (uint8_t)(int16_t)-(F_CPU / 1024 * 10e-3 + 0.5);  // preload for 10ms
	i++;
	if (i==50)
	{
		i=0;
		PORTB ^=(1<<O_RUN);
		
	}		
	entprell();
	
	
}

void Transmit(u8 *cData,uint8_t len)
{
	while(len-- > 0)
	{
		uputchar( *cData++);				// shift out data
		
	}

}
//void uputs_( u8 *s )			// transmit string from SRAM
//{
  //while( *s )
    //uputchar( *s++ );
//}
//void Transmit(void *cData,uint8_t len)
//{
	//while(len-- > 0)
	//{
		//uputchar( *(char *)cData);				// shift out data
		//cData++;
	//}
//
//}