/**
  ******************************************************************************
  * @file platform_config.h
  * @author  MCD Application Team, mod. Martin Thomas for Manley EK-STM32F
  * @version  V3.0.0.1
  * @date  04/17/2009
  * @brief  Evaluation board specific configuration file.
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2009 STMicroelectronics</center></h2>
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __PLATFORM_CONFIG_H
#define __PLATFORM_CONFIG_H

//
//#define RxBufferSize1   256

// LED Configuration
#define GPIO_LED                  		GPIOA
#define RCC_APB2Periph_GPIO_LED   		RCC_APB2Periph_GPIOA
#define GPIO_Pin_LED1             		GPIO_Pin_5
#define GPIO_Pin_LED2             		GPIO_Pin_1

// USART 1 Configuration
#define GPIO_USART1				  		GPIOA
#define RCC_APB2Periph_GPIO_USART1		RCC_APB2Periph_GPIOA
#define GPIO_USART1_Tx             		GPIO_Pin_9
#define GPIO_USART1_Rx             		GPIO_Pin_10

// SPI Configuration
#define SPI_SD                   		SPI2
#define GPIO_CS                  		GPIOD
#define RCC_APB2Periph_GPIO_CS  		RCC_APB2Periph_GPIOD
#define GPIO_Pin_CS             		GPIO_Pin_2
#define DMA_Channel_SPI_SD_RX   		DMA1_Channel4
#define DMA_Channel_SPI_SD_TX   		DMA1_Channel5
#define DMA_FLAG_SPI_SD_TC_RX  	  		DMA1_FLAG_TC4
#define DMA_FLAG_SPI_SD_TC_TX  	  		DMA1_FLAG_TC5
#define GPIO_SPI_SD              		GPIOB
#define GPIO_Pin_SPI_SD_SCK      		GPIO_Pin_13
#define GPIO_Pin_SPI_SD_MISO     		GPIO_Pin_14
#define GPIO_Pin_SPI_SD_MOSI     		GPIO_Pin_15
#define RCC_APBPeriphClockCmd_SPI_SD  	RCC_APB1PeriphClockCmd
#define RCC_APBPeriph_SPI_SD     		RCC_APB1Periph_SPI2
/* - for SPI1 and full-speed APB2: 72MHz/4 */
#define SPI_BaudRatePrescaler_SPI_SD  	SPI_BaudRatePrescaler_4

// CAN Configuration
#define RCC_APB2Periph_GPIO_CAN    		RCC_APB2Periph_GPIOB
#define GPIO_Remapping_CAN        		GPIO_Remap1_CAN1
#define GPIO_CAN                   		GPIOB
#define GPIO_Pin_CAN_TX            		GPIO_Pin_9
#define GPIO_Pin_CAN_RX            		GPIO_Pin_8
#define RCC_APB2Periph_GPIO_CAN_CTRL    RCC_APB2Periph_GPIOC
#define GPIO_CAN_CTRL					GPIOC
#define GPIO_Pin_CAN_CTRL            	GPIO_Pin_13
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

#endif /* __PLATFORM_CONFIG_H */

/******************* (C) COPYRIGHT 2009 STMicroelectronics *****END OF FILE****/
