#ifndef DEFINES_H
#define DEFINES_H

#include <avr/io.h>

/***********************************************************/

/* Alternate port access macros from avr-gcc list */
/* http://lists.gnu.org/archive/html/avr-gcc-list/2004-12/msg00097.html */
/* Dave Hylands */

#if 0
//Example defines
#define DATA1         (D, 7)
#define DATA2         (C, 3)
#define DATA3         (B, 3)
#endif

/* Code to manipulate PORTx, PINx, and DDRx using definitions like those above */
#define PORT(port,pin)     (PORT##port)
#define DDR(port,pin)      (DDR##port)
#define PIN(port,pin)      (PIN##port)
#define PIN_MASK(port,pin) (1<<(pin))

/* Set a pin */
#define SETPIN(pindef)      PORT pindef |= PIN_MASK pindef

/* Clear a pin */
#define CLRPIN(pindef)      PORT pindef &= ~PIN_MASK pindef

/* Set a IO to output */
#define SET_DDR_OUT(pindef) DDR pindef |= PIN_MASK pindef

/* Set a IO to input */
#define SET_DDR_IN(pindef)  DDR pindef &= ~PIN_MASK pindef

/* Read the value of a pin - a byte with the correspondig bit set or cleard is returned.
   Example:

   #define PIN7 (D, 7)
   ...
   SETPIN(PIN7);
   x = GETPIN(PIN7);
  { x = 128 }
*/
#define GETPIN(pindef)      PIN pindef & PIN_MASK pindef

/*
Example usage:

	SET_DDR_OUT(DATA1);
	SET_DDR_IN(DATA2);
	SETPIN(DATA1);
	CLRPIN(DATA1);
	x = GETPIN(DATA2);
*/

/*********************************************************************/
#define set_timer0(x) TCNT0 = x
#define get_timer0()  TCNT0

#define set_timer1(x) TCNT1 = x
#define get_timer1()  TCNT1

#define set_timer2(x) TCNT2 = x
#define get_timer2()  TCNT2

/***********************************************/

/* Binary constant generator macro
  By Tom Torfs - donated to the public domain
*/
 
/* All macro's evaluate to compile-time constants */

 
/* *** helper macros ***/

 
/* turn a numeric literal into a hex constant
  (avoids problems with leading zeroes)
  8-bit constants max value 0x11111111, always fits in unsigned long
*/
#define HEX__(n) 0x##n##LU

 
/* 8-bit conversion function */
#define B8__(x) ((x&0x0000000FLU)?1:0)      \
              +((x&0x000000F0LU)?2:0)       \
              +((x&0x00000F00LU)?4:0)       \
              +((x&0x0000F000LU)?8:0)       \
              +((x&0x000F0000LU)?16:0)      \
              +((x&0x00F00000LU)?32:0)      \
              +((x&0x0F000000LU)?64:0)      \
              +((x&0xF0000000LU)?128:0)

 
/* *** user macros ***/

 
/* for upto 8-bit binary constants */
#define B8(d) ((unsigned char)B8__(HEX__(d)))

 
/* for upto 16-bit binary constants, MSB first */
#define B16(dmsb,dlsb) (((unsigned short)B8(dmsb)<<8)     \
                        + B8(dlsb))

 
/* for upto 32-bit binary constants, MSB first */
#define B32(dmsb,db2,db3,dlsb) (((unsigned long)B8(dmsb)<<24)      \
                                  + ((unsigned long)B8(db2)<<16) \
                                  + ((unsigned long)B8(db3)<<8)    \
                                  + B8(dlsb))

 
/* Sample usage:
     B8(01010101) = 85
     B16(10101010,01010101) = 43605
     B32(10000000,11111111,10101010,01010101) = 2164238933
*/

/*************************************************************/

#ifndef true
#define true 1
#endif
#ifndef false
#define false 0
#endif

#define PREPARE_CRITICAL	uint8_t _reg
#define ENTER_CRITICAL		_reg = SREG; cli()
#define LEAVE_CRITICAL		SREG = _reg

#endif
