#include <stdio.h>
#include <stdint.h>
#include <util/delay.h>

#include "defines.h"
#include "pictiva128x64.h"

int main()
{
	uint8_t k, h;

	OSCCAL = 0xBD;
	initPorts();
	oled_init();

	_delay_ms(25);
	selectFont(0);
	writeText(1, 0, 5, "AaBbCcDdEeFfGgHhIi");

	selectFont(2);
	writeText(32, 45, 7, "Hello");

	k = 0;
	h = 0;
	
	while (1) {
		char buf[10];
		uint8_t n;

		sprintf(buf, "%u.%02u", 7000 + k, h);
		writeText(30, 20, 10, buf);

		h++;
		if (h == 100) {
			h = 0; 
			k++;
			if (k == 100) {
				k = 0;
			}
		}
	}

	return 0;
}
