//SPI-Ansteuerung fr den M16C80

#include	"SFR80_100.h"

void SPI_Init(void)
{
	u1mr	= 0x01;							// SPI-Modus eingestellt						
	u1c0	= 0x92;							// f32 selected; TxD1 CMOS output
	u1c1	= 0x05;							// Senden und Empfangen aktiviert
	u1brg	= 30;								// set baud rate to 10Kbps
}


void SPI_ReInit(void)
{
//SPI hochfahren	auf 909Kbps
	u1c0	= 0x90;							// f1 selected; TxD1 CMOS output
	u1brg	= 10;								// set baud rate to 909Kbps	
	
}

	

void SendeByte(unsigned char Byte)
{
//	te_u1c1 = 1;							//Senden aktivieren
	                      	
	while(!ti_u1c1);					// Warten, bis ti_u1c1 == 1 (transmit buffer empty flag) ist, d.h. Sendepuffer leer
	while(!txept_u1c0);				// Warten, bis transmit register empty flag txept_u1c0 == 1 ist, d.h. Senderegister leer
	u1tb = Byte;          	
                        	
//	te_u1c1 = 0;						//Senden deaktivieren
}                       	



unsigned char EmpfangeByte(void)
{                       
//	re_u1c1 = 1;						//Empfangen aktivieren
	
	SendeByte(0xFF);

//	re_u1c1 = 0;						//Empfangen deaktivieren

	return u1rb;		
}
