#ifndef CAPTURE_H
#define CAPTURE_H

#include "control.h"

#include <QThread>
#include <QMutex>
#include <QWaitCondition>
#include <QDialog>
#include <QGridLayout>
#include <QList>

class Capture : public QThread
{
    Q_OBJECT

private:
    QWidget *_parent;

    int   _video_device;    // device h
    void *_video_buffer;    // buffer for reading
    int   _buffer_size;     // size of this buffer
    bool  _abort;           // variable, that signals to run()
    bool  _cinit;           // true, when controls are initialized
    int   _width;           // width of output widget
    int   _height;          // dito height

    QDialog     _dialog;
    QPushButton _reset;
    QGridLayout _grid;

    QList <Control*> _controls;

    QMutex _mutex;     // semaphore for locking access to variables
    QWaitCondition _condition;

public:
    Capture (QWidget *p=0);
    ~Capture ();

    void next_frame();

    int openDeviceFromSettings ();
    int openDevice (const QString &);

    void closeDevice();

    void failure (const QString &text);

public slots:
    int openDeviceDialog();
    void showControls ();
    void writeControl (int id, int value);
    void hideControls ();
    void resetControls ();
    void captureEvent (int r);

signals:
     void buffer_read (uchar *buffer, int width, int height);
     void captureResult  (int);

protected:
    void run();
};


#endif // CAPTURE_H
