#include "control.h"
#include "main.h"

#include <QSpinBox>
#include <QCheckBox>
#include <QComboBox>
#include <QLabel>


Control::Control (struct v4l2_queryctrl& ctrl)
{
    _id = ctrl.id;
    _type = ctrl.type;
    _default = ctrl.default_value;
    _name = (char*)ctrl.name;

    QString text (_name);

    switch (_type)
    {
    case V4L2_CTRL_TYPE_INTEGER:
        _widget.spin = new QSpinBox ();
        _widget.spin->setRange (ctrl.minimum, ctrl.maximum);
        _widget.spin->setSingleStep (ctrl.step);
        connect (_widget.spin, SIGNAL (valueChanged(int)), this, SLOT (emitValueChanged (int)));
        setValuefromSettings();
        text += QString("   ") +  QString::number (ctrl.minimum) +
                QString(" .. ") + QString::number (ctrl.maximum);
        break;
    case V4L2_CTRL_TYPE_BOOLEAN:
        _widget.check = new QCheckBox();
        connect (_widget.check, SIGNAL (toggled(bool)), this, SLOT (emitValueChanged (bool)));
        setValuefromSettings();
        break;
    case V4L2_CTRL_TYPE_MENU:
        _min  = ctrl.minimum;                 // menu control indices might not start with 0
        _widget.combo = new QComboBox ();     // but QComboBox indices (hopefully) always do
        break;
    default:
        break;
    }
    _label = new QLabel (text);
}

Control::~Control ()
{
    globalsettings.setValue(_name, getValue());
}

void Control::emitValueChanged (int value)
{
    emit valueChanged (_id, value);
}

void Control::emitValueChanged (bool value)
{
    emit valueChanged (_id, value?1:0);
}

void Control::setDefault ()
{
    setValue (_default);
}

void Control::setValue (int value)
{
    switch (_type)
    {
    case V4L2_CTRL_TYPE_INTEGER:
        _widget.spin->setValue (value);
        break;
    case V4L2_CTRL_TYPE_BOOLEAN:
        _widget.check->setChecked (value);
        break;
    case V4L2_CTRL_TYPE_MENU:
        _widget.combo->setCurrentIndex (value-_min);
        break;
    default:
        break;
    }
}

void Control::setValuefromSettings ()
{
    int value = globalsettings.value(_name, _default).toInt();
    setValue (value);
}

void Control::addItem (char* name)
{
    if (_type == V4L2_CTRL_TYPE_MENU)
    {
        _widget.combo->addItem (name);
        if (_default==_widget.combo->count()-1) _widget.combo->setCurrentIndex (_default);
        setValuefromSettings ();
    }
}

int Control::getValue ()
{
    switch (_type)
    {
    case V4L2_CTRL_TYPE_INTEGER:
        return _widget.spin->value ();
        break;
    case V4L2_CTRL_TYPE_BOOLEAN:
        return _widget.check->isChecked ();
        break;
    case V4L2_CTRL_TYPE_MENU:
        return _widget.combo->currentIndex()+_min;
        break;
    default:
        return 0;
        break;
    }
}
