#ifndef CONTROL_H
#define CONTROL_H

#include <linux/videodev2.h>

#include <QPushButton>
#include <QSpinBox>
#include <QCheckBox>
#include <QComboBox>
#include <QLabel>

union ControlWidget
{
    QSpinBox  *spin;
    QCheckBox *check;
    QComboBox *combo;
};

class Control : public QObject
{
    Q_OBJECT

private:
    v4l2_ctrl_type _type;
    QLabel  *_label;
    QString _name;
    int      _min;

    int      _default;
    int      _id;

    union ControlWidget _widget;

public:
    const QString& name () {return _name;}
    QLabel* label () {return _label;}
    ControlWidget widget() {return _widget;}

    Control (struct v4l2_queryctrl& ctrl);
    ~Control ();

    void setDefault();
    void setValue(int);
    void setValuefromSettings();
    void addItem (char* name);
    int getValue ();

public slots:
    void emitValueChanged (int);
    void emitValueChanged (bool);

signals:
    void valueChanged (int, int);
};

#endif // CONTROL_H
