#ifndef UI_H
#define UI_H

#include "capture.h"

#include <QLabel>
#include <QMainWindow>

namespace Ui
{
    class MainWindow;
    class Screen;
    class OpenDeviceDialog;
};

class Screen : public QLabel
{
private:
    bool _move_target;

public:
    Screen (QWidget *p);
    ~Screen ();

protected:
    virtual void paintEvent (QPaintEvent * event);

    virtual void mousePressEvent (QMouseEvent* event);
    virtual void mouseReleaseEvent (QMouseEvent* event);
    virtual void mouseMoveEvent (QMouseEvent* event);

};

class MainWindow : public QMainWindow
{
    Q_OBJECT

private:
    Ui::MainWindow *ui;
    Capture *capture;

protected:
    virtual void closeEvent (QCloseEvent* event);
    virtual void keyPressEvent (QKeyEvent *event);

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:
    void show_buffer (uchar *buffer, int width, int height);
    void lockTarget (int b);
    void incTarget (int i);
    void countTarget (int c);

};


class OpenDeviceDialog : public QDialog
{
    Q_OBJECT

private:
    Ui::OpenDeviceDialog *ui;

public:
    OpenDeviceDialog (QWidget *p);
    ~OpenDeviceDialog ();

    QString devicename ();

};

#endif // UI_H
