/**************************************************************************************************
*	  			  SSD1289 color Graphical LCD Display Driver
* File name		: SSD1289.h
* Programmer 	: jaruwit supa
* Web presence  : www.circuitidea.com
* Note			: SSD1289 16 bit interface.for 8 bit use 74lv573 to latch HI byte
* Language		: avrGCC
* Hardware		: atmega16
* Date			: 01/05/2009
************************************************************************************************/

#ifndef __SSD1289X16_H__
#define __SSD1289X16_H__

/* _____CONFIG DEFINES_____________________________________________________ */
#define LCD_BL_HARDWARE	// black light jumper

/* _____HARDWARE DEFINES_____________________________________________________ */
#define LCD_LO_DDR  PORTB.DIR
#define LCD_LO_PORT PORTB.OUT
#define LCD_LO_PIN  PORTB.IN


#define LCD_HI_DDR  PORTC.DIR
#define LCD_HI_PORT PORTC.OUT
#define LCD_HI_PIN  PORTC.IN



#define LCD_RS_DDR  PORTD.DIR
#define LCD_RS_PORT PORTD.OUT
#define LCD_RS_PIN  PORTD.IN
#define LCD_RS_BIT  0

#define LCD_WR_DDR  PORTD.DIR
#define LCD_WR_PORT PORTD.OUT
#define LCD_WR_PIN  PORTD.IN
#define LCD_WR_BIT  1

#define LCD_RD_DDR  PORTD.DIR
#define LCD_RD_PORT PORTD.OUT
#define LCD_RD_PIN  PORTD.IN
#define LCD_RD_BIT  2

#define LCD_CS_DDR  PORTD.DIR
#define LCD_CS_PORT PORTD.OUT
#define LCD_CS_PIN  PORTD.IN
#define LCD_CS_BIT  3

#define LCD_RST_DDR  PORTD.DIR
#define LCD_RST_PORT PORTD.OUT
#define LCD_RST_PIN  PORTD.IN
#define LCD_RST_BIT  4

#ifndef LCD_BL_HARDWARE
	#define LCD_BL_DDR  PORTD.DIR
	#define LCD_BL_PORT PORTD.OUT
	#define LCD_BL_PIN  PORTD.IN
	#define LCD_BL_BIT  5
#endif


#define LCD_SET_CS()  LCD_CS_PORT  |=  (1<<LCD_CS_BIT)
#define LCD_CLR_CS()  LCD_CS_PORT  &= ~(1<<LCD_CS_BIT)
#define LCD_DIR_CS(x) LCD_CS_DDR   |=  (1<<LCD_CS_BIT)

#define LCD_SET_RS()  LCD_RS_PORT  |=  (1<<LCD_RS_BIT)
#define LCD_CLR_RS()  LCD_RS_PORT  &= ~(1<<LCD_RS_BIT)
#define LCD_DIR_RS(x) LCD_RS_DDR   |=  (1<<LCD_RS_BIT)

#define LCD_SET_WR()  LCD_WR_PORT  |=  (1<<LCD_WR_BIT)
#define LCD_CLR_WR()  LCD_WR_PORT  &= ~(1<<LCD_WR_BIT)
#define LCD_DIR_WR(x) LCD_WR_DDR   |=  (1<<LCD_WR_BIT)

#define LCD_SET_RD()  LCD_RD_PORT  |=  (1<<LCD_RD_BIT)
#define LCD_CLR_RD()  LCD_RD_PORT  &= ~(1<<LCD_RD_BIT)
#define LCD_DIR_RD(x) LCD_RD_DDR   |=  (1<<LCD_RD_BIT)

#define LCD_SET_RST()  LCD_RST_PORT |= (1<<LCD_RST_BIT)
#define LCD_CLR_RST()  LCD_RST_PORT &= ~(1<<LCD_RST_BIT)
#define LCD_DIR_RST(x) LCD_RST_DDR  |= (1<<LCD_RST_BIT)

#define LCD_SET_LATCH()  LCD_LATCH_PORT |=  (1<<LCD_LATCH_BIT)
#define LCD_CLR_LATCH()  LCD_LATCH_PORT &= ~(1<<LCD_LATCH_BIT)
#define LCD_DIR_LATCH(x) LCD_LATCH_DDR  |=  (1<<LCD_LATCH_BIT)

#ifndef LCD_BL_HARDWARE
	#define LCD_BL_OFF()	LCD_BL_DDR  |=  (1<<LCD_BL_BIT); \
							LCD_BL_PORT &= ~(1<<LCD_BL_BIT)
	#define LCD_BL_ON()		LCD_BL_DDR  |=  (1<<LCD_BL_BIT); \
							LCD_BL_PORT |=  (1<<LCD_BL_BIT)
#else
	#define LCD_BL_OFF()
	#define LCD_BL_ON()
#endif

	#define LCD_INPUT()		LCD_LO_DDR = 0x00; \
							LCD_HI_DDR = 0x00
	#define LCD_OUTPUT()	LCD_LO_DDR = 0xFF; \
							LCD_HI_DDR = 0xFF
	#define LCD_MODE()

	#define LCD_SET_DBH(x)	LCD_HI_PORT = x
	#define LCD_SET_DBL(x)	LCD_LO_PORT = x

	#define LCD_GET_DBH()	LCD_HI_PIN
	#define LCD_GET_DBL()	LCD_LO_PIN


/* _____PUBLIC DEFINE_____________________________________________________ */
#define Horizontal

#ifdef Horizontal
	// Horizontal and vertical screen size
	#define SCREEN_HOR_SIZE    240UL
	#define SCREEN_VER_SIZE    320UL
#else
	// Horizontal and vertical screen size
	#define SCREEN_HOR_SIZE    320UL
	#define SCREEN_VER_SIZE    240UL
#endif

// color
#define BLACK                       RGB(0x00, 0x00, 0x00)
#define WHITE                       RGB(0xFF, 0xFF, 0xFF)
#define RED                         RGB(0xFF, 0x00, 0x00)
#define GREEN                       RGB(0x00, 0xFF, 0x00)
#define BLUE                        RGB(0x00, 0x00, 0xFF)
#define YELLOW                      RGB(0xFF, 0xFF, 0x00)
#define MAGENTA                     RGB(0xFF, 0x00, 0xFF)
#define CYAN                        RGB(0x00, 0xFF, 0xFF)
#define GRAY                        RGB(0x80, 0x80, 0x40)
#define SILVER                      RGB(0xA0, 0xA0, 0x80)
#define GOLD                        RGB(0xA0, 0xA0, 0x40)

/* _____PUBLIC VARIABLE_____________________________________________________ */
extern unsigned int _color;

/* _____PUBLIC FUNCTIONS_____________________________________________________ */
extern void LCD_Reset(void);
extern void LCD_SetCursor(unsigned int x, unsigned int y);
extern void LCD_SetArea(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2);
extern void LCD_PutPixel(unsigned int x, unsigned int y);
extern void LCD_Bar(unsigned int left, unsigned int top, unsigned int right, unsigned int bottom, unsigned int color);
extern void LCD_Clear(unsigned int color);
extern void LCD_DrawSymbol(unsigned int x, unsigned int y, unsigned int w, unsigned int h, unsigned char t, const unsigned char *pImage);
extern void LCD_DrawImage(unsigned int x, unsigned int y, const unsigned char *pImage);

/* _____DEFINE MACRO_________________________________________________________ */
#define GetMaxX() 		((unsigned int)SCREEN_HOR_SIZE-1)
#define GetMaxY() 		((unsigned int)SCREEN_VER_SIZE-1)

#define RGB(red, green, blue)	((unsigned int)( (( red >> 3 ) << 11 ) | \
								(( green >> 2 ) << 5  ) | \
								( blue  >> 3 )))

#define SetColor(color) _color = color
#define GetColor()      _color

#endif
