/**************************************************************************************************
* ADS7843 touch screen Driver
* File name     : touch.h
* Programmer    : jaruwit supa
* Web presence  : www.circuitidea.com
* Note          : BL-TFT240320PLUS using ADS7843 driver
* Language      : avrGCC
* Hardware      : arduino
* Date          : 20/12/2009
************************************************************************************************
* DESCRIPTION
* ===========
	BL-TFT240320PLUS contain touch screen ADS7843.
driver touch screen using 10 bit(1024) to calibrate(not include in api)
Calibrate routine use for calibrate and save matrix to eeprom. 
touch screenclass wil read back on init class.
Change eeprom location by change #define EE_MATRIX_ADDR

Because of no hardware PENIRQ so lowest point require for test touch press or not.
Change #define ADC_MIN_Y for untouch condition. becare full 10 bit(1024) is base.

************************************************************************************************/

#include "ads7843.h"
//#include "touch.h"

void touchscreen(void)
{
	getMatrix();
}

/* _____Private _____________________________________________________________ */
unsigned char readADC(unsigned char axis)
{
	SPIE_DATA = axis;				// transfer axis
	spi_wait_for_idle() ;	// wait for complete
	return (SPIE_DATA);				// get data
}    

void readTouch(POINT * pADC_point)
{
    unsigned int x,y;
	unsigned char buf_data[4];

	// enable touch screen 
	TS_CS_PORT	&= ~(1<<TS_CS_BIT);	// Enable CS
	buf_data[2] = readADC(0x94);	//Write Command Measure Y-Position ; 
	buf_data[2] = readADC(0x00);	//Read ADC data X-Position (7-bit byte High) data: 0ddddddd	(bit11-bit5)
	buf_data[3] = readADC(0x00);	//Read ADC data Y-Position(5-bit byte Low)  data: ddddd000 (bit)
	buf_data[0] = readADC(0xD4);	//Write Command Measure X-Position
	buf_data[0] = readADC(0x00);	//Read ADC data X-Position (7-bit byte High) data: 0ddddddd	(bit11-bit5)
	buf_data[1] = readADC(0x00);	//Read ADC data X-Position (5-bit byte Low)  data:ddddd000(bit)

	// disable touch screen
	TS_CS_PORT	|= (1<<TS_CS_BIT);	// Disable CS

	x  = (unsigned int)buf_data[0] << 5;	// Shift 7 bit High
	x |= (unsigned int)buf_data[1] >> 3;	// Shift 5 bit low

	y  = (unsigned int)buf_data[2] << 5;   	// Shift 7 bit High
	y |= (unsigned int)buf_data[3] >> 3;   	// Shift 5 bit low

	// using 10 bit for 3 point calibrate. by integrate 4 point(0,1,2,3) in to 1 point
	pADC_point->x = x >> 2;				// Modified orig 2
	pADC_point->y = (4095L-y) >> 2;			//	"
}

void sampling(POINT * pScreen, unsigned char nTest)
{
	POINT adcPoint;

	long avgX, avgY;
    
	unsigned char i;				// scan counter
	unsigned char nInvalid;			// Invalid counter
    
	pScreen->x = 0;
    	pScreen->y = 0;
   
	readTouch(&adcPoint);			// Read value ADC Touch X-Y
	if (adcPoint.y < ADC_MIN_Y) 	// inactive touch
		return;

	avgX = adcPoint.x;
	avgY = adcPoint.y;

    nInvalid = 0;
    i = nTest;
    do
	{
        if (++nInvalid > 20)			// too many error. touch not long enought 
        	return;
            
    	readTouch(&adcPoint);			// Read value ADC Touch X-Y
    	if (adcPoint.y < ADC_MIN_Y)		// inactive touch
        	continue;

		// average with 
		avgX += adcPoint.x;
		avgX >>= 1;
		avgY += adcPoint.y;
		avgY >>= 1;

        nInvalid = 0;						// reset invalid
    } while (--i);

    pScreen->x = avgX;
    pScreen->y = avgY;
}

/* _____Public _______________________________________________________________ */
void init_ads7843(void)
{
   
   	PORTE_DIRCLR  = (1 << BUSSY) | (1 << PENINT ) ; 
   	
	
 	TS_CS_PORT	|= (1<<TS_CS_BIT);						// Disable CS
	TS_CS_DDR	|= (1<<TS_CS_BIT);						// Turns on CS pin as output

	TS_SPI_DDR	|= (1<<TS_SCK_BIT)|(1<<TS_MOSI_BIT) | (1<<TS_CS_BIT);
	TS_SPI_DDR &= ~ (1<<TS_MISO_BIT);					// if SS is input

	
	//PORTE.PIN5CTRL 	=  PORT_OPC_PULLUP_gc;   
	//PORTE.PIN4CTRL 	=  PORT_OPC_PULLUP_gc;
	
	SPIE.CTRL =  SPI_MODE_0_gc | SPI_PRESCALER_DIV64_gc | (1<< SPI_CLK2X_bp) | (1<< SPI_ENABLE_bp) | (1<< SPI_MASTER_bp);
	SPIE.INTCTRL = SPI_INTLVL_OFF_gc;
  	SPIE.STATUS = 0;

}    

void getMatrix(void)
{
	//eeprom_read_block((void*)&matrix, (const void*)EE_MATRIX_ADDR, sizeof(MATRIX));
}

void setMatrix(void)
{
	//eeprom_write_block((const void*)&matrix, (void*)EE_MATRIX_ADDR, sizeof(MATRIX));
}

void readPoint(void)
{
	sampling(&screenPoint, 100);     //Modified..... orig 10
	if ((screenPoint.x == 0) || (screenPoint.y == 0))
	{
		displayPoint.x = displayPoint.y = 0;
	}
	else
	{
		displayPoint.x = ((matrix.An * screenPoint.x) + (matrix.Bn * screenPoint.y) + matrix.Cn) / matrix.Divider;
		displayPoint.y = ((matrix.Dn * screenPoint.x) + (matrix.En * screenPoint.y) + matrix.Fn) / matrix.Divider;
    }

	if (displayPoint.x < 0)
		displayPoint.x = 0;
        
	if (displayPoint.y < 0)
		displayPoint.y = 0;

}
