#ifndef ADS7843_H
#define ADS7843_H

#include <avr/io.h>
typedef struct Point
{
	long x;
	long y;
} POINT;

typedef struct Matrix
{
	long An;
	long Bn;
	long Cn;
	long Dn;
	long En;
	long Fn;
	long Divider;
} MATRIX;

// touchscreen hardware define
#define ADC_MIN_Y		(50)	// minumum adc from touch sccreen device


	POINT samplePoint;		// display(LCD) view point from action
	POINT screenPoint;		// touch screen point
	POINT displayPoint;		// display(LCD) view point
	MATRIX matrix;
	

/* _____HARDWARE DEFINES_____________________________________________________ */

#define BUSSY       3   
#define PENINT      2    


//Define a function that waits until SPI interface is idle
#define spi_wait_for_idle()   while(!(SPIE.STATUS & (1<<SPI_IF_bp)))


//Define how to write to SPI data register
#define spi_write(i) SPIE_DATA = i


#define TS_SPI_DDR  PORTE_DIR
#define TS_SPI_PORT PORTE_OUT
#define TS_SPI_PIN  PORTE_IN


#define TS_MOSI_BIT	5
#define TS_MISO_BIT	6
#define TS_SCK_BIT	7

#define TS_CS_DDR  PORTE_DIR
#define TS_CS_PORT PORTE_OUT
#define TS_CS_PIN  PORTE_IN
#define TS_CS_BIT 4


/* _____Constructor__________________________________________________________ */

void touchscreen(void);
unsigned char readADC(unsigned char axis);
void init_ads7843(void);
void getMatrix(void);
void setMatrix(void);
void readPoint(void);
void sampling(POINT *pScreen, unsigned char nTest);
void readTouch(POINT *pADC_point);
/* _____PROJECT INCLUDES_____________________________________________________ */

#endif