/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : fn21x55_1.h
    Date                : 06.03.2012
    Font size in bytes  : 0x06F6, 1782
    Font width          : 22
    Font height         : 38
    Font first char     : 0x20
    Font last char      : 0xB0
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#ifndef fn21x55_H
#define fn21x55_H

#include <inttypes.h>
#include <avr/pgmspace.h>

#define fn21x55_WIDTH 22
#define fn21x55_HEIGHT 38

unsigned char const __attribute__ ((progmem)) fn21x55[] = {
    0x06, 0xF6, 0x16, 0x26, 0x01, 0x20, 0xB0,
    0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x15, 0x09, 0x0D, 0x08, 0x0E, 
    0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x13, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x80, 0x87, 
    0x03, 0x00, 0x00, 0xE0, 0xF1, 0x01, 0x00, 0x00, 0x78, 0x7C, 0x00, 0x00, 0x00, 0x9C, 0x1F, 0x00, 
    0x00, 0x00, 0xE6, 0x03, 0x00, 0x00, 0x8E, 0x7D, 0x00, 0x00, 0xC0, 0xCF, 0x01, 0x00, 0x00, 0xF0, 
    0x3F, 0x00, 0x00, 0x00, 0xFC, 0x1C, 0x00, 0x00, 0x00, 0x8E, 0x7D, 0x00, 0x00, 0x00, 0x60, 0x3E, 
    0x00, 0x00, 0x00, 0x9C, 0x1F, 0x00, 0x00, 0x80, 0xC7, 0x07, 0x00, 0x00, 0xE0, 0xF1, 0x01, 0x00, 
    0x00, 0x78, 0x38, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 
    0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 
    0x00, 0x0E, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
    0xFF, 0x01, 0xC0, 0xFF, 0xFF, 0x7F, 0x00, 0xF0, 0xFF, 0xFF, 0x1F, 0x00, 0x00, 0xE0, 0x00, 0x00, 
    0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 
    0xE0, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x80, 0x03, 
    0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0x00, 0xF8, 0x01, 
    0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x08, 0x00, 0x00, 0xF0, 0x0F, 0x01, 0x00, 
    0x00, 0xFC, 0x61, 0x00, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x00, 0x80, 
    0x1F, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 
    0x00, 0xC0, 0x07, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 
    0x1F, 0x00, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x7C, 0x00, 
    0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x80, 0x1F, 0x00, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0x00, 
    0xFC, 0x03, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0xE0, 0x07, 
    0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 
    0x00, 0xE0, 0x0F, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x00, 0xF8, 0x1F, 0x00, 0x00, 0xC0, 0xFF, 
    0x00, 0x00, 0x00, 0xFE, 0x07, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x00, 
    0xFC, 0x07, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0xFC, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 
    0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x01, 0x00, 0x00, 0xFE, 0xFF, 0x07, 
    0x00, 0xE0, 0xFF, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0xFF, 0x03, 0xC0, 0xFF, 0xFF, 0xFF, 0x03, 0xF0, 
    0xFF, 0xFF, 0xFF, 0x00, 0xFE, 0xFF, 0xFF, 0x7F, 0x80, 0x07, 0x00, 0x00, 0x1E, 0x70, 0x00, 0x00, 
    0x00, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x30, 
    0x70, 0x00, 0x00, 0x00, 0x0E, 0x38, 0x00, 0x00, 0xC0, 0x01, 0xFE, 0xFF, 0xFF, 0x7F, 0x00, 0xFF, 
    0xFF, 0xFF, 0x0F, 0xC0, 0xFF, 0xFF, 0xFF, 0x03, 0xE0, 0xFF, 0xFF, 0x7F, 0x00, 0xE0, 0xFF, 0xFF, 
    0x07, 0x00, 0xE0, 0xFF, 0x7F, 0x00, 0x00, 0x80, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x20, 0x00, 0x03, 0x00, 0x00, 0x08, 0x40, 0x00, 
    0x00, 0x00, 0x02, 0x18, 0x00, 0x00, 0x80, 0x00, 0x0E, 0x00, 0x00, 0x30, 0x80, 0xFF, 0xFF, 0xFF, 
    0x0F, 0xF0, 0xFF, 0xFF, 0xFF, 0x03, 0xFC, 0xFF, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0x3F, 0xE0, 
    0xFF, 0xFF, 0xFF, 0x0F, 0xFC, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 
    0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x80, 
    0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x00, 0x70, 0x00, 0x00, 0x30, 0x00, 0x0F, 0x00, 0x00, 0x0F, 0xE0, 0x01, 0x00, 
    0xE0, 0x03, 0x7C, 0x00, 0x00, 0xFC, 0x80, 0x0F, 0x00, 0x80, 0x3F, 0xE0, 0x03, 0x00, 0xF8, 0x0F, 
    0xFC, 0x00, 0x00, 0xFF, 0x03, 0x3F, 0x00, 0xF0, 0xFD, 0xC0, 0x1F, 0x00, 0x3E, 0x3F, 0xF0, 0x0F, 
    0xE0, 0xC7, 0x0F, 0xFC, 0x07, 0xFE, 0xF0, 0x03, 0xFF, 0xFF, 0x0F, 0xFC, 0x80, 0xFF, 0xFF, 0x01, 
    0x3F, 0xE0, 0xFF, 0x3F, 0xC0, 0x0F, 0xF0, 0xFF, 0x07, 0xF0, 0x03, 0xFC, 0x7F, 0x00, 0xFC, 0x00, 
    0xFC, 0x0F, 0x00, 0x3F, 0x00, 0x7E, 0x00, 0xE0, 0x0F, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 
    0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x02, 0x00, 0xE0, 0x07, 0xC0, 0x00, 0x00, 0xF8, 
    0x01, 0x18, 0x00, 0x00, 0xFE, 0x00, 0x03, 0x00, 0x00, 0x3F, 0x60, 0x00, 0x00, 0x80, 0x0F, 0x18, 
    0x00, 0x01, 0xC0, 0x03, 0x06, 0x40, 0x00, 0xF0, 0xC0, 0x01, 0x38, 0x00, 0x38, 0xF0, 0x00, 0x0E, 
    0x00, 0x0E, 0x3C, 0xC0, 0x07, 0x80, 0x03, 0x3F, 0xFC, 0x03, 0xE0, 0xC0, 0xFF, 0xFF, 0x01, 0x1C, 
    0xF0, 0xFF, 0xFF, 0x81, 0x07, 0xFC, 0xDF, 0xFF, 0xFF, 0x00, 0xFE, 0xF7, 0xFF, 0x3F, 0x00, 0xFF, 
    0xF8, 0xFF, 0x07, 0xC0, 0x1F, 0xFE, 0xFF, 0x00, 0xC0, 0x03, 0xFF, 0x1F, 0x00, 0x00, 0x80, 0xFF, 
    0x03, 0x00, 0x00, 0x80, 0x1F, 0x00, 0x00, 0x00, 0x80, 0x1F, 0x00, 0x00, 0x00, 0xF0, 0x07, 0x00, 
    0x00, 0x00, 0xF6, 0x01, 0x00, 0x00, 0xE0, 0x7C, 0x00, 0x00, 0x00, 0x1C, 0x1F, 0x00, 0x00, 0x80, 
    0xC1, 0x07, 0x00, 0x00, 0x38, 0xF0, 0x01, 0x00, 0x00, 0x07, 0x7C, 0x00, 0x00, 0x60, 0x00, 0x1F, 
    0x00, 0x00, 0x0E, 0xC0, 0x07, 0x00, 0xC0, 0x01, 0xF0, 0x01, 0x00, 0xF8, 0xFF, 0xFF, 0x3F, 0x80, 
    0xFF, 0xFF, 0xFF, 0x0F, 0xF0, 0xFF, 0xFF, 0xFF, 0x03, 0xFE, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 
    0xFF, 0x3F, 0xF0, 0xFF, 0xFF, 0xFF, 0x0F, 0xFC, 0xFF, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x01, 
    0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x02, 0x70, 0x00, 0x00, 
    0xF0, 0x00, 0x3E, 0x00, 0x80, 0x3F, 0x80, 0x1F, 0x00, 0xF8, 0x0F, 0xE0, 0x07, 0xC0, 0xFF, 0x03, 
    0xF8, 0x03, 0x7E, 0xFE, 0x00, 0xFC, 0xC0, 0x8F, 0x3F, 0x00, 0x3E, 0xF0, 0xE3, 0x0F, 0x80, 0x0F, 
    0xFC, 0xF8, 0x07, 0xC0, 0x03, 0x3F, 0xFC, 0x01, 0xE0, 0xC0, 0x0F, 0x7F, 0x00, 0x38, 0xF0, 0xC3, 
    0x3F, 0x00, 0x0C, 0xFC, 0xF0, 0x0F, 0x00, 0x03, 0x3F, 0xF8, 0x07, 0x40, 0xC0, 0x0F, 0xFE, 0x01, 
    0x10, 0xF0, 0x03, 0xFF, 0x00, 0x06, 0xFC, 0xC0, 0x7F, 0x80, 0x00, 0x3F, 0xE0, 0x7F, 0x38, 0xC0, 
    0x0F, 0xF0, 0xFF, 0x07, 0xF0, 0x01, 0xF8, 0x7F, 0x00, 0x0C, 0x00, 0xF0, 0x07, 0x00, 0x00, 0x00, 
    0xFF, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0xC0, 0xFF, 0xFF, 0x00, 0x00, 0xF8, 0xFF, 0x7F, 
    0x00, 0x80, 0xFF, 0xFF, 0x3F, 0x00, 0xF0, 0xFF, 0xFF, 0x1F, 0x00, 0xFE, 0xFF, 0xFF, 0x07, 0x80, 
    0xBF, 0x01, 0xF8, 0x01, 0xF0, 0x23, 0x00, 0xF0, 0x00, 0x3E, 0x0C, 0x00, 0x38, 0x80, 0x03, 0x03, 
    0x00, 0x0C, 0x70, 0xC0, 0x01, 0x00, 0x03, 0x1C, 0xF0, 0x00, 0xC0, 0x80, 0x03, 0xFC, 0x00, 0x3C, 
    0x60, 0x00, 0xFF, 0xFF, 0x07, 0x18, 0x80, 0xFF, 0xFF, 0x01, 0x03, 0xE0, 0xFF, 0x3F, 0xC0, 0x00, 
    0xF0, 0xFF, 0x0F, 0x30, 0x00, 0xFC, 0xFF, 0x01, 0x04, 0x00, 0xFC, 0x1F, 0x00, 0x01, 0x00, 0xFC, 
    0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x80, 0x1F, 0x00, 0x00, 0x00, 0xFC, 0x03, 0x00, 0x00, 0x00, 
    0x7F, 0x00, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x00, 0x00, 0xFC, 0x00, 
    0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0xC0, 0xC0, 0x0F, 0x00, 0x00, 0x3E, 0xF0, 0x03, 0x00, 0xF0, 
    0x0F, 0xFC, 0x00, 0x80, 0xFF, 0x00, 0x3F, 0x00, 0xFC, 0x07, 0xC0, 0x0F, 0xE0, 0x3F, 0x00, 0xF0, 
    0x03, 0xFF, 0x01, 0x00, 0xFC, 0xF8, 0x0F, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0xC0, 0xFF, 0x03, 
    0x00, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x80, 0x1F, 0xC0, 0x7F, 0x00, 0xF0, 
    0x1F, 0xF8, 0x3F, 0x00, 0xFF, 0x0F, 0xFE, 0x0F, 0xC0, 0xFF, 0xC7, 0xFF, 0x07, 0xF8, 0xFF, 0x71, 
    0xE0, 0x01, 0xFE, 0xFF, 0x0E, 0xE0, 0xC0, 0xFF, 0xFF, 0x01, 0x38, 0xF0, 0xF0, 0x3F, 0x00, 0x0C, 
    0x1C, 0xF8, 0x0F, 0x00, 0x03, 0x03, 0xFC, 0x07, 0xC0, 0xC0, 0x00, 0xFE, 0x03, 0x30, 0x30, 0x00, 
    0xFF, 0x01, 0x0E, 0x1C, 0xC0, 0xFF, 0xC1, 0x03, 0x0F, 0xFC, 0xFF, 0x7F, 0x80, 0xFF, 0xFF, 0xFF, 
    0x1F, 0xE0, 0xFF, 0xF9, 0xFF, 0x07, 0xF0, 0x3F, 0xFC, 0xFF, 0x00, 0xF8, 0x07, 0xFE, 0x1F, 0x00, 
    0xF8, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x02, 0xE0, 0xFF, 
    0x00, 0x80, 0x00, 0xFE, 0xFF, 0x00, 0x30, 0xC0, 0xFF, 0x3F, 0x00, 0x0C, 0xF0, 0xFF, 0x1F, 0x00, 
    0x03, 0xFE, 0xFF, 0x07, 0x60, 0x80, 0xFF, 0xFF, 0x03, 0x18, 0xF0, 0x00, 0xFC, 0x00, 0x07, 0x0C, 
    0x00, 0x3C, 0xE0, 0x00, 0x03, 0x00, 0x0E, 0x38, 0xC0, 0x00, 0x00, 0x03, 0x0F, 0x70, 0x00, 0xC0, 
    0xF0, 0x01, 0x3C, 0x00, 0x10, 0x3F, 0x00, 0x7E, 0x00, 0xF6, 0x0F, 0x80, 0xFF, 0xFF, 0xFF, 0x01, 
    0xC0, 0xFF, 0xFF, 0x3F, 0x00, 0xF0, 0xFF, 0xFF, 0x07, 0x00, 0xF8, 0xFF, 0xFF, 0x00, 0x00, 0xFC, 
    0xFF, 0x0F, 0x00, 0x00, 0xFC, 0xFF, 0x00, 0x00, 0x00, 0xF8, 0x07, 0x00, 0x00, 0x00, 0xF0, 0x00, 
    0x78, 0x00, 0x00, 0x7E, 0x00, 0x3F, 0x00, 0xC0, 0x3F, 0xE0, 0x1F, 0x00, 0xF0, 0x0F, 0xF8, 0x07, 
    0x00, 0xFC, 0x03, 0xFE, 0x01, 0x00, 0xFF, 0x80, 0x7F, 0x00, 0x80, 0x1F, 0xC0, 0x0F, 0x00, 0xC0, 
    0x03, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 
    0x00, 0xE0, 0xFF, 0x00, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 0x80, 0xFF, 0x1F, 0x00, 0x00, 0xE0, 
    0xFF, 0x07, 0x00, 0x00, 0x7C, 0xF8, 0x03, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0xC0, 0x01, 0x3E, 
    0x00, 0x00, 0x30, 0x00, 0x0F, 0x00, 0x00, 0x0C, 0xC0, 0x03, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 
    0xC0, 0x01, 0x1C, 0x00, 0x00, 0xF0, 0x80, 0x07, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0xFE, 
    0x1F, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00
};

#endif

