/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : fn31x45.h
    Date                : 10/12/2009
    Font size in bytes  : 0x06E6, 1766
    Font width          : 29
    Font height         : 45
    Font first char     : 0x20
    Font last char      : 0x39
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#ifndef fn31x45_H
#define fn31x45_H

#include <inttypes.h>
#include <avr/pgmspace.h>

#define fn31x45_WIDTH 29
#define fn31x45_HEIGHT 45

unsigned char const __attribute__ ((progmem)) fn31x45[] = {
    0x06, 0xE6, 0x1D, 0x2D, 0x01, 0x20, 0x39,
    0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 
    0xFF, 0x01, 0x00, 0x00, 0xF0, 0xFF, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0xFF, 0xFF, 0x03, 0x00, 0xFE, 
    0xFF, 0xFF, 0xFF, 0x03, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 0xE0, 
    0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
    0x7C, 0x00, 0x00, 0x00, 0x80, 0xDF, 0x03, 0x00, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x00, 
    0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 
    0x00, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x7D, 0x00, 0x00, 
    0x00, 0x00, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF8, 0xFF, 
    0xFF, 0xFF, 0xFF, 0x03, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xE0, 
    0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0xF0, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0xF0, 0xFF, 0xFF, 0x07, 0x00, 
    0x00, 0xC0, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 
    0x00, 0x04, 0x0C, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x40, 0x70, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x1E, 0x00, 
    0x00, 0x00, 0xC0, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 
    0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 
    0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
    0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 
    0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
    0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x18, 
    0x00, 0x00, 0x00, 0x18, 0xE0, 0x01, 0x00, 0x00, 0xC0, 0x03, 0x1E, 0x00, 0x00, 0x00, 0x7C, 0xF0, 
    0x01, 0x00, 0x00, 0xC0, 0x0F, 0x1F, 0x00, 0x00, 0x00, 0xFC, 0xF1, 0x03, 0x00, 0x00, 0xC0, 0x3F, 
    0x3E, 0x00, 0x00, 0x00, 0xFE, 0xE7, 0x07, 0x00, 0x00, 0xE0, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0xFE, 
    0xDF, 0x1F, 0x00, 0x00, 0xF0, 0xFD, 0xFB, 0x03, 0x00, 0x00, 0x9F, 0x7F, 0xFF, 0x00, 0x00, 0xF0, 
    0xF1, 0xEF, 0x1F, 0x00, 0x80, 0x1F, 0xFE, 0xFD, 0x07, 0x00, 0xFC, 0xC1, 0xBF, 0xFF, 0x01, 0xE0, 
    0x1F, 0xF8, 0xF7, 0xFF, 0x80, 0xFF, 0x01, 0xFF, 0xFE, 0xFF, 0xFF, 0x1F, 0xE0, 0x9F, 0xFF, 0xFF, 
    0xFF, 0x01, 0xFC, 0xF3, 0xFF, 0xFF, 0x1F, 0x80, 0x7F, 0xFC, 0xFF, 0xFF, 0x00, 0xF0, 0x8F, 0xFF, 
    0xFF, 0x0F, 0x00, 0xFE, 0xE1, 0xFF, 0x7F, 0x00, 0xC0, 0x3F, 0xF8, 0xFF, 0x07, 0x00, 0xF8, 0x07, 
    0xFC, 0x3F, 0x00, 0x80, 0xFF, 0x00, 0xFE, 0x00, 0x00, 0xF8, 0x1F, 0x00, 0x00, 0x00, 0x80, 0x1F, 
    0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x20, 0x00, 0x00, 0x00, 
    0x7F, 0x00, 0x06, 0x00, 0x00, 0xF0, 0x1F, 0x70, 0x00, 0x00, 0x00, 0xFE, 0x07, 0x07, 0x00, 0x00, 
    0xC0, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x0E, 0x00, 0x00, 0x00, 0xFC, 0xE7, 0x00, 0x00, 
    0x00, 0x00, 0xFF, 0x1E, 0x00, 0x10, 0x00, 0xE0, 0xDF, 0x03, 0x00, 0x02, 0x00, 0xF8, 0x7B, 0x00, 
    0xE0, 0x00, 0x00, 0xFE, 0x0F, 0x00, 0x1C, 0x00, 0x80, 0xFF, 0x01, 0xC0, 0x07, 0x00, 0xF0, 0x7F, 
    0x00, 0xF8, 0x00, 0x00, 0xFE, 0x0F, 0x80, 0x3F, 0x00, 0xC0, 0xFF, 0x03, 0xF8, 0x0F, 0x00, 0x78, 
    0xFF, 0xC1, 0xFF, 0x03, 0x80, 0xEF, 0xFF, 0xFF, 0xFF, 0x01, 0xF8, 0xFD, 0xFF, 0xFF, 0xFF, 0xC0, 
    0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xEF, 0xFF, 0xFF, 0x3F, 0xFC, 0xFF, 0xFC, 0xFF, 
    0xFF, 0x03, 0xFF, 0x0F, 0xFF, 0xFF, 0x7F, 0xC0, 0xFF, 0xC1, 0xFF, 0xFF, 0x07, 0xF0, 0x1F, 0xF8, 
    0xFF, 0x3F, 0x00, 0xF8, 0x00, 0xFC, 0xFF, 0x03, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0x00, 0x00, 
    0x80, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x07, 0x00, 0x00, 
    0x00, 0xC0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x9C, 0x1F, 0x00, 0x00, 0x00, 0xE0, 0xF1, 0x03, 0x00, 
    0x00, 0x00, 0x0E, 0x7E, 0x00, 0x00, 0x00, 0xF0, 0xC0, 0x0F, 0x00, 0x00, 0x00, 0x07, 0xF8, 0x01, 
    0x00, 0x00, 0x78, 0x00, 0x3F, 0x00, 0x00, 0x80, 0x03, 0xE0, 0x07, 0x00, 0x00, 0x38, 0x00, 0xFC, 
    0x00, 0x00, 0xC0, 0x01, 0x80, 0x1F, 0x00, 0x00, 0x1C, 0x00, 0xF0, 0x03, 0x00, 0xE0, 0x00, 0x00, 
    0x7E, 0x00, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 
    0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 
    0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 
    0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0xF8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 
    0x00, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x20, 0x00, 0xC0, 0x01, 0x00, 0x80, 0x07, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x00, 
    0xC0, 0x1F, 0x00, 0xF0, 0x1F, 0x00, 0xF8, 0x07, 0xC0, 0xFF, 0x03, 0x00, 0xFF, 0x00, 0xFE, 0x7F, 
    0x00, 0xE0, 0x3F, 0xF8, 0xF8, 0x0F, 0x00, 0xF8, 0xE7, 0x0F, 0xFF, 0x01, 0x00, 0xFE, 0xFE, 0xE1, 
    0x7F, 0x00, 0x80, 0xDF, 0x3F, 0xFC, 0x0F, 0x00, 0xF0, 0xFB, 0x07, 0xFF, 0x01, 0x00, 0x7C, 0xFF, 
    0xE0, 0x3F, 0x00, 0x00, 0xEF, 0x1F, 0xFC, 0x0F, 0x00, 0xC0, 0xFD, 0x83, 0xFF, 0x01, 0x00, 0xB8, 
    0x7F, 0xF0, 0x7F, 0x00, 0x00, 0xF6, 0x0F, 0xFC, 0x0F, 0x00, 0x40, 0xFE, 0x81, 0xFF, 0x03, 0x00, 
    0xC8, 0x3F, 0xE0, 0xFF, 0x00, 0x00, 0xF9, 0x07, 0xFC, 0x3F, 0x00, 0x30, 0xFF, 0x00, 0xFF, 0x0F, 
    0x00, 0xE2, 0x1F, 0xE0, 0xFF, 0x03, 0x60, 0xFC, 0x03, 0xF8, 0xFF, 0x03, 0x87, 0x7F, 0x00, 0xFE, 
    0xFF, 0x7F, 0xF0, 0x0F, 0x80, 0xFF, 0xFF, 0x07, 0xFE, 0x00, 0xE0, 0xFF, 0x7F, 0xC0, 0x03, 0x00, 
    0xF0, 0xFF, 0x03, 0x08, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x1F, 0x00, 0x00, 0xE0, 0xFF, 0xFF, 0x0F, 0x00, 
    0x00, 0xFF, 0xFF, 0xFF, 0x03, 0x00, 0xF0, 0xFF, 0xFF, 0xFF, 0x01, 0x80, 0xFF, 0xFF, 0xFF, 0x7F, 
    0x00, 0xF8, 0xFF, 0xFF, 0xFF, 0x1F, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xF8, 0xFF, 0xFF, 0xFF, 
    0xFF, 0x80, 0xFF, 0xFF, 0x00, 0xF8, 0x1F, 0xF8, 0xFF, 0x06, 0x00, 0xE0, 0x07, 0xFF, 0x43, 0x00, 
    0x00, 0xF0, 0xF0, 0x0F, 0x0C, 0x00, 0x00, 0x1C, 0x7F, 0x80, 0x01, 0x00, 0x00, 0xE3, 0x07, 0x30, 
    0x00, 0x00, 0x60, 0x7E, 0x00, 0x0E, 0x00, 0x00, 0xCC, 0x03, 0xC0, 0x07, 0x00, 0xC0, 0x79, 0x00, 
    0xF8, 0x0F, 0x00, 0x9E, 0x07, 0x00, 0xFF, 0xFF, 0xFF, 0x73, 0x00, 0xE0, 0xFF, 0xFF, 0x7F, 0x0E, 
    0x00, 0xF8, 0xFF, 0xFF, 0xC7, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x1C, 0x00, 0xC0, 0xFF, 0xFF, 0x8F, 
    0x01, 0x00, 0xF0, 0xFF, 0xFF, 0x30, 0x00, 0x00, 0xFC, 0xFF, 0x07, 0x02, 0x00, 0x00, 0xFE, 0x7F, 
    0x40, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 
    0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 
    0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00, 
    0x00, 0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
    0x00, 0x00, 0x00, 0x00, 0xF8, 0x07, 0x00, 0x00, 0x00, 0x38, 0xFF, 0x00, 0x00, 0x00, 0xE0, 0xE7, 
    0x1F, 0x00, 0x00, 0x80, 0xFF, 0xFC, 0x03, 0x00, 0x00, 0xFE, 0x8F, 0x7F, 0x00, 0x00, 0xF8, 0x3F, 
    0xF0, 0x0F, 0x00, 0xE0, 0xFF, 0x01, 0xFE, 0x01, 0x80, 0xFF, 0x07, 0xC0, 0x3F, 0x00, 0xFE, 0x1F, 
    0x00, 0xF8, 0x07, 0xF8, 0x7F, 0x00, 0x00, 0xFF, 0xE0, 0xFF, 0x01, 0x00, 0xE0, 0x9F, 0xFF, 0x07, 
    0x00, 0x00, 0xFC, 0xFF, 0x1F, 0x00, 0x00, 0x80, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x01, 
    0x00, 0x00, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x01, 0x00, 
    0xFE, 0x00, 0xC0, 0xFF, 0x01, 0xF0, 0x7F, 0x00, 0xFC, 0x7F, 0x80, 0xFF, 0x1F, 0xC0, 0xFF, 0x1F, 
    0xF8, 0xFF, 0x07, 0xFC, 0xFF, 0x87, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xF0, 0xFF, 0x7F, 0xF8, 0xFF, 
    0x3F, 0xFF, 0xFF, 0x9F, 0x1F, 0xE0, 0xE7, 0xFF, 0xFF, 0xF7, 0x00, 0xE0, 0xFD, 0xFF, 0xFF, 0x07, 
    0x00, 0xF8, 0x07, 0xFE, 0x7F, 0x00, 0x00, 0x3F, 0x00, 0xFF, 0x0F, 0x00, 0xC0, 0x03, 0xC0, 0xFF, 
    0x03, 0x00, 0x78, 0x00, 0xF0, 0x7F, 0x00, 0x00, 0x0F, 0x00, 0xFC, 0x1F, 0x00, 0xE0, 0x01, 0x00, 
    0xFF, 0x07, 0x00, 0x7E, 0x00, 0xC0, 0xFF, 0x03, 0xE0, 0x1F, 0x00, 0xFE, 0xFF, 0x01, 0x9F, 0x0F, 
    0xF0, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xBF, 0xFF, 0xFF, 0x7F, 0xFE, 0xFF, 0xE7, 0xFF, 0xFF, 0x87, 
    0xFF, 0x7F, 0xFC, 0xFF, 0xFF, 0xE0, 0xFF, 0x07, 0xFF, 0xFF, 0x0F, 0xF8, 0x7F, 0xC0, 0xFF, 0xFF, 
    0x00, 0xFE, 0x07, 0xE0, 0xFF, 0x0F, 0x00, 0x3F, 0x00, 0xF8, 0x7F, 0x00, 0x00, 0x00, 0x00, 0xF8, 
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x10, 0xF0, 0xFF, 0x03, 
    0x00, 0x00, 0x02, 0xFF, 0xFF, 0x01, 0x00, 0x60, 0xF8, 0xFF, 0x7F, 0x00, 0x00, 0x8C, 0xFF, 0xFF, 
    0x1F, 0x00, 0x80, 0xF1, 0xFF, 0xFF, 0x03, 0x00, 0x18, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xF3, 0xFF, 
    0xFF, 0x1F, 0x00, 0x70, 0xFE, 0xFF, 0xFF, 0x07, 0x00, 0xCE, 0x03, 0x80, 0xFF, 0x00, 0xE0, 0x1C, 
    0x00, 0x00, 0x1F, 0x00, 0x9E, 0x01, 0x00, 0xC0, 0x03, 0xE0, 0x33, 0x00, 0x00, 0x70, 0x00, 0x3E, 
    0x06, 0x00, 0x00, 0x0C, 0xE0, 0xC7, 0x01, 0x00, 0x80, 0x01, 0x7F, 0x78, 0x00, 0x00, 0x30, 0xF8, 
    0x07, 0x3E, 0x00, 0x00, 0xC2, 0xFF, 0xC0, 0xFF, 0x00, 0xE0, 0xFF, 0x0F, 0xF8, 0xFF, 0xFF, 0xFF, 
    0xFF, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xF0, 0xFF, 0xFF, 
    0xFF, 0x0F, 0x00, 0xFC, 0xFF, 0xFF, 0x7F, 0x00, 0x00, 0xFE, 0xFF, 0xFF, 0x07, 0x00, 0x80, 0xFF, 
    0xFF, 0x3F, 0x00, 0x00, 0xC0, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00
};

#endif

