/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : ft14x25_1.h
    Date                : 06.03.2012
    Font size in bytes  : 0x0432, 1074
    Font width          : 13
    Font height         : 14
    Font first char     : 0x20
    Font last char      : 0x7E
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#ifndef ft14x25_1_H
#define ft14x25_1_H

#include <inttypes.h>
#include <avr/pgmspace.h>

#define ft14x25_WIDTH 13
#define ft14x25_HEIGHT 14

unsigned char const __attribute__ ((progmem)) ft14x25[] = {
    0x04, 0x32, 0x0D, 0x0E, 0x01, 0x20, 0x7E,
    0x05, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x09, 0x01, 0x03, 0x03, 0x05, 0x07, 0x02, 0x03, 0x01, 0x04, 
    0x05, 0x05, 0x05, 0x05, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x02, 0x08, 0x08, 0x08, 0x04, 
    0x0C, 0x09, 0x07, 0x07, 0x08, 0x06, 0x06, 0x08, 0x08, 0x03, 0x04, 0x09, 0x06, 0x09, 0x09, 0x08, 
    0x06, 0x08, 0x08, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0A, 0x09, 0x08, 0x03, 0x04, 0x03, 0x05, 0x07, 
    0x02, 0x05, 0x06, 0x04, 0x06, 0x04, 0x05, 0x07, 0x07, 0x03, 0x02, 0x07, 0x03, 0x0B, 0x07, 0x05, 
    0x06, 0x06, 0x05, 0x03, 0x04, 0x07, 0x07, 0x0A, 0x07, 0x07, 0x06, 0x05, 0x01, 0x05, 0x07, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xC1, 0x03, 0x00, 0x00, 0x00, 0x00, 
    0x0F, 0x00, 0x09, 0x40, 0x1A, 0xF0, 0x81, 0x27, 0x00, 0x69, 0xC0, 0x07, 0x9E, 0x00, 0x86, 0x40, 
    0x42, 0xF8, 0x3F, 0x44, 0x04, 0xE2, 0x80, 0x03, 0x10, 0x11, 0x44, 0x02, 0x4E, 0x00, 0x0C, 0x80, 
    0x00, 0x90, 0x03, 0x12, 0x41, 0x44, 0x00, 0x0E, 0x00, 0x03, 0x20, 0x81, 0x47, 0x10, 0x11, 0xA4, 
    0x04, 0xC6, 0x00, 0x4A, 0x80, 0x11, 0x20, 0x02, 0x0F, 0x00, 0x3F, 0x30, 0x30, 0x02, 0x90, 0x00, 
    0xC4, 0xC0, 0xC0, 0x0F, 0x14, 0x00, 0x02, 0xE0, 0x03, 0x20, 0x00, 0x14, 0x00, 0x10, 0x00, 0x04, 
    0x00, 0x01, 0xF8, 0x03, 0x10, 0x00, 0x04, 0x00, 0x01, 0x00, 0x26, 0x80, 0x07, 0x04, 0x00, 0x01, 
    0x40, 0x00, 0x80, 0x01, 0x60, 0x00, 0x07, 0x38, 0x80, 0x01, 0x80, 0x3F, 0x10, 0x10, 0x04, 0x04, 
    0x01, 0x81, 0x3F, 0x00, 0x00, 0x08, 0x04, 0xFF, 0x01, 0x40, 0x00, 0x00, 0x18, 0x04, 0x81, 0x41, 
    0x50, 0x10, 0x13, 0x38, 0x04, 0x02, 0x41, 0x40, 0x10, 0x11, 0x64, 0x04, 0xE6, 0x00, 0x18, 0x00, 
    0x05, 0x30, 0x01, 0x42, 0xC0, 0x7F, 0x00, 0x04, 0x30, 0x04, 0x0A, 0x41, 0x42, 0x10, 0x11, 0x84, 
    0x03, 0xF8, 0x00, 0x45, 0xA0, 0x10, 0x24, 0x04, 0xF1, 0x80, 0x00, 0x10, 0x00, 0x04, 0x06, 0x79, 
    0xC0, 0x01, 0x60, 0x0C, 0xA4, 0x04, 0x11, 0x41, 0x4A, 0x60, 0x0C, 0x78, 0x04, 0x21, 0x41, 0x28, 
    0x10, 0x06, 0xF8, 0x00, 0x98, 0x01, 0x60, 0x82, 0x79, 0x40, 0x00, 0x10, 0x00, 0x0A, 0x80, 0x02, 
    0x10, 0x01, 0x44, 0x00, 0x11, 0x20, 0x08, 0xA0, 0x00, 0x28, 0x00, 0x0A, 0x80, 0x02, 0xA0, 0x00, 
    0x28, 0x00, 0x0A, 0x80, 0x02, 0x08, 0x02, 0x44, 0x00, 0x11, 0x40, 0x04, 0xA0, 0x00, 0x28, 0x00, 
    0x04, 0x00, 0x01, 0x18, 0x00, 0xB1, 0x41, 0x02, 0x60, 0x00, 0xC0, 0x07, 0x0C, 0x82, 0x00, 0x21, 
    0x9E, 0x44, 0x24, 0x09, 0x49, 0x7A, 0x92, 0x91, 0x08, 0x24, 0x84, 0x04, 0x9E, 0x00, 0x10, 0x00, 
    0x04, 0xC0, 0x01, 0x4C, 0xC0, 0x02, 0x8C, 0x00, 0x3C, 0x01, 0x70, 0x00, 0x10, 0x00, 0x04, 0x01, 
    0xC1, 0x7F, 0x10, 0x11, 0x44, 0x04, 0x11, 0x81, 0x47, 0x00, 0x0E, 0xF0, 0x01, 0x82, 0x40, 0x40, 
    0x10, 0x10, 0x04, 0x04, 0x02, 0xC1, 0x21, 0x10, 0x10, 0xFC, 0x07, 0x01, 0x41, 0x40, 0x10, 0x10, 
    0x04, 0x04, 0x82, 0x00, 0x1F, 0x10, 0x10, 0xFC, 0x07, 0x11, 0x41, 0x44, 0x90, 0x13, 0x0C, 0x06, 
    0x01, 0xC1, 0x7F, 0x10, 0x11, 0x44, 0x00, 0x39, 0xC0, 0x00, 0xC0, 0x07, 0x08, 0x02, 0x01, 0x41, 
    0x40, 0x10, 0x10, 0x48, 0x04, 0xF7, 0x01, 0x04, 0x10, 0x10, 0xFC, 0x07, 0x11, 0x01, 0x04, 0x00, 
    0x01, 0x44, 0x04, 0xFF, 0x41, 0x40, 0x10, 0x10, 0xFC, 0x07, 0x01, 0x01, 0x60, 0x10, 0x10, 0xFC, 
    0x03, 0x01, 0x40, 0x40, 0xF0, 0x1F, 0x44, 0x04, 0x28, 0x00, 0x11, 0x30, 0x18, 0x04, 0x04, 0x01, 
    0x01, 0x40, 0x10, 0x10, 0xFC, 0x07, 0x01, 0x01, 0x40, 0x00, 0x10, 0x00, 0x07, 0x01, 0xC1, 0x7F, 
    0x70, 0x10, 0xE0, 0x01, 0x80, 0x01, 0x1E, 0x70, 0x10, 0xFC, 0x07, 0x01, 0x41, 0x00, 0x10, 0x10, 
    0xFC, 0x07, 0x06, 0x01, 0x02, 0x00, 0x03, 0x04, 0x01, 0xFF, 0x41, 0x00, 0xC0, 0x07, 0x08, 0x02, 
    0x01, 0x41, 0x40, 0x10, 0x10, 0x04, 0x04, 0x82, 0x00, 0x1F, 0x10, 0x10, 0xFC, 0x07, 0x11, 0x41, 
    0x04, 0x10, 0x01, 0x38, 0x00, 0x7C, 0x80, 0x20, 0x10, 0x10, 0x04, 0x0C, 0x01, 0x45, 0x40, 0x21, 
    0x88, 0xF0, 0x21, 0x01, 0xC1, 0x7F, 0x10, 0x11, 0xC4, 0x00, 0x51, 0x80, 0x23, 0x00, 0x10, 0x00, 
    0x04, 0xC6, 0x41, 0x22, 0x10, 0x11, 0x48, 0x04, 0x27, 0x01, 0x30, 0x30, 0x00, 0x04, 0x00, 0x01, 
    0xC1, 0x7F, 0x10, 0x10, 0x04, 0x00, 0x03, 0x40, 0x00, 0xF0, 0x0F, 0x04, 0x04, 0x00, 0x01, 0x40, 
    0x10, 0x10, 0xFC, 0x03, 0x01, 0x40, 0x00, 0x30, 0x00, 0x14, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 
    0xC0, 0x01, 0x0D, 0xC0, 0x00, 0x10, 0x00, 0x04, 0x00, 0x03, 0x40, 0x03, 0x00, 0x07, 0x04, 0x06, 
    0x61, 0xC0, 0x07, 0x10, 0x06, 0x00, 0x07, 0x39, 0xC0, 0x01, 0x10, 0x00, 0x04, 0x04, 0x01, 0xC1, 
    0x60, 0x50, 0x04, 0xE0, 0x00, 0x38, 0x40, 0x51, 0x30, 0x18, 0x04, 0x04, 0x01, 0x41, 0x00, 0x30, 
    0x00, 0x14, 0x00, 0x08, 0x01, 0x7C, 0x80, 0x10, 0x14, 0x00, 0x03, 0x40, 0x00, 0x00, 0x10, 0x0C, 
    0x06, 0x41, 0x41, 0x4C, 0x90, 0x10, 0x14, 0x04, 0x03, 0x41, 0x60, 0xF8, 0x7F, 0x02, 0x90, 0x00, 
    0x64, 0x00, 0xE0, 0x00, 0xC0, 0x01, 0x80, 0x21, 0x00, 0x09, 0x40, 0xFE, 0x1F, 0x10, 0x00, 0x03, 
    0x30, 0x00, 0x30, 0x00, 0x10, 0x00, 0x00, 0x02, 0x80, 0x00, 0x20, 0x00, 0x08, 0x00, 0x02, 0x80, 
    0x00, 0x20, 0x01, 0x80, 0x00, 0x80, 0x1D, 0x20, 0x05, 0x28, 0x01, 0x7E, 0x00, 0x10, 0x04, 0x80, 
    0xFF, 0x00, 0x44, 0x80, 0x10, 0x20, 0x02, 0x70, 0x00, 0x3C, 0x80, 0x10, 0x20, 0x04, 0x98, 0x00, 
    0x3C, 0x80, 0x10, 0x20, 0x04, 0x09, 0xE1, 0x7F, 0x00, 0x08, 0xC0, 0x03, 0x28, 0x01, 0x4A, 0x00, 
    0x0B, 0x20, 0x04, 0xFF, 0x21, 0x42, 0x88, 0x00, 0x06, 0x00, 0x00, 0x06, 0x6C, 0x82, 0x94, 0x20, 
    0x25, 0x48, 0x09, 0xCE, 0x81, 0x00, 0x04, 0x84, 0xFF, 0x01, 0x44, 0x80, 0x00, 0x20, 0x04, 0xF8, 
    0x01, 0x40, 0x00, 0x11, 0xE2, 0x07, 0x00, 0x01, 0x04, 0x8A, 0x7F, 0x04, 0x84, 0xFF, 0x01, 0x48, 
    0x80, 0x05, 0x20, 0x06, 0x08, 0x01, 0x40, 0x10, 0x10, 0xFE, 0x07, 0x00, 0x01, 0x44, 0x80, 0x1F, 
    0x40, 0x04, 0x08, 0x00, 0x42, 0x80, 0x1F, 0x40, 0x04, 0x08, 0x00, 0x42, 0x80, 0x1F, 0x00, 0x04, 
    0x10, 0x01, 0x7E, 0x00, 0x11, 0x20, 0x00, 0x08, 0x01, 0x7E, 0x00, 0x10, 0xC0, 0x03, 0x08, 0x01, 
    0x42, 0x80, 0x10, 0xC0, 0x03, 0x10, 0x08, 0xFE, 0x03, 0x91, 0x20, 0x04, 0x08, 0x01, 0x3C, 0x00, 
    0x0F, 0x20, 0x04, 0x08, 0x01, 0x42, 0x82, 0xFF, 0x00, 0x20, 0x10, 0x01, 0x7E, 0x00, 0x11, 0x20, 
    0x00, 0x08, 0x00, 0x4C, 0x80, 0x12, 0x20, 0x03, 0x08, 0x80, 0x7F, 0x80, 0x10, 0x00, 0x02, 0x08, 
    0x00, 0x7E, 0x00, 0x10, 0x00, 0x04, 0x88, 0x00, 0x7E, 0x00, 0x08, 0x20, 0x00, 0x18, 0x00, 0x3A, 
    0x00, 0x10, 0x20, 0x03, 0x38, 0x00, 0x02, 0x80, 0x00, 0xE0, 0x00, 0xC8, 0x00, 0x40, 0x80, 0x0C, 
    0xE0, 0x00, 0xC8, 0x00, 0x40, 0x80, 0x0E, 0x60, 0x00, 0x08, 0x01, 0x42, 0x80, 0x09, 0x80, 0x01, 
    0x98, 0x01, 0x42, 0x00, 0x10, 0x20, 0x20, 0x18, 0x08, 0x1A, 0x02, 0x78, 0x20, 0x03, 0x38, 0x00, 
    0x02, 0x00, 0x10, 0x60, 0x06, 0x48, 0x01, 0x4A, 0x80, 0x11, 0x20, 0x06, 0x10, 0x00, 0x0A, 0xF8, 
    0x3E, 0x01, 0x50, 0x00, 0xE4, 0xFF, 0x07, 0x40, 0x01, 0x90, 0xEF, 0x03, 0x0A, 0x00, 0x01, 0xC0, 
    0x00, 0x08, 0x00, 0x04, 0x00, 0x01, 0x80, 0x00, 0x20, 0x00, 0x06, 0x00
};

#endif

