/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : ft18x34_1.h
    Date                : 06.03.2012
    Font size in bytes  : 0x09D2, 2514
    Font width          : 16
    Font height         : 24
    Font first char     : 0x20
    Font last char      : 0x7E
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#ifndef ft18x34_1_H
#define ft18x34_1_H

#include <inttypes.h>
#include <avr/pgmspace.h>

#define ft18x34_WIDTH 16
#define ft18x34_HEIGHT 24

unsigned char const __attribute__ ((progmem)) ft18x34[] = {
    0x09, 0xD2, 0x10, 0x18, 0x01, 0x20, 0x7E,
    0x0A, 0x02, 0x06, 0x0A, 0x09, 0x0E, 0x09, 0x03, 0x06, 0x06, 0x07, 0x08, 0x03, 0x07, 0x03, 0x07, 
    0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x03, 0x03, 0x06, 0x07, 0x06, 0x09, 
    0x0F, 0x0A, 0x0A, 0x0A, 0x0A, 0x09, 0x08, 0x0B, 0x0A, 0x02, 0x06, 0x0A, 0x08, 0x0F, 0x0C, 0x0C, 
    0x0A, 0x0C, 0x0A, 0x0B, 0x0A, 0x0A, 0x0C, 0x0E, 0x0B, 0x0C, 0x0A, 0x04, 0x08, 0x04, 0x08, 0x09, 
    0x05, 0x09, 0x09, 0x08, 0x09, 0x0A, 0x07, 0x0A, 0x09, 0x02, 0x03, 0x0A, 0x02, 0x0E, 0x09, 0x09, 
    0x09, 0x09, 0x06, 0x09, 0x07, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x08, 0x06, 0x02, 0x06, 0x0A, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x7F, 
    0x03, 0xF0, 0x7F, 0x03, 0x80, 0x00, 0x00, 0x70, 0x00, 0x00, 0x10, 0x00, 0x00, 0xC0, 0x00, 0x00, 
    0x70, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xF1, 0x03, 0x00, 0x7F, 0x00, 0xE0, 
    0x13, 0x00, 0x30, 0x11, 0x00, 0x00, 0xD1, 0x03, 0x00, 0x7F, 0x00, 0xE0, 0x17, 0x00, 0x70, 0x11, 
    0x00, 0x00, 0x11, 0x00, 0x80, 0xC3, 0x00, 0xC0, 0xC7, 0x01, 0x60, 0x0C, 0x03, 0x60, 0x0C, 0x02, 
    0xF0, 0xFF, 0x0F, 0x60, 0x08, 0x02, 0x60, 0x18, 0x03, 0xC0, 0xF1, 0x01, 0x80, 0xE1, 0x00, 0xC0, 
    0x03, 0x00, 0xE0, 0x07, 0x00, 0x10, 0x08, 0x02, 0x10, 0x08, 0x03, 0xE0, 0xC7, 0x00, 0xC0, 0x63, 
    0x00, 0x00, 0x18, 0x00, 0x00, 0x0C, 0x00, 0x00, 0xE3, 0x01, 0x80, 0xF1, 0x03, 0x60, 0x08, 0x04, 
    0x20, 0x08, 0x04, 0x00, 0xF0, 0x03, 0x00, 0xE0, 0x01, 0x00, 0xF0, 0x00, 0xC0, 0xFB, 0x01, 0xE0, 
    0x1F, 0x02, 0x60, 0x1C, 0x02, 0x60, 0x37, 0x02, 0xC0, 0x63, 0x02, 0x00, 0xC0, 0x03, 0x00, 0xE0, 
    0x03, 0x00, 0x60, 0x03, 0x80, 0x00, 0x00, 0x70, 0x00, 0x00, 0x10, 0x00, 0x00, 0x80, 0xFF, 0x00, 
    0xE0, 0xFF, 0x07, 0x78, 0x00, 0x0F, 0x1C, 0x00, 0x38, 0x06, 0x00, 0x70, 0x03, 0x00, 0xC0, 0x01, 
    0x00, 0xC0, 0x06, 0x00, 0x60, 0x0C, 0x00, 0x38, 0x78, 0x00, 0x1F, 0xE0, 0xFF, 0x07, 0x80, 0xFF, 
    0x00, 0xB0, 0x01, 0x00, 0xA0, 0x01, 0x00, 0x40, 0x00, 0x00, 0xF8, 0x07, 0x00, 0x40, 0x00, 0x00, 
    0xA0, 0x00, 0x00, 0xB0, 0x01, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x80, 
    0xFF, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
    0x13, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x07, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 
    0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 
    0x80, 0x03, 0x00, 0x00, 0x03, 0x00, 0x80, 0x03, 0x00, 0xC0, 0x00, 0x00, 0x30, 0x00, 0x00, 0x1C, 
    0x00, 0x00, 0x06, 0x00, 0x80, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x80, 0x7F, 0x00, 0xC0, 0xFF, 0x00, 
    0x60, 0x80, 0x01, 0x30, 0x00, 0x03, 0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x30, 0x00, 0x03, 0x60, 
    0x80, 0x01, 0xC0, 0xFF, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 
    0x00, 0x60, 0x00, 0x00, 0x30, 0x00, 0x00, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC1, 0x03, 0xE0, 0xE1, 0x03, 0x30, 0x30, 0x02, 0x10, 
    0x38, 0x02, 0x10, 0x18, 0x02, 0x10, 0x1C, 0x02, 0x10, 0x0C, 0x02, 0x30, 0x0E, 0x02, 0xE0, 0x07, 
    0x02, 0xC0, 0x03, 0x02, 0x80, 0xC0, 0x00, 0xE0, 0xC0, 0x01, 0x30, 0x00, 0x03, 0x10, 0x00, 0x02, 
    0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x30, 0x0A, 0x03, 0xE0, 0x9B, 0x01, 0xE0, 
    0xF1, 0x01, 0x00, 0x30, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x26, 0x00, 0x00, 0x23, 0x00, 0xC0, 0x21, 
    0x00, 0x60, 0x20, 0x00, 0x30, 0x20, 0x00, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x00, 0x20, 0x00, 
    0x80, 0xC3, 0x00, 0xF0, 0xC3, 0x01, 0x10, 0x01, 0x03, 0x90, 0x00, 0x02, 0x90, 0x00, 0x02, 0x90, 
    0x00, 0x02, 0x90, 0x00, 0x02, 0x90, 0x83, 0x03, 0x10, 0xFF, 0x01, 0x00, 0x7E, 0x00, 0x80, 0x7F, 
    0x00, 0xC0, 0xFF, 0x01, 0x20, 0x02, 0x01, 0x10, 0x01, 0x02, 0x10, 0x01, 0x02, 0x10, 0x01, 0x02, 
    0x10, 0x01, 0x02, 0x30, 0x03, 0x03, 0x60, 0xFE, 0x01, 0x40, 0xFC, 0x00, 0x10, 0x00, 0x00, 0x10, 
    0x00, 0x00, 0x10, 0x00, 0x02, 0x10, 0xE0, 0x03, 0x10, 0xF8, 0x03, 0x10, 0x1E, 0x00, 0x90, 0x07, 
    0x00, 0xD0, 0x01, 0x00, 0x70, 0x00, 0x00, 0x30, 0x00, 0x00, 0xC0, 0xF1, 0x00, 0xE0, 0xFB, 0x01, 
    0x30, 0x0A, 0x01, 0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x30, 
    0x0A, 0x01, 0xE0, 0xFB, 0x01, 0xC0, 0xF1, 0x00, 0xC0, 0xC7, 0x00, 0xE0, 0xCF, 0x01, 0x30, 0x18, 
    0x03, 0x10, 0x10, 0x02, 0x10, 0x10, 0x02, 0x10, 0x10, 0x02, 0x10, 0x18, 0x03, 0x60, 0x8C, 0x01, 
    0xE0, 0xFF, 0x00, 0x80, 0x3F, 0x00, 0x60, 0x00, 0x03, 0xE0, 0x80, 0x03, 0x60, 0x00, 0x03, 0x40, 
    0x00, 0x13, 0xE0, 0x00, 0x0B, 0x40, 0x00, 0x07, 0x00, 0x08, 0x00, 0x00, 0x14, 0x00, 0x00, 0x36, 
    0x00, 0x00, 0x22, 0x00, 0x00, 0x41, 0x00, 0x80, 0xC1, 0x00, 0x00, 0x22, 0x00, 0x00, 0x22, 0x00, 
    0x00, 0x22, 0x00, 0x00, 0x22, 0x00, 0x00, 0x22, 0x00, 0x00, 0x22, 0x00, 0x00, 0x22, 0x00, 0x80, 
    0xC1, 0x00, 0x00, 0x41, 0x00, 0x00, 0x22, 0x00, 0x00, 0x36, 0x00, 0x00, 0x14, 0x00, 0x00, 0x08, 
    0x00, 0xC0, 0x01, 0x00, 0xE0, 0x01, 0x00, 0x30, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x78, 0x03, 
    0x10, 0x7C, 0x03, 0x10, 0x06, 0x00, 0x20, 0x02, 0x00, 0xE0, 0x01, 0x00, 0x00, 0x3E, 0x00, 0x80, 
    0x7F, 0x00, 0xC0, 0xC1, 0x00, 0x40, 0x80, 0x01, 0x20, 0x3C, 0x01, 0x20, 0x7E, 0x02, 0x90, 0x41, 
    0x02, 0x90, 0x21, 0x02, 0x90, 0x31, 0x02, 0x10, 0x7F, 0x02, 0x30, 0x47, 0x03, 0x20, 0x41, 0x02, 
    0x60, 0x20, 0x00, 0xC0, 0x39, 0x00, 0x00, 0x0F, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x78, 0x00, 0x00, 
    0x3F, 0x00, 0xE0, 0x23, 0x00, 0x70, 0x20, 0x00, 0xF0, 0x20, 0x00, 0xE0, 0x27, 0x00, 0x00, 0x3F, 
    0x00, 0x00, 0xF8, 0x01, 0x00, 0xC0, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x10, 0x04, 0x02, 
    0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x70, 0x0B, 0x03, 0xE0, 
    0xFB, 0x01, 0x80, 0xF0, 0x00, 0x00, 0x3F, 0x00, 0xC0, 0xFF, 0x00, 0xE0, 0xC0, 0x01, 0x30, 0x00, 
    0x03, 0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x20, 0x00, 0x01, 
    0xE0, 0xE0, 0x01, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x10, 
    0x00, 0x02, 0x10, 0x00, 0x02, 0x20, 0x00, 0x01, 0xE0, 0xC0, 0x01, 0xC0, 0xFF, 0x00, 0x00, 0x3F, 
    0x00, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 
    0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x10, 0x04, 0x02, 0x10, 0x00, 0x02, 0xF0, 0xFF, 0x03, 0xF0, 
    0xFF, 0x03, 0x10, 0x04, 0x00, 0x10, 0x04, 0x00, 0x10, 0x04, 0x00, 0x10, 0x04, 0x00, 0x10, 0x04, 
    0x00, 0x10, 0x00, 0x00, 0x00, 0x3F, 0x00, 0xC0, 0xFF, 0x00, 0xE0, 0xC0, 0x01, 0x20, 0x00, 0x01, 
    0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x10, 0x08, 0x02, 0x30, 0x08, 0x03, 0x60, 0x88, 0x01, 0xE0, 
    0xF8, 0x01, 0x80, 0xF8, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x00, 0x04, 0x00, 0x00, 0x04, 
    0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0xF0, 0xFF, 0x03, 
    0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 
    0x00, 0x02, 0x00, 0x00, 0x03, 0xF0, 0xFF, 0x01, 0xF0, 0xFF, 0x00, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 
    0x03, 0x00, 0x38, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x06, 0x00, 0x80, 0x07, 0x00, 0xC0, 0x1C, 0x00, 
    0x60, 0x78, 0x00, 0x30, 0xE0, 0x01, 0x10, 0x80, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x00, 
    0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 
    0x02, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x70, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x80, 0x0F, 0x00, 
    0x00, 0x3C, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x80, 0x03, 0x00, 0xE0, 0x01, 0x00, 0x38, 0x00, 0x00, 
    0x0F, 0x00, 0xC0, 0x01, 0x00, 0x30, 0x00, 0x00, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 
    0x03, 0xF0, 0xFF, 0x03, 0x30, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x07, 0x00, 
    0x00, 0x1C, 0x00, 0x00, 0x38, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x80, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 
    0xFF, 0x03, 0x00, 0x3F, 0x00, 0xC0, 0xFF, 0x00, 0xE0, 0xC0, 0x01, 0x20, 0x00, 0x01, 0x10, 0x00, 
    0x02, 0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x20, 0x00, 0x01, 0xE0, 0xC0, 0x01, 
    0xC0, 0xFF, 0x00, 0x00, 0x3F, 0x00, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x10, 0x08, 0x00, 0x10, 
    0x08, 0x00, 0x10, 0x08, 0x00, 0x10, 0x08, 0x00, 0x10, 0x08, 0x00, 0x30, 0x0C, 0x00, 0xE0, 0x07, 
    0x00, 0xC0, 0x03, 0x00, 0x00, 0x3F, 0x00, 0xC0, 0xFF, 0x00, 0xE0, 0xC0, 0x01, 0x20, 0x00, 0x01, 
    0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x10, 0x00, 0x0E, 0x10, 0x00, 0x1A, 0x30, 0x00, 0x13, 0xE0, 
    0xC0, 0x11, 0xC0, 0xFF, 0x10, 0x00, 0x3F, 0x00, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x10, 0x08, 
    0x00, 0x10, 0x08, 0x00, 0x10, 0x08, 0x00, 0x10, 0x08, 0x00, 0x10, 0x38, 0x00, 0x30, 0xFC, 0x01, 
    0xE0, 0x87, 0x03, 0xC0, 0x03, 0x02, 0xC0, 0xC3, 0x00, 0xE0, 0x87, 0x01, 0x30, 0x06, 0x03, 0x10, 
    0x06, 0x02, 0x10, 0x0C, 0x02, 0x10, 0x0C, 0x02, 0x10, 0x0C, 0x02, 0x30, 0x0C, 0x02, 0xE0, 0x18, 
    0x01, 0x40, 0xF8, 0x01, 0x00, 0xF0, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
    0x10, 0x00, 0x00, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 
    0x00, 0x00, 0x10, 0x00, 0x00, 0xF0, 0xFF, 0x00, 0xF0, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 
    0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x03, 0xF0, 0xFF, 0x01, 
    0xF0, 0xFF, 0x00, 0x10, 0x00, 0x00, 0xF0, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x3F, 0x00, 0x00, 
    0xF8, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x80, 0x03, 0x00, 0xF0, 0x00, 0x00, 0x3E, 0x00, 0xC0, 0x07, 
    0x00, 0xF0, 0x00, 0x00, 0x10, 0x00, 0x00, 0xF0, 0x03, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0xFC, 0x01, 
    0x00, 0xC0, 0x03, 0x00, 0xE0, 0x03, 0x80, 0x3F, 0x00, 0xF0, 0x03, 0x00, 0xF0, 0x03, 0x00, 0x80, 
    0x3F, 0x00, 0x00, 0xF8, 0x01, 0x00, 0x80, 0x03, 0x00, 0xF0, 0x03, 0xF0, 0x3F, 0x00, 0xF0, 0x03, 
    0x00, 0x10, 0x00, 0x02, 0x30, 0x00, 0x03, 0x70, 0xC0, 0x01, 0xC0, 0x71, 0x00, 0x80, 0x1F, 0x00, 
    0x00, 0x0E, 0x00, 0x00, 0x3F, 0x00, 0xC0, 0xF1, 0x00, 0x70, 0xC0, 0x01, 0x10, 0x80, 0x03, 0x00, 
    0x00, 0x02, 0x10, 0x00, 0x00, 0x30, 0x00, 0x00, 0xF0, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x80, 0x07, 
    0x00, 0x00, 0xFE, 0x03, 0x00, 0xFC, 0x03, 0x00, 0x07, 0x00, 0x80, 0x03, 0x00, 0xE0, 0x00, 0x00, 
    0x30, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x03, 0x10, 0x80, 0x03, 0x10, 0xE0, 0x02, 0x10, 
    0x70, 0x02, 0x10, 0x1C, 0x02, 0x10, 0x07, 0x02, 0x90, 0x03, 0x02, 0xF0, 0x00, 0x02, 0x70, 0x00, 
    0x02, 0x10, 0x00, 0x02, 0xF0, 0xFF, 0x1F, 0xF0, 0xFF, 0x1F, 0x10, 0x00, 0x10, 0x10, 0x00, 0x10, 
    0x30, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x18, 0x00, 0x00, 
    0x70, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x03, 0x10, 0x00, 0x10, 0x10, 0x00, 0x10, 0xF0, 0xFF, 
    0x1F, 0xF0, 0xFF, 0x1F, 0x00, 0x18, 0x00, 0x00, 0x0E, 0x00, 0xC0, 0x01, 0x00, 0x70, 0x00, 0x00, 
    0x70, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x10, 0x00, 
    0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
    0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x10, 0x00, 0x00, 
    0x20, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0xC2, 0x01, 0x00, 0xE7, 0x03, 0x80, 0x31, 0x03, 0x80, 
    0x10, 0x02, 0x80, 0x10, 0x02, 0x80, 0x10, 0x02, 0x80, 0x11, 0x01, 0x00, 0xFF, 0x03, 0x00, 0xFE, 
    0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x01, 0x00, 0x01, 0x01, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 
    0x80, 0x00, 0x02, 0x80, 0x03, 0x03, 0x00, 0xFF, 0x01, 0x00, 0x7C, 0x00, 0x00, 0x7C, 0x00, 0x00, 
    0xFF, 0x01, 0x80, 0x83, 0x03, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x00, 0x01, 
    0x01, 0x00, 0xC7, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xFF, 0x01, 0x80, 0x83, 0x03, 0x80, 0x00, 0x02, 
    0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x00, 0x01, 0x01, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x00, 
    0x7C, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x93, 0x01, 0x80, 0x11, 0x03, 0x80, 0x10, 0x02, 0x80, 0x10, 
    0x02, 0x80, 0x10, 0x02, 0x00, 0x11, 0x03, 0x00, 0x9F, 0x01, 0x00, 0x9C, 0x00, 0x80, 0x00, 0x00, 
    0x80, 0x00, 0x00, 0xE0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x90, 0x00, 0x00, 0x90, 0x00, 0x00, 0x10, 
    0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0xCE, 0x1D, 0x00, 0xFF, 0x13, 0x80, 0x31, 0x12, 0x80, 0x20, 
    0x12, 0x80, 0x20, 0x12, 0x80, 0x31, 0x12, 0xC0, 0x1F, 0x12, 0x40, 0x0E, 0x1E, 0x00, 0x00, 0x0C, 
    0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x80, 0x00, 0x00, 0x80, 
    0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xFF, 0x03, 0x00, 0xFE, 0x03, 0x90, 0xFF, 0x03, 0x90, 0xFF, 
    0x03, 0x00, 0x00, 0x10, 0x90, 0xFF, 0x1F, 0x90, 0xFF, 0x0F, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 
    0x00, 0x30, 0x00, 0x00, 0x18, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x3E, 0x00, 0x00, 0xF3, 0x00, 0x80, 
    0xC1, 0x01, 0x80, 0x00, 0x03, 0x00, 0x00, 0x02, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x80, 0xFF, 
    0x03, 0x80, 0xFF, 0x03, 0x00, 0x01, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80, 0x01, 0x00, 
    0x00, 0xFF, 0x03, 0x00, 0xFE, 0x03, 0x00, 0x01, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80, 
    0x01, 0x00, 0x80, 0xFF, 0x03, 0x00, 0xFE, 0x03, 0x80, 0xFF, 0x03, 0x80, 0xFF, 0x03, 0x00, 0x03, 
    0x00, 0x00, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x00, 0xFF, 0x03, 
    0x00, 0xFE, 0x03, 0x00, 0x7C, 0x00, 0x00, 0xFF, 0x01, 0x80, 0x03, 0x03, 0x80, 0x00, 0x02, 0x80, 
    0x00, 0x02, 0x80, 0x00, 0x02, 0x80, 0x01, 0x03, 0x00, 0xFF, 0x01, 0x00, 0x7C, 0x00, 0x80, 0xFF, 
    0x1F, 0x80, 0xFF, 0x1F, 0x00, 0x81, 0x01, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 
    0x80, 0x81, 0x03, 0x00, 0xFF, 0x01, 0x00, 0x7C, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xFF, 0x01, 0x80, 
    0x83, 0x03, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x00, 0x81, 0x01, 0x00, 0xFF, 
    0x1F, 0x80, 0xFF, 0x1F, 0x80, 0xFF, 0x03, 0x80, 0xFF, 0x03, 0x00, 0x03, 0x00, 0x80, 0x01, 0x00, 
    0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x84, 0x00, 0x00, 0x8F, 0x01, 0x80, 0x19, 0x03, 0x80, 
    0x18, 0x02, 0x80, 0x10, 0x02, 0x80, 0x31, 0x02, 0x80, 0x31, 0x02, 0x00, 0xF3, 0x01, 0x00, 0xE4, 
    0x00, 0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0xF0, 0xFF, 0x01, 0xF0, 0xFF, 0x03, 0x80, 0x00, 0x02, 
    0x80, 0x00, 0x02, 0x00, 0x00, 0x02, 0x80, 0xFF, 0x00, 0x80, 0xFF, 0x01, 0x00, 0x00, 0x03, 0x00, 
    0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x80, 0x01, 0x80, 0xFF, 0x03, 0x80, 0xFF, 
    0x03, 0x80, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x3E, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x80, 0x03, 
    0x00, 0xC0, 0x03, 0x00, 0x7C, 0x00, 0x80, 0x0F, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 
    0x0F, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xE0, 0x03, 0x00, 0xC0, 0x03, 0x00, 0x7C, 0x00, 0x80, 0x0F, 
    0x00, 0x80, 0x0F, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xE0, 0x03, 0x00, 0xC0, 0x03, 0x00, 0xF8, 0x00, 
    0x80, 0x0F, 0x00, 0x80, 0x01, 0x00, 0x80, 0x00, 0x02, 0x80, 0x01, 0x03, 0x80, 0xC3, 0x01, 0x00, 
    0x7E, 0x00, 0x00, 0x38, 0x00, 0x00, 0x7E, 0x00, 0x00, 0xC3, 0x01, 0x80, 0x00, 0x03, 0x00, 0x00, 
    0x02, 0x80, 0x00, 0x10, 0x80, 0x07, 0x10, 0x00, 0x3E, 0x10, 0x00, 0xF0, 0x0D, 0x00, 0x80, 0x07, 
    0x00, 0xE0, 0x00, 0x00, 0x3C, 0x00, 0x80, 0x07, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00, 0x03, 0x80, 
    0x80, 0x03, 0x80, 0xE0, 0x02, 0x80, 0x70, 0x02, 0x80, 0x1C, 0x02, 0x80, 0x0F, 0x02, 0x80, 0x03, 
    0x02, 0x80, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x38, 0x00, 0xE0, 0xEF, 0x0F, 0xF0, 0xC7, 0x1F, 
    0x10, 0x00, 0x10, 0x10, 0x00, 0x10, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x03, 0x10, 0x00, 0x10, 0x10, 
    0x00, 0x10, 0xF0, 0xC7, 0x1F, 0xE0, 0xEF, 0x0F, 0x00, 0x38, 0x00, 0x00, 0x10, 0x00, 0x00, 0x30, 
    0x00, 0x00, 0x18, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x18, 0x00, 0x00, 0x10, 0x00, 
    0x00, 0x30, 0x00, 0x00, 0x20, 0x00, 0x00, 0x30, 0x00, 0x00, 0x18, 0x00
};

#endif

