/**************************************************************************************************
*	  			  BL-TFT320420 Touch
* File name		: main.c
* Programmer 	: jaruwit supa
* Web presence  : www.circuitidea.com
* Note			: test lcd BL-TFT320420
* Language		: avrGCC
* Hardware		: Atxmega32a3/Atxmega256B
* Date			: 01/05/20012
* 16 Bit Datenbertragung
* Low_Port		: PORTB
* High_Port		: PORTC
* Select_Port	: PORTD (siehe SSD1289.h)
* touch screen	:  ADS7843 SPIE (siehe ads7843.h)
* RS232			: wurde nur zum Debuggen bentigt!
***************************************************************************************************/

// 240/960 = 4 ,bei z.B. 100 Pixel ist AD-Wert Touch 400 dezimal
// 320/960 = 3 ,bei z.B. 200 Pixel ist AD-Wert Touch 600 dezimal

#include "tools.h"

static FILE mystdout = FDEV_SETUP_STREAM(tft_putchar, NULL, _FDEV_SETUP_WRITE); // bindet printf() ein

static uint8_t T1; // Men -< Touch
static uint8_t T2;
static uint8_t T3;
static uint8_t T4;


int main(void)
{

	system_clocks_init(); // System Clocks initialization
	
	// Enable HI/MED/LO interrupt level
	// Interupt einschalten
	PMIC.CTRL |= PMIC_HILVLEN_bm;
	PMIC.CTRL |= PMIC_MEDLVLEN_bm;
	PMIC.CTRL |= PMIC_LOLVLEN_bm;
	
	sei();

	stdout = &mystdout; // bindet printf() ein
	
	//LCD_BL_ON();
	LCD_Reset();
	LCD_Clear(BLACK);
		
	LcdFont(fn20x19);
	
	
	SetColor( WHITE);  	// Hintergrund-Color
	//SetColor( RED);
	SetFgColor(GREEN);	// Font-Color
	SetCursor(0, 40); 	printf("4567");
	SetCursor(0, 40); 	printf("Gerdi");
	
	
	LcdFont(ft18x34);
	
	init_ads7843();// T
	menu(); // Menu-Tasten aufrufen
	
	while(1)
	{
		//Rs232_SendByte('A');
		Action();	// Tastenabfrage
		run();		// Ausgabe Display
	}
	return 0;
}

void system_clocks_init(void)
{
	unsigned char n,s;

	/// Save interrupts enabled/disabled state
	s=SREG;
	// Disable interrupts
	cli();

	// Internal 32 MHz RC oscillator initialization
	// Enable the internal 32 MHz RC oscillator
	OSC.CTRL|=OSC_RC32MEN_bm;

	// System Clock prescaler A division factor: 2
	// System Clock prescalers B & C division factors: B:1, C:1
	// ClkPer4: 16000,000 kHz
	// ClkPer2: 16000,000 kHz
	// ClkPer:  16000,000 kHz
	// ClkCPU:  16000,000 kHz
	n=(CLK.PSCTRL & (~(CLK_PSADIV_gm | CLK_PSBCDIV1_bm | CLK_PSBCDIV0_bm))) |
	CLK_PSADIV_1_gc | CLK_PSBCDIV_1_1_gc; // Hier kann der Takt umgestellt werden!!
	CCP=CCP_IOREG_gc;
	CLK.PSCTRL=n;

	// Disable the autocalibration of the internal 32 MHz RC oscillator
	DFLLRC32M.CTRL&= ~DFLL_ENABLE_bm;

	// Wait for the internal 32 MHz RC oscillator to stabilize
	while ((OSC.STATUS & OSC_RC32MRDY_bm)==0);

	// Select the system clock source: 32 MHz Internal RC Osc.
	n=(CLK.CTRL & (~CLK_SCLKSEL_gm)) | CLK_SCLKSEL_RC32M_gc;
	CCP=CCP_IOREG_gc;
	CLK.CTRL=n;

	// Disable the unused oscillators: 2 MHz, internal 32 kHz, external clock/crystal oscillator, PLL
	OSC.CTRL&= ~(OSC_RC2MEN_bm | OSC_RC32KEN_bm | OSC_XOSCEN_bm | OSC_PLLEN_bm);

	// Peripheral Clock output: Disabled
	PORTCFG.CLKEVOUT=(PORTCFG.CLKEVOUT & (~PORTCFG_CLKOUT_gm)) | PORTCFG_CLKOUT_OFF_gc;

	// Restore interrupts enabled/disabled state
	SREG=s;
}


int tft_putchar(char c, FILE *stream) // // bindet printf() ein
{
	DrawChar(c); //LIB DOGS102
	return 0;
}



void Action(void) // ADS7843 abfragen
{
	uint16_t avgX=0, avgY=0;
	POINT adcPoint;
	
	sampling(&adcPoint, 10);	// Hauptfunktion Tastendruckabfrage
	avgX = adcPoint.x;			// X-Achse -->
	avgY = adcPoint.y;			// Y-Achse |

	
	//SetCursor(0, 40); 	printf("%04d %04d",avgY,avgX );// X/Y Koordinaten Test Ausgabe


	if( (avgY >= 730 && avgY <= 910) && (avgX >= 70 && avgX <= 300))//T1
	{
		T2=T3=T4 = 0;
		T1=1;
		return;
	}

	if(( avgY >= 730 && avgY <= 910) && (avgX >= 320 && avgX <= 480))//T2
	{
		T1=T3=T4 = 0;
		T2=1;
		return;

	}

	if(( avgY >= 730 && avgY <= 910) && (avgX >= 500 && avgX <= 700))//T3
	{
		T1=T2=T4 = 0;
		T3=1;
		return;

	}
	
	if(( avgY >= 730 && avgY <= 910) && (avgX >= 740 && avgX <= 900))//T4
	{
		T1=T2=T3 = 0;
		T4=1;
		return;

	}

}

void menu(void) // Men anzeigen
{
	TextBox(9, 260, 59,310, "T1", ALINE_CENTER | BORDER_MASK | BORDER_FILL );
	TextBox(66, 260, 116,310, "T2", ALINE_CENTER | BORDER_MASK | BORDER_FILL );
	TextBox(123, 260, 173,310, "T3", ALINE_CENTER | BORDER_MASK | BORDER_FILL );
	TextBox(179, 260, 228,310, "T4", ALINE_CENTER | BORDER_MASK | BORDER_FILL );
	
}


void run(void) // Text je Taste ausgeben
{
	if(T1==1)
	{
		
		SetCursor(80, GetMaxY()-100); printf("    ");
		SetCursor(140, GetMaxY()-100); printf("    ");
		SetCursor(190, GetMaxY()-100); printf("    ");
		SetCursor(25, GetMaxY()-100); printf("T1");
		
	}

	if(T2==1)
	{
		SetCursor(25, GetMaxY()-100); printf("    ");
		SetCursor(140, GetMaxY()-100); printf("    ");
		SetCursor(190, GetMaxY()-100); printf("    ");
		SetCursor(80, GetMaxY()-100); printf("T2");
		
	}
	
	if(T3==1)
	{
		SetCursor(25, GetMaxY()-100); printf("    ");
		SetCursor(80, GetMaxY()-100); printf("    ");
		SetCursor(190, GetMaxY()-100); printf("    ");
		SetCursor(140, GetMaxY()-100); printf("T3");
		
	}

	if(T4==1)
	{
		SetCursor(25, GetMaxY()-100); printf("    ");
		SetCursor(80, GetMaxY()-100); printf("    ");
		SetCursor(140, GetMaxY()-100); printf("    ");
		SetCursor(190, GetMaxY()-100); printf("T4");
		
		
	}
}