// top level module
module W2000Nios2 // name as specified in the project

( // port description, the FPGA pins to the outside world
	// system reset
	input reset_n,

	// PLL input clocks, in fact 25 MHz	
	input clk1_25mhz,
	input clk2_25mhz,
	input clk3_25mhz,
	input clk4_25mhz,

	// PLL LVDS clock outputs, 250 MHz quadrature
	output pll1_out,
	output pll2_out,
	output pll3_out,
	output pll4_out,

	// SRAM bus
	output [20:2] shared_adr,
	inout [31:0] shared_data,
	output [3:0] sram_be_n,
	output sram_cs_n,
	output sram_rd_n,
	output sram_wr_n,

	// Flash bus
	output [22:0] flash_a,
	inout [7:0] flash_d,
	output oe_flash_n,
	output ce_flash_n,
	output wr_flash_n,

	// RS232 serial
	input rxd,
	output txd,

	// USB serial
	input usb_rxd,
	output usb_txd
);

// local connections
wire clk_cpu;
wire [15:0] test_cnt;
wire [20:0] shared_adr_int;
  
// instance of pll1, 0 deg. phase
pll1 u_pll1
(
	.inclk0 (clk1_25mhz),
	.c0     (clk_cpu), // internal signal, clock to the CPU
	.c2     (pll1_out)
);

// instance of pll2, 90 deg. phase
pll2 u_pll2
(
	.inclk0 (clk2_25mhz),
	.c2     (pll2_out)
);

// instance of pll3, 180 deg. phase
pll3 u_pll3
(
	.inclk0 (clk3_25mhz),
	.c2     (pll3_out)
);

// instance of pll4, 270 deg. phase
pll4 u_pll4
(
	.inclk0 (clk4_25mhz),
	.c2     (pll4_out)
);

// instance of SOPC-built Nios
Nios2 u_Nios2
(
	// clock, reset	
	.clk_0                             (clk_cpu), // core clock
	.clk_1                             (clk1_25mhz), // peripheral clock
	.reset_n                           (reset_n),

	// SRAM bus	
	.Ext_Shared_Bus_address            (shared_adr_int),
	.Ext_Shared_Bus_data               (shared_data),
	.be_n_to_the_sram_2MByte           (sram_be_n),
	.read_n_to_the_sram_2MByte         (sram_rd_n),
	.select_n_to_the_sram_2MByte       (sram_cs_n),
	.write_n_to_the_sram_2MByte        (sram_wr_n),

	// Flash bus	
	.address_to_the_flash_8MByte       (flash_a),
	.data_to_and_from_the_flash_8MByte (flash_d),
	.read_n_to_the_flash_8MByte        (oe_flash_n),
	.select_n_to_the_flash_8MByte      (ce_flash_n),
	.write_n_to_the_flash_8MByte       (wr_flash_n),

	// UART for serial	
	.rxd_to_the_uart_rs232             (rxd),
	.txd_from_the_uart_rs232           (txd),

	// UART for USB
	.rxd_to_the_uart_usb               (usb_rxd),
	.txd_from_the_uart_usb             (usb_txd)
);
assign shared_adr = shared_adr_int[20:2];


endmodule
