Imports System
Imports System.Double
Imports System.Runtime.InteropServices
Imports System.Windows.Forms
Imports EnvDTE
Imports EnvDTE80
Imports System.IO.Ports
Imports System.Collections
Imports System.Runtime.CompilerServices



Public Class Form1

    Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
    Private status As Long
    Public DeviceIndex As Integer
    Public DevSerial As String


    Private Sub SCL(ByVal Level As Byte)
        Dim data As Byte
        Dim byteswritten As Integer
        Dim dataafter As Byte
        FT_GetBitMode(FT_Handle, data)
        If Level = 1 Then
            status = FT_Write_Bytes(FT_Handle, SetBit(data, 0), 1, byteswritten)
        Else
            status = FT_Write_Bytes(FT_Handle, ClearBit(data, 0), 1, byteswritten)
        End If
        FT_GetBitMode(FT_Handle, dataafter)
        'debug.Print("     SCL("+str$(Level)+"): "+dec2bin(data)+" ==> "+dec2bin(dataafter))
        TextBox1.Text = TextBox1.Text + "     SCL(" + Str$(Level) + "): " + Dec2Bin(data) + " ==> " + Dec2Bin(dataafter) + vbCrLf
        Sleep(1)                       
    End Sub


    Private Sub SDA(ByVal Level As Byte)
        Dim data As Byte
        Dim byteswritten As Integer
        Dim dataafter As Byte
        FT_GetBitMode(FT_Handle, data)
        If Level = 1 Then
            'High level is generated by the pull-up resistor while SDA on the FT232H is set to INPUT
            status = FT_SetBitMode(FT_Handle, &H1, &H1)
        Else
            status = FT_SetBitMode(FT_Handle, &H3, &H1)
            status = FT_Write_Bytes(FT_Handle, ClearBit(data, 1), 1, byteswritten)
        End If
        FT_GetBitMode(FT_Handle, dataafter)
        'Debug.Print("     SDA(" + Str$(Level) + "): " + Dec2Bin(data) + " ==> " + Dec2Bin(dataafter))
        TextBox1.Text = TextBox1.Text + "     SDA(" + Str$(Level) + "): " + Dec2Bin(data) + " ==> " + Dec2Bin(dataafter) + vbCrLf
    End Sub




    Private Sub I2C_Start()
        dim i as integer
        Debug.Print("Start")
        TextBox1.Text = TextBox1.Text + "Start"+ vbCrLf
        SCL(1)
        SDA(1)
        SDA(0)
        SCL(0)
        SDA(1)
        Debug.Print("------------------------------------")
        TextBox1.Text = TextBox1.Text + "------------------------------------" + vbCrLf
    End Sub

    Private Sub I2C_Stop()
        Dim i As Integer
        Debug.Print("Stop")
        TextBox1.Text = TextBox1.Text + "Stop"+ vbCrLf
        SDA(0)
        SDA(1)
        SCL(1)
        Debug.Print("------------------------------------")
        TextBox1.Text = TextBox1.Text + "------------------------------------" + vbCrLf
    End Sub

    Private Sub I2C_ACK_Master()
        Debug.Print("ACK_Master")
        TextBox1.Text = TextBox1.Text +"ACK_Master"+ vbCrLf
        SDA(0)
        SCL(1)
        SCL(0)
        SDA(1)
        Debug.Print("------------------------------------")
        TextBox1.Text = TextBox1.Text + "------------------------------------"+ vbCrLf
    End Sub

    Private Sub I2C_NoACK_Master()
        Debug.Print("NoACK_Master")
        TextBox1.Text = TextBox1.Text +"NoACK_Master"+ vbCrLf
        SDA(1)
        SCL(1)
        SCL(0)
        Debug.Print("------------------------------------")
        TextBox1.Text = TextBox1.Text + "------------------------------------"+ vbCrLf
    End Sub

    Private Sub I2C_WriteByte(ByVal ByteW As Byte)
        Debug.Print("WriteByte")
        TextBox1.Text = TextBox1.Text +"WriteByte"+ vbCrLf
        Dim BitW, i As Integer
        BitW = 128
        For i = 0 To 7
            If (ByteW And BitW) Then
                SDA(1)
            Else
                SDA(0)
            End If
            BitW = BitW \ 2
            SCL(1)
            SCL(0)
        Next i
        Debug.Print("     WriteByte: " + Hex$(ByteW) + " = " + Str$(ByteW) + " = " + Dec2Bin(ByteW))
        TextBox1.Text = TextBox1.Text + "     WriteByte: " + Hex$(ByteW) + " = " + Str$(ByteW) + " = " + Dec2Bin(ByteW)+ vbCrLf
        Debug.Print("------------------------------------")
        TextBox1.Text = TextBox1.Text + "------------------------------------"+ vbCrLf
    End Sub

    Private Function I2C_ReadByte()
        Debug.Print("ReadByte")
        TextBox1.Text = TextBox1.Text +"ReadByte"+ vbCrLf
        Dim BitW, ByteW, i As Integer
        BitW = 128
        For i = 0 To 7
            SCL(1)
            If SDAin() = 1 Then ByteW = ByteW + BitW
            BitW = BitW \ 2
            SCL(0)
        Next
        I2C_ReadByte = ByteW
        Debug.Print("     ReadByte: " + Hex$(ByteW) + " = " + Str$(ByteW) + " = " + Dec2Bin(ByteW))
        TextBox1.Text = TextBox1.Text +"     ReadByte: " + Hex$(ByteW) + " = " + Str$(ByteW) + " = " + Dec2Bin(ByteW)+ vbCrLf
        Debug.Print("------------------------------------")
        TextBox1.Text = TextBox1.Text + "------------------------------------"+ vbCrLf
    End Function

    Private Function I2C_ACK_Slave()
        Debug.Print("ACK_Slave")
        TextBox1.Text = TextBox1.Text + "ACK_Slave" + vbCrLf
        If SDAin() = 1 Then
            I2C_ACK_Slave = 0
        Else
            I2C_ACK_Slave = 1
        End If
        SCL(1)
        SCL(0)
        Debug.Print("     ACK_Slave: " + Str$(I2C_ACK_Slave))
        TextBox1.Text = TextBox1.Text + "     ACK_Slave: " + Str$(I2C_ACK_Slave) + vbCrLf
        Debug.Print("------------------------------------")
        TextBox1.Text = TextBox1.Text + "------------------------------------" + vbCrLf
    End Function

    private Function SDAin() As Byte
        Dim data As Long
        Sleep(2)
        FT_GetBitMode(FT_Handle, data)
        If IsBitSet(data, 1) = True Then SDAin = 1
        Debug.Print("     SDAin: " + Str$(SDAin) + " " + Dec2Bin(data))
        TextBox1.Text = TextBox1.Text + "     SDAin: " + Str$(SDAin) + " " + Dec2Bin(data) + vbCrLf
    End Function

    Private Sub I2C_Init()
        Dim i As Integer
        SDA(1)
        SCL(0)
        For i = 0 To 3
            I2C_stop
        Next
    End Sub


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Call ClearImmediateWindow()

    End Sub


    Function Dec2Bin(ByVal n As Byte) As String
        Dim i As Integer
        For i = 0 To 7
            If (n Mod 2) Then Dec2Bin = "1" & Dec2Bin Else Dec2Bin = "0" & Dec2Bin
            n = n \ 2
        Next i
    End Function


    Sub ClearImmediateWindow()
        Dim DTE As EnvDTE.DTE
        DTE = System.Runtime.InteropServices.Marshal.GetActiveObject("VisualStudio.DTE")
        Dim currentActiveWindow As Window = DTE.ActiveWindow
        DTE.Windows.Item("{ECB7191A-597B-41F5-9843-03A4CF275DDE}").Activate()
        DTE.ExecuteCommand("Edit.SelectAll")
        DTE.ExecuteCommand("Edit.ClearAll")
        currentActiveWindow.Activate()
    End Sub


    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim i, DeviceCount As Integer
        Dim DataH, DataL, Checksum As Byte
        Dim TempDevString As String
        Dim byteswritten As Integer
        Dim data As Byte
        Debug.Print("")
        Debug.Print("")

        ' Get the number of device attached
        FT_Status = FT_GetNumberOfDevices(DeviceCount, vbNullChar, FT_LIST_NUMBER_ONLY)
        ' Display device count on form
        Debug.Print(DeviceCount.ToString)
        TempDevString = Space(16)
        FT_Status = FT_GetDeviceString(DeviceIndex, TempDevString, FT_LIST_BY_INDEX Or FT_OPEN_BY_SERIAL_NUMBER)
        FT_Serial_Number = Microsoft.VisualBasic.Left(TempDevString, InStr(1, TempDevString, vbNullChar) - 1)
        ' Display serial number on form
        Debug.Print(FT_Serial_Number)
        TempDevString = Space(64)
        FT_Status = FT_GetDeviceString(DeviceIndex, TempDevString, FT_LIST_BY_INDEX Or FT_OPEN_BY_DESCRIPTION)
        FT_Description = Microsoft.VisualBasic.Left(TempDevString, InStr(1, TempDevString, vbNullChar) - 1)
        ' Display serial number on form
        Debug.Print(FT_Description)
        'Set USB request transfer size
        status = FT_SetUSBParameters(FT_Handle, 65535, 65535)
        'Disable event and error characters
        status = FT_SetChars(FT_Handle, 0, 0, 0, 0)
        status = FT_OpenByIndex(DeviceIndex, FT_Handle)
        status = FT_ResetDevice(FT_Handle)
        Sleep(50)

        'Set the latency timer
        status = FT_SetLatencyTimer(FT_Handle, 16)
        'Sets the read and write timeouts in milliseconds for the FT2232H
        status = FT_SetTimeouts(FT_Handle, 0, 0)

        DataL = 0
        DataH = 0
        FT_SetBaudRate(FT_Handle, 9600)
        FT_SetBitMode(FT_Handle, &HFF, &H1)
        FT_GetBitMode(FT_Handle, data)
        status = FT_Write_Bytes(FT_Handle, ClearBit(data, 4), 1, byteswritten)
        TextBox1.Text = ""
        TextBox1.Clear()
        TextBox1.Update()

        Sleep(100)
        I2C_Init()

        'Reset the SHT25 sensor
        'I2C_Start()
        'I2C_WriteByte(&HFE)
        'Sleep(2000)
        'I2C_ACK_Slave()
        'I2C_Stop()

        I2C_Start()
        I2C_WriteByte(&H80)
        I2C_ACK_Slave()
        I2C_WriteByte(&HF3)
        I2C_ACK_Slave()
        Do
            I2C_Start()
            I2C_WriteByte(&H81)
            status = I2C_ACK_Slave()
            Debug.Print("ACK Meas: " + Str$(status))
        Loop Until status = 1

        DataH = I2C_ReadByte()
        I2C_ACK_Master()
        DataL = I2C_ReadByte()
        I2C_ACK_Master()
        Checksum = I2C_ReadByte()
        I2C_NoACK_Master()
        I2C_Stop()

        FT_GetBitMode(FT_Handle, data)
        Debug.Print("Ende: " + Dec2Bin(data))

        Call FT_Close(FT_Handle)

        Dim st As UInt16
        Dim temperature As Double
        Debug.Print(DataH)
        Debug.Print(DataL)
        Debug.Print(Checksum)

        st = (DataH * 256) Or DataL

        Debug.Print(st)
        temperature = -46.85 + 175.72 * st / (2 ^ 16)
        Debug.Print("Temperature: " + Str$(temperature) + " C")
    End Sub



    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Dim i, DeviceCount As Integer
        Dim Checksum As Byte
        Dim TempDevString As String
        Dim byteswritten As Integer
        Dim data As Byte
        Debug.Print("")
        Debug.Print("")


        ' Get the number of device attached
        FT_Status = FT_GetNumberOfDevices(DeviceCount, vbNullChar, FT_LIST_NUMBER_ONLY)
        ' Display device count on form
        Debug.Print(DeviceCount.ToString)
        TempDevString = Space(16)
        FT_Status = FT_GetDeviceString(DeviceIndex, TempDevString, FT_LIST_BY_INDEX Or FT_OPEN_BY_SERIAL_NUMBER)
        FT_Serial_Number = Microsoft.VisualBasic.Left(TempDevString, InStr(1, TempDevString, vbNullChar) - 1)
        ' Display serial number on form
        Debug.Print(FT_Serial_Number)
        TempDevString = Space(64)
        FT_Status = FT_GetDeviceString(DeviceIndex, TempDevString, FT_LIST_BY_INDEX Or FT_OPEN_BY_DESCRIPTION)
        FT_Description = Microsoft.VisualBasic.Left(TempDevString, InStr(1, TempDevString, vbNullChar) - 1)
        ' Display serial number on form
        Debug.Print(FT_Description)
        'Set USB request transfer size
        status = FT_SetUSBParameters(FT_Handle, 65535, 65535)
        'Disable event and error characters
        status = FT_SetChars(FT_Handle, 0, 0, 0, 0)
        status = FT_OpenByIndex(DeviceIndex, FT_Handle)
        status = FT_ResetDevice(FT_Handle)
        Sleep(50)
        'Set the latency timer
        status = FT_SetLatencyTimer(FT_Handle, 16)
        'Sets the read and write timeouts in milliseconds for the FT2232H
        status = FT_SetTimeouts(FT_Handle, 0, 0)

        FT_SetBaudRate(FT_Handle, 9600)
        FT_SetBitMode(FT_Handle, &HFF, &H1)
        FT_GetBitMode(FT_Handle, data)
        status = FT_Write_Bytes(FT_Handle, ClearBit(data, 4), 1, byteswritten)
        TextBox1.Text = ""
        TextBox1.Clear()
        TextBox1.Update()

        Sleep(100)
        Dim snb3, snb2, snb1, snb0 As Byte


        I2C_Start()
        I2C_WriteByte(&H80)
        I2C_ACK_Slave()


        I2C_WriteByte(&HFB)
        I2C_ACK_Slave()
        I2C_WriteByte(&HF)
        I2C_ACK_Slave()
        I2C_Start()
        I2C_WriteByte(&H81)
        I2C_ACK_Slave()
        snb3 = I2C_ReadByte()
        I2C_ACK_Master()
        Checksum = I2C_ReadByte()
        I2C_ACK_Master()
        snb2 = I2C_ReadByte()
        I2C_ACK_Master()
        Checksum = I2C_ReadByte()
        I2C_ACK_Master()
        snb1 = I2C_ReadByte()
        I2C_ACK_Master()
        Checksum = I2C_ReadByte()
        I2C_ACK_Master()
        snb0 = I2C_ReadByte()
        I2C_ACK_Master()
        Checksum = I2C_ReadByte()
        I2C_NoACK_Master()

        I2C_Stop()

        FT_GetBitMode(FT_Handle, data)
        Debug.Print("Ende: " + Dec2Bin(data))

        Call FT_Close(FT_Handle)

        Debug.Print("serial: " + Str$(snb3) + " " + Str$(snb2) + " " + Str$(snb1) + " " + Str$(snb0))

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        Dim i, DeviceCount As Integer
        Dim DataH, DataL, Checksum As Byte
        Dim TempDevString As String
        Dim byteswritten As Integer
        Dim data As Byte
        Debug.Print("")
        Debug.Print("")

        ' Get the number of device attached
        FT_Status = FT_GetNumberOfDevices(DeviceCount, vbNullChar, FT_LIST_NUMBER_ONLY)
        ' Display device count on form
        Debug.Print(DeviceCount.ToString)
        TempDevString = Space(16)
        FT_Status = FT_GetDeviceString(DeviceIndex, TempDevString, FT_LIST_BY_INDEX Or FT_OPEN_BY_SERIAL_NUMBER)
        FT_Serial_Number = Microsoft.VisualBasic.Left(TempDevString, InStr(1, TempDevString, vbNullChar) - 1)
        ' Display serial number on form
        Debug.Print(FT_Serial_Number)
        TempDevString = Space(64)
        FT_Status = FT_GetDeviceString(DeviceIndex, TempDevString, FT_LIST_BY_INDEX Or FT_OPEN_BY_DESCRIPTION)
        FT_Description = Microsoft.VisualBasic.Left(TempDevString, InStr(1, TempDevString, vbNullChar) - 1)
        ' Display serial number on form
        Debug.Print(FT_Description)
        'Set USB request transfer size
        status = FT_SetUSBParameters(FT_Handle, 65535, 65535)
        'Disable event and error characters
        status = FT_SetChars(FT_Handle, 0, 0, 0, 0)
        status = FT_OpenByIndex(DeviceIndex, FT_Handle)
        status = FT_ResetDevice(FT_Handle)
        Sleep(50)

        'Set the latency timer
        status = FT_SetLatencyTimer(FT_Handle, 16)
        'Sets the read and write timeouts in milliseconds for the FT2232H
        status = FT_SetTimeouts(FT_Handle, 0, 0)

        DataL = 0
        DataH = 0
        FT_SetBaudRate(FT_Handle, 9600)
        FT_SetBitMode(FT_Handle, &HFF, &H1)
        FT_GetBitMode(FT_Handle, data)
        status = FT_Write_Bytes(FT_Handle, ClearBit(data, 4), 1, byteswritten)
        TextBox1.Text = ""
        TextBox1.Clear()
        TextBox1.Update()

        Sleep(100)
        I2C_Init()

        'Reset the SHT25 sensor
        'I2C_Start()
        'I2C_WriteByte(&HFE)
        'Sleep(2000)
        'I2C_ACK_Slave()
        'I2C_Stop()

        I2C_Start()
        I2C_WriteByte(&H80)
        I2C_ACK_Slave()
        I2C_WriteByte(&HF5)
        I2C_ACK_Slave()
        Do
            I2C_Start()
            I2C_WriteByte(&H81)
            status = I2C_ACK_Slave()
            Debug.Print("ACK Meas: " + Str$(status))
        Loop Until status = 1

        DataH = I2C_ReadByte()
        I2C_ACK_Master()
        DataL = I2C_ReadByte()
        I2C_ACK_Master()
        Checksum = I2C_ReadByte()
        I2C_NoACK_Master()
        I2C_Stop()

        FT_GetBitMode(FT_Handle, data)
        Debug.Print("Ende: " + Dec2Bin(data))

        Call FT_Close(FT_Handle)

        Dim rh As UInt16
        Dim humidity As Double
        Debug.Print(DataH)
        Debug.Print(DataL)
        Debug.Print(Checksum)

        rh = (DataH * 256) Or DataL

        Debug.Print(rh)
        humidity = -6 + 125 * rh / (2 ^ 16)
        Debug.Print("Temperature: " + Str$(humidity) + " %")

    End Sub
End Class
