#ifndef _USART_H
#define _USART_H

#include <stdio.h>
#include "stm32f4xx.h"


#define	USART2_OPEN
//#define	USART3_OPEN

/**
 * @brief Definition for COM port1, connected to USART3
 */  
#ifdef	USART2_OPEN
	#define Open_USART                        USART2
	#define Open_USART_CLK                    RCC_APB1Periph_USART2
	
	#define Open_USART_TX_PIN                 GPIO_Pin_2
	#define Open_USART_TX_GPIO_PORT           GPIOA
	#define Open_USART_TX_GPIO_CLK            RCC_AHB1Periph_GPIOA
	#define Open_USART_TX_SOURCE              GPIO_PinSource2
	#define Open_USART_TX_AF                  GPIO_AF_USART2
	
	
	#define Open_USART_RX_PIN                 GPIO_Pin_3
	#define Open_USART_RX_GPIO_PORT           GPIOA
	#define Open_USART_RX_GPIO_CLK            RCC_AHB1Periph_GPIOA
	#define Open_USART_RX_SOURCE              GPIO_PinSource3
	#define Open_USART_RX_AF                  GPIO_AF_USART2
	
	#define Open_USART_IRQn                   USART2_IRQn
	#define USARTx_IRQHANDLER  				  USART2_IRQHandler

#elif	defined	USART3_OPEN
	#define Open_USART                        USART3
	#define Open_USART_CLK                    RCC_APB1Periph_USART3
	
	#define Open_USART_TX_PIN                 GPIO_Pin_10
	#define Open_USART_TX_GPIO_PORT           GPIOC
	#define Open_USART_TX_GPIO_CLK            RCC_AHB1Periph_GPIOC
	#define Open_USART_TX_SOURCE              GPIO_PinSource10
	#define Open_USART_TX_AF                  GPIO_AF_USART3
	
	
	#define Open_USART_RX_PIN                 GPIO_Pin_11
	#define Open_USART_RX_GPIO_PORT           GPIOC
	#define Open_USART_RX_GPIO_CLK            RCC_AHB1Periph_GPIOC
	#define Open_USART_RX_SOURCE              GPIO_PinSource11
	#define Open_USART_RX_AF                  GPIO_AF_USART3
	
	#define Open_USART_IRQn                   USART3_IRQn
	#define USARTx_IRQHANDLER  				  USART3_IRQHandler
#else
	#error "Please select The COM to be used (in usart.h)"
#endif 		 
/**
 * @brief Definition for connected to I2C1
 */
#define Open_I2C                        	I2C1
#define Open_I2C_CLK                    	RCC_APB1Periph_I2C1

#define Open_I2C_SDA_PIN                 	GPIO_Pin_7
#define Open_I2C_SDA_GPIO_PORT           	GPIOB
#define Open_I2C_SDA_GPIO_CLK            	RCC_AHB1Periph_GPIOB
#define Open_I2C_SDA_SOURCE              	GPIO_PinSource7
#define Open_I2C_SDA_AF                  	GPIO_AF_I2C1

#define Open_I2C_SCL_PIN                 	GPIO_Pin_6
#define Open_I2C_SCL_GPIO_PORT           	GPIOB
#define Open_I2C_SCL_GPIO_CLK            	RCC_AHB1Periph_GPIOB
#define Open_I2C_SCL_SOURCE              	GPIO_PinSource6
#define Open_I2C_SCL_AF                  	GPIO_AF_I2C1

#define I2C_SPEED               100000
#define I2C_SLAVE_ADDRESS7      0x30
void USART_Configuration(void);
void USART_NVIC_Config(void);

#endif /*_USART_H*/
