

/*---------------------------- Include ---------------------------------------*/
#include <CoOS.h>			              /*!< CoOS header file	         */
#include "stm32f4xx.h"
#include "stm32f4xx_gpio.h"
#include "stm32f4xx_rcc.h"
#include "usart.h"
//#include "misc.h"

/*---------------------------- Symbol Define -------------------------------*/
#define STACK_SIZE_TASKA 128              /*!< Define "taskA" task size */
#define STACK_SIZE_TASKB 128              /*!< Define "taskB" task size */
#define STACK_SIZE_TASKC 128              /*!< Define "taskC" task size */
#define STACK_SIZE_TASKD 128              /*!< Define "taskD" task size */

/* Private typedef -----------------------------------------------------------*/
GPIO_InitTypeDef GPIO_InitStructure;
unsigned int a,b,c,d;
/*---------------------------- Variable Define -------------------------------*/
OS_STK taskA_stk[STACK_SIZE_TASKA]; /*!< Define "taskA" task stack */
OS_STK taskB_stk[STACK_SIZE_TASKB]; /*!< Define "taskB" task stack */
OS_STK taskC_stk[STACK_SIZE_TASKC]; /*!< Define "taskC" task stack */
OS_STK taskD_stk[STACK_SIZE_TASKD]; /*!< Define "taskD" task stack */

/**
 *******************************************************************************
 * @brief       "taskA" task code
 * @param[in]   None
 * @param[out]  None
 * @retval      None
 * @par Description
 * @details    This task use to crate mutex and flags,print message "taskA running".
 *             Indicate "taskA" had been executed.
 *******************************************************************************
 */
void taskA(void* pdata)
{
	a = 0;
  while (1)
    {
      if (a & 1)
        {
          GPIO_SetBits(GPIOD, GPIO_Pin_12);
          a=0;
        }
      else
        {
          GPIO_ResetBits(GPIOD, GPIO_Pin_12);
          a++;
        }

      CoTickDelay(10);
    }
}

/**
 *******************************************************************************
 * @brief       "taskB" task code
 * @param[in]   None
 * @param[out]  None
 * @retval      None
 * @par Description
 * @details    This task use to print message "taskB running". Indicate "taskB"
 *             had been executed.
 *******************************************************************************
 */
void taskB(void* pdata)
{
	b = 0;
  while (1)
    {
      if (b & 1)
        {
          GPIO_SetBits(GPIOD, GPIO_Pin_13);
          b=0;
        }
      else
        {
          GPIO_ResetBits(GPIOD, GPIO_Pin_13);
          b++;
        }

      CoTickDelay(15);
    }
}

/**
 *******************************************************************************
 * @brief       "taskC" task code
 * @param[in]   None
 * @param[out]  None
 * @retval      None
 * @par Description
 * @details    This task use to print message "taskB running". Indicate "taskB"
 *             had been executed.
 *******************************************************************************
 */
void taskC(void* pdata)
{
	c = 0;
  while (1)
    {
      if (c & 1)
        {
          GPIO_SetBits(GPIOD, GPIO_Pin_14);
          c=0;
        }
      else
        {
          GPIO_ResetBits(GPIOD, GPIO_Pin_14);
          c++;
        }

      CoTickDelay(20);
    }
}


/**
 *******************************************************************************
 * @brief       "taskC" task code
 * @param[in]   None
 * @param[out]  None
 * @retval      None
 * @par Description
 * @details    This task use to print message "taskB running". Indicate "taskB"
 *             had been executed.
 *******************************************************************************
 */
void taskD(void* pdata)
{
	d = 0;
  while (1)
    {
      if (d & 1)
        {
          GPIO_ResetBits(GPIOD, GPIO_Pin_15);
          d=0;
        }
      else
        {
          GPIO_SetBits(GPIOD, GPIO_Pin_15);
          d++;
        }

      CoTickDelay(25);
    }
}


int main(void)
{
	USART_Configuration();
	USART_NVIC_Config();

	printf("\r\nHallo! Greatings from vampire\r\n");

  /* GPIOD Periph clock enable */
  RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOD, ENABLE);
  /* Configure PD12, PD13, PD14 and PD15 in output pushpull mode */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12 | GPIO_Pin_13 | GPIO_Pin_14  | GPIO_Pin_15;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOD, &GPIO_InitStructure);

  CoInitOS(); /*!< Initial CooCox CoOS          */

  /*!< Create three tasks	*/
  CoCreateTask(taskA, 0, 0, &taskA_stk[STACK_SIZE_TASKA-1], STACK_SIZE_TASKA);
  CoCreateTask(taskB, 0, 1, &taskB_stk[STACK_SIZE_TASKB-1], STACK_SIZE_TASKB);
  CoCreateTask(taskC, 0, 2, &taskC_stk[STACK_SIZE_TASKC-1], STACK_SIZE_TASKC);
  CoCreateTask(taskD, 0, 3, &taskD_stk[STACK_SIZE_TASKD-1], STACK_SIZE_TASKD);

  CoStartOS(); /*!< Start multitask	           */



  while (1)
    {
    }
}

