/*  EVENTS.C   SwissBetty: Unit fr die Ereignisverwaltung im LPC2220 */

#include "LPC22xx.h"
#include "StdTypes.h"
#include "setup.h"
#include "events.h"


/***********************************/
/*  gepufferte Event-Verwaltung    */
/***********************************/

#if !defined (GCC)
#pragma thumb
#endif

#define eventbuffersize 32
word EventBuffer[eventbuffersize];
word evWZ, evRZ;

void Event_Init (void)
{ evWZ = evRZ = 0; }

byte Event_avail (void) { return (evWZ!=evRZ); }

word Get_Event (void)
{ word w;
  if (evWZ==evRZ) return 0;
  w = EventBuffer[evRZ];
  evRZ = (evRZ+1) & (eventbuffersize-1);
  return w;
}

void Add_Event (word aEvent)
{ word w;
  w = (evWZ+1) & (eventbuffersize-1);
  if (w==evRZ) return;
  EventBuffer[evWZ & (eventbuffersize-1)] = aEvent;
  evWZ = w;
}
