/*  SERIAL.H   SwissBetty: Unit fr den V24-Anschlu im LPC2220 */

#ifndef _SERIAL_INCLUDED
#define _SERIAL_INCLUDED

/* nur fr UART0
   =============
   Der Empfang verlt sich auf den Hardware-Fifo
   und das Senden erfolgt gepuffert ber V24puffer per Interrupt.

   Beim Senden wird eine begrenzte Zeit gewartet, wenn der Sendepuffer fast voll ist
   Beim Empfangen wird nicht gewartet, sondern 0 geliefert, wenn nix anliegt.
   Also vorher prfen, ob Zeichen im Rx anliegen
 */

#define v24bufsize 256                /* immer 2er Potenz */
extern char V24puffer[v24bufsize];    /* Sendepuffer */
extern volatile int v24sin;           /* Index im Sendepuffer */
extern volatile int v24sout;          /* Index im Sendepuffer */



extern dword V24_Init      (long baudrate); /* liefert tatschliche Baudrate zurck */
extern int   V24_Txfree    (void);          /* liefert Anzahl freier Pltze im Tx Puffer */
extern char  V24_CharOut   (char c);        /* Zeichen auf UART ausgeben */
extern void  V24_StrOut    (char* P);       /* String auf UART ausgeben  */
extern void  V24_CRLF      (void);          /* 0x13 0x10 auf UART ausgeben */
extern bool  V24_CharAvail (void);          /* ob empfangene Zeichen anliegen */
extern char  V24_CharIn    (void);          /* liest empfangenes Zeichen (ohne Warten) */

#endif
