/*  SYSTEMTICK.C   SwissBetty: Unit fr die Zeitverwaltung im LPC2220 */

#include "LPC22xx.h"
#include "StdTypes.h"
#include "interrupts.h"
#include "setup.h"
#include "events.h"
#include "systemtick.h"
#include "Tasten.h"

/*
Im Prinzip knnte man hier den RTC Uhrenschaltkreis PCF8563 mit einbeziehen, der ber I2C
betrieben wird. Aber dieser RTC hat keine Sttzbatterie o.. und ist deshalb keine
groe Hilfe.
*/

volatile dword Ticks;

/*
Als innere Uhr wird der Timer0 benutzt, der pro Millisekunde um 1 weiterzhlt.
Sein Zhlerstand ist also gleichbedeutend mit der Uhrzeit in Millisekunden.

Die Interrupt-Bedienung ist ausgelagert, siehe Interrupts.c
*/


/* Timer0 als 1ms System-Uhr einrichten */
void Systemtick_Init (void)
{  T0PR  = PCLK/1000;                      /* Prescaler: --> 1 ms */
   Ticks =  T0TC = 0;                      /* Timer 0 als 10 ms-Zhler, jetzt ab 0 */
   T0MR0 = 10;
   VICVectAddr11 = (dword)Timer0Service;   /* wir benutzen hier Slot 11   */
   VICIntSelect  &=  ~(1<<4);              /* kein FIQ                    */
   VICVectCntl11 = (1<<5) | 4;             /* Timer0 hat VIC-Nummer 4     */
   VICIntEnable  = (1<<4);                 /* enable Timer0 im VIC        */
   T0MCR = 1;                              /* Interrupt bei T0TC=T0MR0 */
   T0TCR = 1;                              /* Timer starten */
}


   /* ende */
