/* Betty-TV-Fernbedienung: Definitionen fr das Grafik-Interface */

#ifndef _GDI_INCLUDED
#define _GDI_INCLUDED

/* Definitionen fr Zeichenmodi,
die untersten 4 Bit sind fr die Fontnummer 0..15 */
#define white          0
#define ltgr        0x10
#define dkgr        0x20
#define black       0x30
#define invert      0x40
#define allmodes  0xFFF0

/*  Beschreibung des verwendeten Font-Formates:
 zuerst kommt der Font-Header in folgendem Format: */

#define Fontheadersize 6

#define PFONT  const struct Fontheader*
struct Fontheader
{ byte Capitals; /* Hoehe der Grossbuchstaben */
  byte Height;   /* Font-Gesamthoehe */
  byte Ascent;   /* Hoehe ueber Null-Linie */
  byte Descent;  /* Tiefe unter Null-Linie */
  char ChMin;    /* kleinstes vorhandenes Zeichen */
  char ChMax;    /* groesstes vorhandenes Zeichen */
};

/* danach kommen unterschiedlich viele Char-Entries.
   eigentlich ist 'Disp' ein 16 bit Offset, aber der
   Font muss bei BigEndian und LittleEndian-CPU's
   gleichermassen funktionieren, deswegen die explizite
   Aufteilung in DispHi und DispLo  */

#define Charentrysize 4

struct CharEntry
{ byte DispHi;   /* Hi vom Displacement ab Fontbeginn */
  byte DispLo;   /* Lo vom Displacement ab Fontbeginn */
  byte dX;       /* Breite in Pixeln */
  byte dY;       /* Hoehe in Pixeln */
};

/* danach kommen die Pixel. Jeder CharEntry (s.o.) zeigt
   auf den Beginn des zu seinem Char gehrigen Bitmusters.
   Jedes Bitmuster beginnt an einem ganzen Byte, aber innerhalb
   geht es je nach Zeichenbreite asynchron zu den Bytegrenzen */




/* Funktionen und Daten im GDI: */

extern const char  Simple5x7_7[];
extern const char  Simple6x13_13[];
extern const char  Helvetica_14[];
extern const char  Helvetica_Bold_14[];
extern const char  Helvetica_12[];
extern const char  Helvetica_Bold_12[];
extern const char  Lucida_Bold_20[];

#define FontAnzahl  7

#define idf_Simple5x7    0
#define idf_Simple6x13   1
#define idf_Helv_12      2
#define idf_Helv_12B     3
#define idf_Helv_14      4
#define idf_Helv_14B     5
#define idf_Lucida_20    6



extern PFONT const FontPool[FontAnzahl];


extern void FillLanes        (byte mode);
extern void LichtAus         (void);
extern void LichtEin         (void);
extern void FlipDisplay      (bool normal);
extern int  ScrBlt           (void);
extern bool CgPixel_at       (int X, int Y, int mode);
extern void DrawLine         (POINT A, POINT B, int mode);
extern void MoveTo           (POINT* A);
extern void LineTo           (POINT* B, int mode);
extern void CgPicture_at     (int x, int y, char* P);

extern void CgFillRect       (RECT* R, int mode);
extern int  CgCh_at          (int X, int Y, char Ch, word FontMode);
extern int  CgStr_at         (int x, int y, char* P, word FontMode);
extern int  StringWidth      (char* S, PFONT Font);
extern int  Get_dY           (PFONT Font);
extern int  Get_Ascent       (PFONT Font);
extern int  Get_Descent      (PFONT Font);
extern int  Get_dX           (PFONT Font, char Ch);
extern PFONT  Get_Font       (int Fontnummer);

extern void init_GDI         (void);


#endif
