/*  MENU.H   SwissBetty: Unit fr ein Men im LPC2220 */

#ifndef MENUINCLUDED
#define MENUINCLUDED

/* dies ist ein generischer Konstrukt fr Mens in C auf nem uC und dazu noch weitestgehend im ROM.
Prinzip:
Jedes Men besteht aus einem MenuItem, also einem Datensatz im ROM.
Dieser enthlt Members, also weitere Datenstze, die jeweils ein Menelement darstellen
und ihrerseits wiederum Members haben knnen.
Jedes MenuItem zeichnet sich selbst und ruft alle seine Members auf, sich ebenfalls selbst zu zeichnen.
Das Men selbst hat keinen Owner, aber alle darin enthaltenen MenuItems haben einen Owner.
Die Koordinaten eines jeden MenuItems beziehen sich auf den Innenraum seines Owners.

Events: Events werden von DispatchEvent an das Menu weitergeleitet und zwar getrennt nach Gruppen:
Tasten-Events gehen an Menu.OnKey und mssen dort an das fokussierte Element weitergeleitet werden,
weil diese Ereignisse ja nur fr ein bestimmtes Element gedacht sind.
Alle anderen Ereignisse gehen an alle Elemente und nur diejenigen, die damit was anfangen knnen,
beachten sie.
 */

#define RCST  const struct TMenuItem
struct TMenuItem
{ struct TRect R;                  /* die Koordinaten relativ zum Owner       */
  const struct TMenuItem *davor;   /* Listenverkettung: Item davor            */
  const struct TMenuItem *danach;  /* Listenverkettung: Item danach           */
  const struct TMenuItem *Owner;   /* Item, wo dieses enthalten ist           */
  const struct TMenuItem *Members; /* Liste der enthaltenen Items             */
  dword Flags;                     /* diverse Flag-Bits                       */
  void  *Data;                     /* Zeiger auf fallspezifische Daten        */
  void  (*OnKey)  (RCST* self, word *aKey);     /* wertet Tastendrcke aus    */
  void  (*OnEvent)(RCST* self, word *aEvent);   /* wertet Ereignisse aus      */
  void  (*Draw)   (RCST* self);    /* zeichnet sich und Members  */
};

/* Flagwerte fr die Flags von TMenuItem */
#define   cl_white      0
#define   cl_ltgr       1
#define   cl_dkgr       2
#define   cl_black      3
#define   border       (1<<2)      /* ob Element eine Umrandung har */
#define   canFocus     (1<<3)      /* ob es fokussierbar ist        */
#define   center       (1<<4)      /* hier knnen beliebige weitere */
#define   opaque       (1<<5)      /* Flags vereinbart werden       */
#define   debrect      (1<<6)


extern RCST* CurrentMenu;
extern bool  isEditing;

extern word DispatchEvent     (word aEvent);
extern void LocalToScreen     (RCST* PItem, RECT* R);

extern void Umrande           (RECT* Pr, int mode);
extern void PanelKeyHandler   (RCST *self, word *aKey);
extern void PanelEventHandler (RCST* self, word *aEvent);
extern void PanelDrawProc     (RCST* self);
extern void ButtonDrawProc    (RCST* self);
extern void Messagebox        (char* Caption, char* Message);

#endif
