/* SwissBetty-TV-Fernbedienung: setup.c */

/* PIN-Beschreibungen sortiert nach Pins, soweit bekannt
 Nr   Port   i/o   was              bekannte Verwendung
----+------+-----+----------------+-------------------------------------
  1  P2.22   O                     Tasten-Drive 5
  2 +3.3 Volt
  3 GND
  4  P0.21   O                     zur IR-Diode (Senden)
  5  P0.22   ?
  6  P0.23   O                     Funkmodul Chipselect
  7  P1.19   I                     Tasten-Sense 1
  8  P0.24   ?                     Funkmodul Daten GDO2
  9 GND
 10  P2.23   O                     Tasten-Drive 6
 11  P2.24   O                     Tasten-Drive 7
 12  P2.25                  ???
 13  P2.26   I     BOOT0           fest auf +3.3V
 14 +3.3 Volt analog
 15  P1.18   I                     Tasten-Sense 2
 16  P2.27         BOOT1           fest auf GND
 17  P2.28                  ???
 18  P2.29                  ???
 19  P2.30         AIN4     ???
 20  P2.31   A     AIN5            Akkuspannung
 21  P0.25                  ???
 22  ---   do not connect
 23  P0.27   ?     AIN0
 24  P1.17   I                     Tasten-Sense 3
 25  P0.28   ?     AIN1
 26 GND
 27  P3.29   I/O  /BLS2 oder ADC6  ???
 28  P3.28   I/O  /BLS3 oder ADC7  ???
 29  P3.27   O    /WE              /WE an Flash und LCD
 30  P3.26   O    /CS1             /CS an LCD (0x8100 0000 .. 0x8100 0001)
 31 +3.3 Volt
 32  P0.29   I    (CAP0.3 ?)       IR Empfang, Capture? auch AIN2
 33  P0.30   I    EINT3            Tastatur-Interrupt   auch AIN3
 34  P1.16   I                     Tasten-Sense 4
 35  P3.25   O    /CS2             /CS fr Flash 1  (0x8200 0000 .. 0x820F FFFF)
 36  P3.24   O    /CS3      ???
 37 +1.8 Volt
 38 GND
 39 +3.3 Volt
 40  P3.23   O    XCLK             3.75 MHz (PCLK/2) Takt fr Smartcard-Chip
 41  P3.22   O    A22       ???
 42  P0.0    O                     TXD0 Bootlader
 43  P1.31   I     /TRST           JTAG an Pinhead
 44  P3.21   ?
 45  P3.20   ?
 46  P3.19   O    A19
 47  P3.18   O    A18              ext.Bus: Adressen
 48  P3.17   O    A17              ext.Bus: Adressen
 49  P0.1    I                     RXD0 Bootlader
 50  P0.2    -                     SCL an RTC-IC
 51 +3.3 Volt
 52  P1.26   I/O  RTCK             JTAG an Pinhead
 53  P3.16   O    A16              ext.Bus: Adressen
 54 GND
 55  P3.15   O    A15              ext.Bus: Adressen
 56  P3.14   O    A14              ext.Bus: Adressen
 57 +3.3 Volt
 58  P0.3    -                     SDA an RTC-IC
 59  P0.4    out                   LCD Backlight
 60  P1.25   I     EXTIN0
 61  P0.5    ?                     Hardwareerkennung?
 62  P3.13   O    A13              ext.Bus: Adressen
 63  P3.12   O    A12              ext.Bus: Adressen
 64  P3.11   O    A11              ext.Bus: Adressen
 65  P3.10   O    A10              ext.Bus: Adressen
 66  P3.9    O    A9               ext.Bus: Adressen
 67 GND
 68  P0.6    ?                     Sound on
 69  P0.7    O    PWM2             Audio-PWM an LM4871
 70  P1.24   O    TRACECLK
 71  P3.8    O    A8               ext.Bus: Adressen
 72  P3.7    O    A7               ext.Bus: Adressen
 73  P3.6    O    A6               ext.Bus: Adressen
 74  P3.5    O    A5               ext.Bus: Adressen
 75  P0.8    O                     TXD1  an Smartcard-Chip
 76  P0.9    I                     RXD1  an Smartcard-Chip
 77 +3.3 Volt
 78  P0.10   O                     /Stromversorgung an Smartcard-Chip
 79 GND
 80  P3.4    O    A4               ext.Bus: Adressen
 81  P3.3    O    A3               ext.Bus: Adressen
 82  P1.23   O    PIPESTAT2
 83  P0.11   O                     /Audio_Shutdown an LM4871
 84  P0.12   O                     IR-Empfang aktivieren
 85  P0.13   I                     ?
 86  P1.22   I                     Tasten-Sense 5 ?
 87  P3.2    O    A2               ext.Bus: Adressen
 88  P3.1    O    A1               ext.Bus: Adressen
 89  P3.0    O    A0               ext.Bus: Adressen
 90  P1.1    O    fest /OE         /OE fr Flash 0 und 1
 91  P1.0    O    fest /CS0        /CS fr Flash 0 (0x8000 0000 .. 0x800F FFFF)
 92  P0.14   I    /BOOTLDR         an Pinhead fr ISP/Bootlader
 93 GND
 94 +3.3 Volt
 95  P1.21   I                     Tasten-Sense 6
 96  P3.31   O    /BLS0       ???
 97  P3.30   O    /BLS1       ???
 98  P2.0    I/O  D0               ext.Bus: Daten
 99  P0.15   I    EINT2            /INT vom RTC-IC
100  P0.16   ?                     Funkmodul I/O
101  P0.17   O    SCK1             Funkmodul Takt
102  P1.20   O    TRACESYNC ?
103 GND
104 +3.3 Volt
105  P2.1    I/O  D1               ext.Bus: Daten
106  P2.2    I/O  D2               ext.Bus: Daten
107 GND
108  P2.3    I/O  D3               ext.Bus: Daten
109  P2.4    I/O  D4               ext.Bus: Daten
110 +1.8 Volt
111 GND
112 +3.3 Volt
113  P1.30   I    TMS              JTAG an Pinhead
114  P2.5    I/O  D5               ext.Bus: Daten
115  P2.6    I/O  D6               ext.Bus: Daten
116  P2.7    I/O  D7               ext.Bus: Daten
117  P2.8    I/O  D8               ext.Bus: Daten
118  P2.9    I/O  D9               ext.Bus: Daten
119 +3.3 Volt
120  P2.10   I/O  D10              ext.Bus: Daten
121  P0.18   I    MISO1            Funkmodul Daten
122  P0.19   O    MOSI1            Funkmodul Daten
123  P0.20                  ???
124  P2.11   I/O  D11              ext.Bus: Daten
125  P2.12   I/O  D12              ext.Bus: Daten
126  P1.29   I    TCK              JTAG an Pinhead
127  P2.13   I/O  D13
128 GND
129  P2.14   I/O  D14              ext.Bus: Daten
130  P2.15   I/O  D15              ext.Bus: Daten
131  P2.16                  ???
132  P2.17   O                     Smartcard-Chip: Reset
133  P2.18   O                     Tasten-Drive 1
134  P2.19   O                     Tasten-Drive 2
135  /RESET                        an Pinhead: ISP + JTAG
136  P2.20   O                     Tasten-Drive 3
137  P2.21   O                     Tasten-Drive 4
138 GND pll
139 GND analog
140  P1.28   I     TDI             JTAG an Pinhead
141  XTAL2   O
142  XTAL1   I
143 +1.8 Volt analog
144  P1.27   O     TDO             JTAG an Pinhead

P0.26 ist nicht vorhanden
P0.31 ist nicht vorhanden
P1.0..15 sind nicht frei verfgbar

Zitat:
"The direction control bit in the IO0DIR/IO1DIR register is effective only when the GPIO
function is selected for a pin. For other functions, direction is controlled automatically."
Also braucht man sich um alle Pins mit Sonderfunktionen wegen I/O eigentlich nicht zu kmmern.
(Ausnahme: ADC)
*/



/**** PORT 0 ********************************************************************************/
/* PINSEL0 steuert P0.00 bis P0.15 */
/* PINSEL1 steuert P0.16 bis P0.31 */
/* PINSEL2 steuert externen Bus, Datenbreite usw. und wird im Startupcode gesetzt */
/* IO0DIR steuert bei GPIO-Pins die Richtung: 0=input, 1=output */
/* Datenrichtung der GPIO-Pins */
#define IN   0
#define OUT  1

/* Defines:
   Q_xx  = Wert fr PINSEL,
   io_xx = Wert fr IODIR,
   st_xx = Wert fr Vorbelegung
 */

/* Pin  Port   i/o                    bekannte Verwendung  */
/*-------------------------------------------------------  */
/* 42   P0.0    O     TXD0 Bootlader */
#define Q_00    1
#define io_00   OUT
#define st_00   1

/* 49   P0.1    I     RXD0 Bootlader */
#define Q_01    1
#define io_01   IN
#define st_01   1

/* 50   P0.2    -     SCL (I2C) an RTC-IC  */
#define Q_02    1
#define io_02   OUT
#define st_02   1

/* 58   P0.3    -     SDA (I2C) an RTC-IC  */
#define Q_03    1
#define io_03   IN
#define st_03   1

/* 59   P0.4    O     LCD Backlight, lo=leuchtet */
#define Q_04    0     /* auch  SCK  (SPI0)       */
#define io_04   OUT
#define st_04   1

/* 61   P0.5    ?     Hardwareerkennung?         */
#define Q_05    0     /* auch MISO (SPI0)        */
#define io_05   IN
#define st_05   1

/* 68   P0.6    O     Sound on ?                 */
#define Q_06    0     /* auch  MOSI (SPI0)       */
#define io_06   OUT
#define st_06   1

/* 69   P0.7    O     PWM2    Audio-PWM an LM4786 */
#define Q_07    2
#define io_07   IN    /* erstmal Tristate..       */
#define st_07   0

/* 75   P0.8    O     TXD1 UART1 an Smartcard-Chip */
#define Q_08    1
#define io_08   OUT
#define st_08   1

/* 76   P0.9    I     RXD1 UART1 an Smartcard-Chip */
#define Q_09    1
#define io_09   IN
#define st_09   1

/* 78   P0.10   O     /Stromversorgung an Smartcard-Chip */
#define Q_10    0
#define io_10   IN    /* erstmal Tristate.. */
#define st_10   0

/* 83   P0.11   O     /Audio_Shutdown an LM4786 */
#define Q_11    0
#define io_11   OUT
#define st_11   0

/* 84   P0.12   O     IR-Empfang aktivieren */
#define Q_12    0
#define io_12   IN    /* erstmal Tristate.. */
#define st_12   1

/* 85   P0.13   I       ? */
#define Q_13    0
#define io_13   IN
#define st_13   1

/* 92   P0.14   I    /BOOTLDR  an Pinhead fr ISP/Bootlader */
#define Q_14    0
#define io_14   IN
#define st_14   1

/* 99   P0.15   I    EINT2       /INT vom RTC-IC */
#define Q_15    2
#define io_15   IN
#define st_15   1

/* 100  P0.16   ?    Funkmodul I/O  */
#define Q_16    0
#define io_16   IN
#define st_16   1

/* 101  P0.17   O    SCK1   Funkmodul Takt */
#define Q_17    2    /*  SCK  (SPI1)       */
#define io_17   OUT
#define st_17   0

/* 121  P0.18   I    MISO1  Funkmodul Daten */
#define Q_18    2    /*   MISO (SPI1)       */
#define io_18   IN
#define st_18   1

/* 122  P0.19   O    MOSI1  Funkmodul Daten */
#define Q_19    2    /*   MOSI (SPI1)       */
#define io_19   OUT
#define st_19   0

/* 123  P0.20                  ??? */
#define Q_20    0
#define io_20   IN
#define st_20   1

/*  4   P0.21   O     zur IR-Diode (Senden) */
#define Q_21    0
#define io_21   IN    /* erstmal Tristate.. */
#define st_21   1

/*  5   P0.22   ?                  */
#define Q_22    0
#define io_22   IN
#define st_22   1

/*  6   P0.23   O     Funkmodul Chipselect  */
#define Q_23    0
#define io_23   IN    /* erstmal Tristate.. */
#define st_23   1

/*  8   P0.24   ?     Funkmodul Daten GDO2  */
#define Q_24    0
#define io_24   IN    /* erstmal Tristate.. */
#define st_24   1

/* 21  P0.25                  ??? */
#define Q_25    0
#define io_25   IN
#define st_25   1

/*     P0.26          ist nicht vorhanden   */
#define Q_26    0     /*  reserviert        */
#define io_26   0
#define st_26   0

/* 23   P0.27   ?      auch AIN0 */
#define Q_27    1
#define io_27   IN
#define st_27   1

/* 25   P0.28   ?      auch AIN1 */
#define Q_28    1
#define io_28   IN
#define st_28   1

/* 32   P0.29   I    (CAP0.3 ?) IR Empfang, Capture? auch AIN2 */
#define Q_29    0
#define io_29   IN
#define st_29   1

/* 33   P0.30   I    EINT3  Tastatur-Interrupt auch AIN3 */
#define Q_30    0     /* P0.30 EINT3  war 2      */
#define io_30   IN
#define st_30   1

/* --   P0.31 ist nicht vorhanden */

#define ValForPinsel0  (Q_00 |(Q_01<<2) | (Q_02<<4) | (Q_03<<6) | (Q_04<<8) | \
                       (Q_05<<10) | (Q_06<<12) | (Q_07<<14) | (Q_08<<16)|(Q_09<<18) | \
                       (Q_10<<20) | (Q_11<<22) | (Q_12<<24) | (Q_13<<26) | (Q_14<<28) | \
                       ((unsigned)Q_15<<30) )

#define ValForPinsel1  (Q_16 |(Q_17<<2) | (Q_18<<4) | (Q_19<<6) | (Q_20<<8) | \
                       (Q_21<<10) | (Q_22<<12) | (Q_23<<14) | (Q_24<<16)|(Q_25<<18) | \
                       (Q_26<<20) | (Q_27<<22) | (Q_28<<24) | (Q_29<<26) | (Q_30<<28))

#define ValForIO0DIR   (io_00      | (io_01<<1)  | (io_02<<2)  | (io_03<<3)  | (io_04<<4)  | \
                       (io_05<<5)  | (io_06<<6)  | (io_07<<7)  | (io_08<<8)  | (io_09<<9)  | \
                       (io_10<<10) | (io_11<<11) | (io_12<<12) | (io_13<<13) | (io_14<<14) | \
                       (io_15<<15) | (io_16<<16) | (io_17<<17) | (io_18<<18) | (io_19<<19) | \
                       (io_20<<20) | (io_21<<21) | (io_22<<22) | (io_23<<23) | (io_24<<24) | \
                       (io_25<<25) | (io_26<<26) | (io_27<<27) | (io_28<<28) | (io_29<<29) | \
                       (io_30<<30) )

#define ValForIO0PORT  (st_00      | (st_01<<1)  | (st_02<<2)  | (st_03<<3)  | (st_04<<4)  | \
                       (st_05<<5)  | (st_06<<6)  | (st_07<<7)  | (st_08<<8)  | (st_09<<9)  | \
                       (st_10<<10) | (st_11<<11) | (st_12<<12) | (st_13<<13) | (st_14<<14) | \
                       (st_15<<15) | (st_16<<16) | (st_17<<17) | (st_18<<18) | (st_19<<19) | \
                       (st_20<<20) | (st_21<<21) | (st_22<<22) | (st_23<<23) | (st_24<<24) | \
                       (st_25<<25) | (st_26<<26) | (st_27<<27) | (st_28<<28) | (st_29<<29) | \
                       (st_30<<30) )



/**** PORT 1 ********************************************************************************/
/*
 91  P1.0    OUT    fest /CS0        /CS fr Flash 0 (0x8000 0000 .. 0x800F FFFF)
 90  P1.1    OUT    fest /OE         /OE fr Flash 0 und 1
     P1.0..15 gibt es nicht
 34  P1.16   IN                      Tasten-Sense 4
 24  P1.17   IN                      Tasten-Sense 3
 15  P1.18   IN                      Tasten-Sense 2
  7  P1.19   IN                      Tasten-Sense 1
102  P1.20   IN    Port              (kein TRACESYNC)
 95  P1.21   IN                      Tasten-Sense 6
 86  P1.22   IN                      Tasten-Sense 5
 82  P1.23   IN    Port              (kein PIPESTAT2)
 70  P1.24   IN    Port              (kein TRACECLK)
 60  P1.25   IN      EXTIN0
 52  P1.26   I/O   RTCK            JTAG an Pinhead
144  P1.27   OUT   TDO             JTAG an Pinhead
140  P1.28   IN    TDI             JTAG an Pinhead
126  P1.29   IN    TCK             JTAG an Pinhead
113  P1.30   IN    TMS             JTAG an Pinhead
 43  P1.31   IN    /TRST           JTAG an Pinhead
*/

#define ValForIO1DIR  (3 | (1<<27) )
#define ValForIO1PORT 0xFFFFFFFF


/**** PORT 2 ********************************************************************************/
/*
 98  P2.0    I/O  D0               ext.Bus: Daten
105  P2.1    I/O  D1               ext.Bus: Daten
106  P2.2    I/O  D2               ext.Bus: Daten
108  P2.3    I/O  D3               ext.Bus: Daten
109  P2.4    I/O  D4               ext.Bus: Daten
114  P2.5    I/O  D5               ext.Bus: Daten
115  P2.6    I/O  D6               ext.Bus: Daten
116  P2.7    I/O  D7               ext.Bus: Daten
117  P2.8    I/O  D8               ext.Bus: Daten
118  P2.9    I/O  D9               ext.Bus: Daten
120  P2.10   I/O  D10              ext.Bus: Daten
124  P2.11   I/O  D11              ext.Bus: Daten
125  P2.12   I/O  D12              ext.Bus: Daten
127  P2.13   I/O  D13
129  P2.14   I/O  D14              ext.Bus: Daten
130  P2.15   I/O  D15              ext.Bus: Daten
131  P2.16   IN   GPIO             ??? erstmal Tristate
132  P2.17   O    GPIO             Smartcard-Chip: Reset
133  P2.18   O    GPIO             Tasten-Drive 1
134  P2.19   O    GPIO             Tasten-Drive 2
136  P2.20   O    GPIO             Tasten-Drive 3
137  P2.21   O    GPIO             Tasten-Drive 4
  1  P2.22   O    GPIO             Tasten-Drive 5
 10  P2.23   O    GPIO             Tasten-Drive 6
 11  P2.24   O    GPIO             Tasten-Drive 7
 12  P2.25        GPIO             ???
 13  P2.26   I    GPIO   BOOT0     fest auf +3.3V
 16  P2.27        GPIO   BOOT1     fest auf GND
 17  P2.28        GPIO
 18  P2.29        GPIO
 19  P2.30   A    AIN4             auf Ltpad
 20  P2.31   A    AIN5             Akkuspannung
*/

#define ValForIO2DIR ( (0xFF<<17)  )
#define ValForIO2PORT ( 0 )


/**** PORT 3 ********************************************************************************/
/*
 89  P3.0    O    A0               ext.Bus: Adressen
 88  P3.1    O    A1               ext.Bus: Adressen
 87  P3.2    O    A2               ext.Bus: Adressen
 81  P3.3    O    A3               ext.Bus: Adressen
 80  P3.4    O    A4               ext.Bus: Adressen
 74  P3.5    O    A5               ext.Bus: Adressen
 73  P3.6    O    A6               ext.Bus: Adressen
 72  P3.7    O    A7               ext.Bus: Adressen
 71  P3.8    O    A8               ext.Bus: Adressen
 66  P3.9    O    A9               ext.Bus: Adressen
 65  P3.10   O    A10              ext.Bus: Adressen
 64  P3.11   O    A11              ext.Bus: Adressen
 63  P3.12   O    A12              ext.Bus: Adressen
 62  P3.13   O    A13              ext.Bus: Adressen
 56  P3.14   O    A14              ext.Bus: Adressen
 55  P3.15   O    A15              ext.Bus: Adressen
 53  P3.16   O    A16              ext.Bus: Adressen
 48  P3.17   O    A17              ext.Bus: Adressen
 47  P3.18   O    A18              ext.Bus: Adressen
 46  P3.19   O    A19              ext.Bus: Adressen

 45  P3.20   ?
 44  P3.21   ?
 41  P3.22   ?

 40  P3.23   O    XCLK             3.75 MHz (PCLK/2) Takt fr Smartcard-Chip
 36  P3.24   O    /CS3             ???
 35  P3.25   O    /CS2             /CS fr Flash 1  (0x8200 0000 .. 0x820F FFFF)
 30  P3.26   O    /CS1             /CS an LCD (0x8100 0000 .. 0x8100 0001)
 29  P3.27   O    /WE              /WE an Flash und LCD

 28  P3.28   I/O  /BLS3 oder ADC7  ???
 27  P3.29   I/O  /BLS2 oder ADC6  ???

 97  P3.30   O    /BLS1            ???
 96  P3.31   O    /BLS0            ???
*/

#define ValForIO3DIR  ( 0xFFFFF | (0x1F<<23) | ((unsigned)3<<30)  )
#define ValForIO3PORT ( 0 )


/* PINSEL2 steuert P1 und P2/P3 (Adr+Datenbus) */
/* 0x0D6041D4 or 0x800 or 0x800000 in Swissbetty

value  0    D    E    0    4    9    D    4
    0000.1101.1110.0000.0100.1001.1101.0100 ; original SwissBetty
        .    .    .    .    .    .    .   0 bit 0 res.
        .    .    .    .    .    .    .  0  bit  res
        .    .    .    .    .    .    . 1   bit 2    JTAG
        .    .    .    .    .    .    .0    bit 3    kein Traceport
        .    .    .    .    .    .    .
        .    .    .    .    .    .   1  bits 4+5    01=Mode 1
        .    .    .    .    .    .  0
        .    .    .    .    .    . 1    bit 6    P3.29=AIN6
        .    .    .    .    .    .1     bit 7    P3.28=AIN7
        .    .    .    .    .    .
        .    .    .    .    .   1       bit 8    P3.27=WE
        .    .    .    .    .  0        bits 9+10 reserved
        .    .    .    .    . 0         bits 9+10 reserved
        .    .    .    .    .1  bit 11  P3.26=CS1
        .    .    .    .    .
        .    .    .    .   0    bit 12  reserved
        .    .    .    .  0     bit 13  P3.23=XCLK Ausgang
        .    .    .    . 1      bit 14+15 P3.25=CS2
        .    .    .    .0
        .    .    .    .
        .    .    .   0    bit 16+17 P3.24=GPIO
        .    .    .  0
        .    .    .00      bit 18+19 reserved
        .    .    .
        .    .   0    bit 20  P2.28+29=GPIO
        .    .  1     bit 21  P2.30=AIN4
        .    . 1      bit 22  P2.31=AIN5
        .    .1       bit 23  P3.0= (0:GPIO, 1: P3.0=A0)
        .    .
	.   1    bit 24  P3.1=A1 (Adressline 1)
        .  0     bit 25..27 = 110 = P3.2..19 = A2..A19 Adresslines
	. 1      bit 26
	.1       bit 27
	.
    0000	 bit 28..31 res.
 */


#include "LPC22xx.h"
#include "StdTypes.h"
#include "serial.h"
#include "gdi.h"
#include "tasten.h"


extern void IRQ_HandlerDummy (void);

void setup (void)
{ PINSEL0 = ValForPinsel0;
  PINSEL1 = ValForPinsel1;
  /* PINSEL2 siehe Startup-Code, weil Bus betreffend */
  APBDIV = 2;    /* Peripherie = CPU/2, XCLK Ausgang = CPU/4 */
  SCS    = 3;    /* Port 0 und Port 1 auf fast (FIOxXXX) umschalten */
  FIO0MASK = 0;
  FIO1MASK = 0;

  FIO0DIR = ValForIO0DIR;
  FIO0CLR = 0xFFFFFFFF;
  FIO0SET = ValForIO0PORT;

  FIO1DIR = ValForIO1DIR;
  FIO1CLR = 0xFFFFFFFF;
  FIO1SET = ValForIO1PORT;

  /* FIO.. gibt es bei Port 2+3 nicht */
  IO2DIR = ValForIO2DIR;
  IO2CLR = 0xFFFFFFFF;
  IO2SET = ValForIO2PORT;

  IO3DIR = ValForIO3DIR;
  IO3CLR = 0xFFFFFFFF;
  IO3SET = ValForIO3PORT;

  /* einen Default-Handler fr spurious INTs usw. einrichten */
  VICDefVectAddr = (dword) IRQ_HandlerDummy;
//  VICProtection  = 0;      /* wenn 1 dann ist VIC im Usermode gesperrt */

  /* ADC Setup: einfach alle 8 Eingnge automatisch scannen. Der ADC darf
     maximal mit 4.5 MHz betrieben werden und braucht 11 Clocks fr 10 Bit Auflsung.
     Also CLKDIV = 3, macht 15 MHz / 4 --> 3.75 MHz
     macht 42.6 kHz Wiederholfrequenz fr alle 8 Kanle, also nach 23.5 us sind 
     alle ADC-Kanle abgearbeitet.
    P0.27   AIN0
    P0.28   AIN1
    P0.29   AIN2
    P0.30   AIN3
    P2.30   AIN4     
    P2.31   AIN5  Akkuspannung
    P3.29   AIN6
    P3.28   AIN7
  */
  ADCR = 255 | (4<<8) | (1<<16) | (1<<21);  /* 8 Kanle, PCLK:4, burst, enabled */

}
