/* Betty-TV-Fernbedienung: Definitionen berall bentigter Datentypen */

#ifndef _STDTYPES_INCLUDED
#define _STDTYPES_INCLUDED

/* Wichtig: wegen Interrupts 
   =========================
  der GCC bentigt anstelle
  des Ausdruckes "__irq"
  den Ausdruck   "__attribute__ ((interrupt("IRQ")))"
  deshalb ist in der Datei 'compile_gcc.xcl' der
  Kommandozeilen-Parameter '-D GCC' enthalten
  und die folgende Sequenz ersetzt __irq durch das, was GCC braucht.
  
  Die Ersetzung ist hier, weil die Serviceroutinen in anderen Quellen
  bentigt werden, zwecks Eintragung in den VIC
 */

#if defined (GCC)
#define __irq  __attribute__ ((interrupt("IRQ")))
#endif

/************** Daten-Typen ********************/

#define  integer   short int
#define  word      unsigned short int
#define  byte      unsigned char
#define  dword     unsigned long
#define  qword     unsigned long long
#define  int64     long long
#define  bool      unsigned char

#define  TRUE      1
#define  true      1
#define  FALSE     0
#define  false     0

/* schlecht merkbare Kringels */
#define     MOD   %
#define     XOR   ^
#define     NOT   ~
#define     AND   &
#define     OR    |



#define POINT struct TPoint
struct TPoint
{ integer X, Y; };

#define RECT  struct TRect
struct TRect
{ integer  left,
           top,
	   right,
	   bottom;
};


/*  ---  */
#endif






