/* Betty-TV-Fernbedienung: Arbeits-Routinen vom Men */

#include <stdlib.h>
#include <math.h>
#include "StdTypes.h"
#include "LPC22xx.h"
#include "setup.h"
#include "tasten.h"
#include "cmd.h"
#include "conv.h"
#include "systemtick.h"
#include "gdi.h"
#include "menu.h"
#include "events.h"


/************* Batterieanzeige im Men *****************/
/*
man kann auf ADDR5 rechnen 335 / Volt.
Also bei 2 Volt an den Akkus = 2*335 = 670
Akku krachvoll --> ca. 2.6  V --> 871
Akku leer      --> ca. 2.12 V --> 711
Differenz also 160
*/

const RECT BatR1 = { 0, 0, 25, 12};  /* uerer Rahmen */
const RECT BatR2 = { 1, 1, 24, 11};  /* Innenraum      */
const RECT BatR3 = { 26, 3, 28, 9};  /* "Pluspol"      */

void Betty_Batterie_Draw (RCST* self)
{ RECT  R;
  int adc, dvoll;

  dvoll = BatR2.right - BatR2.left - 2;  /* Ma fr "voll" Anzeige */
  adc   = ((ADDR5>>6) & 0x3FF) - 711;
  if (adc < 0) adc = 0;
  adc = adc * dvoll;
  adc = adc / 160;
  if (adc > dvoll) adc = dvoll;

  R = BatR1;
  LocalToScreen(self,&R);
  CgFillRect (&R, black);

  R = BatR3;
  LocalToScreen(self,&R);
  CgFillRect (&R, black);

  R = BatR2;
  LocalToScreen(self,&R);
  CgFillRect (&R, white);

  ++R.left;
  ++R.top;
  --R.bottom;
  R.right = R.left + adc;
  CgFillRect (&R, black);
}


void Betty_Batterie_OnEvent (RCST* self, word *aEvent)
{ if (*aEvent == idSekundeUm) self->Draw(self);
}


/************* Uhrzeitanzeige im Men *****************/

void Betty_Uhrzeit_Draw     (RCST* self)
{ RECT  R;
  long L;
  ldiv_t T;
  char S[9];          /*  "88:88:88  */

  S[2] = S[5] = ':';
  S[8] = 0;
  R = self->R;
  LocalToScreen(self,&R);
  CgFillRect(&R, white);

  L = T0TC / 1000;
  T = ldiv(L,10); L = T.quot;  S[7] = '0'+T.rem;
  T = ldiv(L,6);  L = T.quot;  S[6] = '0'+T.rem;

  T = ldiv(L,10); L = T.quot;  S[4] = '0'+T.rem;
  T = ldiv(L,6);  L = T.quot;  S[3] = '0'+T.rem;

  T = ldiv(L,10); L = T.quot;  S[1] = '0'+T.rem;
  T = ldiv(L,6);  L = T.quot;  S[0] = '0'+T.rem;

  CgStr_at (R.left, R.top, S,  black | idf_Helv_14B);
}

void Betty_Uhrzeit_OnEvent  (RCST* self, word *aEvent)
{ if (*aEvent == idSekundeUm) self->Draw(self);
}



/************* Tasten testen ************************/
/*
hier sieht man mal, wie es ist, wenn man prozedural
und damit blockierend programmiert. Das was sonst wie
von selbst luft, mu man hier explizit immer wieder
selbst aufrufen, sonst hngt alles.
*/
extern const RECT R1;
extern const RECT R2;
extern const RECT R3;

const char HeyCaption[] = { 0x1D, ' ', 'B', 'e', 't', 't', 'y', 0};

void Betty_Tastentest_OnKey (RCST* self, word *aKey)
{ char c;
  if (*aKey == idEnterTaste)
  {  Messagebox ((char*)HeyCaption, "Betty says ...boop!");
     CgFillRect((RECT*)&R1, ltgr);
     CgFillRect((RECT*)&R2, dkgr);
     ScrBlt();

     c = 0;
     while (c!=27)    /* esc */
     { Talk();                      /* damit der Hintergrund-Moni luft */
       if (IsKeyAvailable())
       { c = TranslateKeynum(GetKey());
         CgFillRect((RECT*)&R3, white);
         CgCh_at(24,122,c,  black | idf_Helv_14B);
         ScrBlt();
       }
     }
    *aKey = 0;        /* austragen */
    Add_Event(idMenuRedraw);
  }
}

/************* Lict ein und wieder aus *****************/

void Betty_Lichtein_OnKey   (RCST* self, word *aKey)
{ if (*aKey == idEnterTaste)
  { LichtEin();
    *aKey = 0;        /* austragen */
  }
}

void Betty_Lichtaus_OnKey   (RCST* self, word *aKey)
{ if (*aKey == idEnterTaste)
  { LichtAus();
    *aKey = 0;        /* austragen */
  }
}


/************* Anzeige der ADC-Werte *******************/

void Betty_ADCsee_OnKey (RCST *self, word *aKey)
{ if (*aKey == idEnterTaste) Add_Event(idMenuSelect2);
}

void ADCsee_exit_OnKey (RCST *self, word *aKey)
{if ((*aKey == idEnterTaste)||
     (*aKey == idEscapeTaste))  Add_Event(idMenuSelect1);
}

void ADCsee_Results_OnEvent (RCST *self, word *aEvent)
{ if ((*aEvent == id_200_milli)||
      (*aEvent == idSekundeUm)) self->Draw(self);
}

void ADCsee_Results_Draw (RCST* self)
{ RECT  R;
  int   X, Y;
  int   i;
  int   values[8];
  char  S[16];

  values[0]= (ADDR0>>6)&0x3FF;
  values[1]= (ADDR1>>6)&0x3FF;
  values[2]= (ADDR2>>6)&0x3FF;
  values[3]= (ADDR3>>6)&0x3FF;
  values[4]= (ADDR4>>6)&0x3FF;
  values[5]= (ADDR5>>6)&0x3FF;
  values[6]= (ADDR6>>6)&0x3FF;
  values[7]= (ADDR7>>6)&0x3FF;

  R = self->R;
  LocalToScreen(self,&R);
  CgFillRect (&R, white);
  if (self->Flags & debrect) Umrande(&R, black);
  X = R.left + 10;
  Y = R.top  + 2;

  S[0] = 'A'; S[1] = 'D'; S[2] = 'C'; S[4] = ':'; S[5] = ' ';
  i = 0;
  while ((i<8)&&(Y<R.bottom))
  { S[3] = '0'+i;
    LONGtoStr (values[i], 4, &S[6], sizeof(S)-6);
    CgStr_at (X, Y, S, black | idf_Simple6x13);
    Y = Y + Get_dY(Get_Font(idf_Simple6x13)) + 1;
    ++i;
  }
}


/************* App-Finder, sucht Apps im 2. ROM ********/

void Betty_Appfinder_OnKey (RCST *self, word *aKey)
{ if (*aKey == idEnterTaste) Add_Event(idMenuSelect3);
}

void Appfinder_exit_OnKey (RCST *self, word *aKey)
{if ((*aKey == idEnterTaste)||
     (*aKey == idEscapeTaste)) Add_Event(idMenuSelect1);
}


   /* ende */
