/* SwissBetty-TV-Fernbedienung: cmd.c */
/* Hintergrund-Kommandointerpreter fr Kommunikation ber UART0 */

#include "LPC22xx.h"
#include "StdTypes.h"
#include "cmd.h"
#include "conv.h"
#include "gdi.h"
#include "setup.h"
#include "serial.h"
#include "tasten.h"


char* Cpt;
char Kommandozeile[64];
int kzi;

void InitCmd (void)
{  long L;

   L = sizeof(Kommandozeile);
   while (L) Kommandozeile[--L] = 0;
   kzi = L;
   V24_CharOut('>');
}

  /* Kommandozeile hereinholen */
void Talk (void)
{ char c;

  if (V24_CharAvail())
  { c =  V24_CharIn();
    if (c==0x0D)
    { V24_CRLF();
      DoCommand (Kommandozeile);
      InitCmd();
    }
    else
    { if (kzi>=(sizeof(Kommandozeile)-1)) return;
      if (c==8)
      { V24_CharOut(8);
        V24_CharOut(' ');
        V24_CharOut(8);
        Kommandozeile[--kzi]=0;
      }
      else
      { if (c<' ') return;
        V24_CharOut(c);
        Kommandozeile[kzi++] = c;
        Kommandozeile[kzi] = 0;
      }
    }
  }
}


/* Display Memory
 D  anf end     display Bereich
 DM anf end     display Memory1 (0x80000000 ...)
 DR anf end     display RAM     (0x40000000 ...)
 DX anf end     display Memory2 (0x82000000 ...)

*/

void DoDisplay (void)
{ char* von;
  char* bis;
  char* von2;
  dword morr;
  word  i;
  char  c;

  morr = 0;
  if (match("M",&Cpt)) morr = 0x80000000;
  if (match("R",&Cpt)) morr = 0x40000000;
  if (match("X",&Cpt)) morr = 0x82000000;

  von = (char*) 0;
  bis = (char*) 0xFF;
  if (*Cpt)
  { von = (char*) Hex_In(&Cpt);
    bis = (char*) Hex_In(&Cpt);
    if (bis<=von) bis = von + 255;
  }
  von = (char*) ((dword)von | morr);
  bis = (char*) ((dword)bis | morr);

  while((long) bis >= (long) von)
  {  V24_CRLF();
     HexL_Out((long) von);
     von2 = von;
     V24_CharOut(':');
     i = 16;
     while(i)
     { --i;
       V24_CharOut(' ');
       HexB_Out(*von++);
     }
     V24_CharOut(' ');
     i = 16;
     while(i)
     { --i;
       c = *von2++;
       if ((c<' ')||(c>126)) c = ' ';
       V24_CharOut(c);
     }
  }
  V24_CRLF();
}



void DoCommand (char* Pzeile)
{ Cpt = Pzeile;

  if (match("D",&Cpt))     { DoDisplay(); return;}
  if (match("E",&Cpt))     { LichtEin(); return;}
  if (match("A",&Cpt))     { LichtAus(); return;}
  if (match("PORTS",&Cpt)) { HexL_Out(IO0PIN); V24_CharOut(' ');
 	                     HexL_Out(IO1PIN); V24_CharOut(' ');
	                     HexL_Out(IO2PIN); V24_CharOut(' ');
	                     HexL_Out(IO3PIN); V24_CRLF();
			     return;
                           }

  /* Platz fr weitere Kommandos */

  if (!*Cpt) return;
  V24_StrOut("wat? ");
  V24_StrOut(Cpt);
  V24_CRLF();
}
