/* SwissBetty-TV-Fernbedienung: main.c */

#include "LPC22xx.h"
#include "StdTypes.h"
#include "setup.h"
#include "systemtick.h"
#include "events.h"
#include "serial.h"
#include "conv.h"
#include "cmd.h"
#include "gdi.h"
#include "tasten.h"
#include "menu.h"


#include "bilder\evangeline.inc"

const RECT R1 = { 0, 128, 127, 159};
const RECT R2 = { 4, 132, 123, 155};
const RECT R3 = { 8, 136, 119, 151};

int main(void)
{  int  i;

   setup();
   V24_Init(9600);
   V24_CRLF();
   V24_StrOut((char*)Manifest);
   V24_CRLF();
   if (Errors)
   { V24_StrOut("Restart bei ");
     HexL_Out(ErrAddr);
     V24_StrOut(" wegen ");
     if (Errors >= 0x80000000) V24_StrOut("abort");
     if (Errors & 1) V24_StrOut("Warmstart, ");
     if (Errors & 2) V24_StrOut("raised Lib exc, ");
     if (Errors & 4) V24_StrOut("prefetch Abort, ");
     if (Errors & 8) V24_StrOut("invalid Instruction, ");
     if (Errors & 16) V24_StrOut("wrong SWI num, ");
     if (Errors & 32) V24_StrOut("data Abort, ");
     V24_CRLF();
   }

   Systemtick_Init();         /* Timer 0 als 10 ms Timer initialisieren */
   Event_Init();
   Tasten_Init();
   InitCmd();
   init_GDI();

   CgPicture_at(0, 0, (char*) &evangeline);

   ScrBlt();
   LichtEin();
   while (T0TC < 1000);                  /* damit man es sieht.. */

   CgFillRect((RECT*)&R1, ltgr);
   CgFillRect((RECT*)&R2, dkgr);
   CgFillRect((RECT*)&R3, black);
   CgStr_at(R3.left+1,R3.top+1,(char*)Manifest, invert | idf_Helv_12B);

   ScrBlt();

   while (T0TC < 3000);                  /* damit man auch dies sieht.. */

   DispatchEvent(idMenuSelect1);
   DispatchEvent(idMenuRedraw);


   immerzu:
     Talk();                                         /* Hintergrund-Moni ber UART0 */
     if (Event_avail()) DispatchEvent(Get_Event());  /* Events ins Men einspeisen */


     if (IsKeyAvailable())
     { i = TranslateKeynum(GetKey());
       if (i) Add_Event(tastMin + i);
     }


   goto immerzu;
}


