unit ManUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, ComCtrls;

type
  PHeader = ^THeader;
  THeader = packed record
    Signatur : array[0..7] of char;
    Flags    : dword;
    Alloc    : dword;
    Start    : dword;
    Icon     : dword;
    Name     : dword;
    Descr    : dword;
    end;


  TMainForm = class(TForm)
    Flash1GroupBox: TGroupBox;
    Flash2GroupBox: TGroupBox;
    Flash1Grid: TStringGrid;
    Flash2Grid: TStringGrid;
    StaBar: TStatusBar;
    OpenDialog: TOpenDialog;
    LadeRom1: TButton;
    LadeRom2: TButton;
    Rom1StoreButton: TButton;
    Rom2StoreButton: TButton;
    SaveDialog: TSaveDialog;
    AppLadeButton: TButton;
    BaseLadeButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure LadeRom1Click(Sender: TObject);
    procedure LadeRom2Click(Sender: TObject);
    procedure Flash2GridSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure Flash1GridSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure Rom1StoreButtonClick(Sender: TObject);
    procedure Rom2StoreButtonClick(Sender: TObject);
    procedure AppLadeButtonClick(Sender: TObject);
    procedure BaseLadeButtonClick(Sender: TObject);
  private
    { Private declarations }
    procedure AnalysiereBuffers;
  public
    { Public declarations }
  end;

var
  MainForm  : TMainForm;
  Buffer1   : array[0..$FFFFF] of byte;
  Buffer2   : array[0..$FFFFF] of byte;
  TmpBuffer : array[0..$FFFFF] of byte;

  Belegung1 : array[0..31] of THeader;
  Belegung2 : array[0..31] of THeader;
  Filename1 : String;
  Filename2 : String;


implementation

{$R *.dfm}

function StringConv (Pcc : PChar): String;
var
  S : String;
begin
  S:= '';
  while Pcc^ <> #0 do
  begin
    S:= S + Pcc^;
    inc(Pcc);
  end;
  result:= S;
end;


procedure TMainForm.FormCreate(Sender: TObject);
var
  i : integer;
  L1, L2 : dword;
begin
  fillchar(Buffer1,sizeof(Buffer1),$FF);
  fillchar(Buffer2,sizeof(Buffer2),$FF);
  fillchar(Belegung1,sizeof(Belegung1),0);
  fillchar(Belegung2,sizeof(Belegung2),0);

  L1:= $80000000;
  L2:= $82000000;
  Flash1Grid.ColWidths[1]:= Flash1Grid.Width - Flash1Grid.ColWidths[0] - 8;
  Flash2Grid.ColWidths[1]:= Flash2Grid.Width - Flash2Grid.ColWidths[0] - 8;
  for i:= 31 downto 0 do
  begin
     Flash1Grid.Cells[0,i]:= IntToHex(L1,8);
     Flash1Grid.Cells[1,i]:= '---';
     Flash2Grid.Cells[0,i]:= IntToHex(L2,8);
     Flash2Grid.Cells[1,i]:= '---';
     inc(L1,$8000);
     inc(L2,$8000);
  end;
  Filename1:= '';
  Filename2:= '';
end;

procedure TMainForm.LadeRom1Click(Sender: TObject);
var
  F : file;
  L : longint;
begin
  if OpenDialog.Execute
  then begin
         fillchar(Buffer1,sizeof(Buffer1),$FF);
         assignfile(F,OpenDialog.FileName);
         Filename1:= OpenDialog.FileName;
         reset(F,1);
         L:= FileSize(F);
         if L > sizeof(Buffer1) then L:= sizeof(Buffer1);
         blockread(F,Buffer1,L);
         closefile(F);
         AnalysiereBuffers;
       end;
end;

procedure TMainForm.LadeRom2Click(Sender: TObject);
var
  F : file;
  L : longint;
begin
  if OpenDialog.Execute
  then begin
         fillchar(Buffer2,sizeof(Buffer2),$FF);
         assignfile(F,OpenDialog.FileName);
         Filename2:= OpenDialog.FileName;
         reset(F,1);
         L:= FileSize(F);
         if L > sizeof(Buffer2) then L:= sizeof(Buffer2);
         blockread(F,Buffer2,L);
         closefile(F);
         AnalysiereBuffers;
       end;
end;

procedure TMainForm.AnalysiereBuffers;
var
  Ph : PHeader;
  P  : PChar;
  Q  : dword;
  i  : integer;
  S  : String;
begin
  fillchar(Belegung1,sizeof(Belegung1),0);
  fillchar(Belegung2,sizeof(Belegung2),0);
  P:= @Buffer1[$40];
  S:= StringConv(P);
  if pos('Betty',S)<>0
  then Flash1Grid.Cells[1,31]:= S;
  Q:= $8000;
  for i:= 1 to 31 do
  begin
    Ph:= @Buffer1[Q];
    if (Ph^.Signatur = 'BETTYAPP') and
       (Ph^.Alloc = Q + $80000000 )
    then
    begin
      Belegung1[i]:= Ph^;
      P:= @Buffer1[Ph^.Name - $80000000];
      S:= StringConv(P);
      Flash1Grid.Cells[1,31-i]:= S;
    end
    else
    begin

    end;
    inc(Q,$8000);
  end;

  Q:= 0;
  for i:= 0 to 31 do
  begin
    Ph:= @Buffer2[Q];
    if (Ph^.Signatur = 'BETTYAPP') and
       (Ph^.Alloc = Q + $82000000 )
    then
    begin
      Belegung2[i]:= Ph^;
      P:= @Buffer2[Ph^.Name - $82000000];
      S:= StringConv(P);
      Flash2Grid.Cells[1,31-i]:= S;
    end
    else
    begin

    end;
    inc(Q,$8000);
  end;


end;



procedure TMainForm.Flash2GridSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
var
  P  : PChar;
  Q  : dword;
  i  : integer;
  S  : String;
begin
  i:= 31-ARow;
  with  Belegung2[i] do
  if (Signatur = 'BETTYAPP')
  then
  begin
    S:= 'Bereich ' + IntToStr(i) + ':  NAME: ' +
        StringConv(@Buffer2[Name - $82000000]) + '  Beschreibung: ' +
        StringConv(@Buffer2[Descr - $82000000]);
    StaBar.Panels[0].Text:= S;
  end
  else StaBar.Panels[0].Text:= 'Bereich '+IntToStr(i)+' ???';
end;

procedure TMainForm.Flash1GridSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
var
  P  : PChar;
  Q  : dword;
  i  : integer;
  S  : String;
begin
  i:= 31-ARow;
  with  Belegung1[i] do
  if (Signatur = 'BETTYAPP')
  then
  begin
    S:= 'Bereich ' + IntToStr(i) + ':  NAME: ' +
        StringConv(@Buffer2[Name - $80000000]) + '  Beschreibung: ' +
        StringConv(@Buffer2[Descr - $80000000]);
    StaBar.Panels[0].Text:= S;
  end
  else StaBar.Panels[0].Text:= 'Bereich '+IntToStr(i)+' ???';

end;

procedure TMainForm.Rom1StoreButtonClick(Sender: TObject);
var
  F : File;
begin
  SaveDialog.FileName:= 'Flash1.bin';
  if SaveDialog.Execute
  then
  begin
    assignfile(F,SaveDialog.FileName);
    rewrite(F,1);
    blockwrite(F,Buffer1,sizeof(Buffer1));
    closefile(F);
  end;
end;

procedure TMainForm.Rom2StoreButtonClick(Sender: TObject);
var
  F : File;
begin
  SaveDialog.FileName:= 'Flash2.bin';
  if SaveDialog.Execute
  then
  begin
    assignfile(F,SaveDialog.FileName);
    rewrite(F,1);
    blockwrite(F,Buffer2,sizeof(Buffer2));
    closefile(F);

  end;
end;

procedure TMainForm.AppLadeButtonClick(Sender: TObject);
var
  F : file;
  L : longint;
  O : dword;
  P : PHeader;
begin
  if OpenDialog.Execute
  then begin
         fillchar(TmpBuffer,sizeof(TmpBuffer),$FF);
         assignfile(F,OpenDialog.FileName);
         reset(F,1);
         L:= FileSize(F);
         if L > sizeof(TmpBuffer)
         then
         begin
           closefile(F);
           beep;
           exit;
         end;
         blockread(F,TmpBuffer,L);
         closefile(F);
         P:= @TmpBuffer;
         O:= P^.Alloc;
         if (O >= $80008000) and (O <= $800FFFFF)
         then begin
                O:= O and $FFFFF;
                if (O+L) > $FFFFF
                then  begin
                        beep;
                        exit;
                      end;
                move(TmpBuffer,Buffer1[O],L);
              end;

         if (O >= $82000000) and (O <= $820FFFFF)
         then begin
                O:= O and $FFFFF;
                if (O+L) > $FFFFF
                then  begin
                        beep;
                        exit;
                      end;
                move(TmpBuffer,Buffer2[O],L);
              end;
         AnalysiereBuffers;
       end;
end;

procedure TMainForm.BaseLadeButtonClick(Sender: TObject);
var
  F : file;
  L, LL : longint;
begin
  if OpenDialog.Execute
  then begin
         assignfile(F,OpenDialog.FileName);
         Filename1:= OpenDialog.FileName;
         reset(F,1);
         L:= FileSize(F);
         if L > sizeof(Buffer1) then L:= sizeof(Buffer1);
         LL:= L or $7FFF;
         fillchar(Buffer1,LL,$FF);

         blockread(F,Buffer1,L);
         closefile(F);

         AnalysiereBuffers;
       end;
end;

end.
