/* Betty-TV-Fernbedienung: Definitionen des BettyBase-Interfaces fr Apps */
/* ====================================================================== */
#ifndef _APPGDI_INCLUDED
#define _APPGDI_INCLUDED

/* GCC-Version mit indirekten SWI's per 'BettyApiGcc.asm' */

/* Definitionen fr Zeichenmodi,
die untersten 4 Bit sind fr die Fontnummer 0..15 */
#define white          0
#define ltgr        0x10
#define dkgr        0x20
#define black       0x30
#define invert      0x40
#define allmodes  0xFFF0

/* Definitionen fr Fonts */
#define idf_Simple5x7    0
#define idf_Simple6x13   1
#define idf_Helv_12      2
#define idf_Helv_12B     3
#define idf_Helv_14      4
#define idf_Helv_14B     5
#define idf_Lucida_20    6


/*  Beschreibung des verwendeten Font-Formates:
 zuerst kommt der Font-Header in folgendem Format: */

#define Fontheadersize 6

#define PFONT  struct Fontheader*
struct Fontheader
{ byte Capitals; /* Hoehe der Grossbuchstaben */
  byte Height;   /* Font-Gesamthoehe */
  byte Ascent;   /* Hoehe ueber Null-Linie */
  byte Descent;  /* Tiefe unter Null-Linie */
  char ChMin;    /* kleinstes vorhandenes Zeichen */
  char ChMax;    /* groesstes vorhandenes Zeichen */
};

/* danach kommen unterschiedlich viele Char-Entries.
   eigentlich ist 'Disp' ein 16 bit Offset, aber der
   Font muss bei BigEndian und LittleEndian-CPU's
   gleichermassen funktionieren, deswegen die explizite
   Aufteilung in DispHi und DispLo  */

#define Charentrysize 4

struct CharEntry
{ byte DispHi;   /* Hi vom Displacement ab Fontbeginn */
  byte DispLo;   /* Lo vom Displacement ab Fontbeginn */
  byte dX;       /* Breite in Pixeln */
  byte dY;       /* Hoehe in Pixeln */
};

/* danach kommen die Pixel. Jeder CharEntry (s.o.) zeigt
   auf den Beginn des zu seinem Char gehrigen Bitmusters.
   Jedes Bitmuster beginnt an einem ganzen Byte, aber innerhalb
   geht es je nach Zeichenbreite asynchron zu den Bytegrenzen
 */


#define RCST  const struct TMenuItem
struct TMenuItem
{ struct TRect R;                  /* die Koordinaten relativ zum Owner       */
  const struct TMenuItem *davor;   /* Listenverkettung: Item davor            */
  const struct TMenuItem *danach;  /* Listenverkettung: Item danach           */
  const struct TMenuItem *Owner;   /* Item, wo dieses enthalten ist           */
  const struct TMenuItem *Members; /* Liste der enthaltenen Items             */
  dword Flags;                     /* diverse Flag-Bits                       */
  void  *Data;                     /* Zeiger auf fallspezifische Daten        */
  void  (*OnKey)  (RCST* self, word *aKey);     /* wertet Tastendrcke aus    */
  void  (*OnEvent)(RCST* self, word *aEvent);   /* wertet Ereignisse aus      */
  void  (*Draw)   (RCST* self);    /* zeichnet sich und Members  */
};

/* Flagwerte fr die Flags von TMenuItem */
#define   cl_white      0
#define   cl_ltgr       1
#define   cl_dkgr       2
#define   cl_black      3
#define   border       (1<<2)      /* ob Element eine Umrandung har */
#define   canFocus     (1<<3)      /* ob es fokussierbar ist        */
#define   center       (1<<4)      /* hier knnen beliebige weitere */
#define   opaque       (1<<5)      /* Flags vereinbart werden       */
#define   debrect      (1<<6)





/* Funktionen im GDI: */
extern  void   FillLanes           (byte mode);
extern  void   LichtAus            (void);
extern  void   LichtEin            (void);
extern  void   FlipDisplay         (bool normal);
extern  int    ScrBlt              (void);
extern  bool   CgPixel_at          (int X, int Y, int mode);
extern  void   MoveTo              (POINT* A);
extern  void   LineTo              (POINT* B, int mode);
extern  void   CgFillRect          (RECT* R, int mode);
extern  int    CgCh_at             (int X, int Y, char Ch, word FontMode);
extern  int    CgStr_at            (int x, int y, char* P, word FontMode);
extern  int    StringWidth         (char* S, const char* Font);
extern  int    Get_dY              (PFONT Font);
extern  int    Get_Ascent          (PFONT Font);
extern  int    Get_Descent         (PFONT Font);
extern  int    Get_dX              (PFONT Font, char Ch);
extern  PFONT  Get_Font            (int Fontnummer);


/* Funktionen im Mensystem: direkte Verweise auf Wrappers in 'BettyApiGcc.asm' */
#define PanelKeyHandler     PanelKeyHandlerEx
#define PanelEventHandler   PanelEventHandlerEx
#define PanelDrawProc       PanelDrawProcEx
#define ButtonDrawProc      ButtonDrawProcEx

/* Funktionen im Mensystem */
extern  word   DispatchEvent       (word aEvent);
extern  void   LocalToScreen       (RCST* PItem, RECT* R);
extern  void   Umrande             (RECT* Pr, int mode);
extern  void   PanelKeyHandlerEx   (RCST *self, word *aKey);
extern  void   PanelEventHandlerEx (RCST* self, word *aEvent);
extern  void   PanelDrawProcEx     (RCST* self);
extern  void   ButtonDrawProcEx    (RCST* self);
extern  void   Messagebox          (char* Caption, char* Message);
extern  RCST*  GetSetMenu          (RCST* aMenu);


/* Funktionen der seriellen Schnittstelle */
extern  dword  V24_Init           (long baudrate); /* liefert tatschliche Baudrate zurck */
extern  int    V24_Txfree         (void);          /* liefert Anzahl freier Pltze im Tx Puffer */
extern  char   V24_CharOut        (char c);        /* Zeichen auf UART ausgeben */
extern  void   V24_StrOut         (char* P);       /* String auf UART ausgeben  */
extern  void   V24_CRLF           (void);          /* 0x13 0x10 auf UART ausgeben */
extern  bool   V24_CharAvail      (void);          /* ob empfangene Zeichen anliegen */
extern  char   V24_CharIn         (void);          /* liest empfangenes Zeichen (ohne Warten) */


/* Funktionen zum Abrufen von Tasten */
extern  bool   IsKeyAvailable     (void);          /* ob ein Tastenereignis im Puffer vorhanden ist */
extern  bool   IsKeyPressed       (void);          /* ob momentan eine Taste gedrckt ist */
extern  byte   GetKey             (void);          /* Tastenereignis aus dem Puffer holen */
extern  char   TranslateKeynum    (byte KeyCode);  /* Keycode --> ASCII char */
extern  int64  TastenZustand      (void);          /* momentane Belegung aller Tasten lesen  */

/* hier kommen alle spter dazugekommenen Funktionen */
extern  void   CgPicture_at      (int x, int y, char* P); /* zeichnet ein Bild auf dem LCD */
extern  void   CgCircle_at       (POINT* A, int radius, int mode);
extern  bool   Ich_selected      (RCST* self);
extern  char*  StringCopy        (char* ziel, char* quelle, int bufmax);
extern  char*  StringAdd         (char* ziel, char* quelle, int bufmax);
extern  bool   Add_Delayed_Event (dword millisec, word aEvent);


#endif
