/* Betty-TV-Fernbedienung: Definitionen des BettyBase-Interfaces fr Apps */
/* ====================================================================== */

/* ARM-Version mit direkten SWI's */
#ifndef _APPGDI_INCLUDED
#define _APPGDI_INCLUDED


/* Definitionen fr Zeichenmodi,
die untersten 4 Bit sind fr die Fontnummer 0..15 */
#define white          0
#define ltgr        0x10
#define dkgr        0x20
#define black       0x30
#define invert      0x40
#define allmodes  0xFFF0

/* Definitionen fr Fonts */
#define idf_Simple5x7    0
#define idf_Simple6x13   1
#define idf_Helv_12      2
#define idf_Helv_12B     3
#define idf_Helv_14      4
#define idf_Helv_14B     5
#define idf_Lucida_20    6


/*  Beschreibung des verwendeten Font-Formates:
 zuerst kommt der Font-Header in folgendem Format: */

#define Fontheadersize 6

#define PFONT  struct Fontheader*
struct Fontheader
{ byte Capitals; /* Hoehe der Grossbuchstaben */
  byte Height;   /* Font-Gesamthoehe */
  byte Ascent;   /* Hoehe ueber Null-Linie */
  byte Descent;  /* Tiefe unter Null-Linie */
  char ChMin;    /* kleinstes vorhandenes Zeichen */
  char ChMax;    /* groesstes vorhandenes Zeichen */
};

/* danach kommen unterschiedlich viele Char-Entries.
   eigentlich ist 'Disp' ein 16 bit Offset, aber der
   Font muss bei BigEndian und LittleEndian-CPU's
   gleichermassen funktionieren, deswegen die explizite
   Aufteilung in DispHi und DispLo  */

#define Charentrysize 4

struct CharEntry
{ byte DispHi;   /* Hi vom Displacement ab Fontbeginn */
  byte DispLo;   /* Lo vom Displacement ab Fontbeginn */
  byte dX;       /* Breite in Pixeln */
  byte dY;       /* Hoehe in Pixeln */
};

/* danach kommen die Pixel. Jeder CharEntry (s.o.) zeigt
   auf den Beginn des zu seinem Char gehrigen Bitmusters.
   Jedes Bitmuster beginnt an einem ganzen Byte, aber innerhalb
   geht es je nach Zeichenbreite asynchron zu den Bytegrenzen
 */


#define RCST  const struct TMenuItem
struct TMenuItem
{ struct TRect R;                  /* die Koordinaten relativ zum Owner       */
  const struct TMenuItem *davor;   /* Listenverkettung: Item davor            */
  const struct TMenuItem *danach;  /* Listenverkettung: Item danach           */
  const struct TMenuItem *Owner;   /* Item, wo dieses enthalten ist           */
  const struct TMenuItem *Members; /* Liste der enthaltenen Items             */
  dword Flags;                     /* diverse Flag-Bits                       */
  void  *Data;                     /* Zeiger auf fallspezifische Daten        */
  void  (*OnKey)  (RCST* self, word *aKey);     /* wertet Tastendrcke aus    */
  void  (*OnEvent)(RCST* self, word *aEvent);   /* wertet Ereignisse aus      */
  void  (*Draw)   (RCST* self);    /* zeichnet sich und Members  */
};

/* Flagwerte fr die Flags von TMenuItem */
#define   cl_white      0
#define   cl_ltgr       1
#define   cl_dkgr       2
#define   cl_black      3
#define   border       (1<<2)      /* ob Element eine Umrandung har */
#define   canFocus     (1<<3)      /* ob es fokussierbar ist        */
#define   center       (1<<4)      /* hier knnen beliebige weitere */
#define   opaque       (1<<5)      /* Flags vereinbart werden       */
#define   debrect      (1<<6)





/* Funktionen im GDI: */
__swi(9)  void   FillLanes           (byte mode);
__swi(10) void   LichtAus            (void);
__swi(11) void   LichtEin            (void);
__swi(12) void   FlipDisplay         (bool normal);
__swi(13) int    ScrBlt              (void);
__swi(14) bool   CgPixel_at          (int X, int Y, int mode);
__swi(15) void   MoveTo              (POINT* A);
__swi(16) void   LineTo              (POINT* B, int mode);
__swi(17) void   CgFillRect          (RECT* R, int mode);
__swi(18) int    CgCh_at             (int X, int Y, char Ch, word FontMode);
__swi(19) int    CgStr_at            (int x, int y, char* P, word FontMode);
__swi(20) int    StringWidth         (char* S, const char* Font);
__swi(21) int    Get_dY              (PFONT Font);
__swi(22) int    Get_Ascent          (PFONT Font);
__swi(23) int    Get_Descent         (PFONT Font);
__swi(24) int    Get_dX              (PFONT Font, char Ch);
__swi(25) PFONT  Get_Font            (int Fontnummer);


/* Funktionen im Mensystem */
__swi(26) word   DispatchEvent       (word aEvent);
__swi(27) void   LocalToScreen       (RCST* PItem, RECT* R);
__swi(28) void   Umrande             (RECT* Pr, int mode);
__swi(29) void   PanelKeyHandlerEx   (RCST *self, word *aKey);
__swi(30) void   PanelEventHandlerEx (RCST* self, word *aEvent);
__swi(31) void   PanelDrawProcEx     (RCST* self);
__swi(32) void   ButtonDrawProcEx    (RCST* self);
__swi(33) void   Messagebox          (char* Caption, char* Message);
__swi(34) RCST*  GetSetMenu          (RCST* aMenu);


/* in den MenuItems mssen diese Funktionen verwendet werden,
   weil die Funktionen "...Ex" quasi Inline-Funktionen sind   */
extern    void   PanelKeyHandler     (RCST *self, word *aKey);
extern    void   PanelEventHandler   (RCST* self, word *aEvent);
extern    void   PanelDrawProc       (RCST* self);
extern    void   ButtonDrawProc      (RCST* self);


/* Funktionen der seriellen Schnittstelle */
__swi(35) dword  V24_Init           (long baudrate); /* liefert tatschliche Baudrate zurck */
__swi(36) int    V24_Txfree         (void);          /* liefert Anzahl freier Pltze im Tx Puffer */
__swi(37) char   V24_CharOut        (char c);        /* Zeichen auf UART ausgeben */
__swi(38) void   V24_StrOut         (char* P);       /* String auf UART ausgeben  */
__swi(39) void   V24_CRLF           (void);          /* 0x13 0x10 auf UART ausgeben */
__swi(40) bool   V24_CharAvail      (void);          /* ob empfangene Zeichen anliegen */
__swi(41) char   V24_CharIn         (void);          /* liest empfangenes Zeichen (ohne Warten) */


/* Funktionen zum Abrufen von Tasten */
__swi(42) bool   IsKeyAvailable     (void);          /* ob ein Tastenereignis im Puffer vorhanden ist */
__swi(43) bool   IsKeyPressed       (void);          /* ob momentan eine Taste gedrckt ist */
__swi(44) byte   GetKey             (void);          /* Tastenereignis aus dem Puffer holen */
__swi(45) char   TranslateKeynum    (byte KeyCode);  /* Keycode --> ASCII char */
__swi(46) int64  TastenZustand      (void);          /* momentane Belegung aller Tasten lesen  */

/* hier kommen alle spter dazugekommenen Funktionen */
__swi(47) void   CgPicture_at      (int x, int y, char* P); /* zeichnet ein Bild auf dem LCD */
__swi(48) void   CgCircle_at       (POINT* A, int radius, int mode);
__swi(49) bool   Ich_selected      (RCST* self);
__swi(50) char*  StringCopy        (char* ziel, char* quelle, int bufmax);
__swi(51) char*  StringAdd         (char* ziel, char* quelle, int bufmax);
__swi(52) bool   Add_Delayed_Event (dword millisec, word aEvent);

#endif
