/* Konvertierungen aller Art */

#ifndef _CONV_INCLUDED
#define _CONV_INCLUDED

#include "StdTypes.h"

/* Ausgabe-Konvertierungen Integer und float */
extern long  LONGtoStr   (long aValue,  int digits, char* Buffer, int BufLen);
extern float FFtoStr     (float aValue, int digits, int dezi, char* Buffer, int BufLen);
extern void  FF_Out      (float f, int digits, int dezi);

/* Eingabe-Konvertierungen */
extern int   GetNibble    (char** Zptr);               /* liest 1 Hex-Zeichen 0..F, bei Fehlern: -1 */
extern dword Hex_In       (char** Zptr);               /* liest ganze Hex-Zahl (32 bit) */
extern dword Long_In      (char** Zptr);               /* liest Dezimalzahl, kann auch negative Zahlen  */
extern float Float_In     (char** Zptr);               /* float aus String lesen */
extern float FF_round     (float aValue, byte Digits); /* nur Digits 1..5 zulssig */
extern char  UpCase       (char aChar);                /* wandelt Char in Grobuchstaben */
extern void  IgnoreSpace  (char** Zptr);               /* bergeht Leerzeichen */
extern char  match        (char* item, char** Zptr);   /* Sub-Strings erkennen */

/* Ausgaben ber V24 */
extern void  Nibble_Out   (int aHex);                  /* ein Hex-Zeichen ausgeben */
extern void  HexB_Out     (byte aHex);                 /* ein Byte als Hexa ausgeben */
extern void  HexW_Out     (word aHex);                 /* ein Word als Hexa ausgeben */
extern void  HexL_Out     (long aHex);                 /* ein DWORD als Hexa ausgeben */
extern void  HexQ_Out     (int64 aHex);                /* ein QWORD als Hexa ausgeben */
extern void  Dezi_Out     (long aDez, signed char digits); /* kleiner&schneller als LONGtoString */

/* sonstiger Kram */
extern char* StringCopy   (char* ziel, char* quelle, int bufmax); /* Kopieren mit Lngenbegrenzung */
extern char* StringAdd    (char* ziel, char* quelle, int bufmax); /* Strings addieren mit Lngenbegrenzung */
#endif
