/*  EVENTS.H   SwissBetty: Unit fr die Ereignisverwaltung im LPC2220 */

#ifndef EVENTSINCLUDED
#define EVENTSINCLUDED

/*
Ein Event wird durch ein word (16bit) dargestellt. Im Prinzip ist man
frei bei der Wahl der Werte, aber es ist gut, diverse Gruppen zu
bilden: Tastatur-Events, System-Events und so weiter.

Hier:
0           = nix
1   .. 255  = Systemevents
256 .. 511  = Tastaturevents
512 .. ?    = ?
*/


/* ladbare Timer, d.h. Down-Counters, die bei Erreichen von 0 einen Event
 in den Eventbuffer einspeisen  */

#define DTTE  struct TTimerEvent
struct TTimerEvent
{ dword endzeit;
  word  aEvent;
  word  Flags;
};

#define numtimers   4
extern DTTE CurrTimers[numtimers];


/* 42 Tasten */
#define tastMin (256)
#define tastMax (256+41)


#define idMenuClear     1
#define idMenuInit      2
#define idMenuRedraw    3
#define idSekundeUm     4
#define id_200_milli    5


#define idMenuSelect1 201
#define idMenuSelect2 202
#define idMenuSelect3 203   /* usw. je nach Bedarf */

#define idEnterTaste  (13+tastMin)
#define idLinksTaste  (17+tastMin)
#define idRechtsTaste (18+tastMin)
#define idRaufTaste   (19+tastMin)
#define idRunterTaste (20+tastMin)
#define idEscapeTaste (27+tastMin)


extern void Event_Init        (void);
extern byte Event_avail       (void);
extern word Get_Event         (void);
extern void Add_Event         (word aEvent);
extern bool Add_Delayed_Event (dword millisec, word aEvent);

#endif
