/*
    sokoban.h - game
    Copyright (C) 2007  Colibri <colibri_dvb@lycos.com>

    Adapted as Lern-Betty-App from swausd 25.11.2012

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SOKOBAN_H
#define SOKOBAN_H

#define LERN_BETTY

#define BOOL				bool
#define BYTE				byte
#define WORD				word

#define LCD_SIZE_Y		160
#define LCD_SIZE_X		128

#define KEY_Up				(key0 == 32)
#define KEY_Down			(key0 == 14)
#define KEY_Left			(key0 == 26)
#define KEY_Right			(key0 == 27)
#define KEY_8				(key0 == 35)
#define KEY_0				(key0 == 29)
#define KEY_Pplus			(key0 == 15)
#define KEY_Pminus		(key0 ==  9)
#define KEY_Vplus			(key0 == 24)
#define KEY_Vminus		(key0 == 18)
#define KEY_Exit			(key0 == 21)

#define ARROW_UP			1
#define ARROW_DOWN		2
#define ARROW_LEFT		3
#define ARROW_RIGHT		4
#define ARROW_LEN			4






#define SOKOBAN_MAX_UNDOS	100
#define SOKOBAN_UNDO_DIR_LEFT	0
#define SOKOBAN_UNDO_DIR_RIGHT	1
#define SOKOBAN_UNDO_DIR_UP		2
#define SOKOBAN_UNDO_DIR_DOWN	3

#define SPACE	0
#define GOAL	1
#define PUSHER	2
#define PACKET	4
#define WALL	8
#define PUSHER_ON_GOAL	(PUSHER | GOAL)
#define PACKET_ON_GOAL	(PACKET | GOAL)

#define SOKOBAN_CELLS_X	21
#define SOKOBAN_CELLS_Y	19
//Size without grid
#define SOKOBAN_CELL_SIZE	5

struct _SokobanGameInfo
{
	BYTE G[SOKOBAN_CELLS_X][SOKOBAN_CELLS_Y];
	short Level;
	int PusherX;
	int PusherY;
	WORD Moves;
	WORD UndoCount;
	BYTE UndoBuffer[SOKOBAN_MAX_UNDOS][3];
};

void GameSokoban(void);
void GameSokoban_InitGameField(struct _SokobanGameInfo *pGI);
void GameSokoban_DrawCell(int x, int y, BYTE Object);
BOOL GameSokoban_IsSolved(BYTE G[SOKOBAN_CELLS_X][SOKOBAN_CELLS_Y]);
void GameSokoban_InitDisplayForNewGame(struct _SokobanGameInfo *pGI);
void GameSokoban_Move(struct _SokobanGameInfo *pGI);
void GameSokoban_SaveUndo(struct _SokobanGameInfo *pGI, BYTE Count, BYTE Dir);
void GameSokoban_UndoAMove(struct _SokobanGameInfo *pGI);


#endif
