/*
    sokoban.h - game
    Copyright (C) 2007  Colibri <colibri_dvb@lycos.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SOKOBAN_LEVELS_H
#define SOKOBAN_LEVELS_H

#ifndef DEBUGMODE
#define SOKOBAN_LEVELS	375
const unsigned char Sokoban_Levels[] = {
//Level: 1
0x13, 0x0B,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //    #####           
0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //    #   #           
0x00, 0x00, 0x84, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //    #$  #           
0x00, 0x88, 0x80, 0x04, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //  ###  $##          
0x00, 0x80, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, //  #  $ $ #          
0x88, 0x80, 0x80, 0x88, 0x08, 0x00, 0x08, 0x88, 0x88, 0x80, //### # ## #   ###### 
0x80, 0x00, 0x80, 0x88, 0x08, 0x88, 0x88, 0x00, 0x11, 0x80, //#   # ## #####  ..# 
0x80, 0x40, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x80, //# $  $          ..# 
0x88, 0x88, 0x80, 0x88, 0x80, 0x82, 0x88, 0x00, 0x11, 0x80, //##### ### #@##  ..# 
0x00, 0x00, 0x80, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //    #     ######### 
0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //    #######         
//Level: 2
0x0E, 0x0A,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //############  
0x81, 0x10, 0x08, 0x00, 0x00, 0x08, 0x88, //#..  #     ###
0x81, 0x10, 0x08, 0x04, 0x00, 0x40, 0x08, //#..  # $  $  #
0x81, 0x10, 0x08, 0x48, 0x88, 0x80, 0x08, //#..  #$####  #
0x81, 0x10, 0x00, 0x02, 0x08, 0x80, 0x08, //#..    @ ##  #
0x81, 0x10, 0x08, 0x08, 0x00, 0x40, 0x88, //#..  # #  $ ##
0x88, 0x88, 0x88, 0x08, 0x84, 0x04, 0x08, //###### ##$ $ #
0x00, 0x80, 0x40, 0x04, 0x04, 0x04, 0x08, //  # $  $ $ $ #
0x00, 0x80, 0x00, 0x08, 0x00, 0x00, 0x08, //  #    #     #
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //  ############
//Level: 3
0x11, 0x0A,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, //        ########  
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x28, 0x00, //        #     @#  
0x00, 0x00, 0x00, 0x00, 0x80, 0x48, 0x40, 0x88, 0x00, //        # $#$ ##  
0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x04, 0x80, 0x00, //        # $  $#   
0x00, 0x00, 0x00, 0x00, 0x88, 0x40, 0x40, 0x80, 0x00, //        ##$ $ #   
0x88, 0x88, 0x88, 0x88, 0x80, 0x40, 0x80, 0x88, 0x80, //######### $ # ### 
0x81, 0x11, 0x10, 0x08, 0x80, 0x40, 0x04, 0x00, 0x80, //#....  ## $  $  # 
0x88, 0x11, 0x10, 0x00, 0x04, 0x00, 0x40, 0x00, 0x80, //##...    $  $   # 
0x81, 0x11, 0x10, 0x08, 0x88, 0x88, 0x88, 0x88, 0x80, //#....  ########## 
0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //########          
//Level: 4
0x0B, 0x0A,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //########### 
0x80, 0x00, 0x08, 0x00, 0x00, 0x80, //#    #    # 
0x80, 0x42, 0x44, 0x44, 0x40, 0x80, //# $@$$$$$ # 
0x80, 0x00, 0x00, 0x00, 0x00, 0x80, //#         # 
0x88, 0x88, 0x80, 0x88, 0x88, 0x80, //##### ##### 
0x00, 0x08, 0x10, 0x08, 0x00, 0x00, //   #.  #    
0x00, 0x08, 0x10, 0x08, 0x00, 0x00, //   #.  #    
0x00, 0x08, 0x11, 0x18, 0x00, 0x00, //   #...#    
0x00, 0x08, 0x10, 0x08, 0x00, 0x00, //   #.  #    
0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //   #####    
//Level: 5
0x0E, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x00, 0x88, 0x88, 0x80, //######  ##### 
0x80, 0x00, 0x08, 0x00, 0x80, 0x00, 0x80, //#    #  #   # 
0x80, 0x40, 0x08, 0x88, 0x80, 0x40, 0x80, //# $  #### $ # 
0x80, 0x40, 0x00, 0x00, 0x04, 0x00, 0x80, //# $      $  # 
0x80, 0x08, 0x88, 0x28, 0x88, 0x40, 0x80, //#  ###@###$ # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x08, 0x88, //########## ###
0x81, 0x10, 0x00, 0x88, 0x00, 0x00, 0x08, //#..   ##     #
0x81, 0x10, 0x00, 0x88, 0x40, 0x00, 0x08, //#..   ##$    #
0x81, 0x10, 0x00, 0x88, 0x04, 0x00, 0x08, //#..   ## $   #
0x81, 0x10, 0x00, 0x88, 0x04, 0x00, 0x08, //#..   ## $   #
0x81, 0x10, 0x00, 0x00, 0x40, 0x40, 0x08, //#..     $ $  #
0x88, 0x80, 0x08, 0x88, 0x88, 0x88, 0x88, //###  #########
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //  ####        
//Level: 6
0x0B, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //########### 
0x80, 0x00, 0x00, 0x80, 0x00, 0x80, //#     #   # 
0x80, 0x00, 0x40, 0x04, 0x00, 0x80, //#   $  $  # 
0x88, 0x88, 0x80, 0x80, 0x00, 0x80, //##### #   # 
0x88, 0x88, 0x80, 0x88, 0x81, 0x80, //##### ###.# 
0x80, 0x08, 0x00, 0x00, 0x81, 0x80, //#  #    #.# 
0x80, 0x40, 0x00, 0x40, 0x81, 0x80, //# $   $ #.# 
0x80, 0x08, 0x88, 0x08, 0x81, 0x80, //#  ### ##.# 
0x88, 0x08, 0x88, 0x00, 0x81, 0x80, //## ###  #.# 
0x80, 0x40, 0x00, 0x40, 0x81, 0x80, //# $   $ #.# 
0x80, 0x00, 0x88, 0x00, 0x81, 0x80, //#   ##  #.# 
0x88, 0x80, 0x88, 0x88, 0x81, 0x80, //### #####.# 
0x88, 0x80, 0x80, 0x00, 0x20, 0x80, //### #   @ # 
0x80, 0x04, 0x00, 0x00, 0x40, 0x80, //#  $    $ # 
0x80, 0x00, 0x08, 0x80, 0x00, 0x80, //#    ##   # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //########### 
//Level: 7
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x02, 0x88, //#### @##
0x88, 0x88, 0x00, 0x08, //####   #
0x81, 0x08, 0x44, 0x08, //#. #$$ #
0x80, 0x00, 0x00, 0x88, //#     ##
0x81, 0x00, 0x48, 0x88, //#.  $###
0x88, 0x10, 0x08, 0x88, //##.  ###
0x88, 0x88, 0x88, 0x88, //########
//Level: 8
0x0C, 0x06,//Size x and y
0x08, 0x88, 0x80, 0x08, 0x88, 0x88, // ####  #####
0x88, 0x00, 0x80, 0x08, 0x00, 0x08, //##  #  #   #
0x80, 0x40, 0x88, 0x88, 0x40, 0x08, //# $ ####$  #
0x80, 0x04, 0x11, 0x11, 0x04, 0x08, //#  $.... $ #
0x88, 0x00, 0x00, 0x80, 0x20, 0x88, //##    # @ ##
0x08, 0x88, 0x88, 0x88, 0x88, 0x80, // ########## 
//Level: 9
0x07, 0x06,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x80, 0x04, 0x01, 0x80, //#  $ .# 
0x80, 0x02, 0x40, 0x80, //#  @$ # 
0x80, 0x08, 0x41, 0x80, //#  #$.# 
0x80, 0x01, 0x08, 0x80, //#  . ## 
0x88, 0x88, 0x88, 0x00, //######  
//Level: 10
0x07, 0x08,//Size x and y
0x00, 0x88, 0x88, 0x00, //  ####  
0x88, 0x80, 0x08, 0x80, //###  ## 
0x80, 0x00, 0x40, 0x80, //#   $ # 
0x80, 0x81, 0x82, 0x80, //# #.#@# 
0x80, 0x84, 0x01, 0x80, //# #$ .# 
0x80, 0x01, 0x40, 0x80, //#  .$ # 
0x88, 0x00, 0x08, 0x80, //##   ## 
0x08, 0x88, 0x88, 0x00, // #####  
//Level: 11
0x09, 0x09,//Size x and y
0x88, 0x88, 0x00, 0x00, 0x00, //####      
0x80, 0x08, 0x88, 0x80, 0x00, //#  ####   
0x80, 0x00, 0x00, 0x88, 0x80, //#     ### 
0x80, 0x08, 0x40, 0x10, 0x80, //#  #$ . # 
0x88, 0x08, 0x18, 0x40, 0x80, //## #.#$ # 
0x80, 0x08, 0x02, 0x50, 0x80, //#  # @* # 
0x80, 0x00, 0x50, 0x08, 0x80, //#   *  ## 
0x88, 0x88, 0x00, 0x88, 0x00, //####  ##  
0x00, 0x08, 0x88, 0x80, 0x00, //   ####   
//Level: 12
0x09, 0x08,//Size x and y
0x00, 0x88, 0x88, 0x00, 0x00, //  ####    
0x00, 0x82, 0x08, 0x00, 0x00, //  #@ #    
0x88, 0x80, 0x08, 0x88, 0x80, //###  #### 
0x80, 0x01, 0x50, 0x00, 0x80, //#  .*   # 
0x80, 0x41, 0x10, 0x40, 0x80, //# $.. $ # 
0x88, 0x80, 0x48, 0x88, 0x80, //### $#### 
0x00, 0x80, 0x08, 0x00, 0x00, //  #  #    
0x00, 0x88, 0x88, 0x00, 0x00, //  ####    
//Level: 13
0x0D, 0x11,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x00, 0x00, 0x00, //     ###      
0x00, 0x00, 0x88, 0x18, 0x80, 0x00, 0x00, //    ##.##     
0x00, 0x00, 0x81, 0x11, 0x80, 0x00, 0x00, //    #...#     
0x00, 0x88, 0x81, 0x12, 0x88, 0x80, 0x00, //  ###..@###   
0x00, 0x80, 0x01, 0x11, 0x00, 0x80, 0x00, //  #  ...  #   
0x88, 0x80, 0x88, 0x18, 0x80, 0x88, 0x80, //### ##.## ### 
0x80, 0x00, 0x00, 0x40, 0x00, 0x00, 0x80, //#     $     # 
0x80, 0x08, 0x00, 0x40, 0x08, 0x00, 0x80, //#  #  $  #  # 
0x88, 0x48, 0x48, 0x88, 0x48, 0x48, 0x80, //##$#$###$#$## 
0x80, 0x08, 0x00, 0x40, 0x08, 0x00, 0x80, //#  #  $  #  # 
0x80, 0x00, 0x00, 0x40, 0x00, 0x00, 0x80, //#     $     # 
0x88, 0x80, 0x08, 0x08, 0x00, 0x88, 0x80, //###  # #  ### 
0x00, 0x80, 0x88, 0x08, 0x80, 0x80, 0x00, //  # ## ## #   
0x00, 0x80, 0x04, 0x04, 0x00, 0x80, 0x00, //  #  $ $  #   
0x00, 0x80, 0x88, 0x08, 0x80, 0x80, 0x00, //  # ## ## #   
0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, //  #       #   
0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //  #########   
//Level: 14
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x21, 0x80, 0x08, //# @.#  #
0x80, 0x14, 0x01, 0x08, //# .$ . #
0x80, 0x08, 0x40, 0x08, //#  #$  #
0x80, 0x04, 0x00, 0x88, //#  $  ##
0x88, 0x80, 0x08, 0x80, //###  ## 
0x00, 0x80, 0x08, 0x00, //  #  #  
0x00, 0x88, 0x88, 0x00, //  ####  
//Level: 15
0x09, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x00, //########  
0x80, 0x00, 0x00, 0x08, 0x00, //#      #  
0x80, 0x84, 0x40, 0x08, 0x00, //# #$$  #  
0x80, 0x11, 0x18, 0x08, 0x00, //# ...# #  
0x88, 0x11, 0x14, 0x08, 0x80, //##...$ ## 
0x08, 0x08, 0x80, 0x40, 0x80, // # ## $ # 
0x08, 0x40, 0x04, 0x00, 0x80, // #$  $  # 
0x08, 0x00, 0x80, 0x02, 0x80, // #  #  @# 
0x08, 0x88, 0x88, 0x88, 0x80, // ######## 
//Level: 16
0x0B, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //  #####     
0x00, 0x80, 0x00, 0x80, 0x00, 0x00, //  #   #     
0x88, 0x84, 0x14, 0x88, 0x88, 0x80, //###$.$##### 
0x80, 0x00, 0x10, 0x40, 0x00, 0x80, //#   . $   # 
0x80, 0x88, 0x48, 0x80, 0x20, 0x80, //# ##$## @ # 
0x80, 0x00, 0x10, 0x88, 0x88, 0x80, //#   . ##### 
0x88, 0x80, 0x10, 0x80, 0x00, 0x00, //### . #     
0x00, 0x80, 0x00, 0x80, 0x00, 0x00, //  #   #     
0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //  #####     
//Level: 17
0x0C, 0x0B,//Size x and y
0x88, 0x88, 0x88, 0x00, 0x88, 0x80, //######  ### 
0x81, 0x10, 0x08, 0x08, 0x82, 0x88, //#..  # ##@##
0x81, 0x10, 0x08, 0x88, 0x00, 0x08, //#..  ###   #
0x81, 0x10, 0x00, 0x00, 0x44, 0x08, //#..     $$ #
0x81, 0x10, 0x08, 0x08, 0x04, 0x08, //#..  # # $ #
0x81, 0x18, 0x88, 0x08, 0x04, 0x08, //#..### # $ #
0x88, 0x88, 0x04, 0x08, 0x40, 0x08, //#### $ #$  #
0x00, 0x08, 0x00, 0x48, 0x04, 0x08, //   #  $# $ #
0x00, 0x08, 0x04, 0x00, 0x40, 0x08, //   # $  $  #
0x00, 0x08, 0x00, 0x88, 0x00, 0x08, //   #  ##   #
0x00, 0x08, 0x88, 0x88, 0x88, 0x88, //   #########
//Level: 18
0x10, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //#######         
0x80, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, //#     ##########
0x80, 0x00, 0x00, 0x80, 0x00, 0x08, 0x00, 0x88, //#     #    #  ##
0x80, 0x40, 0x00, 0x80, 0x00, 0x40, 0x40, 0x08, //# $   #   $ $  #
0x80, 0x04, 0x00, 0x80, 0x04, 0x08, 0x80, 0x08, //#  $  #  $ ##  #
0x80, 0x44, 0x00, 0x88, 0x40, 0x40, 0x00, 0x08, //# $$  ##$ $    #
0x88, 0x08, 0x00, 0x88, 0x08, 0x88, 0x88, 0x88, //## #  ## #######
0x88, 0x08, 0x00, 0x88, 0x00, 0x00, 0x11, 0x18, //## #  ##    ...#
0x80, 0x08, 0x40, 0x00, 0x00, 0x00, 0x11, 0x18, //#  #$       ...#
0x80, 0x00, 0x44, 0x00, 0x00, 0x00, 0x11, 0x18, //#   $$      ...#
0x80, 0x00, 0x00, 0x88, 0x28, 0x00, 0x11, 0x18, //#     ##@#  ...#
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //################
//Level: 19
0x0D, 0x0C,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, // ############ 
0x08, 0x00, 0x00, 0x10, 0x80, 0x00, 0x80, // #    . #   # 
0x08, 0x00, 0x04, 0x50, 0x80, 0x40, 0x80, // #   $* # $ # 
0x08, 0x00, 0x08, 0x10, 0x80, 0x88, 0x80, // #   #. # ### 
0x08, 0x00, 0x88, 0x18, 0x00, 0x08, 0x00, // #  ##.#   #  
0x88, 0x00, 0x88, 0x18, 0x04, 0x08, 0x80, //##  ##.# $ ## 
0x80, 0x00, 0x80, 0x18, 0x48, 0x00, 0x80, //#   # .#$#  # 
0x80, 0x20, 0x80, 0x10, 0x00, 0x40, 0x80, //# @ # .   $ # 
0x80, 0x08, 0x80, 0x54, 0x48, 0x00, 0x80, //#  ## *$$#  # 
0x80, 0x00, 0x80, 0x10, 0x00, 0x08, 0x80, //#   # .    ## 
0x80, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, //#   ########  
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //#####         
//Level: 20
0x0D, 0x0C,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x00, //     #######  
0x00, 0x00, 0x08, 0x00, 0x80, 0x08, 0x00, //     #  #  #  
0x00, 0x00, 0x08, 0x00, 0x44, 0x08, 0x00, //     #  $$ #  
0x88, 0x88, 0x88, 0x04, 0x80, 0x08, 0x00, //###### $#  #  
0x81, 0x11, 0x88, 0x80, 0x80, 0x08, 0x80, //#...### #  ## 
0x81, 0x00, 0x80, 0x04, 0x08, 0x00, 0x80, //#.  #  $ #  # 
0x81, 0x00, 0x00, 0x40, 0x40, 0x40, 0x80, //#.    $ $ $ # 
0x81, 0x00, 0x80, 0x04, 0x08, 0x00, 0x80, //#.  #  $ #  # 
0x81, 0x11, 0x88, 0x80, 0x80, 0x08, 0x80, //#...### #  ## 
0x88, 0x88, 0x88, 0x04, 0x00, 0x08, 0x00, //###### $   #  
0x00, 0x00, 0x08, 0x20, 0x80, 0x08, 0x00, //     #@ #  #  
0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x00, //     #######  
//Level: 21
0x08, 0x08,//Size x and y
0x00, 0x88, 0x88, 0x00, //  ####  
0x00, 0x81, 0x18, 0x00, //  #..#  
0x08, 0x80, 0x18, 0x80, // ## .## 
0x08, 0x00, 0x41, 0x80, // #  $.# 
0x88, 0x04, 0x00, 0x88, //## $  ##
0x80, 0x08, 0x44, 0x08, //#  #$$ #
0x80, 0x02, 0x00, 0x08, //#  @   #
0x88, 0x88, 0x88, 0x88, //########
//Level: 22
0x09, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x88, 0x00, 0x00, 0x08, 0x80, //##     ## 
0x80, 0x81, 0x40, 0x40, 0x80, //# #.$ $ # 
0x80, 0x15, 0x14, 0x00, 0x80, //# .*.$  # 
0x80, 0x41, 0x81, 0x40, 0x80, //# $.#.$ # 
0x80, 0x04, 0x18, 0x10, 0x80, //#  $.#. # 
0x80, 0x40, 0x41, 0x80, 0x80, //# $ $.# # 
0x88, 0x00, 0x20, 0x08, 0x80, //##  @  ## 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 23
0x10, 0x0C,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, //       #########
0x88, 0x88, 0x88, 0x88, 0x28, 0x80, 0x01, 0x18, //########@##  ..#
0x80, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x18, //#      $     ..#
0x80, 0x40, 0x84, 0x08, 0x48, 0x80, 0x01, 0x18, //# $ #$ #$##  ..#
0x88, 0x08, 0x80, 0x00, 0x08, 0x88, 0x81, 0x18, //## ##    ####..#
0x08, 0x04, 0x04, 0x88, 0x08, 0x00, 0x88, 0x88, // # $ $## #  ####
0x08, 0x08, 0x80, 0x80, 0x08, 0x00, 0x00, 0x00, // # ## #  #      
0x88, 0x08, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, //## #    ##      
0x80, 0x04, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, //#  $   ##       
0x80, 0x08, 0x84, 0x08, 0x00, 0x00, 0x00, 0x00, //#  ##$ #        
0x80, 0x08, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, //#  ##  #        
0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //########        
//Level: 24
0x0F, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //  #####         
0x00, 0x80, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //  #   ######### 
0x00, 0x80, 0x40, 0x40, 0x00, 0x00, 0x00, 0x80, //  # $ $       # 
0x88, 0x88, 0x80, 0x04, 0x08, 0x44, 0x00, 0x80, //#####  $ #$$  # 
0x80, 0x00, 0x80, 0x88, 0x00, 0x00, 0x88, 0x80, //#   # ##    ### 
0x81, 0x11, 0x00, 0x08, 0x80, 0x04, 0x80, 0x00, //#...   ##  $#   
0x81, 0x11, 0x84, 0x40, 0x04, 0x00, 0x80, 0x00, //#...#$$  $  #   
0x81, 0x11, 0x80, 0x02, 0x80, 0x08, 0x80, 0x00, //#...#  @#  ##   
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, //############    
//Level: 25
0x09, 0x08,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x00, // #######  
0x08, 0x02, 0x11, 0x18, 0x00, // # @...#  
0x08, 0x00, 0x08, 0x88, 0x80, // #   #### 
0x88, 0x84, 0x00, 0x00, 0x80, //###$    # 
0x80, 0x00, 0x84, 0x80, 0x80, //#   #$# # 
0x80, 0x40, 0x80, 0x00, 0x80, //# $ #   # 
0x80, 0x00, 0x88, 0x88, 0x80, //#   ##### 
0x88, 0x88, 0x80, 0x00, 0x00, //#####     
//Level: 26
0x0F, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
0x80, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, //#     #   #   # 
0x80, 0x44, 0x00, 0x40, 0x00, 0x40, 0x40, 0x80, //# $$  $   $ $ # 
0x80, 0x04, 0x08, 0x88, 0x88, 0x80, 0x80, 0x80, //#  $ ###### # # 
0x80, 0x44, 0x08, 0x20, 0x08, 0x00, 0x40, 0x80, //# $$ #@  #  $ # 
0x80, 0x00, 0x08, 0x00, 0x40, 0x00, 0x08, 0x80, //#    #  $    ## 
0x88, 0x88, 0x88, 0x48, 0x80, 0x08, 0x81, 0x80, //######$##  ##.# 
0x08, 0x00, 0x08, 0x04, 0x00, 0x08, 0x11, 0x80, // #   # $   #..# 
0x08, 0x00, 0x00, 0x40, 0x00, 0x81, 0x11, 0x80, // #    $   #...# 
0x08, 0x80, 0x88, 0x88, 0x08, 0x01, 0x11, 0x80, // ## #### # ...# 
0x08, 0x00, 0x40, 0x00, 0x45, 0x11, 0x11, 0x80, // #  $   $*....# 
0x08, 0x00, 0x08, 0x00, 0x08, 0x10, 0x01, 0x80, // #   #   #.  .# 
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, // ############## 
//Level: 27
0x09, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x00, 0x00, //######    
0x80, 0x00, 0x08, 0x00, 0x00, //#    #    
0x80, 0x44, 0x48, 0x80, 0x00, //# $$$##   
0x80, 0x08, 0x11, 0x88, 0x80, //#  #..### 
0x88, 0x00, 0x11, 0x40, 0x80, //##  ..$ # 
0x08, 0x02, 0x00, 0x00, 0x80, // # @    # 
0x08, 0x88, 0x88, 0x88, 0x80, // ######## 
//Level: 28
0x0E, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x00, 0x08, 0x88, 0x88, //######   #####
0x80, 0x00, 0x08, 0x88, 0x08, 0x00, 0x18, //#    ### #  .#
0x80, 0x04, 0x04, 0x08, 0x08, 0x11, 0x18, //#  $ $ # #...#
0x80, 0x80, 0x04, 0x08, 0x88, 0x00, 0x18, //# #  $ ###  .#
0x80, 0x04, 0x44, 0x00, 0x04, 0x02, 0x18, //#  $$$   $ @.#
0x88, 0x80, 0x04, 0x00, 0x48, 0x00, 0x18, //###  $  $#  .#
0x00, 0x80, 0x04, 0x84, 0x08, 0x11, 0x18, //  #  $#$ #...#
0x00, 0x88, 0x00, 0x00, 0x08, 0x00, 0x18, //  ##     #  .#
0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, //   ###########
//Level: 29
0x09, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x80, 0x00, //#######   
0x80, 0x01, 0x40, 0x88, 0x80, //#  .$ ### 
0x80, 0x14, 0x14, 0x00, 0x80, //# .$.$  # 
0x85, 0x41, 0x41, 0x20, 0x80, //#*$.$.@ # 
0x80, 0x14, 0x14, 0x08, 0x80, //# .$.$ ## 
0x80, 0x01, 0x40, 0x08, 0x00, //#  .$  #  
0x88, 0x88, 0x88, 0x88, 0x00, //########  
//Level: 30
0x0A, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x81, 0x11, 0x88, 0x00, 0x80, //#...##  # 
0x81, 0x51, 0x00, 0x42, 0x80, //#.*.  $@# 
0x80, 0x04, 0x80, 0x08, 0x80, //#  $#  ## 
0x88, 0x80, 0x88, 0x08, 0x88, //### ## ###
0x80, 0x00, 0x40, 0x00, 0x08, //#   $    #
0x80, 0x04, 0x88, 0x48, 0x08, //#  $##$# #
0x80, 0x00, 0x04, 0x00, 0x18, //#    $  .#
0x88, 0x88, 0x88, 0x88, 0x88, //##########
//Level: 31
0x08, 0x07,//Size x and y
0x00, 0x88, 0x88, 0x80, //  ##### 
0x88, 0x80, 0x02, 0x80, //###  @# 
0x80, 0x04, 0x10, 0x88, //#  $. ##
0x80, 0x01, 0x41, 0x08, //#  .$. #
0x88, 0x80, 0x54, 0x08, //### *$ #
0x00, 0x80, 0x00, 0x88, //  #   ##
0x00, 0x88, 0x88, 0x80, //  ##### 
//Level: 32
0x0E, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, //       ####   
0x88, 0x88, 0x88, 0x88, 0x00, 0x88, 0x88, //########  ####
0x80, 0x00, 0x88, 0x11, 0x11, 0x10, 0x08, //#   ##.....  #
0x80, 0x04, 0x00, 0x88, 0x11, 0x18, 0x08, //#  $  ##...# #
0x88, 0x00, 0x40, 0x08, 0x88, 0x08, 0x08, //##  $  ### # #
0x08, 0x08, 0x04, 0x00, 0x80, 0x00, 0x08, // # # $  #    #
0x08, 0x00, 0x80, 0x40, 0x08, 0x00, 0x08, // #  # $  #   #
0x08, 0x00, 0x08, 0x04, 0x00, 0x80, 0x08, // #   # $  #  #
0x08, 0x00, 0x00, 0x80, 0x40, 0x80, 0x88, // #    # $ # ##
0x08, 0x88, 0x80, 0x08, 0x04, 0x00, 0x80, // ####  # $  # 
0x00, 0x00, 0x88, 0x00, 0x80, 0x40, 0x80, //    ##  # $ # 
0x00, 0x00, 0x08, 0x82, 0x80, 0x00, 0x80, //     ##@#   # 
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //      ####### 
//Level: 33
0x0A, 0x08,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
0x88, 0x80, 0x00, 0x88, 0x88, //###   ####
0x80, 0x00, 0x40, 0x40, 0x08, //#   $ $  #
0x80, 0x40, 0x00, 0x40, 0x28, //# $   $ @#
0x88, 0x84, 0x48, 0x88, 0x88, //###$$#####
0x00, 0x80, 0x01, 0x18, 0x00, //  #  ..#  
0x00, 0x81, 0x11, 0x18, 0x00, //  #....#  
0x00, 0x88, 0x88, 0x88, 0x00, //  ######  
//Level: 34
0x09, 0x0C,//Size x and y
0x88, 0x88, 0x08, 0x88, 0x80, //#### #### 
0x80, 0x08, 0x88, 0x00, 0x80, //#  ###  # 
0x80, 0x00, 0x04, 0x00, 0x80, //#    $  # 
0x80, 0x08, 0x08, 0x00, 0x80, //#  # #  # 
0x88, 0x08, 0x08, 0x48, 0x80, //## # #$## 
0x80, 0x08, 0x18, 0x00, 0x80, //#  #.#  # 
0x80, 0x05, 0x15, 0x02, 0x80, //#  *.* @# 
0x80, 0x08, 0x18, 0x08, 0x80, //#  #.# ## 
0x88, 0x88, 0x00, 0x08, 0x00, //####   #  
0x00, 0x08, 0x08, 0x48, 0x00, //   # #$#  
0x00, 0x08, 0x00, 0x08, 0x00, //   #   #  
0x00, 0x08, 0x88, 0x88, 0x00, //   #####  
//Level: 35
0x0A, 0x06,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x80, 0x40, 0x11, 0x00, 0x80, //# $ ..  # 
0x82, 0x44, 0x11, 0x04, 0x88, //#@$$.. $##
0x80, 0x40, 0x11, 0x04, 0x08, //# $ .. $ #
0x88, 0x88, 0x88, 0x00, 0x08, //######   #
0x00, 0x00, 0x08, 0x88, 0x88, //     #####
//Level: 36
0x0F, 0x07,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //    ######      
0x88, 0x88, 0x80, 0x00, 0x08, 0x88, 0x88, 0x80, //#####    ###### 
0x80, 0x00, 0x80, 0x00, 0x20, 0x08, 0x00, 0x80, //#   #   @  #  # 
0x80, 0x04, 0x15, 0x55, 0x55, 0x51, 0x40, 0x80, //#  $.******.$ # 
0x88, 0x88, 0x00, 0x00, 0x80, 0x08, 0x00, 0x80, //####    #  #  # 
0x00, 0x08, 0x80, 0x00, 0x80, 0x00, 0x08, 0x80, //   ##   #    ## 
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //    ##########  
//Level: 37
0x09, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
0x88, 0x80, 0x20, 0x88, 0x80, //### @ ### 
0x80, 0x04, 0x04, 0x00, 0x80, //#  $ $  # 
0x80, 0x51, 0x51, 0x50, 0x80, //# *.*.* # 
0x80, 0x14, 0x04, 0x10, 0x80, //# .$ $. # 
0x80, 0x51, 0x51, 0x50, 0x80, //# *.*.* # 
0x80, 0x04, 0x04, 0x00, 0x80, //#  $ $  # 
0x88, 0x88, 0x88, 0x00, 0x80, //######  # 
0x00, 0x00, 0x08, 0x88, 0x80, //     #### 
//Level: 38
0x11, 0x0E,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //          ####### 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x11, 0x80, //          #  ...# 
0x00, 0x00, 0x00, 0x88, 0x88, 0x80, 0x01, 0x11, 0x80, //      #####  ...# 
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x01, 0x80, //      #      . .# 
0x00, 0x00, 0x00, 0x80, 0x08, 0x80, 0x01, 0x11, 0x80, //      #  ##  ...# 
0x00, 0x00, 0x00, 0x88, 0x08, 0x80, 0x01, 0x11, 0x80, //      ## ##  ...# 
0x00, 0x00, 0x08, 0x88, 0x08, 0x88, 0x88, 0x88, 0x80, //     ### ######## 
0x00, 0x00, 0x08, 0x04, 0x44, 0x08, 0x80, 0x00, 0x00, //     # $$$ ##     
0x08, 0x88, 0x88, 0x00, 0x40, 0x40, 0x88, 0x88, 0x80, // #####  $ $ ##### 
0x88, 0x00, 0x08, 0x40, 0x40, 0x00, 0x80, 0x00, 0x80, //##   #$ $   #   # 
0x82, 0x04, 0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x80, //#@ $  $    $  $ # 
0x88, 0x88, 0x88, 0x04, 0x40, 0x40, 0x88, 0x88, 0x80, //###### $$ $ ##### 
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, //     #      #     
0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //     ########     
//Level: 39
0x0A, 0x07,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x80, //   ###### 
0x08, 0x88, 0x00, 0x00, 0x80, // ###    # 
0x88, 0x10, 0x48, 0x80, 0x88, //##. $## ##
0x81, 0x14, 0x04, 0x00, 0x28, //#..$ $  @#
0x81, 0x10, 0x40, 0x40, 0x88, //#.. $ $ ##
0x88, 0x88, 0x80, 0x00, 0x80, //#####   # 
0x00, 0x00, 0x88, 0x88, 0x80, //    ##### 
//Level: 40
0x11, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, //        ########  
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x08, 0x00, //        #      #  
0x00, 0x00, 0x00, 0x00, 0x80, 0x04, 0x04, 0x08, 0x00, //        #  $ $ #  
0x08, 0x88, 0x88, 0x88, 0x80, 0x40, 0x40, 0x08, 0x00, // ######## $ $  #  
0x88, 0x11, 0x10, 0x08, 0x88, 0x80, 0x88, 0x08, 0x00, //##...  #### ## #  
0x81, 0x11, 0x10, 0x00, 0x00, 0x00, 0x88, 0x08, 0x00, //#....       ## #  
0x88, 0x11, 0x10, 0x08, 0x80, 0x44, 0x88, 0x08, 0x80, //##...  ## $$## ## 
0x08, 0x88, 0x88, 0x88, 0x80, 0x40, 0x00, 0x02, 0x80, // ######## $    @# 
0x00, 0x00, 0x00, 0x88, 0x80, 0x88, 0x88, 0x08, 0x80, //      ### #### ## 
0x00, 0x00, 0x00, 0x80, 0x40, 0x40, 0x00, 0x08, 0x00, //      # $ $    #  
0x00, 0x00, 0x00, 0x80, 0x04, 0x08, 0x88, 0x88, 0x00, //      #  $ #####  
0x00, 0x00, 0x00, 0x88, 0x00, 0x08, 0x00, 0x00, 0x00, //      ##   #      
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, //       #####      
//Level: 41
0x07, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x80, 0x00, 0x00, 0x80, //#     # 
0x80, 0x00, 0x00, 0x80, //#     # 
0x80, 0x08, 0x00, 0x80, //#  #  # 
0x84, 0x44, 0x44, 0x80, //#$$$$$# 
0x81, 0x13, 0x11, 0x80, //#..+..# 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 42
0x0E, 0x0C,//Size x and y
0x08, 0x88, 0x88, 0x80, 0x88, 0x88, 0x80, // ###### ##### 
0x88, 0x28, 0x00, 0x88, 0x80, 0x00, 0x88, //##@#  ###   ##
0x80, 0x00, 0x04, 0x00, 0x80, 0x40, 0x08, //#    $  # $  #
0x80, 0x04, 0x00, 0x80, 0x00, 0x04, 0x08, //#  $  #    $ #
0x88, 0x80, 0x88, 0x88, 0x88, 0x00, 0x08, //### ######   #
0x88, 0x80, 0x88, 0x00, 0x88, 0x48, 0x88, //### ##  ##$###
0x80, 0x40, 0x08, 0x88, 0x80, 0x11, 0x80, //# $  #### ..# 
0x80, 0x40, 0x40, 0x40, 0x01, 0x11, 0x80, //# $ $ $  ...# 
0x80, 0x00, 0x08, 0x88, 0x81, 0x11, 0x80, //#    ####...# 
0x80, 0x44, 0x08, 0x00, 0x81, 0x11, 0x80, //# $$ #  #...# 
0x80, 0x08, 0x88, 0x00, 0x88, 0x88, 0x80, //#  ###  ##### 
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //####          
//Level: 43
0x07, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x80, 0x05, 0x02, 0x80, //#  * @# 
0x80, 0x45, 0x40, 0x80, //# $*$ # 
0x80, 0x01, 0x00, 0x80, //#  .  # 
0x80, 0x45, 0x40, 0x80, //# $*$ # 
0x84, 0x15, 0x10, 0x80, //#$.*. # 
0x81, 0x01, 0x41, 0x80, //#. .$.# 
0x80, 0x41, 0x00, 0x80, //# $.  # 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 44
0x13, 0x0C,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //       ###########  
0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, //       #         #  
0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x40, 0x40, 0x08, 0x00, //       #    $ $  #  
0x88, 0x88, 0x88, 0x08, 0x04, 0x08, 0x88, 0x88, 0x08, 0x00, //###### # $ ##### #  
0x80, 0x00, 0x08, 0x88, 0x88, 0x04, 0x00, 0x88, 0x48, 0x00, //#    ##### $  ##$#  
0x80, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x08, 0x00, //#       $ $      #  
0x80, 0x00, 0x00, 0x00, 0x00, 0x08, 0x80, 0x88, 0x08, 0x00, //#          ## ## #  
0x80, 0x00, 0x08, 0x82, 0x88, 0x88, 0x80, 0x88, 0x08, 0x00, //#    ##@##### ## #  
0x80, 0x00, 0x08, 0x88, 0x80, 0x00, 0x80, 0x88, 0x08, 0x80, //#    ####   # ## ## 
0x81, 0x11, 0x18, 0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x80, //#....#      # $   # 
0x81, 0x11, 0x18, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80, //#....#      #     # 
0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //######      ####### 
//Level: 45
0x12, 0x0C,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x88, 0x88, //       #####  ####
0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x88, 0x80, 0x08, //       #   ####  #
0x08, 0x88, 0x88, 0x88, 0x08, 0x00, 0x04, 0x04, 0x08, // ####### #   $ $ #
0x08, 0x00, 0x08, 0x80, 0x04, 0x08, 0x80, 0x80, 0x08, // #   ##  $ ## #  #
0x08, 0x04, 0x00, 0x01, 0x18, 0x18, 0x80, 0x40, 0x88, // # $   ..#.## $ ##
0x08, 0x04, 0x08, 0x81, 0x11, 0x10, 0x40, 0x80, 0x80, // # $ ##.... $ # # 
0x08, 0x08, 0x00, 0x41, 0x11, 0x18, 0x80, 0x40, 0x80, // # #  $....## $ # 
0x88, 0x44, 0x08, 0x81, 0x81, 0x10, 0x00, 0x40, 0x80, //##$$ ##.#..   $ # 
0x80, 0x08, 0x08, 0x80, 0x40, 0x08, 0x80, 0x20, 0x80, //#  # ## $  ## @ # 
0x80, 0x00, 0x00, 0x40, 0x80, 0x88, 0x88, 0x88, 0x80, //#     $ # ####### 
0x80, 0x08, 0x88, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, //#  ####   #       
0x88, 0x88, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //####  #####       
//Level: 46
0x0A, 0x07,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x00, // #######  
0x08, 0x00, 0x00, 0x08, 0x88, // #     ###
0x88, 0x48, 0x88, 0x00, 0x08, //##$###   #
0x80, 0x20, 0x40, 0x04, 0x08, //# @ $  $ #
0x80, 0x11, 0x80, 0x40, 0x88, //# ..# $ ##
0x88, 0x11, 0x80, 0x00, 0x80, //##..#   # 
0x08, 0x88, 0x88, 0x88, 0x80, // ######## 
//Level: 47
0x11, 0x0C,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //  ########        
0x00, 0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, //  #      #        
0x00, 0x80, 0x04, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //  #  $   #####    
0x00, 0x88, 0x88, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, //  ####   $   #    
0x00, 0x80, 0x08, 0x84, 0x80, 0x40, 0x08, 0x00, 0x00, //  #  ##$# $  #    
0x00, 0x80, 0x00, 0x02, 0x80, 0x80, 0x88, 0x88, 0x80, //  #    @# # ##### 
0x08, 0x80, 0x88, 0x04, 0x04, 0x04, 0x40, 0x00, 0x80, // ## ## $ $ $$   # 
0x08, 0x00, 0x08, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, // #   #  #   #   # 
0x88, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //##   ############ 
0x81, 0x11, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //#....#            
0x81, 0x11, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //#....#            
0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //######            
//Level: 48
0x0F, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //      ######### 
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, //      #       # 
0x00, 0x00, 0x00, 0x84, 0x04, 0x44, 0x00, 0x80, //      #$ $$$  # 
0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x40, 0x80, //      #   # $ # 
0x00, 0x00, 0x00, 0x80, 0x00, 0x42, 0x40, 0x80, //      #   $@$ # 
0x00, 0x00, 0x88, 0x84, 0x04, 0x08, 0x08, 0x80, //    ###$ $ # ## 
0x00, 0x00, 0x80, 0x00, 0x48, 0x48, 0x08, 0x00, //    #   $#$# #  
0x88, 0x88, 0x80, 0x80, 0x08, 0x00, 0x08, 0x00, //##### #  #   #  
0x81, 0x11, 0x00, 0x80, 0x48, 0x08, 0x88, 0x00, //#...  # $# ###  
0x81, 0x11, 0x11, 0x00, 0x08, 0x08, 0x00, 0x00, //#.....   # #    
0x81, 0x11, 0x11, 0x80, 0x48, 0x08, 0x00, 0x00, //#.....# $# #    
0x88, 0x88, 0x88, 0x88, 0x00, 0x08, 0x00, 0x00, //########   #    
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //       #####    
//Level: 49
0x0C, 0x07,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //  #####     
0x00, 0x80, 0x00, 0x88, 0x88, 0x88, //  #   ######
0x88, 0x84, 0x81, 0x00, 0x00, 0x08, //###$#.     #
0x80, 0x40, 0x11, 0x18, 0x04, 0x08, //# $ ...# $ #
0x82, 0x04, 0x18, 0x54, 0x00, 0x08, //#@ $.#*$   #
0x88, 0x88, 0x00, 0x00, 0x88, 0x88, //####    ####
0x00, 0x08, 0x88, 0x88, 0x80, 0x00, //   ######   
//Level: 50
0x07, 0x07,//Size x and y
0x08, 0x88, 0x88, 0x80, // ###### 
0x88, 0x01, 0x02, 0x80, //## . @# 
0x80, 0x40, 0x40, 0x80, //# $ $ # 
0x81, 0x05, 0x01, 0x80, //#. * .# 
0x80, 0x40, 0x40, 0x80, //# $ $ # 
0x80, 0x01, 0x08, 0x80, //#  . ## 
0x88, 0x88, 0x88, 0x00, //######  
//Level: 51
0x08, 0x07,//Size x and y
0x00, 0x00, 0x88, 0x88, //    ####
0x00, 0x00, 0x82, 0x08, //    #@ #
0x88, 0x88, 0x80, 0x18, //##### .#
0x80, 0x40, 0x40, 0x48, //# $ $ $#
0x80, 0x00, 0x10, 0x08, //#   .  #
0x88, 0x80, 0x10, 0x08, //### .  #
0x00, 0x88, 0x88, 0x88, //  ######
//Level: 52
0x13, 0x0D,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //  ################# 
0x88, 0x82, 0x88, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x80, //###@##         ...# 
0x80, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x80, //#    #         ...# 
0x80, 0x40, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x80, //# $  #         ...# 
0x80, 0x44, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x80, //# $$ #         ...# 
0x88, 0x04, 0x08, 0x88, 0x48, 0x88, 0x88, 0x88, 0x88, 0x80, //## $ ###$########## 
0x08, 0x08, 0x88, 0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, // # ###  $ #         
0x88, 0x00, 0x04, 0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, //##   $  $ #         
0x80, 0x04, 0x08, 0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, //#  $ #  $ #         
0x80, 0x40, 0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //# $  #    #         
0x80, 0x04, 0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //#  $ #    #         
0x80, 0x00, 0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //#    #    #         
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //###########         
//Level: 53
0x10, 0x0C,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //   ######       
0x00, 0x08, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, //   #    ##      
0x00, 0x08, 0x04, 0x04, 0x08, 0x80, 0x00, 0x00, //   # $ $ ##     
0x88, 0x88, 0x08, 0x48, 0x00, 0x88, 0x88, 0x00, //#### #$#  ####  
0x80, 0x40, 0x00, 0x04, 0x00, 0x80, 0x08, 0x88, //# $    $  #  ###
0x80, 0x00, 0x04, 0x08, 0x04, 0x11, 0x11, 0x18, //#    $ # $.....#
0x88, 0x80, 0x80, 0x88, 0x88, 0x11, 0x11, 0x18, //### # ####.....#
0x08, 0x80, 0x84, 0x04, 0x00, 0x11, 0x88, 0x88, // ## #$ $  ..####
0x08, 0x00, 0x80, 0x00, 0x48, 0x00, 0x80, 0x00, // #  #   $#  #   
0x08, 0x24, 0x00, 0x40, 0x08, 0x88, 0x80, 0x00, // #@$  $  ####   
0x08, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, // #  ######      
0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, // ####           
//Level: 54
0x0C, 0x06,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x00, //      ####  
0x00, 0x00, 0x00, 0x80, 0x08, 0x88, //      #  ###
0x88, 0x88, 0x88, 0x80, 0x00, 0x08, //#######    #
0x80, 0x40, 0x51, 0x05, 0x14, 0x28, //# $ *. *.$@#
0x80, 0x00, 0x00, 0x80, 0x00, 0x08, //#     #    #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //############
//Level: 55
0x0D, 0x0C,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, //       #####  
0x08, 0x88, 0x88, 0x88, 0x00, 0x08, 0x80, // #######   ## 
0x88, 0x08, 0x02, 0x88, 0x04, 0x40, 0x80, //## # @## $$ # 
0x80, 0x00, 0x04, 0x00, 0x00, 0x00, 0x80, //#    $      # 
0x80, 0x04, 0x00, 0x88, 0x80, 0x00, 0x80, //#  $  ###   # 
0x88, 0x80, 0x88, 0x88, 0x84, 0x88, 0x80, //### #####$### 
0x80, 0x40, 0x08, 0x88, 0x01, 0x18, 0x00, //# $  ### ..#  
0x80, 0x40, 0x40, 0x40, 0x11, 0x18, 0x00, //# $ $ $ ...#  
0x80, 0x00, 0x08, 0x88, 0x11, 0x18, 0x00, //#    ###...#  
0x80, 0x44, 0x08, 0x08, 0x11, 0x18, 0x00, //# $$ # #...#  
0x80, 0x08, 0x88, 0x08, 0x88, 0x88, 0x00, //#  ### #####  
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //####          
//Level: 56
0x0D, 0x0F,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, //      ####    
0x00, 0x88, 0x88, 0x80, 0x08, 0x00, 0x00, //  #####  #    
0x08, 0x80, 0x00, 0x00, 0x48, 0x00, 0x00, // ##     $#    
0x88, 0x04, 0x00, 0x88, 0x08, 0x88, 0x00, //## $  ## ###  
0x82, 0x40, 0x40, 0x80, 0x40, 0x08, 0x00, //#@$ $ # $  #  
0x88, 0x88, 0x08, 0x80, 0x00, 0x48, 0x00, //#### ##   $#  
0x08, 0x11, 0x11, 0x84, 0x04, 0x08, 0x00, // #....#$ $ #  
0x08, 0x11, 0x11, 0x80, 0x00, 0x48, 0x00, // #....#   $#  
0x08, 0x11, 0x11, 0x00, 0x44, 0x08, 0x80, // #....  $$ ## 
0x08, 0x11, 0x10, 0x80, 0x40, 0x00, 0x80, // #... # $   # 
0x08, 0x88, 0x88, 0x84, 0x04, 0x00, 0x80, // ######$ $  # 
0x00, 0x00, 0x00, 0x80, 0x00, 0x88, 0x80, //      #   ### 
0x00, 0x00, 0x00, 0x84, 0x08, 0x88, 0x00, //      #$ ###  
0x00, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, //      #  #    
0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, //      ####    
//Level: 57
0x0A, 0x08,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x00, // #######  
0x08, 0x11, 0x11, 0x08, 0x00, // #.... #  
0x88, 0x81, 0x11, 0x48, 0x88, //###...$###
0x80, 0x04, 0x84, 0x04, 0x08, //#  $#$ $ #
0x80, 0x44, 0x00, 0x84, 0x08, //# $$  #$ #
0x80, 0x00, 0x08, 0x00, 0x08, //#    #   #
0x88, 0x88, 0x02, 0x08, 0x88, //#### @ ###
0x00, 0x08, 0x88, 0x88, 0x00, //   #####  
//Level: 58
0x0D, 0x0A,//Size x and y
0x88, 0x88, 0x88, 0x00, 0x88, 0x88, 0x80, //######  ##### 
0x80, 0x00, 0x08, 0x88, 0x80, 0x00, 0x80, //#    ####   # 
0x80, 0x40, 0x00, 0x40, 0x00, 0x80, 0x80, //# $   $   # # 
0x88, 0x00, 0x80, 0x88, 0x80, 0x40, 0x80, //##  # ### $ # 
0x08, 0x44, 0x00, 0x88, 0x84, 0x80, 0x80, // #$$  ###$# # 
0x88, 0x00, 0x08, 0x00, 0x11, 0x10, 0x80, //##   #  ... # 
0x80, 0x08, 0x04, 0x00, 0x41, 0x11, 0x80, //#  # $  $...# 
0x80, 0x08, 0x88, 0x88, 0x11, 0x88, 0x80, //#  #####..### 
0x80, 0x28, 0x00, 0x08, 0x88, 0x80, 0x00, //# @#   ####   
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //####          
//Level: 59
0x0E, 0x0C,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, //       #######
0x00, 0x00, 0x88, 0x88, 0x11, 0x11, 0x18, //    ####.....#
0x88, 0x88, 0x80, 0x00, 0x11, 0x11, 0x18, //#####   .....#
0x80, 0x00, 0x80, 0x08, 0x10, 0x11, 0x18, //#   #  #. ...#
0x80, 0x42, 0x88, 0x08, 0x88, 0x08, 0x88, //# $@## ### ###
0x80, 0x04, 0x00, 0x04, 0x00, 0x44, 0x08, //#  $   $  $$ #
0x80, 0x00, 0x84, 0x00, 0x04, 0x00, 0x08, //#   #$   $   #
0x80, 0x40, 0x80, 0x88, 0x40, 0x04, 0x08, //# $ # ##$  $ #
0x88, 0x80, 0x00, 0x04, 0x08, 0x80, 0x08, //###    $ ##  #
0x00, 0x80, 0x40, 0x40, 0x40, 0x00, 0x88, //  # $ $ $   ##
0x00, 0x88, 0x80, 0x00, 0x08, 0x88, 0x80, //  ###    #### 
0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, //    ######    
//Level: 60
0x0B, 0x0A,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x80, 0x00, //   ######   
0x88, 0x88, 0x80, 0x00, 0x80, 0x00, //#####   #   
0x80, 0x40, 0x01, 0x00, 0x80, 0x00, //# $  .  #   
0x80, 0x40, 0x11, 0x88, 0x80, 0x00, //# $ ..###   
0x82, 0x40, 0x44, 0x88, 0x80, 0x00, //#@$ $$###   
0x88, 0x80, 0x14, 0x10, 0x88, 0x80, //### .$. ### 
0x08, 0x84, 0x11, 0x14, 0x00, 0x80, // ##$...$  # 
0x08, 0x04, 0x18, 0x80, 0x00, 0x80, // # $.##   # 
0x08, 0x00, 0x08, 0x88, 0x88, 0x80, // #   ###### 
0x08, 0x88, 0x88, 0x00, 0x00, 0x00, // #####      
//Level: 61
0x07, 0x08,//Size x and y
0x88, 0x88, 0x80, 0x00, //#####   
0x80, 0x00, 0x88, 0x80, //#   ### 
0x80, 0x04, 0x00, 0x80, //#  $  # 
0x88, 0x44, 0x01, 0x80, //##$$ .# 
0x08, 0x20, 0x10, 0x80, // #@ . # 
0x08, 0x80, 0x80, 0x80, // ## # # 
0x00, 0x80, 0x01, 0x80, //  #  .# 
0x00, 0x88, 0x88, 0x80, //  ##### 
//Level: 62
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x00, 0x80, 0x08, //#   #  #
0x80, 0x81, 0x40, 0x48, //# #.$ $#
0x80, 0x00, 0x40, 0x08, //#   $  #
0x88, 0x88, 0x81, 0x08, //#####. #
0x00, 0x80, 0x00, 0x28, //  #   @#
0x00, 0x80, 0x00, 0x18, //  #   .#
0x00, 0x88, 0x88, 0x88, //  ######
//Level: 63
0x08, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x08, 0x00, 0x08, //#  #   #
0x80, 0x41, 0x14, 0x08, //# $..$ #
0x82, 0x41, 0x50, 0x88, //#@$.* ##
0x80, 0x41, 0x14, 0x08, //# $..$ #
0x80, 0x08, 0x00, 0x08, //#  #   #
0x88, 0x88, 0x88, 0x88, //########
//Level: 64
0x0F, 0x0E,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, //     #####      
0x00, 0x08, 0x88, 0x00, 0x08, 0x00, 0x00, 0x00, //   ###   #      
0x00, 0x08, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, //   #   # #      
0x08, 0x88, 0x00, 0x40, 0x08, 0x88, 0x88, 0x80, // ###  $  ###### 
0x08, 0x00, 0x84, 0x80, 0x08, 0x00, 0x00, 0x80, // #  #$#  #    # 
0x08, 0x40, 0x40, 0x88, 0x00, 0x04, 0x00, 0x80, // #$ $ ##   $  # 
0x88, 0x00, 0x80, 0x00, 0x04, 0x44, 0x88, 0x80, //##  #    $$$### 
0x80, 0x00, 0x08, 0x88, 0x40, 0x00, 0x80, 0x00, //#    ###$   #   
0x80, 0x48, 0x44, 0x11, 0x18, 0x88, 0x80, 0x00, //# $#$$...####   
0x80, 0x00, 0x08, 0x11, 0x11, 0x80, 0x00, 0x00, //#    #....#     
0x80, 0x80, 0x20, 0x81, 0x11, 0x80, 0x00, 0x00, //# # @ #...#     
0x80, 0x00, 0x00, 0x41, 0x11, 0x80, 0x00, 0x00, //#     $...#     
0x88, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00, 0x00, //##  #     #     
0x08, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, // ##########     
//Level: 65
0x0B, 0x0A,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //#########   
0x80, 0x00, 0x00, 0x00, 0x80, 0x00, //#       #   
0x80, 0x04, 0x04, 0x04, 0x80, 0x00, //#  $ $ $#   
0x88, 0x08, 0x48, 0x80, 0x80, 0x00, //## #$## #   
0x08, 0x01, 0x10, 0x11, 0x88, 0x00, // # .. ..##  
0x08, 0x81, 0x10, 0x11, 0x08, 0x00, // ##.. .. #  
0x00, 0x80, 0x88, 0x48, 0x08, 0x80, //  # ##$# ## 
0x00, 0x84, 0x04, 0x04, 0x00, 0x80, //  #$ $ $  # 
0x00, 0x80, 0x00, 0x00, 0x02, 0x80, //  #      @# 
0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //  ######### 
//Level: 66
0x09, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x00, //########  
0x81, 0x11, 0x11, 0x18, 0x00, //#......#  
0x80, 0x04, 0x08, 0x08, 0x80, //#  $ # ## 
0x80, 0x40, 0x80, 0x40, 0x80, //# $ # $ # 
0x88, 0x40, 0x40, 0x40, 0x80, //##$ $ $ # 
0x08, 0x00, 0x20, 0x00, 0x80, // #  @   # 
0x08, 0x88, 0x88, 0x88, 0x80, // ######## 
//Level: 67
0x0A, 0x08,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, //     #####
0x88, 0x88, 0x88, 0x11, 0x18, //######...#
0x80, 0x00, 0x42, 0x04, 0x88, //#   $@ $##
0x80, 0x04, 0x08, 0x04, 0x08, //#  $ # $ #
0x81, 0x04, 0x08, 0x40, 0x08, //#. $ #$  #
0x80, 0x88, 0x88, 0x08, 0x18, //# #### #.#
0x81, 0x00, 0x00, 0x04, 0x18, //#.     $.#
0x88, 0x88, 0x88, 0x88, 0x88, //##########
//Level: 68
0x0B, 0x07,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x88, 0x80, //   ######## 
0x88, 0x88, 0x20, 0x00, 0x10, 0x80, //####@   . # 
0x80, 0x04, 0x04, 0x04, 0x10, 0x80, //#  $ $ $. # 
0x80, 0x01, 0x88, 0x80, 0x18, 0x80, //#  .### .## 
0x80, 0x41, 0x40, 0x40, 0x08, 0x00, //# $.$ $  #  
0x80, 0x01, 0x00, 0x88, 0x88, 0x00, //#  .  ####  
0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //#######     
//Level: 69
0x08, 0x08,//Size x and y
0x00, 0x08, 0x88, 0x88, //   #####
0x00, 0x08, 0x02, 0x08, //   # @ #
0x08, 0x88, 0x00, 0x08, // ###   #
0x08, 0x04, 0x04, 0x88, // # $ $##
0x88, 0x04, 0x00, 0x80, //## $  # 
0x81, 0x00, 0x80, 0x80, //#.  # # 
0x81, 0x10, 0x00, 0x80, //#..   # 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 70
0x10, 0x0E,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //   ##########   
0x00, 0x08, 0x11, 0x00, 0x80, 0x00, 0x80, 0x00, //   #..  #   #   
0x00, 0x08, 0x11, 0x00, 0x00, 0x00, 0x80, 0x00, //   #..      #   
0x00, 0x08, 0x11, 0x00, 0x80, 0x08, 0x88, 0x80, //   #..  #  #### 
0x00, 0x88, 0x88, 0x88, 0x80, 0x08, 0x00, 0x88, //  #######  #  ##
0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, //  #            #
0x00, 0x80, 0x08, 0x00, 0x88, 0x00, 0x80, 0x08, //  #  #  ##  #  #
0x88, 0x88, 0x08, 0x80, 0x08, 0x88, 0x80, 0x88, //#### ##  #### ##
0x80, 0x04, 0x00, 0x88, 0x88, 0x80, 0x80, 0x08, //#  $  ##### #  #
0x80, 0x80, 0x40, 0x04, 0x00, 0x80, 0x40, 0x08, //# # $  $  # $  #
0x80, 0x24, 0x00, 0x40, 0x00, 0x80, 0x00, 0x88, //# @$  $   #   ##
0x88, 0x88, 0x08, 0x80, 0x88, 0x88, 0x88, 0x80, //#### ## ####### 
0x00, 0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, //   #    #       
0x00, 0x08, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //   ######       
//Level: 71
0x0A, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, //  ########
0x00, 0x80, 0x00, 0x81, 0x08, //  #   #. #
0x08, 0x80, 0x04, 0x11, 0x18, // ##  $...#
0x08, 0x00, 0x40, 0x85, 0x18, // #  $ #*.#
0x88, 0x08, 0x84, 0x80, 0x88, //## ##$# ##
0x80, 0x00, 0x40, 0x04, 0x08, //#   $  $ #
0x80, 0x00, 0x80, 0x00, 0x08, //#   #    #
0x88, 0x88, 0x88, 0x82, 0x08, //#######@ #
0x00, 0x00, 0x00, 0x88, 0x88, //      ####
//Level: 72
0x13, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //#############       
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, //#           #       
0x80, 0x88, 0x80, 0x44, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, //# ### $$    #       
0x80, 0x00, 0x80, 0x40, 0x04, 0x00, 0x80, 0x00, 0x00, 0x00, //#   # $  $  #       
0x80, 0x04, 0x88, 0x88, 0x48, 0x88, 0x88, 0x80, 0x00, 0x00, //#  $####$######     
0x80, 0x40, 0x88, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, //# $ ##        ##### 
0x80, 0x04, 0x40, 0x40, 0x00, 0x00, 0x00, 0x01, 0x11, 0x80, //#  $$ $        ...# 
0x88, 0x80, 0x88, 0x04, 0x48, 0x00, 0x00, 0x01, 0x11, 0x80, //### ## $$#     ...# 
0x00, 0x80, 0x88, 0x00, 0x08, 0x00, 0x00, 0x01, 0x11, 0x80, //  # ##   #     ...# 
0x00, 0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x01, 0x11, 0x80, //  #      #     ...# 
0x00, 0x88, 0x82, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //  ###@############# 
0x00, 0x00, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //    ###             
//Level: 73
0x11, 0x0D,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //    ######        
0x08, 0x88, 0x80, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, // ####    #        
0x08, 0x00, 0x00, 0x88, 0x08, 0x00, 0x00, 0x00, 0x00, // #    ## #        
0x08, 0x04, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, // # $     #        
0x88, 0x80, 0x88, 0x88, 0x08, 0x88, 0x88, 0x88, 0x80, //### #### ######## 
0x80, 0x04, 0x00, 0x04, 0x08, 0x80, 0x01, 0x11, 0x80, //#  $   $ ##  ...# 
0x80, 0x00, 0x44, 0x04, 0x40, 0x00, 0x01, 0x11, 0x80, //#   $$ $$    ...# 
0x80, 0x00, 0x04, 0x00, 0x48, 0x80, 0x01, 0x11, 0x80, //#    $  $##  ...# 
0x88, 0x28, 0x80, 0x88, 0x08, 0x80, 0x01, 0x11, 0x80, //##@## ## ##  ...# 
0x08, 0x88, 0x00, 0x40, 0x08, 0x88, 0x88, 0x88, 0x80, // ###  $  ######## 
0x08, 0x00, 0x04, 0x40, 0x08, 0x00, 0x00, 0x00, 0x00, // #   $$  #        
0x08, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, // #    #  #        
0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, // #########        
//Level: 74
0x0F, 0x0F,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
0x80, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x80, //#   #####     # 
0x80, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x80, //#    . .      # 
0x81, 0x81, 0x88, 0x08, 0x81, 0x88, 0x80, 0x80, //#.#.## ##.### # 
0x81, 0x11, 0x00, 0x40, 0x01, 0x11, 0x10, 0x80, //#...  $  .... # 
0x88, 0x11, 0x08, 0x08, 0x01, 0x18, 0x80, 0x80, //##.. # # ..## # 
0x88, 0x88, 0x88, 0x08, 0x88, 0x88, 0x80, 0x80, //###### ###### # 
0x80, 0x00, 0x08, 0x08, 0x00, 0x00, 0x80, 0x80, //#    # #    # # 
0x80, 0x44, 0x08, 0x48, 0x04, 0x40, 0x80, 0x80, //# $$ #$# $$ # # 
0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, //# $ $ $ $ $ # # 
0x80, 0x44, 0x08, 0x48, 0x04, 0x40, 0x80, 0x80, //# $$ #$# $$ # # 
0x80, 0x00, 0x08, 0x28, 0x00, 0x00, 0x80, 0x80, //#    #@#    # # 
0x80, 0x88, 0x88, 0x08, 0x88, 0x08, 0x80, 0x80, //# #### ### ## # 
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#             # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
//Level: 75
0x09, 0x09,//Size x and y
0x88, 0x88, 0x80, 0x00, 0x00, //#####     
0x82, 0x00, 0x80, 0x00, 0x00, //#@  #     
0x80, 0x44, 0x80, 0x88, 0x80, //# $$# ### 
0x80, 0x40, 0x80, 0x81, 0x80, //# $ # #.# 
0x88, 0x80, 0x88, 0x81, 0x80, //### ###.# 
0x08, 0x80, 0x00, 0x01, 0x80, // ##    .# 
0x08, 0x00, 0x08, 0x00, 0x80, // #   #  # 
0x08, 0x00, 0x08, 0x88, 0x80, // #   #### 
0x08, 0x88, 0x88, 0x00, 0x00, // #####    
//Level: 76
0x0A, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, //##########
0x81, 0x10, 0x00, 0x00, 0x08, //#..      #
0x81, 0x14, 0x00, 0x80, 0x08, //#..$  #  #
0x80, 0x08, 0x48, 0x80, 0x88, //#  #$## ##
0x80, 0x40, 0x00, 0x00, 0x80, //# $     # 
0x88, 0x88, 0x80, 0x80, 0x80, //##### # # 
0x00, 0x80, 0x40, 0x20, 0x80, //  # $ @ # 
0x00, 0x80, 0x00, 0x00, 0x80, //  #     # 
0x00, 0x88, 0x88, 0x88, 0x80, //  ####### 
//Level: 77
0x0C, 0x0D,//Size x and y
0x08, 0x88, 0x80, 0x00, 0x00, 0x00, // ####       
0x08, 0x00, 0x88, 0x88, 0x88, 0x00, // #  ######  
0x08, 0x00, 0x00, 0x04, 0x28, 0x00, // #     $@#  
0x88, 0x08, 0x81, 0x88, 0x48, 0x00, //## ##.##$#  
0x80, 0x08, 0x01, 0x08, 0x08, 0x88, //#  # . # ###
0x80, 0x00, 0x51, 0x18, 0x00, 0x08, //#   *..#   #
0x88, 0x08, 0x01, 0x04, 0x08, 0x08, //## # . $ # #
0x88, 0x08, 0x81, 0x80, 0x04, 0x08, //## ##.#  $ #
0x80, 0x08, 0x81, 0x80, 0x88, 0x88, //#  ##.# ####
0x80, 0x44, 0x04, 0x80, 0x08, 0x00, //# $$ $#  #  
0x80, 0x08, 0x00, 0x00, 0x08, 0x00, //#  #     #  
0x88, 0x88, 0x88, 0x80, 0x08, 0x00, //#######  #  
0x00, 0x00, 0x00, 0x88, 0x88, 0x00, //      ####  
//Level: 78
0x0D, 0x0A,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //    #####     
0x00, 0x88, 0x80, 0x00, 0x88, 0x80, 0x00, //  ###   ###   
0x08, 0x81, 0x40, 0x00, 0x00, 0x88, 0x00, // ##.$     ##  
0x08, 0x10, 0x44, 0x44, 0x40, 0x08, 0x00, // #. $$$$$  #  
0x88, 0x00, 0x80, 0x00, 0x80, 0x08, 0x80, //##  #   #  ## 
0x80, 0x08, 0x58, 0x28, 0x58, 0x00, 0x80, //#  #*#@#*#  # 
0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, //#   #   #   # 
0x88, 0x01, 0x44, 0x44, 0x41, 0x08, 0x80, //## .$$$$$. ## 
0x08, 0x81, 0x11, 0x11, 0x11, 0x88, 0x00, // ##.......##  
0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //  #########   
//Level: 79
0x10, 0x09,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, //         #####  
0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, //         #   #  
0x88, 0x88, 0x88, 0x88, 0x88, 0x05, 0x08, 0x88, //########## * ###
0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, //#          .   #
0x80, 0x44, 0x44, 0x55, 0x55, 0x41, 0x11, 0x28, //# $$$$****$...@#
0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, //#          .   #
0x88, 0x88, 0x88, 0x88, 0x88, 0x05, 0x08, 0x88, //########## * ###
0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, //         #   #  
0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, //         #####  
//Level: 80
0x11, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //################  
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, //#              #  
0x80, 0x80, 0x88, 0x88, 0x88, 0x00, 0x00, 0x08, 0x00, //# # ######     #  
0x80, 0x80, 0x04, 0x04, 0x04, 0x04, 0x80, 0x08, 0x00, //# #  $ $ $ $#  #  
0x80, 0x80, 0x00, 0x42, 0x40, 0x00, 0x88, 0x08, 0x80, //# #   $@$   ## ## 
0x80, 0x80, 0x04, 0x04, 0x04, 0x88, 0x81, 0x11, 0x80, //# #  $ $ $###...# 
0x80, 0x80, 0x00, 0x40, 0x40, 0x08, 0x81, 0x11, 0x80, //# #   $ $  ##...# 
0x80, 0x88, 0x84, 0x44, 0x04, 0x08, 0x81, 0x11, 0x80, //# ###$$$ $ ##...# 
0x80, 0x00, 0x00, 0x80, 0x88, 0x08, 0x81, 0x11, 0x80, //#     # ## ##...# 
0x88, 0x88, 0x80, 0x00, 0x88, 0x08, 0x81, 0x11, 0x80, //#####   ## ##...# 
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x88, 0x80, //    #####     ### 
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00, //        #     #   
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, //        #######   
//Level: 81
0x06, 0x08,//Size x and y
0x08, 0x88, 0x80, // #### 
0x88, 0x00, 0x80, //##  # 
0x82, 0x40, 0x80, //#@$ # 
0x88, 0x40, 0x88, //##$ ##
0x88, 0x04, 0x08, //## $ #
0x81, 0x40, 0x08, //#.$  #
0x81, 0x15, 0x18, //#..*.#
0x88, 0x88, 0x88, //######
//Level: 82
0x0E, 0x0C,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, //    ######    
0x00, 0x88, 0x80, 0x00, 0x08, 0x88, 0x00, //  ###    ###  
0x00, 0x80, 0x00, 0x84, 0x00, 0x08, 0x88, //  #   #$   ###
0x00, 0x80, 0x00, 0x40, 0x00, 0x44, 0x08, //  #   $   $$ #
0x00, 0x80, 0x44, 0x08, 0x40, 0x00, 0x08, //  # $$ #$    #
0x00, 0x88, 0x00, 0x04, 0x00, 0x04, 0x08, //  ##   $   $ #
0x88, 0x88, 0x88, 0x08, 0x48, 0x88, 0x88, //###### #$#####
0x81, 0x12, 0x08, 0x40, 0x08, 0x00, 0x00, //#..@ #$  #    
0x81, 0x81, 0x10, 0x04, 0x88, 0x00, 0x00, //#.#..  $##    
0x81, 0x11, 0x14, 0x80, 0x80, 0x00, 0x00, //#....$# #     
0x81, 0x11, 0x10, 0x00, 0x80, 0x00, 0x00, //#....   #     
0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //#########     
//Level: 83
0x0D, 0x0A,//Size x and y
0x00, 0x08, 0x88, 0x80, 0x00, 0x00, 0x00, //   ####       
0x88, 0x88, 0x00, 0x88, 0x88, 0x88, 0x00, //####  ######  
0x80, 0x00, 0x00, 0x88, 0x00, 0x08, 0x00, //#     ##   #  
0x80, 0x48, 0x04, 0x00, 0x00, 0x48, 0x00, //# $# $    $#  
0x88, 0x08, 0x88, 0x04, 0x80, 0x08, 0x00, //## ### $#  #  
0x08, 0x04, 0x04, 0x00, 0x88, 0x08, 0x00, // # $ $  ## #  
0x08, 0x00, 0x04, 0x08, 0x80, 0x08, 0x80, // #   $ ##  ## 
0x08, 0x40, 0x81, 0x11, 0x50, 0x40, 0x80, // #$ #...* $ # 
0x08, 0x02, 0x80, 0x11, 0x11, 0x11, 0x80, // # @# ......# 
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, // ############ 
//Level: 84
0x08, 0x08,//Size x and y
0x00, 0x88, 0x88, 0x00, //  ####  
0x00, 0x80, 0x08, 0x00, //  #  #  
0x00, 0x80, 0x08, 0x88, //  #  ###
0x88, 0x80, 0x11, 0x08, //### .. #
0x80, 0x04, 0x80, 0x08, //#  $#  #
0x80, 0x01, 0x44, 0x08, //#  .$$ #
0x88, 0x88, 0x02, 0x08, //#### @ #
0x00, 0x08, 0x88, 0x88, //   #####
//Level: 85
0x08, 0x08,//Size x and y
0x08, 0x88, 0x88, 0x80, // ###### 
0x08, 0x20, 0x00, 0x88, // #@   ##
0x08, 0x84, 0x00, 0x08, // ##$   #
0x88, 0x80, 0x10, 0x08, //### .  #
0x80, 0x40, 0x84, 0x88, //# $ #$##
0x80, 0x10, 0x01, 0x80, //# .  .# 
0x88, 0x88, 0x00, 0x80, //####  # 
0x00, 0x08, 0x88, 0x80, //   #### 
//Level: 86
0x0F, 0x0F,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //#########       
0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, //#       #       
0x80, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, //#       ####    
0x88, 0x08, 0x88, 0x80, 0x80, 0x08, 0x00, 0x00, //## #### #  #    
0x88, 0x08, 0x28, 0x80, 0x00, 0x08, 0x00, 0x00, //## #@##    #    
0x80, 0x44, 0x40, 0x40, 0x04, 0x48, 0x00, 0x00, //# $$$ $  $$#    
0x80, 0x08, 0x08, 0x80, 0x40, 0x08, 0x00, 0x00, //#  # ## $  #    
0x80, 0x08, 0x08, 0x80, 0x04, 0x08, 0x88, 0x80, //#  # ##  $ #### 
0x88, 0x88, 0x00, 0x44, 0x40, 0x48, 0x00, 0x80, //####  $$$ $#  # 
0x08, 0x00, 0x08, 0x80, 0x00, 0x11, 0x11, 0x80, // #   ##   ....# 
0x08, 0x08, 0x00, 0x08, 0x08, 0x11, 0x01, 0x80, // # #   # #.. .# 
0x08, 0x00, 0x08, 0x08, 0x08, 0x81, 0x11, 0x80, // #   # # ##...# 
0x08, 0x88, 0x88, 0x04, 0x00, 0x81, 0x11, 0x80, // ##### $  #...# 
0x00, 0x00, 0x08, 0x80, 0x00, 0x88, 0x88, 0x80, //     ##   ##### 
0x00, 0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //      #####     
//Level: 87
0x13, 0x0F,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //           #####    
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x08, 0x80, 0x00, //          ##   ##   
0x00, 0x00, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x80, 0x00, //         ##     #   
0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x44, 0x00, 0x80, 0x00, //        ##  $$  #   
0x00, 0x00, 0x00, 0x08, 0x80, 0x44, 0x00, 0x40, 0x80, 0x00, //       ## $$  $ #   
0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x40, 0x80, 0x00, //       # $    $ #   
0x88, 0x88, 0x00, 0x08, 0x00, 0x04, 0x40, 0x88, 0x88, 0x80, //####   #   $$ ##### 
0x80, 0x08, 0x88, 0x88, 0x88, 0x80, 0x88, 0x00, 0x00, 0x80, //#  ######## ##    # 
0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x42, 0x80, //#.            $$$@# 
0x81, 0x80, 0x88, 0x88, 0x88, 0x80, 0x88, 0x00, 0x08, 0x80, //#.# ####### ##   ## 
0x81, 0x80, 0x88, 0x88, 0x88, 0x81, 0x08, 0x40, 0x48, 0x80, //#.# #######. #$ $## 
0x81, 0x11, 0x11, 0x11, 0x11, 0x11, 0x08, 0x00, 0x00, 0x80, //#........... #    # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x40, 0x80, //##############  $ # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x80, //             ##  ## 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, //              ####  
//Level: 88
0x0D, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############# 
0x80, 0x01, 0x01, 0x01, 0x01, 0x00, 0x80, //#  . . . .  # 
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, //# # # # # # # 
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, //# # # # # # # 
0x81, 0x40, 0x80, 0x40, 0x80, 0x41, 0x80, //#.$ # $ # $.# 
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, //# # # # # # # 
0x80, 0x84, 0x44, 0x84, 0x44, 0x80, 0x80, //# #$$$#$$$# # 
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, //# # # # # # # 
0x81, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, //#.$ # $ # $ # 
0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, //# # # # # #.# 
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, //# # # # # # # 
0x80, 0x01, 0x01, 0x21, 0x01, 0x00, 0x80, //#  . .@. .  # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############# 
//Level: 89
0x0A, 0x06,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, // #########
0x88, 0x20, 0x00, 0x00, 0x08, //##@      #
0x80, 0x00, 0x84, 0x84, 0x08, //#   #$#$ #
0x80, 0x44, 0x00, 0x14, 0x18, //# $$  .$.#
0x80, 0x08, 0x88, 0x11, 0x18, //#  ###...#
0x88, 0x88, 0x08, 0x88, 0x88, //#### #####
//Level: 90
0x11, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x80, 0x88, 0x88, 0x88, 0x88, 0x80, //####### ######### 
0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x88, 0x00, 0x80, //#     # #   ##  # 
0x80, 0x88, 0x80, 0x80, 0x80, 0x00, 0x40, 0x00, 0x80, //# ### # #   $   # 
0x80, 0x80, 0x40, 0x88, 0x80, 0x00, 0x40, 0x00, 0x80, //# # $ ###   $   # 
0x80, 0x00, 0x44, 0x00, 0x00, 0x00, 0x88, 0x40, 0x80, //#   $$      ##$ # 
0x80, 0x00, 0x08, 0x88, 0x80, 0x00, 0x88, 0x00, 0x80, //#    ####   ##  # 
0x82, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x08, 0x80, //#@############ ## 
0x88, 0x81, 0x10, 0x00, 0x08, 0x88, 0x88, 0x40, 0x80, //###..    #####$ # 
0x00, 0x81, 0x10, 0x00, 0x08, 0x88, 0x80, 0x00, 0x80, //  #..    ####   # 
0x00, 0x81, 0x10, 0x00, 0x00, 0x00, 0x44, 0x00, 0x80, //  #..       $$  # 
0x00, 0x81, 0x10, 0x00, 0x08, 0x88, 0x80, 0x40, 0x80, //  #..    #### $ # 
0x00, 0x81, 0x10, 0x00, 0x08, 0x00, 0x80, 0x00, 0x80, //  #..    #  #   # 
0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x88, 0x88, 0x80, //  ########  ##### 
//Level: 91
0x10, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, //       #########
0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, //       #       #
0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, //       # # # # #
0x00, 0x00, 0x00, 0x08, 0x00, 0x40, 0x48, 0x08, //       #  $ $# #
0x00, 0x00, 0x00, 0x08, 0x00, 0x04, 0x00, 0x08, //       #   $   #
0x00, 0x00, 0x00, 0x08, 0x80, 0x40, 0x48, 0x08, //       ## $ $# #
0x08, 0x88, 0x00, 0x00, 0x80, 0x40, 0x40, 0x08, // ###    # $ $  #
0x88, 0x18, 0x88, 0x88, 0x80, 0x88, 0x88, 0x88, //##.###### ######
0x81, 0x11, 0x00, 0x80, 0x40, 0x40, 0x80, 0x00, //#...  # $ $ #   
0x88, 0x11, 0x00, 0x00, 0x04, 0x00, 0x80, 0x00, //##..     $  #   
0x81, 0x11, 0x00, 0x80, 0x02, 0x88, 0x80, 0x00, //#...  #  @###   
0x88, 0x18, 0x88, 0x80, 0x08, 0x80, 0x00, 0x00, //##.####  ##     
0x08, 0x88, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, // ###  ####      
//Level: 92
0x12, 0x0F,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //      ########### 
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00, 0x88, //      #     #   ##
0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x00, 0x01, 0x18, //      # $      ..#
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x84, 0x81, 0x18, //      #     #$#..#
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x01, 0x18, //  ###########  ..#
0x00, 0x80, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x18, //  #      $     ..#
0x00, 0x80, 0x80, 0x80, 0x48, 0x80, 0x80, 0x81, 0x18, //  # # # $## # #..#
0x00, 0x80, 0x00, 0x84, 0x00, 0x00, 0x80, 0x01, 0x18, //  #   #$    #  ..#
0x08, 0x84, 0x80, 0x40, 0x88, 0x88, 0x88, 0x80, 0x08, // ##$# $ #######  #
0x88, 0x00, 0x04, 0x00, 0x80, 0x00, 0x08, 0x04, 0x08, //##   $  #    # $ #
0x80, 0x00, 0x48, 0x00, 0x80, 0x00, 0x08, 0x00, 0x08, //#   $#  #    #   #
0x80, 0x04, 0x00, 0x08, 0x80, 0x00, 0x08, 0x88, 0x88, //#  $   ##    #####
0x80, 0x48, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //# $#####          
0x80, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //# @#              
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //####              
//Level: 93
0x12, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##################
0x80, 0x00, 0x00, 0x00, 0x00, 0x88, 0x08, 0x11, 0x18, //#         ## #...#
0x80, 0x40, 0x44, 0x80, 0x00, 0x04, 0x08, 0x11, 0x18, //# $ $$#    $ #...#
0x80, 0x40, 0x00, 0x84, 0x88, 0x44, 0x08, 0x11, 0x18, //# $   #$##$$ #...#
0x80, 0x44, 0x84, 0x00, 0x00, 0x00, 0x02, 0x11, 0x18, //# $$#$       @...#
0x80, 0x40, 0x40, 0x48, 0x40, 0x88, 0x88, 0x00, 0x18, //# $ $ $#$ ####  .#
0x80, 0x00, 0x88, 0x00, 0x00, 0x00, 0x04, 0x11, 0x18, //#   ##       $...#
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##################
//Level: 94
0x0A, 0x0A,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x80, 0x00, 0x88, 0x00, 0x80, //#   ##  # 
0x80, 0x80, 0x40, 0x40, 0x80, //# # $ $ # 
0x80, 0x05, 0x18, 0x00, 0x80, //#  *.#  # 
0x88, 0x08, 0x12, 0x18, 0x80, //## #.@.## 
0x88, 0x48, 0x88, 0x58, 0x88, //##$###*###
0x80, 0x00, 0x00, 0x00, 0x08, //#        #
0x80, 0x00, 0x88, 0x08, 0x08, //#   ## # #
0x88, 0x88, 0x88, 0x00, 0x08, //######   #
0x00, 0x00, 0x08, 0x88, 0x88, //     #####
//Level: 95
0x0E, 0x0D,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, //  ########    
0x00, 0x80, 0x00, 0x80, 0x08, 0x88, 0x00, //  #   #  ###  
0x88, 0x80, 0x80, 0x40, 0x04, 0x08, 0x88, //### # $  $ ###
0x80, 0x00, 0x08, 0x44, 0x08, 0x00, 0x08, //#    #$$ #   #
0x80, 0x88, 0x48, 0x00, 0x20, 0x04, 0x08, //# ##$#  @  $ #
0x80, 0x00, 0x04, 0x48, 0x88, 0x40, 0x88, //#    $$###$ ##
0x80, 0x00, 0x48, 0x08, 0x80, 0x08, 0x80, //#   $# ##  ## 
0x80, 0x84, 0x08, 0x01, 0x11, 0x88, 0x00, //# #$ # ...##  
0x80, 0x40, 0x81, 0x11, 0x11, 0x80, 0x00, //# $ #.....#   
0x88, 0x00, 0x11, 0x11, 0x18, 0x80, 0x00, //##  .....##   
0x08, 0x04, 0x80, 0x88, 0x88, 0x00, 0x00, // # $# ####    
0x08, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, // ##   #       
0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //  #####       
//Level: 96
0x0C, 0x08,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, //       #####
0x88, 0x88, 0x88, 0x88, 0x00, 0x08, //########   #
0x80, 0x11, 0x11, 0x11, 0x40, 0x08, //# ......$  #
0x80, 0x08, 0x48, 0x88, 0x00, 0x08, //#  #$###   #
0x88, 0x04, 0x24, 0x08, 0x00, 0x08, //## $@$ #   #
0x08, 0x04, 0x04, 0x08, 0x00, 0x08, // # $ $ #   #
0x08, 0x00, 0x00, 0x08, 0x88, 0x88, // #     #####
0x08, 0x88, 0x88, 0x88, 0x00, 0x00, // #######    
//Level: 97
0x14, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //######              
0x80, 0x00, 0x08, 0x88, 0x00, 0x00, 0x08, 0x88, 0x88, 0x80, //#    ###     ###### 
0x80, 0x80, 0x04, 0x08, 0x00, 0x88, 0x88, 0x00, 0x11, 0x80, //# #  $ #  ####  ..# 
0x80, 0x80, 0x04, 0x08, 0x88, 0x82, 0x88, 0x00, 0x11, 0x88, //# #  $ ####@##  ..##
0x80, 0x04, 0x44, 0x00, 0x04, 0x00, 0x00, 0x00, 0x11, 0x18, //#  $$$   $      ...#
0x88, 0x80, 0x04, 0x00, 0x48, 0x88, 0x88, 0x00, 0x11, 0x88, //###  $  $#####  ..##
0x00, 0x84, 0x04, 0x04, 0x08, 0x00, 0x08, 0x00, 0x11, 0x80, //  #$ $ $ #   #  ..# 
0x00, 0x80, 0x00, 0x00, 0x08, 0x00, 0x08, 0x88, 0x88, 0x80, //  #      #   ###### 
0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //  ########          
//Level: 98
0x0F, 0x0E,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //    #####       
0x88, 0x88, 0x80, 0x00, 0x88, 0x88, 0x88, 0x00, //#####   ######  
0x80, 0x00, 0x00, 0x80, 0x08, 0x80, 0x08, 0x80, //#     #  ##  ## 
0x80, 0x80, 0x44, 0x00, 0x04, 0x00, 0x00, 0x80, //# # $$   $    # 
0x80, 0x08, 0x00, 0x08, 0x80, 0x80, 0x80, 0x80, //#  #   ## # # # 
0x80, 0x40, 0x80, 0x88, 0x00, 0x04, 0x00, 0x80, //# $ # ##   $  # 
0x80, 0x00, 0x04, 0x04, 0x00, 0x08, 0x08, 0x80, //#    $ $   # ## 
0x88, 0x04, 0x08, 0x00, 0x84, 0x88, 0x08, 0x00, //## $ #  #$## #  
0x08, 0x88, 0x00, 0x80, 0x80, 0x80, 0x48, 0x00, // ###  # # # $#  
0x00, 0x08, 0x04, 0x00, 0x20, 0x11, 0x18, 0x00, //   # $  @ ...#  
0x00, 0x08, 0x04, 0x88, 0x48, 0x11, 0x18, 0x00, //   # $##$#...#  
0x00, 0x08, 0x80, 0x00, 0x11, 0x11, 0x88, 0x00, //   ##   ....##  
0x00, 0x00, 0x88, 0x80, 0x11, 0x18, 0x80, 0x00, //    ### ...##   
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, //      ######    
//Level: 99
0x0B, 0x0A,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x00, // #########  
0x08, 0x00, 0x00, 0x00, 0x08, 0x80, // #       ## 
0x08, 0x40, 0x88, 0x88, 0x00, 0x80, // #$ ####  # 
0x88, 0x08, 0x01, 0x50, 0x80, 0x80, //## # .* # # 
0x80, 0x00, 0x45, 0x10, 0x80, 0x80, //#   $*. # # 
0x80, 0x84, 0x21, 0x50, 0x80, 0x80, //# #$@.* # # 
0x80, 0x00, 0x04, 0x00, 0x00, 0x80, //#    $    # 
0x88, 0x88, 0x48, 0x84, 0x08, 0x80, //####$##$ ## 
0x00, 0x08, 0x01, 0x11, 0x08, 0x00, //   # ... #  
0x00, 0x08, 0x88, 0x88, 0x88, 0x00, //   #######  
//Level: 100
0x09, 0x0C,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
0x00, 0x80, 0x20, 0x80, 0x00, //  # @ #   
0x00, 0x80, 0x40, 0x80, 0x00, //  # $ #   
0x88, 0x80, 0x10, 0x88, 0x80, //### . ### 
0x80, 0x00, 0x50, 0x00, 0x80, //#   *   # 
0x80, 0x55, 0x55, 0x50, 0x80, //# ***** # 
0x80, 0x00, 0x50, 0x00, 0x80, //#   *   # 
0x88, 0x84, 0x54, 0x88, 0x80, //###$*$### 
0x00, 0x80, 0x10, 0x80, 0x00, //  # . #   
0x00, 0x80, 0x50, 0x80, 0x00, //  # * #   
0x00, 0x80, 0x10, 0x80, 0x00, //  # . #   
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
//Level: 101
0x11, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //        #####     
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x88, 0x88, 0x80, //        #   ##### 
0x00, 0x00, 0x00, 0x00, 0x80, 0x84, 0x88, 0x00, 0x80, //        # #$##  # 
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x40, 0x80, //        #     $ # 
0x88, 0x88, 0x88, 0x88, 0x80, 0x88, 0x80, 0x00, 0x80, //######### ###   # 
0x81, 0x11, 0x10, 0x08, 0x80, 0x40, 0x04, 0x88, 0x80, //#....  ## $  $### 
0x81, 0x11, 0x10, 0x00, 0x04, 0x04, 0x40, 0x88, 0x00, //#....    $ $$ ##  
0x81, 0x11, 0x10, 0x08, 0x84, 0x00, 0x40, 0x28, 0x00, //#....  ##$  $ @#  
0x88, 0x88, 0x88, 0x88, 0x80, 0x04, 0x00, 0x88, 0x00, //#########  $  ##  
0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x40, 0x08, 0x00, //        # $ $  #  
0x00, 0x00, 0x00, 0x00, 0x88, 0x80, 0x88, 0x08, 0x00, //        ### ## #  
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x08, 0x00, //          #    #  
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x00, //          ######  
//Level: 102
0x13, 0x0F,//Size x and y
0x08, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // #####              
0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // #   #              
0x08, 0x08, 0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, // # # #######        
0x08, 0x00, 0x00, 0x00, 0x42, 0x88, 0x88, 0x88, 0x00, 0x00, // #      $@######    
0x08, 0x04, 0x08, 0x84, 0x08, 0x88, 0x00, 0x08, 0x00, 0x00, // # $ ##$ ###   #    
0x08, 0x08, 0x88, 0x80, 0x40, 0x00, 0x04, 0x08, 0x00, 0x00, // # #### $    $ #    
0x08, 0x08, 0x88, 0x88, 0x08, 0x00, 0x84, 0x08, 0x88, 0x80, // # ##### #  #$ #### 
0x88, 0x00, 0x88, 0x88, 0x08, 0x84, 0x00, 0x00, 0x00, 0x80, //##  #### ##$      # 
0x80, 0x04, 0x80, 0x04, 0x00, 0x80, 0x88, 0x08, 0x80, 0x80, //#  $#  $  # ## ## # 
0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x81, 0x11, 0x80, 0x80, //#         # #...# # 
0x88, 0x88, 0x88, 0x00, 0x88, 0x80, 0x01, 0x11, 0x00, 0x80, //######  ###  ...  # 
0x00, 0x00, 0x08, 0x88, 0x80, 0x80, 0x81, 0x11, 0x80, 0x80, //     #### # #...# # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x88, 0x80, 0x80, 0x80, //          # ### # # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, //          #       # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //          ######### 
//Level: 103
0x08, 0x07,//Size x and y
0x00, 0x88, 0x88, 0x88, //  ######
0x00, 0x80, 0x00, 0x08, //  #    #
0x88, 0x84, 0x44, 0x08, //###$$$ #
0x82, 0x04, 0x11, 0x08, //#@ $.. #
0x80, 0x41, 0x11, 0x88, //# $...##
0x88, 0x88, 0x00, 0x80, //####  # 
0x00, 0x08, 0x88, 0x80, //   #### 
//Level: 104
0x0C, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //#######     
0x80, 0x11, 0x11, 0x80, 0x00, 0x00, //# ....#     
0x80, 0x11, 0x11, 0x80, 0x00, 0x00, //# ....#     
0x80, 0x11, 0x11, 0x80, 0x00, 0x00, //# ....#     
0x88, 0x48, 0x88, 0x88, 0x88, 0x88, //##$#########
0x80, 0x40, 0x40, 0x00, 0x00, 0x08, //# $ $      #
0x80, 0x00, 0x80, 0x00, 0x00, 0x08, //#   #      #
0x88, 0x80, 0x80, 0x44, 0x04, 0x08, //### # $$ $ #
0x00, 0x80, 0x80, 0x00, 0x84, 0x08, //  # #   #$ #
0x00, 0x80, 0x80, 0x44, 0x00, 0x08, //  # # $$   #
0x00, 0x80, 0x80, 0x80, 0x44, 0x08, //  # # # $$ #
0x00, 0x80, 0x80, 0x04, 0x08, 0x88, //  # #  $ ###
0x00, 0x80, 0x88, 0x80, 0x08, 0x00, //  # ###  #  
0x00, 0x80, 0x00, 0x08, 0x28, 0x00, //  #    #@#  
0x00, 0x88, 0x88, 0x00, 0x08, 0x00, //  ####   #  
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, //     #####  
//Level: 105
0x0E, 0x0D,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x80, 0x00, //     ######   
0x00, 0x08, 0x88, 0x00, 0x00, 0x88, 0x00, //   ###    ##  
0x00, 0x08, 0x00, 0x08, 0x80, 0x08, 0x00, //   #   ##  #  
0x08, 0x88, 0x48, 0x80, 0x08, 0x08, 0x00, // ###$##  # #  
0x88, 0x00, 0x00, 0x01, 0x18, 0x08, 0x00, //##     ..# #  
0x80, 0x04, 0x84, 0x85, 0x18, 0x08, 0x00, //#  $#$#*.# #  
0x80, 0x44, 0x20, 0x81, 0x58, 0x08, 0x88, //# $$@ #.*# ###
0x80, 0x04, 0x40, 0x81, 0x18, 0x00, 0x08, //#  $$ #..#   #
0x88, 0x00, 0x00, 0x81, 0x14, 0x00, 0x08, //##    #..$   #
0x08, 0x88, 0x48, 0x81, 0x08, 0x08, 0x88, // ###$##. # ###
0x00, 0x08, 0x00, 0x88, 0x80, 0x08, 0x00, //   #  ###  #  
0x00, 0x08, 0x80, 0x00, 0x00, 0x88, 0x00, //   ##     ##  
0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, //    #######   
//Level: 106
0x0D, 0x0B,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, //        ##### 
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, //        #   # 
0x88, 0x88, 0x88, 0x88, 0x80, 0x80, 0x80, //######### # # 
0x80, 0x40, 0x40, 0x40, 0x40, 0x00, 0x80, //# $ $ $ $   # 
0x80, 0x81, 0x81, 0x81, 0x82, 0x48, 0x80, //# #.#.#.#@$## 
0x81, 0x11, 0x11, 0x11, 0x00, 0x08, 0x00, //#.......   #  
0x80, 0x80, 0x80, 0x80, 0x84, 0x88, 0x80, //# # # # #$### 
0x80, 0x40, 0x40, 0x40, 0x40, 0x00, 0x80, //# $ $ $ $   # 
0x88, 0x88, 0x88, 0x88, 0x80, 0x80, 0x80, //######### # # 
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, //        #   # 
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, //        ##### 
//Level: 107
0x08, 0x08,//Size x and y
0x08, 0x88, 0x80, 0x00, // ####   
0x08, 0x20, 0x88, 0x80, // #@ ### 
0x08, 0x04, 0x00, 0x80, // # $  # 
0x88, 0x80, 0x80, 0x88, //### # ##
0x81, 0x80, 0x80, 0x08, //#.# #  #
0x81, 0x40, 0x08, 0x08, //#.$  # #
0x81, 0x00, 0x04, 0x08, //#.   $ #
0x88, 0x88, 0x88, 0x88, //########
//Level: 108
0x0B, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x80, //       #### 
0x00, 0x00, 0x00, 0x08, 0x20, 0x80, //       #@ # 
0x00, 0x08, 0x88, 0x88, 0x00, 0x80, //   #####  # 
0x88, 0x88, 0x00, 0x00, 0x00, 0x80, //####      # 
0x80, 0x00, 0x18, 0x88, 0x08, 0x80, //#   .### ## 
0x80, 0x80, 0x80, 0x00, 0x08, 0x80, //# # #    ## 
0x80, 0x80, 0x40, 0x48, 0x10, 0x80, //# # $ $#. # 
0x80, 0x80, 0x05, 0x00, 0x80, 0x80, //# #  *  # # 
0x80, 0x18, 0x40, 0x40, 0x80, 0x80, //# .#$ $ # # 
0x88, 0x00, 0x00, 0x80, 0x80, 0x80, //##    # # # 
0x08, 0x08, 0x88, 0x10, 0x00, 0x80, // # ###.   # 
0x08, 0x00, 0x00, 0x08, 0x88, 0x80, // #     #### 
0x08, 0x88, 0x88, 0x88, 0x00, 0x00, // #######    
//Level: 109
0x11, 0x0D,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //    #########     
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, //    #       #     
0x00, 0x00, 0x84, 0x40, 0x44, 0x80, 0x88, 0x88, 0x00, //    #$$ $$# ####  
0x88, 0x88, 0x80, 0x08, 0x00, 0x40, 0x80, 0x08, 0x00, //#####  #  $ #  #  
0x81, 0x18, 0x00, 0x88, 0x04, 0x00, 0x40, 0x08, 0x00, //#..#  ## $  $  #  
0x81, 0x18, 0x04, 0x40, 0x00, 0x00, 0x80, 0x08, 0x00, //#..# $$     #  #  
0x81, 0x18, 0x00, 0x88, 0x48, 0x88, 0x80, 0x88, 0x00, //#..#  ##$#### ##  
0x81, 0x18, 0x80, 0x88, 0x00, 0x00, 0x80, 0x80, 0x00, //#..## ##    # #   
0x81, 0x11, 0x00, 0x08, 0x80, 0x88, 0x80, 0x88, 0x80, //#...   ## ### ### 
0x80, 0x00, 0x88, 0x00, 0x04, 0x00, 0x00, 0x00, 0x80, //#   ##   $      # 
0x88, 0x88, 0x88, 0x28, 0x00, 0x08, 0x80, 0x80, 0x80, //######@#   ## # # 
0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x80, 0x00, 0x80, //     ########   # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, //            ##### 
//Level: 110
0x0F, 0x0D,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //  #####         
0x88, 0x80, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, //###   ##        
0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, //#      #        
0x80, 0x44, 0x08, 0x48, 0x88, 0x88, 0x88, 0x80, //# $$ #$######## 
0x88, 0x08, 0x40, 0x40, 0x40, 0x80, 0x00, 0x80, //## #$ $ $ #   # 
0x81, 0x11, 0x18, 0x00, 0x04, 0x00, 0x00, 0x80, //#....#   $    # 
0x81, 0x11, 0x12, 0x80, 0x08, 0x88, 0x48, 0x80, //#....@#  ###$## 
0x81, 0x11, 0x14, 0x80, 0x00, 0x40, 0x40, 0x80, //#....$#   $ $ # 
0x81, 0x11, 0x14, 0x04, 0x80, 0x00, 0x00, 0x80, //#....$ $#     # 
0x88, 0x88, 0x80, 0x00, 0x80, 0x48, 0x48, 0x80, //#####   # $#$## 
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x40, 0x80, //    #####   $ # 
0x00, 0x00, 0x00, 0x00, 0x88, 0x80, 0x00, 0x80, //        ###   # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, //          ##### 
//Level: 111
0x0A, 0x08,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, //     #####
0x08, 0x88, 0x88, 0x00, 0x08, // #####   #
0x08, 0x01, 0x10, 0x48, 0x08, // # .. $# #
0x08, 0x08, 0x15, 0x00, 0x08, // # #.*   #
0x88, 0x05, 0x18, 0x40, 0x88, //## *.#$ ##
0x80, 0x40, 0x04, 0x00, 0x80, //# $  $  # 
0x80, 0x00, 0x88, 0x02, 0x80, //#   ## @# 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 112
0x0E, 0x0F,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, // #########    
0x08, 0x11, 0x11, 0x00, 0x08, 0x80, 0x00, // #....   ##   
0x08, 0x18, 0x18, 0x00, 0x40, 0x88, 0x00, // #.#.#  $ ##  
0x88, 0x11, 0x11, 0x80, 0x80, 0x28, 0x80, //##....# # @## 
0x80, 0x11, 0x11, 0x80, 0x08, 0x00, 0x88, //# ....#  #  ##
0x80, 0x00, 0x00, 0x84, 0x08, 0x84, 0x08, //#     #$ ##$ #
0x88, 0x08, 0x88, 0x00, 0x40, 0x00, 0x08, //## ###  $    #
0x08, 0x40, 0x04, 0x04, 0x04, 0x80, 0x08, // #$  $ $ $#  #
0x08, 0x08, 0x00, 0x40, 0x40, 0x88, 0x08, // # #  $ $ ## #
0x08, 0x00, 0x88, 0x80, 0x08, 0x80, 0x08, // #  ###  ##  #
0x08, 0x00, 0x00, 0x88, 0x08, 0x80, 0x88, // #    ## ## ##
0x08, 0x00, 0x40, 0x80, 0x04, 0x00, 0x80, // #  $ #  $  # 
0x08, 0x88, 0x40, 0x40, 0x00, 0x88, 0x80, // ###$ $   ### 
0x00, 0x08, 0x00, 0x88, 0x88, 0x80, 0x00, //   #  #####   
0x00, 0x08, 0x88, 0x80, 0x00, 0x00, 0x00, //   ####       
//Level: 113
0x0E, 0x0C,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, // #########    
0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, // #       #    
0x08, 0x04, 0x04, 0x40, 0x48, 0x00, 0x00, // # $ $$ $#    
0x88, 0x80, 0x80, 0x04, 0x08, 0x00, 0x00, //### #  $ #    
0x81, 0x80, 0x00, 0x44, 0x08, 0x80, 0x00, //#.#   $$ ##   
0x81, 0x88, 0x80, 0x00, 0x40, 0x80, 0x00, //#.###   $ #   
0x81, 0x81, 0x04, 0x08, 0x80, 0x88, 0x88, //#.#. $ ## ####
0x81, 0x11, 0x00, 0x48, 0x80, 0x40, 0x08, //#...  $## $  #
0x81, 0x11, 0x40, 0x00, 0x40, 0x00, 0x08, //#...$   $    #
0x81, 0x18, 0x88, 0x48, 0x88, 0x08, 0x28, //#..###$### #@#
0x81, 0x18, 0x08, 0x00, 0x00, 0x08, 0x88, //#..# #     ###
0x88, 0x88, 0x08, 0x88, 0x88, 0x88, 0x00, //#### #######  
//Level: 114
0x07, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x81, 0x14, 0x11, 0x80, //#..$..# 
0x81, 0x18, 0x11, 0x80, //#..#..# 
0x80, 0x44, 0x40, 0x80, //# $$$ # 
0x80, 0x04, 0x00, 0x80, //#  $  # 
0x80, 0x44, 0x40, 0x80, //# $$$ # 
0x80, 0x08, 0x20, 0x80, //#  #@ # 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 115
0x08, 0x0B,//Size x and y
0x00, 0x08, 0x88, 0x88, //   #####
0x00, 0x08, 0x00, 0x08, //   #   #
0x88, 0x88, 0x40, 0x08, //####$  #
0x81, 0x10, 0x40, 0x08, //#.. $  #
0x81, 0x14, 0x00, 0x88, //#..$  ##
0x81, 0x18, 0x04, 0x80, //#..# $# 
0x80, 0x18, 0x40, 0x88, //# .#$ ##
0x88, 0x88, 0x04, 0x08, //#### $ #
0x00, 0x80, 0x40, 0x08, //  # $  #
0x00, 0x80, 0x02, 0x08, //  #  @ #
0x00, 0x88, 0x88, 0x88, //  ######
//Level: 116
0x0C, 0x05,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //############
0x80, 0x00, 0x01, 0x11, 0x04, 0x08, //#    ... $ #
0x80, 0x44, 0x45, 0x55, 0x04, 0x28, //# $$$*** $@#
0x80, 0x00, 0x01, 0x11, 0x04, 0x08, //#    ... $ #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //############
//Level: 117
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x02, 0x00, 0x08, //#  @   #
0x80, 0x88, 0x48, 0x08, //# ##$# #
0x80, 0x40, 0x04, 0x08, //# $  $ #
0x88, 0x40, 0x08, 0x88, //##$  ###
0x08, 0x14, 0x01, 0x80, // #.$ .# 
0x08, 0x11, 0x01, 0x80, // #.. .# 
0x08, 0x88, 0x88, 0x80, // ###### 
//Level: 118
0x08, 0x08,//Size x and y
0x08, 0x88, 0x88, 0x88, // #######
0x88, 0x00, 0x01, 0x08, //##   . #
0x80, 0x40, 0x04, 0x28, //# $  $@#
0x81, 0x41, 0x88, 0x88, //#.$.####
0x80, 0x08, 0x80, 0x00, //#  ##   
0x80, 0x08, 0x00, 0x00, //#  #    
0x80, 0x08, 0x00, 0x00, //#  #    
0x88, 0x88, 0x00, 0x00, //####    
//Level: 119
0x13, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, //              ##### 
0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x80, //     ##########   # 
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, //     #        #   # 
0x00, 0x00, 0x08, 0x00, 0x40, 0x40, 0x00, 0x04, 0x40, 0x80, //     #  $ $    $$ # 
0x00, 0x00, 0x08, 0x08, 0x88, 0x88, 0x08, 0x80, 0x40, 0x80, //     # ##### ## $ # 
0x00, 0x00, 0x08, 0x44, 0x00, 0x08, 0x48, 0x80, 0x40, 0x80, //     #$$   #$## $ # 
0x00, 0x00, 0x08, 0x08, 0x88, 0x08, 0x08, 0x84, 0x00, 0x80, //     # ### # ##$  # 
0x88, 0x88, 0x88, 0x08, 0x88, 0x04, 0x04, 0x00, 0x00, 0x80, //###### ### $ $    # 
0x81, 0x11, 0x10, 0x00, 0x00, 0x00, 0x08, 0x80, 0x00, 0x80, //#....        ##   # 
0x81, 0x11, 0x10, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x80, //#....        ###### 
0x81, 0x11, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, //#....        #      
0x88, 0x88, 0x88, 0x88, 0x88, 0x82, 0x88, 0x00, 0x00, 0x00, //###########@##      
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x80, 0x00, 0x00, 0x00, //          ###       
//Level: 120
0x10, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //##############  
0x80, 0x00, 0x08, 0x88, 0x00, 0x08, 0x18, 0x00, //#    ###   #.#  
0x80, 0x40, 0x00, 0x00, 0x40, 0x08, 0x18, 0x00, //# $     $  #.#  
0x80, 0x40, 0x08, 0x08, 0x00, 0x08, 0x18, 0x80, //# $  # #   #.## 
0x88, 0x08, 0x88, 0x08, 0x84, 0x88, 0x11, 0x88, //## ### ##$##..##
0x80, 0x40, 0x08, 0x48, 0x00, 0x08, 0x02, 0x18, //# $  #$#   # @.#
0x80, 0x04, 0x04, 0x00, 0x04, 0x00, 0x11, 0x18, //#  $ $   $  ...#
0x80, 0x40, 0x08, 0x48, 0x00, 0x08, 0x11, 0x08, //# $  #$#   #.. #
0x88, 0x08, 0x88, 0x08, 0x80, 0x88, 0x11, 0x88, //## ### ## ##..##
0x80, 0x04, 0x08, 0x08, 0x04, 0x08, 0x18, 0x80, //#  $ # # $ #.## 
0x80, 0x44, 0x00, 0x00, 0x04, 0x08, 0x18, 0x00, //# $$     $ #.#  
0x80, 0x00, 0x08, 0x88, 0x00, 0x08, 0x18, 0x00, //#    ###   #.#  
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //##############  
//Level: 121
0x0F, 0x0C,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //      ######### 
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, //      #       # 
0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, //      # # # # # 
0x00, 0x00, 0x00, 0x80, 0x04, 0x04, 0x80, 0x80, //      #  $ $# # 
0x88, 0x88, 0x88, 0x80, 0x00, 0x40, 0x00, 0x80, //#######   $   # 
0x81, 0x18, 0x00, 0x88, 0x04, 0x04, 0x80, 0x80, //#..#  ## $ $# # 
0x81, 0x10, 0x00, 0x88, 0x04, 0x04, 0x00, 0x80, //#..   ## $ $  # 
0x81, 0x18, 0x00, 0x88, 0x08, 0x88, 0x88, 0x80, //#..#  ## ###### 
0x81, 0x18, 0x08, 0x04, 0x04, 0x08, 0x00, 0x00, //#..# # $ $ #    
0x81, 0x10, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, //#..     $  #    
0x80, 0x08, 0x88, 0x02, 0x08, 0x88, 0x00, 0x00, //#  ### @ ###    
0x88, 0x88, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, //#### #####      
//Level: 122
0x0E, 0x0D,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, //     #########
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, //     #       #
0x00, 0x00, 0x08, 0x00, 0x48, 0x48, 0x08, //     #  $#$# #
0x08, 0x88, 0x88, 0x80, 0x08, 0x04, 0x08, // ######  # $ #
0x08, 0x00, 0x08, 0x04, 0x00, 0x40, 0x08, // #   # $  $  #
0x88, 0x04, 0x00, 0x00, 0x08, 0x88, 0x08, //## $     ### #
0x80, 0x00, 0x84, 0x88, 0x88, 0x00, 0x08, //#   #$####   #
0x80, 0x00, 0x04, 0x08, 0x88, 0x08, 0x88, //#    $ ### ###
0x88, 0x88, 0x81, 0x10, 0x28, 0x08, 0x80, //#####.. @# ## 
0x00, 0x08, 0x11, 0x14, 0x04, 0x40, 0x80, //   #...$ $$ # 
0x00, 0x08, 0x11, 0x18, 0x00, 0x00, 0x80, //   #...#    # 
0x00, 0x08, 0x11, 0x18, 0x88, 0x88, 0x80, //   #...###### 
0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, //   #####      
//Level: 123
0x0D, 0x0A,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //     ####     
0x88, 0x88, 0x88, 0x00, 0x88, 0x88, 0x80, //######  ##### 
0x82, 0x40, 0x00, 0x04, 0x00, 0x40, 0x80, //#@$    $  $ # 
0x84, 0x88, 0x80, 0x40, 0x80, 0x80, 0x80, //#$### $ # # # 
0x80, 0x08, 0x00, 0x80, 0x40, 0x00, 0x80, //#  #  # $   # 
0x80, 0x48, 0x00, 0x00, 0x80, 0x88, 0x80, //# $#    # ### 
0x80, 0x04, 0x08, 0x48, 0x00, 0x08, 0x00, //#  $ #$#   #  
0x81, 0x11, 0x11, 0x11, 0x11, 0x08, 0x00, //#......... #  
0x88, 0x88, 0x88, 0x88, 0x00, 0x08, 0x00, //########   #  
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, //       #####  
//Level: 124
0x09, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x82, 0x00, 0x00, 0x00, 0x80, //#@      # 
0x80, 0x41, 0x41, 0x40, 0x80, //# $.$.$ # 
0x80, 0x14, 0x14, 0x10, 0x80, //# .$.$. # 
0x80, 0x41, 0x51, 0x40, 0x80, //# $.*.$ # 
0x80, 0x14, 0x14, 0x10, 0x80, //# .$.$. # 
0x80, 0x41, 0x41, 0x40, 0x80, //# $.$.$ # 
0x80, 0x00, 0x00, 0x00, 0x80, //#       # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 125
0x09, 0x08,//Size x and y
0x08, 0x88, 0x88, 0x80, 0x00, // ######   
0x88, 0x00, 0x12, 0x88, 0x00, //##  .@##  
0x80, 0x50, 0x80, 0x08, 0x80, //# * #  ## 
0x80, 0x00, 0x80, 0x00, 0x80, //#   #   # 
0x80, 0x48, 0x80, 0x80, 0x80, //# $## # # 
0x80, 0x04, 0x04, 0x51, 0x80, //#  $ $*.# 
0x80, 0x01, 0x80, 0x00, 0x80, //#  .#   # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 126
0x13, 0x06,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //################### 
0x80, 0x00, 0x11, 0x10, 0x02, 0x00, 0x11, 0x10, 0x00, 0x80, //#   ...  @  ...   # 
0x80, 0x44, 0x40, 0x08, 0x88, 0x88, 0x00, 0x44, 0x40, 0x80, //# $$$  #####  $$$ # 
0x88, 0x00, 0x08, 0x88, 0x00, 0x08, 0x88, 0x00, 0x08, 0x80, //##   ###   ###   ## 
0x08, 0x80, 0x08, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x00, // ##  #       ##  #  
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, //  ####        ####  
//Level: 127
0x10, 0x10,//Size x and y
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //  ####          
0x00, 0x80, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, //  #  ###########
0x00, 0x80, 0x00, 0x04, 0x00, 0x04, 0x04, 0x08, //  #    $   $ $ #
0x00, 0x80, 0x48, 0x04, 0x08, 0x00, 0x40, 0x08, //  # $# $ #  $  #
0x00, 0x80, 0x04, 0x04, 0x00, 0x80, 0x00, 0x08, //  #  $ $  #    #
0x88, 0x80, 0x48, 0x08, 0x00, 0x88, 0x88, 0x08, //### $# #  #### #
0x82, 0x84, 0x04, 0x04, 0x00, 0x88, 0x00, 0x08, //#@#$ $ $  ##   #
0x80, 0x00, 0x04, 0x08, 0x48, 0x00, 0x08, 0x08, //#    $ #$#   # #
0x80, 0x00, 0x40, 0x00, 0x04, 0x04, 0x04, 0x08, //#   $    $ $ $ #
0x88, 0x88, 0x80, 0x08, 0x88, 0x88, 0x88, 0x88, //#####  #########
0x00, 0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, //  #      #      
0x00, 0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, //  #      #      
0x00, 0x81, 0x11, 0x11, 0x18, 0x00, 0x00, 0x00, //  #......#      
0x00, 0x81, 0x11, 0x11, 0x18, 0x00, 0x00, 0x00, //  #......#      
0x00, 0x81, 0x11, 0x11, 0x18, 0x00, 0x00, 0x00, //  #......#      
0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //  ########      
//Level: 128
0x0B, 0x0B,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x00, //      ####  
0x88, 0x88, 0x88, 0x80, 0x28, 0x00, //####### @#  
0x80, 0x00, 0x00, 0x40, 0x08, 0x00, //#     $  #  
0x80, 0x00, 0x48, 0x80, 0x48, 0x00, //#   $## $#  
0x88, 0x48, 0x11, 0x18, 0x08, 0x00, //##$#...# #  
0x08, 0x04, 0x11, 0x10, 0x08, 0x00, // # $...  #  
0x08, 0x08, 0x10, 0x18, 0x08, 0x80, // # #. .# ## 
0x08, 0x00, 0x08, 0x08, 0x40, 0x80, // #   # #$ # 
0x08, 0x40, 0x04, 0x00, 0x00, 0x80, // #$  $    # 
0x08, 0x00, 0x88, 0x88, 0x88, 0x80, // #  ####### 
0x08, 0x88, 0x80, 0x00, 0x00, 0x00, // ####       
//Level: 129
0x11, 0x10,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //    ############  
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x08, 0x80, //    #          ## 
0x00, 0x00, 0x80, 0x08, 0x08, 0x44, 0x04, 0x00, 0x80, //    #  # #$$ $  # 
0x00, 0x00, 0x84, 0x08, 0x48, 0x00, 0x88, 0x02, 0x80, //    #$ #$#  ## @# 
0x00, 0x08, 0x80, 0x88, 0x08, 0x04, 0x08, 0x08, 0x80, //   ## ## # $ # ## 
0x00, 0x08, 0x00, 0x04, 0x08, 0x40, 0x08, 0x08, 0x00, //   #   $ #$  # #  
0x00, 0x08, 0x00, 0x08, 0x04, 0x00, 0x08, 0x08, 0x00, //   #   # $   # #  
0x00, 0x08, 0x80, 0x40, 0x40, 0x00, 0x88, 0x08, 0x00, //   ## $ $   ## #  
0x00, 0x08, 0x00, 0x80, 0x08, 0x80, 0x04, 0x08, 0x00, //   #  #  ##  $ #  
0x00, 0x08, 0x00, 0x00, 0x88, 0x04, 0x48, 0x08, 0x00, //   #    ## $$# #  
0x88, 0x88, 0x88, 0x44, 0x00, 0x08, 0x00, 0x08, 0x00, //######$$   #   #  
0x81, 0x11, 0x18, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, //#....#  ########  
0x81, 0x81, 0x11, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, //#.#... ##         
0x81, 0x11, 0x10, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //#....   #         
0x81, 0x11, 0x10, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //#....   #         
0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //#########         
//Level: 130
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, //#                ###
0x80, 0x48, 0x00, 0x04, 0x08, 0x80, 0x04, 0x00, 0x00, 0x88, //# $#   $ ##  $    ##
0x80, 0x00, 0x04, 0x88, 0x80, 0x00, 0x08, 0x04, 0x40, 0x88, //#    $###    # $$ ##
0x81, 0x88, 0x80, 0x00, 0x00, 0x40, 0x40, 0x88, 0x00, 0x88, //#.###     $ $ ##  ##
0x81, 0x11, 0x80, 0x08, 0x00, 0x80, 0x00, 0x08, 0x40, 0x08, //#...#  #  #    #$  #
0x81, 0x18, 0x84, 0x48, 0x88, 0x80, 0x40, 0x08, 0x00, 0x08, //#..##$$#### $  #   #
0x81, 0x11, 0x80, 0x00, 0x00, 0x04, 0x08, 0x80, 0x08, 0x88, //#...#      $ ##  ###
0x81, 0x11, 0x40, 0x08, 0x88, 0x00, 0x80, 0x00, 0x08, 0x08, //#...$  ###  #    # #
0x88, 0x11, 0x00, 0x48, 0x00, 0x88, 0x00, 0x08, 0x82, 0x08, //##..  $#  ##   ##@ #
0x88, 0x81, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, //###.#              #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 131
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x81, 0x11, 0x18, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, //#....###           #
0x81, 0x11, 0x18, 0x88, 0x88, 0x08, 0x00, 0x84, 0x80, 0x88, //#....##### #  #$# ##
0x81, 0x11, 0x18, 0x88, 0x00, 0x08, 0x40, 0x04, 0x00, 0x08, //#....###   #$  $   #
0x81, 0x11, 0x18, 0x88, 0x00, 0x00, 0x40, 0x08, 0x44, 0x88, //#....###    $  #$$##
0x88, 0x00, 0x88, 0x88, 0x04, 0x80, 0x08, 0x40, 0x40, 0x08, //##  #### $#  #$ $  #
0x88, 0x00, 0x88, 0x88, 0x00, 0x40, 0x04, 0x00, 0x80, 0x08, //##  ####  $  $  #  #
0x82, 0x00, 0x88, 0x88, 0x48, 0x88, 0x48, 0x80, 0x40, 0x08, //#@  ####$###$## $  #
0x88, 0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0x00, 0x40, 0x08, //##        #  #  $  #
0x88, 0x00, 0x08, 0x88, 0x00, 0x80, 0x04, 0x00, 0x88, 0x88, //##   ###  #  $  ####
0x88, 0x88, 0x88, 0x88, 0x00, 0x80, 0x08, 0x00, 0x00, 0x08, //########  #  #     #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 132
0x0C, 0x07,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, //  ##########
0x88, 0x82, 0x00, 0x10, 0x00, 0x08, //###@  .    #
0x80, 0x00, 0x88, 0x48, 0x80, 0x08, //#   ##$##  #
0x80, 0x04, 0x10, 0x10, 0x14, 0x88, //#  $. . .$##
0x88, 0x04, 0x88, 0x48, 0x80, 0x80, //## $##$## # 
0x08, 0x00, 0x00, 0x10, 0x00, 0x80, // #    .   # 
0x08, 0x88, 0x88, 0x88, 0x88, 0x80, // ########## 
//Level: 133
0x08, 0x07,//Size x and y
0x00, 0x88, 0x88, 0x80, //  ##### 
0x88, 0x80, 0x00, 0x80, //###   # 
0x80, 0x40, 0x80, 0x88, //# $ # ##
0x80, 0x41, 0x41, 0x08, //# $.$. #
0x80, 0x88, 0x10, 0x08, //# ##.  #
0x80, 0x02, 0x08, 0x88, //#  @ ###
0x88, 0x88, 0x88, 0x00, //######  
//Level: 134
0x0A, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x00, //  ######  
0x00, 0x80, 0x00, 0x08, 0x88, //  #    ###
0x00, 0x80, 0x40, 0x00, 0x08, //  # $    #
0x88, 0x80, 0x40, 0x88, 0x08, //### $ ## #
0x81, 0x11, 0x04, 0x00, 0x08, //#... $   #
0x81, 0x11, 0x48, 0x40, 0x88, //#...$#$ ##
0x88, 0x88, 0x08, 0x04, 0x08, //#### # $ #
0x00, 0x08, 0x00, 0x20, 0x08, //   #  @  #
0x00, 0x08, 0x88, 0x88, 0x88, //   #######
//Level: 135
0x13, 0x0F,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //     ####           
0x88, 0x88, 0x88, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //######  #           
0x80, 0x00, 0x04, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //#    $  ########### 
0x80, 0x88, 0x04, 0x00, 0x88, 0x00, 0x80, 0x11, 0x11, 0x80, //# ## $  ##  # ....# 
0x80, 0x40, 0x40, 0x04, 0x00, 0x00, 0x80, 0x11, 0x11, 0x80, //# $ $  $    # ....# 
0x80, 0x80, 0x04, 0x40, 0x88, 0x80, 0x80, 0x11, 0x11, 0x80, //# #  $$ ### # ....# 
0x80, 0x24, 0x40, 0x00, 0x08, 0x80, 0x80, 0x11, 0x11, 0x80, //# @$$    ## # ....# 
0x88, 0x88, 0x00, 0x80, 0x08, 0x00, 0x88, 0x08, 0x88, 0x80, //####  #  #  ## #### 
0x00, 0x08, 0x04, 0x88, 0x88, 0x00, 0x00, 0x08, 0x00, 0x00, //   # $####     #    
0x00, 0x08, 0x40, 0x40, 0x88, 0x88, 0x48, 0x08, 0x00, 0x00, //   #$ $ ####$# #    
0x00, 0x88, 0x08, 0x00, 0x80, 0x08, 0x08, 0x08, 0x00, 0x00, //  ## #  #  # # #    
0x00, 0x80, 0x04, 0x44, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, //  #  $$$       #    
0x00, 0x80, 0x00, 0x00, 0x88, 0x88, 0x80, 0x08, 0x00, 0x00, //  #     #####  #    
0x00, 0x80, 0x08, 0x88, 0x80, 0x00, 0x88, 0x88, 0x00, 0x00, //  #  ####   ####    
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //  ####              
//Level: 136
0x0B, 0x09,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x00, // #########  
0x08, 0x00, 0x08, 0x00, 0x08, 0x00, // #   #   #  
0x08, 0x04, 0x44, 0x44, 0x08, 0x00, // # $$$$$ #  
0x88, 0x04, 0x04, 0x04, 0x08, 0x00, //## $ $ $ #  
0x80, 0x40, 0x02, 0x00, 0x08, 0x00, //# $  @   #  
0x80, 0x40, 0x88, 0x88, 0x08, 0x80, //# $ #### ## 
0x80, 0x08, 0x11, 0x11, 0x10, 0x80, //#  #..... # 
0x88, 0x00, 0x11, 0x11, 0x10, 0x80, //##  ..... # 
0x08, 0x88, 0x88, 0x88, 0x88, 0x80, // ########## 
//Level: 137
0x0E, 0x0B,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //      ####### 
0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x88, //     ##     ##
0x00, 0x00, 0x88, 0x00, 0x48, 0x80, 0x08, //    ##  $##  #
0x00, 0x00, 0x80, 0x08, 0x00, 0x04, 0x08, //    #  #   $ #
0x00, 0x00, 0x80, 0x80, 0x08, 0x08, 0x08, //    # #  # # #
0x00, 0x00, 0x80, 0x40, 0x40, 0x04, 0x08, //    # $ $  $ #
0x88, 0x88, 0x88, 0x80, 0x84, 0x80, 0x08, //####### #$#  #
0x80, 0x04, 0x04, 0x00, 0x00, 0x00, 0x88, //#  $ $      ##
0x82, 0x11, 0x40, 0x55, 0x18, 0x88, 0x80, //#@..$ **.#### 
0x88, 0x11, 0x11, 0x11, 0x88, 0x00, 0x00, //##......##    
0x08, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, // ########     
//Level: 138
0x0D, 0x0B,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //    #####     
0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, //    #   #     
0x08, 0x88, 0x80, 0x80, 0x88, 0x88, 0x80, // #### # ##### 
0x88, 0x00, 0x04, 0x04, 0x00, 0x00, 0x80, //##   $ $    # 
0x80, 0x48, 0x08, 0x11, 0x18, 0x40, 0x80, //# $# #...#$ # 
0x82, 0x40, 0x01, 0x11, 0x80, 0x08, 0x80, //#@$  ...#  ## 
0x80, 0x48, 0x01, 0x18, 0x04, 0x00, 0x80, //# $# ..# $  # 
0x88, 0x00, 0x01, 0x80, 0x00, 0x00, 0x80, //##   .#     # 
0x08, 0x88, 0x04, 0x04, 0x08, 0x00, 0x80, // ### $ $ #  # 
0x00, 0x08, 0x88, 0x00, 0x08, 0x88, 0x80, //   ###   #### 
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //     #####    
//Level: 139
0x09, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x00, 0x00, //######    
0x80, 0x00, 0x28, 0x00, 0x00, //#   @#    
0x80, 0x40, 0x08, 0x88, 0x80, //# $  #### 
0x80, 0x45, 0x11, 0x50, 0x80, //# $*..* # 
0x80, 0x51, 0x15, 0x40, 0x80, //# *..*$ # 
0x88, 0x88, 0x00, 0x40, 0x80, //####  $ # 
0x00, 0x08, 0x00, 0x00, 0x80, //   #    # 
0x00, 0x08, 0x88, 0x88, 0x80, //   ###### 
//Level: 140
0x09, 0x09,//Size x and y
0x08, 0x88, 0x88, 0x80, 0x00, // ######   
0x88, 0x00, 0x00, 0x88, 0x00, //##    ##  
0x80, 0x08, 0x80, 0x08, 0x00, //#  ##  #  
0x80, 0x80, 0x08, 0x08, 0x00, //# #  # #  
0x81, 0x00, 0x18, 0x48, 0x80, //#.  .#$## 
0x80, 0x80, 0x50, 0x40, 0x80, //# # * $ # 
0x80, 0x80, 0x50, 0x42, 0x80, //# # * $@# 
0x80, 0x01, 0x10, 0x40, 0x80, //#  .. $ # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 141
0x0B, 0x09,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x00, // #########  
0x08, 0x00, 0x88, 0x00, 0x08, 0x00, // #  ##   #  
0x08, 0x00, 0x04, 0x00, 0x08, 0x00, // #   $   #  
0x08, 0x40, 0x88, 0x80, 0x48, 0x00, // #$ ### $#  
0x08, 0x08, 0x11, 0x18, 0x08, 0x00, // # #...# #  
0x88, 0x08, 0x11, 0x18, 0x08, 0x80, //## #...# ## 
0x80, 0x40, 0x04, 0x00, 0x40, 0x80, //# $  $  $ # 
0x80, 0x00, 0x00, 0x80, 0x20, 0x80, //#     # @ # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //########### 
//Level: 142
0x0E, 0x0D,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //     #####    
0x00, 0x00, 0x08, 0x20, 0x08, 0x88, 0x80, //     #@  #### 
0x00, 0x88, 0x88, 0x84, 0x00, 0x00, 0x80, //  #####$    # 
0x00, 0x81, 0x11, 0x80, 0x08, 0x04, 0x88, //  #...#  # $##
0x00, 0x81, 0x51, 0x84, 0x08, 0x40, 0x08, //  #.*.#$ #$  #
0x88, 0x81, 0x11, 0x04, 0x08, 0x08, 0x08, //###... $ # # #
0x80, 0x01, 0x18, 0x84, 0x80, 0x00, 0x08, //#  ..##$#    #
0x80, 0x08, 0x88, 0x80, 0x08, 0x04, 0x08, //#  ####  # $ #
0x88, 0x00, 0x04, 0x00, 0x08, 0x44, 0x08, //##   $   #$$ #
0x08, 0x00, 0x88, 0x08, 0x80, 0x00, 0x88, // #  ## ##   ##
0x08, 0x88, 0x88, 0x00, 0x00, 0x00, 0x80, // #####      # 
0x00, 0x00, 0x08, 0x00, 0x88, 0x88, 0x80, //     #  ##### 
0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //     ####     
//Level: 143
0x11, 0x0F,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //         #####    
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x08, 0x00, 0x00, //     #####   #    
0x00, 0x00, 0x88, 0x04, 0x00, 0x40, 0x08, 0x88, 0x80, //    ## $  $  #### 
0x88, 0x88, 0x80, 0x40, 0x04, 0x04, 0x08, 0x81, 0x80, //##### $  $ $ ##.# 
0x80, 0x00, 0x00, 0x00, 0x44, 0x00, 0x88, 0x11, 0x80, //#       $$  ##..# 
0x80, 0x08, 0x88, 0x88, 0x80, 0x88, 0x81, 0x10, 0x80, //#  ###### ###.. # 
0x88, 0x08, 0x00, 0x80, 0x00, 0x08, 0x11, 0x10, 0x80, //## #  #    #... # 
0x80, 0x40, 0x00, 0x80, 0x00, 0x08, 0x11, 0x10, 0x80, //# $   #    #... # 
0x82, 0x08, 0x40, 0x88, 0x08, 0x88, 0x81, 0x11, 0x80, //#@ #$ ## ####...# 
0x88, 0x88, 0x00, 0x40, 0x44, 0x00, 0x88, 0x11, 0x80, //####  $ $$  ##..# 
0x00, 0x08, 0x80, 0x04, 0x04, 0x00, 0x41, 0x11, 0x80, //   ##  $ $  $...# 
0x00, 0x00, 0x80, 0x44, 0x00, 0x40, 0x80, 0x01, 0x80, //    # $$  $ #  .# 
0x00, 0x00, 0x80, 0x00, 0x40, 0x40, 0x08, 0x88, 0x80, //    #   $ $  #### 
0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x08, 0x00, 0x00, //    ######   #    
0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //         #####    
//Level: 144
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x00, 0x01, 0x11, 0x18, 0x00, 0x00, 0x88, 0x88, //#      ....#    ####
0x80, 0x00, 0x00, 0x01, 0x11, 0x10, 0x00, 0x00, 0x00, 0x08, //#      ....        #
0x80, 0x80, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x08, //# # ##########     #
0x80, 0x84, 0x00, 0x08, 0x00, 0x00, 0x00, 0x88, 0x81, 0x18, //# #$   #      ###..#
0x80, 0x04, 0x00, 0x08, 0x44, 0x88, 0x80, 0x00, 0x81, 0x18, //#  $   #$$###   #..#
0x80, 0x40, 0x88, 0x80, 0x40, 0x00, 0x40, 0x00, 0x81, 0x18, //# $ ### $   $   #..#
0x80, 0x40, 0x80, 0x00, 0x40, 0x40, 0x80, 0x08, 0x81, 0x18, //# $ #   $ $ #  ##..#
0x80, 0x08, 0x00, 0x44, 0x08, 0x04, 0x08, 0x80, 0x00, 0x88, //#  #  $$ # $ ##   ##
0x82, 0x88, 0x04, 0x80, 0x04, 0x00, 0x40, 0x00, 0x00, 0x88, //#@## $#  $  $     ##
0x88, 0x00, 0x00, 0x00, 0x08, 0x80, 0x00, 0x80, 0x08, 0x88, //##       ##   #  ###
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 145
0x11, 0x0A,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //################  
0x80, 0x00, 0x00, 0x00, 0x82, 0x08, 0x00, 0x08, 0x00, //#       #@ #   #  
0x80, 0x80, 0x80, 0x80, 0x80, 0x40, 0x04, 0x48, 0x00, //# # # # # $  $$#  
0x80, 0x81, 0x11, 0x80, 0x84, 0x44, 0x00, 0x08, 0x00, //# #...# #$$$   #  
0x80, 0x01, 0x11, 0x80, 0x80, 0x40, 0x04, 0x48, 0x80, //#  ...# # $  $$## 
0x80, 0x88, 0x18, 0x80, 0x80, 0x88, 0x00, 0x00, 0x80, //# ##.## # ##    # 
0x80, 0x81, 0x11, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, //# #...     $    # 
0x80, 0x88, 0x08, 0x88, 0x00, 0x88, 0x88, 0x88, 0x80, //# ## ###  ####### 
0x80, 0x00, 0x08, 0x08, 0x88, 0x80, 0x00, 0x00, 0x00, //#    # ####       
0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //######            
//Level: 146
0x0A, 0x08,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x88, //   #######
0x00, 0x88, 0x00, 0x80, 0x28, //  ##  # @#
0x00, 0x80, 0x00, 0x80, 0x08, //  #   #  #
0x00, 0x84, 0x04, 0x04, 0x08, //  #$ $ $ #
0x00, 0x80, 0x48, 0x80, 0x08, //  # $##  #
0x88, 0x80, 0x40, 0x80, 0x88, //### $ # ##
0x81, 0x11, 0x11, 0x00, 0x80, //#.....  # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 147
0x11, 0x12,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //          ####### 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x11, 0x80, //          #  ...# 
0x00, 0x00, 0x00, 0x88, 0x88, 0x80, 0x01, 0x11, 0x80, //      #####  ...# 
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x11, 0x80, //      #      ...# 
0x00, 0x00, 0x00, 0x80, 0x08, 0x80, 0x01, 0x11, 0x80, //      #  ##  ...# 
0x00, 0x00, 0x00, 0x88, 0x08, 0x80, 0x01, 0x11, 0x80, //      ## ##  ...# 
0x00, 0x00, 0x08, 0x88, 0x08, 0x88, 0x88, 0x88, 0x80, //     ### ######## 
0x00, 0x00, 0x08, 0x04, 0x44, 0x08, 0x80, 0x00, 0x00, //     # $$$ ##     
0x08, 0x88, 0x88, 0x00, 0x40, 0x40, 0x88, 0x88, 0x80, // #####  $ $ ##### 
0x88, 0x00, 0x08, 0x40, 0x40, 0x00, 0x80, 0x00, 0x80, //##   #$ $   #   # 
0x82, 0x04, 0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x80, //#@ $  $    $  $ # 
0x88, 0x88, 0x88, 0x04, 0x40, 0x40, 0x88, 0x88, 0x80, //###### $$ $ ##### 
0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x80, 0x00, 0x00, //     # $    #     
0x00, 0x00, 0x08, 0x88, 0x80, 0x88, 0x80, 0x00, 0x00, //     #### ###     
0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, //        #  #      
0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, //        #  #      
0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, //        #  #      
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, //        ####      
//Level: 148
0x11, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //        ######### 
0x00, 0x00, 0x00, 0x88, 0x80, 0x00, 0x80, 0x00, 0x80, //      ###   #   # 
0x00, 0x00, 0x00, 0x82, 0x40, 0x04, 0x04, 0x40, 0x80, //      #@$  $ $$ # 
0x88, 0x80, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x80, //### ######      # 
0x81, 0x88, 0x80, 0x00, 0x88, 0x00, 0x88, 0x40, 0x80, //#.###   ##  ##$ # 
0x81, 0x11, 0x11, 0x51, 0x00, 0x88, 0x04, 0x00, 0x80, //#.....*.  ## $  # 
0x80, 0x58, 0x80, 0x08, 0x40, 0x80, 0x04, 0x00, 0x80, //# *##  #$ #  $  # 
0x80, 0x00, 0x80, 0x04, 0x00, 0x11, 0x11, 0x11, 0x80, //#   #  $  ......# 
0x88, 0x04, 0x88, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //## $##  ######### 
0x08, 0x04, 0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, // # $ ####         
0x08, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, // # $ $ #          
0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, // #     #          
0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, // #######          
//Level: 149
0x0B, 0x0A,//Size x and y
0x08, 0x88, 0x88, 0x00, 0x00, 0x00, // #####      
0x08, 0x02, 0x08, 0x88, 0x88, 0x80, // # @ ###### 
0x08, 0x08, 0x11, 0x50, 0x00, 0x80, // # #..*   # 
0x08, 0x01, 0x11, 0x80, 0x00, 0x80, // # ...#   # 
0x88, 0x48, 0x80, 0x40, 0x40, 0x80, //##$## $ $ # 
0x80, 0x00, 0x84, 0x88, 0x88, 0x80, //#   #$##### 
0x80, 0x00, 0x40, 0x00, 0x80, 0x00, //#   $   #   
0x88, 0x88, 0x80, 0x80, 0x80, 0x00, //##### # #   
0x00, 0x00, 0x80, 0x00, 0x80, 0x00, //    #   #   
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, //    #####   
//Level: 150
0x07, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x80, 0x01, 0x02, 0x80, //#  . @# 
0x80, 0x41, 0x40, 0x80, //# $.$ # 
0x80, 0x51, 0x40, 0x80, //# *.$ # 
0x81, 0x45, 0x41, 0x80, //#.$*$.# 
0x80, 0x41, 0x50, 0x80, //# $.* # 
0x80, 0x41, 0x40, 0x80, //# $.$ # 
0x80, 0x01, 0x00, 0x80, //#  .  # 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 151
0x09, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x82, 0x00, 0x50, 0x00, 0x80, //#@  *   # 
0x80, 0x41, 0x41, 0x40, 0x80, //# $.$.$ # 
0x80, 0x14, 0x14, 0x10, 0x80, //# .$.$. # 
0x80, 0x01, 0x41, 0x40, 0x80, //#  .$.$ # 
0x80, 0x00, 0x50, 0x00, 0x80, //#   *   # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 152
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x02, 0x88, //#### @##
0x80, 0x05, 0x40, 0x88, //#  *$ ##
0x80, 0x00, 0x00, 0x88, //#     ##
0x88, 0x01, 0x88, 0x88, //## .####
0x88, 0x40, 0x88, 0x88, //##$ ####
0x88, 0x01, 0x88, 0x88, //## .####
0x88, 0x88, 0x88, 0x88, //########
//Level: 153
0x09, 0x0C,//Size x and y
0x08, 0x88, 0x80, 0x00, 0x00, // ####     
0x08, 0x00, 0x88, 0x88, 0x00, // #  ####  
0x08, 0x40, 0x20, 0x08, 0x00, // #$ @  #  
0x88, 0x00, 0x88, 0x48, 0x80, //##  ##$## 
0x80, 0x58, 0x18, 0x00, 0x80, //# *#.#  # 
0x80, 0x11, 0x54, 0x40, 0x80, //# ..*$$ # 
0x80, 0x18, 0x18, 0x00, 0x80, //# .#.#  # 
0x88, 0x00, 0x08, 0x08, 0x80, //##   # ## 
0x08, 0x88, 0x04, 0x00, 0x80, // ### $  # 
0x00, 0x08, 0x08, 0x00, 0x80, //   # #  # 
0x00, 0x08, 0x00, 0x08, 0x80, //   #   ## 
0x00, 0x08, 0x88, 0x88, 0x00, //   #####  
//Level: 154
0x0C, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //############
0x81, 0x11, 0x08, 0x00, 0x00, 0x08, //#... #     #
0x81, 0x10, 0x08, 0x08, 0x80, 0x08, //#..  # ##  #
0x81, 0x10, 0x00, 0x00, 0x80, 0x08, //#..     #  #
0x81, 0x10, 0x08, 0x04, 0x88, 0x08, //#..  # $## #
0x81, 0x11, 0x08, 0x40, 0x40, 0x08, //#... #$ $  #
0x88, 0x88, 0x88, 0x00, 0x44, 0x08, //######  $$ #
0x08, 0x80, 0x04, 0x04, 0x40, 0x08, // ##  $ $$  #
0x08, 0x20, 0x44, 0x40, 0x08, 0x08, // #@ $$$  # #
0x08, 0x80, 0x40, 0x88, 0x00, 0x08, // ## $ ##   #
0x00, 0x80, 0x00, 0x00, 0x00, 0x08, //  #        #
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, //  ##########
//Level: 155
0x0B, 0x0B,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //##########  
0x80, 0x00, 0x00, 0x80, 0x08, 0x00, //#     #  #  
0x80, 0x04, 0x04, 0x80, 0x08, 0x80, //#  $ $#  ## 
0x80, 0x08, 0x81, 0x80, 0x00, 0x80, //#  ##.#   # 
0x88, 0x48, 0x81, 0x88, 0x40, 0x80, //##$##.##$ # 
0x80, 0x41, 0x11, 0x11, 0x00, 0x80, //# $.....  # 
0x82, 0x48, 0x81, 0x88, 0x48, 0x80, //#@$##.##$## 
0x88, 0x08, 0x81, 0x80, 0x00, 0x80, //## ##.#   # 
0x80, 0x00, 0x40, 0x40, 0x00, 0x80, //#   $ $   # 
0x80, 0x00, 0x80, 0x00, 0x88, 0x80, //#   #   ### 
0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //#########   
//Level: 156
0x0F, 0x0C,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //    #####       
0x88, 0x88, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, //#####   #       
0x80, 0x00, 0x40, 0x20, 0x80, 0x00, 0x00, 0x00, //#   $ @ #       
0x80, 0x04, 0x08, 0x18, 0x88, 0x88, 0x00, 0x00, //#  $ #.#####    
0x88, 0x40, 0x88, 0x18, 0x80, 0x08, 0x88, 0x80, //##$ ##.##  #### 
0x08, 0x00, 0x11, 0x11, 0x10, 0x48, 0x00, 0x80, // #  ..... $#  # 
0x08, 0x04, 0x88, 0x18, 0x80, 0x08, 0x40, 0x80, // # $##.##  #$ # 
0x08, 0x00, 0x08, 0x18, 0x80, 0x00, 0x00, 0x80, // #   #.##     # 
0x08, 0x88, 0x04, 0x08, 0x88, 0x88, 0x08, 0x80, // ### $ ##### ## 
0x00, 0x08, 0x08, 0x40, 0x00, 0x00, 0x40, 0x80, //   # #$     $ # 
0x00, 0x08, 0x00, 0x00, 0x88, 0x80, 0x00, 0x80, //   #    ###   # 
0x00, 0x08, 0x88, 0x88, 0x80, 0x88, 0x88, 0x80, //   ###### ##### 
//Level: 157
0x12, 0x10,//Size x and y
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //  ####            
0x00, 0x80, 0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, //  #  #########    
0x08, 0x80, 0x08, 0x80, 0x08, 0x00, 0x08, 0x00, 0x00, // ##  ##  #   #    
0x08, 0x00, 0x48, 0x04, 0x24, 0x00, 0x08, 0x88, 0x80, // #  $# $@$   #### 
0x08, 0x40, 0x04, 0x00, 0x80, 0x40, 0x48, 0x00, 0x88, // #$  $  # $ $#  ##
0x88, 0x00, 0x48, 0x80, 0x84, 0x04, 0x00, 0x00, 0x08, //##  $## #$ $     #
0x80, 0x08, 0x00, 0x80, 0x80, 0x00, 0x44, 0x40, 0x08, //#  #  # #   $$$  #
0x80, 0x40, 0x00, 0x04, 0x00, 0x48, 0x80, 0x88, 0x88, //# $    $  $## ####
0x80, 0x40, 0x40, 0x84, 0x80, 0x08, 0x00, 0x80, 0x00, //# $ $ #$#  #  #   
0x88, 0x00, 0x88, 0x80, 0x08, 0x88, 0x40, 0x80, 0x00, //##  ###  ###$ #   
0x08, 0x00, 0x81, 0x11, 0x10, 0x00, 0x00, 0x80, 0x00, // #  #....     #   
0x08, 0x88, 0x81, 0x11, 0x11, 0x18, 0x88, 0x80, 0x00, // ####......####   
0x00, 0x08, 0x11, 0x11, 0x88, 0x88, 0x00, 0x00, 0x00, //   #....####      
0x00, 0x08, 0x11, 0x18, 0x80, 0x00, 0x00, 0x00, 0x00, //   #...##         
0x00, 0x08, 0x11, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, //   #...#          
0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //   #####          
//Level: 158
0x09, 0x0C,//Size x and y
0x08, 0x88, 0x80, 0x00, 0x00, // ####     
0x08, 0x00, 0x80, 0x00, 0x00, // #  #     
0x08, 0x40, 0x88, 0x80, 0x00, // #$ ###   
0x08, 0x00, 0x02, 0x80, 0x00, // #   @#   
0x88, 0x08, 0x10, 0x88, 0x80, //## #. ### 
0x80, 0x08, 0x51, 0x40, 0x80, //#  #*.$ # 
0x80, 0x44, 0x11, 0x80, 0x80, //# $$..# # 
0x88, 0x08, 0x81, 0x00, 0x80, //## ##.  # 
0x08, 0x04, 0x00, 0x88, 0x80, // # $  ### 
0x08, 0x00, 0x88, 0x80, 0x00, // #  ###   
0x08, 0x00, 0x80, 0x00, 0x00, // #  #     
0x08, 0x88, 0x80, 0x00, 0x00, // ####     
//Level: 159
0x0F, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //        ####### 
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x80, //    #####     # 
0x08, 0x88, 0x80, 0x40, 0x40, 0x40, 0x40, 0x80, // #### $ $ $ $ # 
0x08, 0x00, 0x80, 0x04, 0x08, 0x88, 0x00, 0x80, // #  #  $ ###  # 
0x08, 0x00, 0x00, 0x20, 0x00, 0x08, 0x40, 0x80, // #    @    #$ # 
0x08, 0x08, 0x88, 0x08, 0x88, 0x00, 0x00, 0x80, // # ### ###    # 
0x08, 0x08, 0x11, 0x11, 0x18, 0x04, 0x40, 0x80, // # #.....# $$ # 
0x08, 0x08, 0x11, 0x11, 0x18, 0x00, 0x48, 0x80, // # #.....#  $## 
0x88, 0x48, 0x11, 0x11, 0x14, 0x00, 0x08, 0x00, //##$#.....$   #  
0x80, 0x00, 0x08, 0x80, 0x80, 0x08, 0x88, 0x00, //#    ## #  ###  
0x80, 0x40, 0x40, 0x00, 0x44, 0x08, 0x00, 0x00, //# $ $   $$ #    
0x88, 0x00, 0x88, 0x88, 0x80, 0x08, 0x00, 0x00, //##  #####  #    
0x08, 0x88, 0x80, 0x00, 0x88, 0x88, 0x00, 0x00, // ####   ####    
//Level: 160
0x10, 0x0C,//Size x and y
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //#####           
0x81, 0x11, 0x80, 0x88, 0x88, 0x80, 0x00, 0x00, //#...# #####     
0x81, 0x11, 0x88, 0x80, 0x00, 0x80, 0x00, 0x00, //#...###   #     
0x81, 0x11, 0x10, 0x00, 0x44, 0x88, 0x88, 0x80, //#....   $$##### 
0x81, 0x11, 0x10, 0x08, 0x00, 0x80, 0x00, 0x88, //#....  #  #   ##
0x81, 0x18, 0x48, 0x88, 0x80, 0x84, 0x80, 0x08, //#..#$#### #$#  #
0x88, 0x04, 0x00, 0x80, 0x00, 0x00, 0x44, 0x08, //## $  #     $$ #
0x80, 0x04, 0x80, 0x20, 0x40, 0x44, 0x80, 0x08, //#  $# @ $ $$#  #
0x80, 0x40, 0x40, 0x40, 0x80, 0x00, 0x40, 0x88, //# $ $ $ #   $ ##
0x80, 0x00, 0x80, 0x04, 0x08, 0x80, 0x00, 0x80, //#   #  $ ##   # 
0x88, 0x88, 0x88, 0x00, 0x08, 0x88, 0x88, 0x80, //######   ###### 
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, //     #####      
//Level: 161
0x13, 0x0E,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x80, //           ######## 
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x11, 0x11, 0x80, //           #  ....# 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x11, 0x11, 0x80, //############  ....# 
0x80, 0x00, 0x08, 0x00, 0x40, 0x40, 0x00, 0x11, 0x11, 0x80, //#    #  $ $   ....# 
0x80, 0x44, 0x48, 0x40, 0x04, 0x08, 0x00, 0x11, 0x11, 0x80, //# $$$#$  $ #  ....# 
0x80, 0x04, 0x00, 0x00, 0x04, 0x08, 0x00, 0x11, 0x11, 0x80, //#  $     $ #  ....# 
0x80, 0x44, 0x08, 0x40, 0x40, 0x48, 0x88, 0x88, 0x88, 0x80, //# $$ #$ $ $######## 
0x80, 0x04, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, //#  $ #     #        
0x88, 0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //## #########        
0x80, 0x00, 0x08, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, //#    #    ##        
0x80, 0x00, 0x00, 0x40, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, //#     $   ##        
0x80, 0x04, 0x48, 0x44, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, //#  $$#$$  @#        
0x80, 0x00, 0x08, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, //#    #    ##        
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //###########         
//Level: 162
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x00, 0x80, 0x00, 0x88, 0x88, 0x80, 0x00, 0x08, //#     #   #####    #
0x88, 0x04, 0x00, 0x80, 0x00, 0x88, 0x88, 0x00, 0x40, 0x08, //## $  #   ####  $  #
0x88, 0x88, 0x04, 0x40, 0x00, 0x81, 0x18, 0x00, 0x80, 0x08, //#### $$   #..#  #  #
0x80, 0x04, 0x00, 0x40, 0x08, 0x81, 0x18, 0x88, 0x80, 0x88, //#  $  $  ##..#### ##
0x80, 0x40, 0x00, 0x88, 0x81, 0x11, 0x10, 0x00, 0x44, 0x08, //# $   ###....   $$ #
0x80, 0x08, 0x48, 0x00, 0x01, 0x11, 0x18, 0x08, 0x04, 0x08, //#  #$#   ....# # $ #
0x80, 0x80, 0x08, 0x04, 0x01, 0x18, 0x88, 0x48, 0x00, 0x08, //# #  # $ ..###$#   #
0x80, 0x80, 0x00, 0x40, 0x81, 0x18, 0x00, 0x08, 0x80, 0x08, //# #   $ #..#   ##  #
0x80, 0x00, 0x48, 0x00, 0x88, 0x88, 0x00, 0x08, 0x04, 0x88, //#   $#  ####   # $##
0x80, 0x80, 0x08, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x88, //# #  #    @#      ##
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 163
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x18, 0x88, 0x18, //##.###.#
0x88, 0x08, 0x00, 0x18, //## #  .#
0x88, 0x04, 0x40, 0x28, //## $$ @#
0x88, 0x00, 0x40, 0x08, //##  $  #
0x88, 0x00, 0x80, 0x08, //##  #  #
0x88, 0x00, 0x88, 0x88, //##  ####
0x88, 0x88, 0x88, 0x88, //########
//Level: 164
0x0E, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##############
0x80, 0x00, 0x88, 0x01, 0x11, 0x11, 0x18, //#   ## ......#
0x80, 0x08, 0x88, 0x01, 0x18, 0x18, 0x08, //#  ### ..#.# #
0x80, 0x48, 0x00, 0x11, 0x88, 0x10, 0x18, //# $#  ..##. .#
0x88, 0x08, 0x04, 0x80, 0x80, 0x00, 0x08, //## # $# #    #
0x80, 0x40, 0x04, 0x00, 0x00, 0x80, 0x88, //# $  $    # ##
0x80, 0x48, 0x08, 0x04, 0x88, 0x84, 0x08, //# $# # $###$ #
0x82, 0x08, 0x08, 0x04, 0x00, 0x80, 0x08, //#@ # # $  #  #
0x80, 0x48, 0x08, 0x84, 0x80, 0x84, 0x08, //# $# ##$# #$ #
0x80, 0x40, 0x00, 0x80, 0x00, 0x00, 0x08, //# $   #      #
0x88, 0x80, 0x00, 0x80, 0x88, 0x40, 0x88, //###   # ##$ ##
0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x80, //  #####     # 
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //      ####### 
//Level: 165
0x0F, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#             # 
0x80, 0x41, 0x41, 0x41, 0x41, 0x41, 0x80, 0x80, //# $.$.$.$.$.# # 
0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x80, //# .$.$.$.$.$  # 
0x80, 0x41, 0x41, 0x41, 0x41, 0x41, 0x82, 0x80, //# $.$.$.$.$.#@# 
0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x80, //# .$.$.$.$.$  # 
0x80, 0x41, 0x41, 0x41, 0x41, 0x41, 0x80, 0x80, //# $.$.$.$.$.# # 
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#             # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
//Level: 166
0x0F, 0x0B,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //   #######      
0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, //   #     #      
0x00, 0x08, 0x04, 0x04, 0x08, 0x80, 0x00, 0x00, //   # $ $ ##     
0x00, 0x08, 0x88, 0x88, 0x11, 0x88, 0x88, 0x80, //   #####..##### 
0x88, 0x88, 0x88, 0x11, 0x51, 0x00, 0x40, 0x80, //######..*.  $ # 
0x80, 0x04, 0x24, 0x11, 0x11, 0x84, 0x40, 0x80, //#  $@$....#$$ # 
0x80, 0x00, 0x40, 0x84, 0x88, 0x80, 0x00, 0x80, //#   $ #$###   # 
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x88, 0x80, //#####       ### 
0x00, 0x00, 0x88, 0x80, 0x08, 0x88, 0x80, 0x00, //    ###  ####   
0x00, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, //      #  #      
0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, //      ####      
//Level: 167
0x09, 0x07,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
0x00, 0x80, 0x00, 0x88, 0x80, //  #   ### 
0x88, 0x81, 0x80, 0x00, 0x80, //###.#   # 
0x80, 0x41, 0x40, 0x80, 0x80, //# $.$ # # 
0x80, 0x85, 0x04, 0x00, 0x80, //# #* $  # 
0x82, 0x01, 0x08, 0x88, 0x80, //#@ . #### 
0x88, 0x88, 0x88, 0x00, 0x00, //######    
//Level: 168
0x13, 0x0E,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //    #######         
0x00, 0x00, 0x80, 0x08, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, //    #  #  ####      
0x88, 0x88, 0x80, 0x48, 0x40, 0x80, 0x08, 0x80, 0x00, 0x00, //##### $#$ #  ##     
0x81, 0x10, 0x80, 0x08, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, //#.. #  #  #   #     
0x81, 0x10, 0x80, 0x48, 0x40, 0x80, 0x04, 0x88, 0x88, 0x00, //#.. # $#$ #  $####  
0x81, 0x00, 0x80, 0x00, 0x00, 0x84, 0x00, 0x80, 0x08, 0x00, //#.  #     #$  #  #  
0x81, 0x10, 0x00, 0x48, 0x00, 0x80, 0x40, 0x00, 0x08, 0x00, //#..   $#  # $    #  
0x81, 0x12, 0x80, 0x08, 0x40, 0x84, 0x00, 0x80, 0x08, 0x00, //#..@#  #$ #$  #  #  
0x81, 0x10, 0x80, 0x48, 0x00, 0x00, 0x04, 0x80, 0x08, 0x00, //#.. # $#     $#  #  
0x81, 0x10, 0x80, 0x08, 0x44, 0x84, 0x00, 0x80, 0x08, 0x80, //#.. #  #$$#$  #  ## 
0x81, 0x10, 0x80, 0x48, 0x00, 0x80, 0x04, 0x84, 0x00, 0x80, //#.. # $#  #  $#$  # 
0x81, 0x10, 0x80, 0x08, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, //#.. #  #  #   #   # 
0x88, 0x10, 0x88, 0x88, 0x00, 0x88, 0x88, 0x80, 0x00, 0x80, //##. ####  #####   # 
0x08, 0x88, 0x80, 0x08, 0x88, 0x80, 0x00, 0x88, 0x88, 0x80, // ####  ####   ##### 
//Level: 169
0x10, 0x0E,//Size x and y
0x88, 0x88, 0x80, 0x88, 0x88, 0x00, 0x00, 0x00, //##### ####      
0x81, 0x11, 0x80, 0x80, 0x08, 0x88, 0x80, 0x00, //#...# #  ####   
0x81, 0x11, 0x88, 0x80, 0x04, 0x00, 0x80, 0x00, //#...###  $  #   
0x81, 0x11, 0x18, 0x80, 0x40, 0x04, 0x88, 0x80, //#....## $  $### 
0x88, 0x11, 0x11, 0x88, 0x00, 0x04, 0x00, 0x80, //##....##   $  # 
0x88, 0x81, 0x11, 0x08, 0x80, 0x40, 0x40, 0x80, //###... ## $ $ # 
0x80, 0x88, 0x00, 0x00, 0x80, 0x04, 0x00, 0x80, //# ##    #  $  # 
0x80, 0x08, 0x80, 0x80, 0x88, 0x80, 0x88, 0x88, //#  ## # ### ####
0x80, 0x40, 0x80, 0x84, 0x00, 0x40, 0x00, 0x08, //# $ # #$  $    #
0x80, 0x04, 0x02, 0x04, 0x00, 0x00, 0x40, 0x08, //#  $ @ $    $  #
0x80, 0x00, 0x80, 0x40, 0x44, 0x04, 0x08, 0x88, //#   # $ $$ $ ###
0x80, 0x08, 0x88, 0x88, 0x80, 0x08, 0x88, 0x00, //#  ######  ###  
0x80, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, //# ##    ####    
0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //###             
//Level: 170
0x0D, 0x0D,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //  #########   
0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, //  #       #   
0x08, 0x84, 0x04, 0x04, 0x04, 0x88, 0x00, // ##$ $ $ $##  
0x88, 0x00, 0x40, 0x40, 0x40, 0x08, 0x80, //##  $ $ $  ## 
0x80, 0x40, 0x08, 0x08, 0x00, 0x40, 0x80, //# $  # #  $ # 
0x80, 0x00, 0x81, 0x11, 0x80, 0x00, 0x80, //#   #...#   # 
0x88, 0x08, 0x11, 0x11, 0x18, 0x08, 0x80, //## #.....# ## 
0x08, 0x08, 0x11, 0x11, 0x18, 0x08, 0x00, // # #.....# #  
0x08, 0x00, 0x81, 0x81, 0x80, 0x08, 0x00, // #  #.#.#  #  
0x08, 0x40, 0x40, 0x44, 0x40, 0x48, 0x00, // #$ $ $$$ $#  
0x08, 0x00, 0x80, 0x00, 0x80, 0x08, 0x00, // #  #   #  #  
0x08, 0x88, 0x80, 0x28, 0x88, 0x88, 0x00, // #### @#####  
0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, //    ####      
//Level: 171
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x82, 0x00, 0x00, 0x08, 0x88, 0x00, 0x08, 0x00, 0x80, 0x08, //#@     ###   #  #  #
0x80, 0x80, 0x80, 0x08, 0x00, 0x40, 0x04, 0x00, 0x00, 0x08, //# # #  #  $  $     #
0x88, 0x88, 0x80, 0x00, 0x00, 0x80, 0x40, 0x48, 0x48, 0x08, //#####     # $ $#$# #
0x81, 0x81, 0x18, 0x00, 0x00, 0x88, 0x40, 0x40, 0x00, 0x08, //#.#..#    ##$ $    #
0x81, 0x11, 0x11, 0x00, 0x00, 0x40, 0x00, 0x80, 0x00, 0x88, //#.....    $   #   ##
0x81, 0x11, 0x11, 0x00, 0x00, 0x88, 0x84, 0x88, 0x48, 0x88, //#.....    ###$##$###
0x81, 0x81, 0x18, 0x00, 0x00, 0x40, 0x00, 0x08, 0x00, 0x08, //#.#..#    $    #   #
0x88, 0x88, 0x80, 0x00, 0x00, 0x80, 0x08, 0x40, 0x04, 0x08, //#####     #  #$  $ #
0x88, 0x88, 0x80, 0x08, 0x00, 0x40, 0x00, 0x04, 0x04, 0x08, //#####  #  $    $ $ #
0x88, 0x88, 0x80, 0x08, 0x00, 0x80, 0x08, 0x00, 0x80, 0x08, //#####  #  #  #  #  #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 172
0x0E, 0x0E,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //  ##########  
0x08, 0x80, 0x08, 0x00, 0x80, 0x08, 0x80, // ##  #  #  ## 
0x88, 0x00, 0x48, 0x00, 0x00, 0x00, 0x88, //##  $#      ##
0x80, 0x00, 0x00, 0x04, 0x80, 0x40, 0x08, //#      $# $  #
0x80, 0x44, 0x08, 0x11, 0x80, 0x40, 0x08, //# $$ #..# $  #
0x88, 0x80, 0x83, 0x51, 0x18, 0x80, 0x88, //### #+*..## ##
0x80, 0x00, 0x15, 0x88, 0x11, 0x40, 0x08, //#   .*##..$  #
0x80, 0x04, 0x11, 0x88, 0x51, 0x40, 0x08, //#  $..##*.$  #
0x88, 0x08, 0x81, 0x15, 0x58, 0x08, 0x88, //## ##..**# ###
0x80, 0x44, 0x08, 0x11, 0x80, 0x04, 0x08, //# $$ #..#  $ #
0x80, 0x00, 0x08, 0x00, 0x04, 0x00, 0x08, //#    #   $   #
0x88, 0x00, 0x00, 0x40, 0x84, 0x00, 0x88, //##    $ #$  ##
0x08, 0x80, 0x08, 0x00, 0x80, 0x08, 0x80, // ##  #  #  ## 
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //  ##########  
//Level: 173
0x0F, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#             # 
0x80, 0x40, 0x08, 0x04, 0x08, 0x00, 0x00, 0x80, //# $  # $ #    # 
0x80, 0x40, 0x80, 0x48, 0x40, 0x80, 0x00, 0x80, //# $ # $#$ #   # 
0x80, 0x48, 0x04, 0x00, 0x04, 0x00, 0x00, 0x80, //# $# $   $    # 
0x80, 0x00, 0x40, 0x00, 0x80, 0x48, 0x00, 0x80, //#   $   # $#  # 
0x84, 0x80, 0x40, 0x08, 0x00, 0x40, 0x84, 0x80, //#$# $  #  $ #$# 
0x80, 0x08, 0x40, 0x80, 0x00, 0x40, 0x00, 0x80, //#  #$ #   $   # 
0x80, 0x00, 0x04, 0x00, 0x04, 0x08, 0x40, 0x80, //#    $   $ #$ # 
0x80, 0x00, 0x80, 0x48, 0x40, 0x80, 0x40, 0x80, //#   # $#$ # $ # 
0x80, 0x00, 0x08, 0x04, 0x08, 0x00, 0x40, 0x80, //#    # $ #  $ # 
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#             # 
0x80, 0x88, 0x88, 0x82, 0x88, 0x88, 0x80, 0x80, //# #####@##### # 
0x81, 0x11, 0x11, 0x01, 0x11, 0x11, 0x11, 0x80, //#..... .......# 
0x81, 0x11, 0x11, 0x01, 0x11, 0x11, 0x11, 0x80, //#..... .......# 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
//Level: 174
0x0A, 0x0C,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x88, //   #######
0x08, 0x88, 0x00, 0x00, 0x08, // ###     #
0x88, 0x00, 0x08, 0x08, 0x08, //##   # # #
0x80, 0x08, 0x14, 0x44, 0x08, //#  #.$$$ #
0x80, 0x81, 0x58, 0x08, 0x88, //# #.*# ###
0x80, 0x01, 0x18, 0x08, 0x00, //#  ..# #  
0x88, 0x81, 0x14, 0x08, 0x80, //###..$ ## 
0x00, 0x81, 0x80, 0x40, 0x80, //  #.# $ # 
0x08, 0x80, 0x80, 0x82, 0x80, // ## # #@# 
0x08, 0x04, 0x00, 0x40, 0x80, // # $  $ # 
0x08, 0x00, 0x00, 0x08, 0x80, // #     ## 
0x08, 0x88, 0x88, 0x88, 0x00, // #######  
//Level: 175
0x0A, 0x09,//Size x and y
0x08, 0x88, 0x80, 0x00, 0x00, // ####     
0x08, 0x00, 0x88, 0x88, 0x80, // #  ##### 
0x88, 0x40, 0x88, 0x00, 0x80, //##$ ##  # 
0x80, 0x04, 0x24, 0x00, 0x80, //#  $@$  # 
0x80, 0x00, 0x88, 0x40, 0x80, //#   ##$ # 
0x88, 0x81, 0x88, 0x08, 0x88, //###.## ###
0x08, 0x11, 0x14, 0x04, 0x08, // #...$ $ #
0x08, 0x81, 0x10, 0x00, 0x08, // ##..    #
0x00, 0x88, 0x88, 0x88, 0x88, //  ########
//Level: 176
0x0B, 0x09,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //   #####    
0x00, 0x08, 0x02, 0x08, 0x00, 0x00, //   # @ #    
0x00, 0x08, 0x04, 0x08, 0x00, 0x00, //   # $ #    
0x00, 0x08, 0x41, 0x48, 0x00, 0x00, //   #$.$#    
0x00, 0x88, 0x14, 0x18, 0x80, 0x00, //  ##.$.##   
0x88, 0x81, 0x41, 0x41, 0x88, 0x80, //###.$.$.### 
0x80, 0x04, 0x14, 0x14, 0x00, 0x80, //#  $.$.$  # 
0x80, 0x00, 0x01, 0x00, 0x00, 0x80, //#    .    # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //########### 
//Level: 177
0x0B, 0x0B,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //   #####    
0x00, 0x08, 0x00, 0x08, 0x00, 0x00, //   #   #    
0x00, 0x08, 0x04, 0x48, 0x00, 0x00, //   # $$#    
0x88, 0x88, 0x01, 0x08, 0x88, 0x80, //#### . #### 
0x80, 0x40, 0x51, 0x50, 0x00, 0x80, //# $ *.*   # 
0x80, 0x41, 0x11, 0x11, 0x40, 0x80, //# $.....$ # 
0x80, 0x00, 0x51, 0x50, 0x40, 0x80, //#   *.* $ # 
0x88, 0x88, 0x01, 0x08, 0x88, 0x80, //#### . #### 
0x00, 0x08, 0x44, 0x48, 0x00, 0x00, //   #$$$#    
0x00, 0x08, 0x02, 0x08, 0x00, 0x00, //   # @ #    
0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //   #####    
//Level: 178
0x08, 0x08,//Size x and y
0x00, 0x88, 0x88, 0x80, //  ##### 
0x88, 0x80, 0x00, 0x88, //###   ##
0x80, 0x01, 0x05, 0x08, //#  . * #
0x80, 0x14, 0x18, 0x28, //# .$.#@#
0x88, 0x08, 0x04, 0x08, //## # $ #
0x08, 0x04, 0x08, 0x08, // # $ # #
0x08, 0x88, 0x00, 0x08, // ###   #
0x00, 0x08, 0x88, 0x88, //   #####
//Level: 179
0x08, 0x08,//Size x and y
0x88, 0x88, 0x80, 0x00, //#####   
0x80, 0x00, 0x88, 0x88, //#   ####
0x80, 0x44, 0x00, 0x08, //# $$   #
0x80, 0x18, 0x10, 0x08, //# .#.  #
0x80, 0x08, 0x80, 0x88, //#  ## ##
0x80, 0x08, 0x84, 0x80, //#  ##$# 
0x80, 0x20, 0x01, 0x80, //# @  .# 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 180
0x14, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //       ####         
0x88, 0x88, 0x88, 0x88, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //########  #####     
0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, //#         #   #     
0x80, 0x00, 0x08, 0x08, 0x80, 0x08, 0x00, 0x88, 0x88, 0x00, //#    # ##  #  ####  
0x88, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x08, 0x88, //##  #     #      ###
0x08, 0x00, 0x08, 0x80, 0x00, 0x80, 0x44, 0x48, 0x00, 0x08, // #   ##   # $$$#   #
0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x04, 0x04, 0x08, // #         #   $ $ #
0x08, 0x00, 0x80, 0x08, 0x08, 0x08, 0x48, 0x02, 0x80, 0x88, // #  #  # # #$# @# ##
0x08, 0x88, 0x80, 0x04, 0x04, 0x08, 0x00, 0x04, 0x00, 0x80, // ####  $ $ #   $  # 
0x00, 0x80, 0x40, 0x88, 0x88, 0x80, 0x88, 0x80, 0x48, 0x80, //  # $ ##### ### $## 
0x00, 0x80, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x08, 0x00, //  #  ........... #  
0x00, 0x88, 0x80, 0x08, 0x88, 0x88, 0x88, 0x00, 0x88, 0x00, //  ###  #######  ##  
0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, //    ####     ####   
//Level: 181
0x0A, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x00, 0x00, //######    
0x80, 0x00, 0x08, 0x00, 0x00, //#    #    
0x80, 0x04, 0x08, 0x88, 0x80, //#  $ #### 
0x80, 0x44, 0x08, 0x00, 0x88, //# $$ #  ##
0x80, 0x80, 0x88, 0x40, 0x08, //# # ##$  #
0x81, 0x11, 0x00, 0x11, 0x08, //#...  .. #
0x88, 0x88, 0x88, 0x80, 0x88, //####### ##
0x80, 0x00, 0x88, 0x00, 0x08, //#   ##   #
0x82, 0x40, 0x00, 0x14, 0x08, //#@$   .$ #
0x80, 0x00, 0x88, 0x00, 0x08, //#   ##   #
0x80, 0x00, 0x88, 0x88, 0x88, //#   ######
0x88, 0x88, 0x80, 0x00, 0x00, //#####     
//Level: 182
0x13, 0x0D,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //   #########        
0x00, 0x88, 0x00, 0x08, 0x80, 0x08, 0x88, 0x88, 0x80, 0x00, //  ##   ##  ######   
0x88, 0x80, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x88, 0x80, //###     #  #    ### 
0x80, 0x04, 0x08, 0x40, 0x80, 0x08, 0x00, 0x11, 0x10, 0x80, //#  $ #$ #  #  ... # 
0x80, 0x80, 0x48, 0x24, 0x88, 0x08, 0x08, 0x18, 0x10, 0x80, //# # $#@$## # #.#. # 
0x80, 0x08, 0x08, 0x40, 0x08, 0x00, 0x00, 0x10, 0x10, 0x80, //#  # #$  #    . . # 
0x80, 0x40, 0x00, 0x04, 0x08, 0x08, 0x08, 0x18, 0x10, 0x80, //# $    $ # # #.#. # 
0x80, 0x00, 0x88, 0x00, 0x88, 0x40, 0x40, 0x10, 0x10, 0x80, //#   ##  ##$ $ . . # 
0x80, 0x40, 0x80, 0x00, 0x80, 0x08, 0x48, 0x18, 0x10, 0x80, //# $ #   #  #$#.#. # 
0x88, 0x04, 0x00, 0x40, 0x00, 0x40, 0x04, 0x11, 0x10, 0x80, //## $  $   $  $... # 
0x08, 0x40, 0x88, 0x88, 0x88, 0x00, 0x00, 0x88, 0x00, 0x80, // #$ ######    ##  # 
0x08, 0x00, 0x80, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x80, // #  #    ########## 
0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ####               
//Level: 183
0x11, 0x0F,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //################# 
0x80, 0x00, 0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x80, //#       #.......# 
0x80, 0x44, 0x40, 0x80, 0x41, 0x81, 0x11, 0x11, 0x80, //# $$$ # $.#.....# 
0x80, 0x08, 0x04, 0x01, 0x11, 0x11, 0x18, 0x11, 0x80, //#  # $ ......#..# 
0x80, 0x40, 0x08, 0x08, 0x88, 0x18, 0x11, 0x00, 0x80, //# $  # ###.#..  # 
0x80, 0x04, 0x04, 0x40, 0x80, 0x00, 0x00, 0x00, 0x80, //#  $ $$ #       # 
0x80, 0x08, 0x04, 0x00, 0x04, 0x40, 0x08, 0x00, 0x80, //#  # $   $$  #  # 
0x80, 0x88, 0x00, 0x80, 0x80, 0x80, 0x08, 0x80, 0x80, //# ##  # # #  ## # 
0x80, 0x40, 0x48, 0x80, 0x80, 0x88, 0x00, 0x00, 0x80, //# $ $## # ##    # 
0x80, 0x42, 0x40, 0x40, 0x80, 0x00, 0x00, 0x00, 0x80, //# $@$ $ #       # 
0x80, 0x40, 0x40, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, //# $ $   #       # 
0x80, 0x08, 0x84, 0x40, 0x80, 0x08, 0x80, 0x00, 0x80, //#  ##$$ #  ##   # 
0x80, 0x44, 0x00, 0x40, 0x80, 0x00, 0x00, 0x00, 0x80, //# $$  $ #       # 
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#               # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //################# 
//Level: 184
0x0F, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //#############   
0x81, 0x11, 0x18, 0x00, 0x88, 0x00, 0x80, 0x00, //#....#  ##  #   
0x81, 0x10, 0x18, 0x04, 0x04, 0x40, 0x80, 0x00, //#.. .# $ $$ #   
0x81, 0x11, 0x11, 0x20, 0x88, 0x00, 0x80, 0x00, //#.....@ ##  #   
0x81, 0x11, 0x18, 0x80, 0x80, 0x08, 0x80, 0x00, //#....## #  ##   
0x88, 0x18, 0x88, 0x84, 0x80, 0x08, 0x00, 0x00, //##.####$#  #    
0x80, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, //#  #       #    
0x80, 0x40, 0x04, 0x08, 0x88, 0x48, 0x88, 0x80, //# $  $ ###$#### 
0x88, 0x08, 0x88, 0x00, 0x00, 0x40, 0x00, 0x80, //## ###    $   # 
0x80, 0x40, 0x80, 0x48, 0x08, 0x80, 0x40, 0x80, //# $ # $# ## $ # 
0x80, 0x00, 0x04, 0x00, 0x40, 0x88, 0x08, 0x80, //#    $  $ ## ## 
0x88, 0x88, 0x88, 0x80, 0x04, 0x88, 0x08, 0x80, //#######  $## ## 
0x00, 0x00, 0x88, 0x84, 0x04, 0x00, 0x00, 0x80, //    ###$ $    # 
0x00, 0x00, 0x80, 0x00, 0x04, 0x80, 0x00, 0x80, //    #    $#   # 
0x00, 0x00, 0x80, 0x00, 0x00, 0x88, 0x88, 0x80, //    #     ##### 
0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //    #######     
//Level: 185
0x0B, 0x0A,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x80, //     ###### 
0x08, 0x88, 0x88, 0x10, 0x00, 0x80, // #####.   # 
0x08, 0x00, 0x81, 0x18, 0x80, 0x80, // #  #..## # 
0x08, 0x00, 0x41, 0x10, 0x00, 0x80, // #  $..   # 
0x08, 0x00, 0x80, 0x18, 0x08, 0x80, // #  # .# ## 
0x88, 0x80, 0x88, 0x48, 0x00, 0x80, //### ##$#  # 
0x80, 0x40, 0x00, 0x04, 0x40, 0x80, //# $    $$ # 
0x80, 0x84, 0x80, 0x08, 0x00, 0x80, //# #$#  #  # 
0x82, 0x00, 0x88, 0x88, 0x88, 0x80, //#@  ####### 
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //#####       
//Level: 186
0x07, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x82, 0x05, 0x00, 0x80, //#@ *  # 
0x80, 0x41, 0x04, 0x80, //# $. $# 
0x84, 0x05, 0x00, 0x80, //#$ *  # 
0x81, 0x51, 0x51, 0x80, //#.*.*.# 
0x80, 0x01, 0x40, 0x80, //#  .$ # 
0x80, 0x41, 0x40, 0x80, //# $.$ # 
0x80, 0x05, 0x00, 0x80, //#  *  # 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 187
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x80, 0x08, 0x28, 0x08, 0x80, 0x08, 0x88, 0x88, //#   #  #@# ##  #####
0x80, 0x80, 0x80, 0x04, 0x00, 0x00, 0x40, 0x08, 0x88, 0x88, //# # #  $    $  #####
0x80, 0x80, 0x00, 0x08, 0x88, 0x88, 0x80, 0x40, 0x08, 0x88, //# #    ###### $  ###
0x80, 0x00, 0x80, 0x08, 0x11, 0x11, 0x80, 0x04, 0x40, 0x08, //#   #  #....#  $$  #
0x88, 0x48, 0x84, 0x88, 0x11, 0x11, 0x80, 0x00, 0x00, 0x08, //##$##$##....#      #
0x80, 0x00, 0x00, 0x08, 0x11, 0x11, 0x88, 0x48, 0x84, 0x88, //#      #....##$##$##
0x80, 0x04, 0x40, 0x08, 0x11, 0x11, 0x80, 0x00, 0x00, 0x08, //#  $$  #....#      #
0x80, 0x40, 0x04, 0x00, 0x80, 0x08, 0x00, 0x88, 0x80, 0x08, //# $  $  #  #  ###  #
0x88, 0x88, 0x80, 0x04, 0x00, 0x04, 0x00, 0x00, 0x40, 0x08, //#####  $   $    $  #
0x88, 0x88, 0x80, 0x80, 0x00, 0x08, 0x00, 0x80, 0x00, 0x88, //##### #    #  #   ##
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 188
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x08, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x88, //#  #      #   #   ##
0x80, 0x48, 0x04, 0x04, 0x08, 0x81, 0x11, 0x40, 0x04, 0x08, //# $# $ $ ##...$  $ #
0x80, 0x04, 0x00, 0x80, 0x88, 0x11, 0x11, 0x80, 0x40, 0x08, //#  $  # ##....# $  #
0x80, 0x88, 0x04, 0x08, 0x81, 0x11, 0x18, 0x00, 0x04, 0x08, //# ## $ ##....#   $ #
0x80, 0x40, 0x00, 0x08, 0x11, 0x11, 0x88, 0x04, 0x00, 0x08, //# $    #....## $   #
0x80, 0x48, 0x80, 0x08, 0x11, 0x18, 0x00, 0x00, 0x00, 0x08, //# $##  #...#       #
0x80, 0x00, 0x44, 0x48, 0x84, 0x88, 0x00, 0x88, 0x80, 0x88, //#   $$$##$##  ### ##
0x80, 0x80, 0x80, 0x08, 0x00, 0x08, 0x00, 0x80, 0x00, 0x08, //# # #  #   #  #    #
0x80, 0x40, 0x80, 0x04, 0x00, 0x88, 0x00, 0x00, 0x00, 0x08, //# $ #  $  ##       #
0x80, 0x00, 0x08, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x08, //#    #    #@       #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 189
0x0F, 0x0E,//Size x and y
0x88, 0x88, 0x80, 0x00, 0x00, 0x08, 0x88, 0x80, //#####      #### 
0x82, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x80, //#@  ########  # 
0x88, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x80, //## $       $  # 
0x08, 0x08, 0x08, 0x00, 0x88, 0x88, 0x00, 0x80, // # # #  ####  # 
0x08, 0x00, 0x40, 0x00, 0x88, 0x88, 0x48, 0x80, // #  $   ####$## 
0x08, 0x40, 0x88, 0x08, 0x04, 0x04, 0x08, 0x00, // #$ ## # $ $ #  
0x88, 0x04, 0x00, 0x48, 0x00, 0x00, 0x08, 0x00, //## $  $#     #  
0x80, 0x00, 0x80, 0x00, 0x00, 0x08, 0x08, 0x00, //#   #      # #  
0x80, 0x00, 0x88, 0x88, 0x84, 0x88, 0x88, 0x00, //#   #####$####  
0x88, 0x88, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, //#####   #   #   
0x00, 0x00, 0x81, 0x11, 0x00, 0x40, 0x80, 0x00, //    #...  $ #   
0x00, 0x00, 0x81, 0x11, 0x18, 0x00, 0x80, 0x00, //    #....#  #   
0x00, 0x00, 0x81, 0x11, 0x18, 0x88, 0x80, 0x00, //    #....####   
0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //    ######      
//Level: 190
0x14, 0x10,//Size x and y
0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ####               
0x88, 0x00, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //##  ###             
0x82, 0x40, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //#@$   #             
0x88, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //### $ #             
0x08, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, // #  #######         
0x08, 0x00, 0x40, 0x11, 0x11, 0x88, 0x88, 0x00, 0x00, 0x00, // #  $ ....####      
0x08, 0x00, 0x88, 0x81, 0x11, 0x00, 0x08, 0x88, 0x88, 0x80, // #  ###...   ###### 
0x08, 0x80, 0x88, 0x01, 0x11, 0x80, 0x08, 0x00, 0x00, 0x88, // ## ## ...#  #    ##
0x08, 0x04, 0x88, 0x01, 0x11, 0x80, 0x88, 0x00, 0x40, 0x08, // # $## ...# ##  $  #
0x08, 0x00, 0x00, 0x88, 0x88, 0x80, 0x88, 0x80, 0x84, 0x08, // #    ##### ### #$ #
0x08, 0x00, 0x80, 0x08, 0x08, 0x80, 0x80, 0x00, 0x80, 0x08, // #  #  # ## #   #  #
0x08, 0x88, 0x88, 0x00, 0x00, 0x80, 0x84, 0x08, 0x04, 0x08, // #####    # #$ # $ #
0x00, 0x00, 0x08, 0x80, 0x80, 0x00, 0x00, 0x40, 0x40, 0x08, //     ## #     $ $  #
0x00, 0x00, 0x00, 0x88, 0x80, 0x00, 0x84, 0x04, 0x04, 0x08, //      ###   #$ $ $ #
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x80, 0x08, //        #####   #  #
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, //            ########
//Level: 191
0x0F, 0x0D,//Size x and y
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //####            
0x80, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //#  #            
0x80, 0x08, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //#  ##########   
0x80, 0x00, 0x08, 0x80, 0x00, 0x00, 0x80, 0x00, //#    ##     #   
0x81, 0x18, 0x00, 0x00, 0x44, 0x80, 0x80, 0x00, //#..#    $$# #   
0x81, 0x10, 0x08, 0x80, 0x00, 0x40, 0x88, 0x80, //#..  ##   $ ### 
0x81, 0x18, 0x00, 0x88, 0x48, 0x04, 0x00, 0x80, //#..#  ##$# $  # 
0x81, 0x10, 0x00, 0x80, 0x24, 0x04, 0x00, 0x80, //#..   # @$ $  # 
0x81, 0x18, 0x00, 0x80, 0x40, 0x40, 0x00, 0x80, //#..#  # $ $   # 
0x80, 0x10, 0x00, 0x80, 0x40, 0x40, 0x88, 0x80, //# .   # $ $ ### 
0x80, 0x08, 0x00, 0x80, 0x00, 0x88, 0x80, 0x00, //#  #  #   ###   
0x80, 0x08, 0x00, 0x00, 0x88, 0x80, 0x00, 0x00, //#  #    ###     
0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //#########       
//Level: 192
0x08, 0x07,//Size x and y
0x00, 0x08, 0x88, 0x88, //   #####
0x88, 0x88, 0x01, 0x08, //#### . #
0x80, 0x52, 0x01, 0x08, //# *@ . #
0x80, 0x40, 0x80, 0x08, //# $ #  #
0x80, 0x80, 0x04, 0x08, //# #  $ #
0x80, 0x00, 0x88, 0x88, //#   ####
0x88, 0x88, 0x80, 0x00, //#####   
//Level: 193
0x13, 0x0B,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //        #######     
0x00, 0x00, 0x88, 0x88, 0x80, 0x08, 0x00, 0x88, 0x88, 0x00, //    #####  #  ####  
0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x00, 0x08, 0x00, //    #   #   $    #  
0x08, 0x88, 0x80, 0x84, 0x40, 0x88, 0x08, 0x80, 0x08, 0x00, // #### #$$ ## ##  #  
0x88, 0x00, 0x00, 0x00, 0x80, 0x80, 0x08, 0x80, 0x88, 0x80, //##      # #  ## ### 
0x80, 0x08, 0x88, 0x04, 0x84, 0x00, 0x40, 0x04, 0x00, 0x80, //#  ### $#$  $  $  # 
0x81, 0x11, 0x00, 0x00, 0x80, 0x88, 0x00, 0x80, 0x00, 0x80, //#...    # ##  #   # 
0x81, 0x11, 0x80, 0x00, 0x02, 0x08, 0x08, 0x88, 0x08, 0x80, //#...#    @ # ### ## 
0x81, 0x11, 0x80, 0x08, 0x88, 0x00, 0x40, 0x04, 0x00, 0x80, //#...#  ###  $  $  # 
0x88, 0x88, 0x88, 0x88, 0x08, 0x80, 0x00, 0x80, 0x00, 0x80, //######## ##   #   # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //          ######### 
//Level: 194
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x80, 0x01, 0x88, //###  .##
0x80, 0x40, 0x80, 0x88, //# $ # ##
0x80, 0x54, 0x00, 0x88, //# *$  ##
0x80, 0x18, 0x20, 0x88, //# .#@ ##
0x80, 0x00, 0x08, 0x88, //#    ###
0x80, 0x00, 0x88, 0x88, //#   ####
0x88, 0x88, 0x88, 0x88, //########
//Level: 195
0x10, 0x0F,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //    ######      
0x00, 0x00, 0x80, 0x00, 0x08, 0x00, 0x00, 0x00, //    #    #      
0x00, 0x88, 0x80, 0x88, 0x08, 0x00, 0x00, 0x00, //  ### ## #      
0x88, 0x80, 0x04, 0x00, 0x48, 0x88, 0x88, 0x88, //###  $  $#######
0x80, 0x00, 0x40, 0x40, 0x08, 0x00, 0x11, 0x18, //#   $ $  #  ...#
0x80, 0x84, 0x08, 0x00, 0x48, 0x00, 0x11, 0x18, //# #$ #  $#  ...#
0x80, 0x80, 0x08, 0x40, 0x00, 0x00, 0x11, 0x18, //# #  #$     ...#
0x80, 0x84, 0x08, 0x00, 0x08, 0x00, 0x11, 0x18, //# #$ #   #  ...#
0x80, 0x80, 0x48, 0x04, 0x48, 0x00, 0x11, 0x18, //# # $# $$#  ...#
0x80, 0x82, 0x08, 0x40, 0x08, 0x88, 0x88, 0x88, //# #@ #$  #######
0x80, 0x80, 0x40, 0x40, 0x88, 0x00, 0x00, 0x00, //# # $ $ ##      
0x80, 0x80, 0x04, 0x00, 0x80, 0x00, 0x00, 0x00, //# #  $  #       
0x80, 0x88, 0x80, 0x88, 0x80, 0x00, 0x00, 0x00, //# ### ###       
0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //#     #         
0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //#######         
//Level: 196
0x0C, 0x0C,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, //       #####
0x00, 0x88, 0x88, 0x88, 0x00, 0x08, //  ######   #
0x88, 0x80, 0x00, 0x01, 0x04, 0x08, //###    . $ #
0x80, 0x40, 0x08, 0x41, 0x84, 0x88, //# $  #$.#$##
0x80, 0x08, 0x00, 0x21, 0x80, 0x08, //#  #  @.#  #
0x88, 0x08, 0x88, 0x81, 0x00, 0x08, //## ####.   #
0x08, 0x04, 0x00, 0x85, 0x88, 0x88, // # $  #*####
0x08, 0x08, 0x80, 0x81, 0x00, 0x80, // # ## #.  # 
0x08, 0x00, 0x00, 0x01, 0x80, 0x80, // #     .# # 
0x08, 0x88, 0x40, 0x00, 0x00, 0x80, // ###$     # 
0x00, 0x08, 0x00, 0x88, 0x88, 0x80, //   #  ##### 
0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //   ####     
//Level: 197
0x0E, 0x0D,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x80, //   ########## 
0x88, 0x88, 0x11, 0x11, 0x11, 0x00, 0x80, //####......  # 
0x80, 0x00, 0x11, 0x11, 0x18, 0x00, 0x80, //#   .....#  # 
0x80, 0x08, 0x11, 0x11, 0x11, 0x08, 0x80, //#  #...... ## 
0x88, 0x08, 0x88, 0x84, 0x88, 0x48, 0x00, //## ####$##$#  
0x82, 0x40, 0x04, 0x04, 0x00, 0x08, 0x88, //#@$  $ $   ###
0x80, 0x44, 0x00, 0x00, 0x88, 0x00, 0x08, //# $$    ##   #
0x80, 0x80, 0x04, 0x48, 0x80, 0x08, 0x08, //# #  $$##  # #
0x80, 0x00, 0x40, 0x08, 0x04, 0x40, 0x08, //#   $  # $$  #
0x80, 0x04, 0x00, 0x40, 0x00, 0x84, 0x08, //#  $  $   #$ #
0x88, 0x88, 0x00, 0x08, 0x04, 0x04, 0x08, //####   # $ $ #
0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x08, //   #   #     #
0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, //   ###########
//Level: 198
0x0F, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //########        
0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, //#      #        
0x80, 0x44, 0x00, 0x08, 0x88, 0x00, 0x00, 0x00, //# $$   ###      
0x80, 0x04, 0x04, 0x44, 0x08, 0x88, 0x88, 0x00, //#  $ $$$ #####  
0x88, 0x08, 0x80, 0x11, 0x10, 0x00, 0x08, 0x80, //## ## ...    ## 
0x08, 0x08, 0x28, 0x11, 0x18, 0x88, 0x40, 0x80, // # #@#...###$ # 
0x08, 0x08, 0x04, 0x11, 0x10, 0x00, 0x00, 0x80, // # # $...     # 
0x88, 0x08, 0x04, 0x11, 0x14, 0x08, 0x08, 0x80, //## # $...$ # ## 
0x80, 0x08, 0x88, 0x88, 0x08, 0x88, 0x08, 0x00, //#  ##### ### #  
0x80, 0x00, 0x00, 0x04, 0x00, 0x04, 0x08, 0x00, //#      $   $ #  
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x08, 0x00, //###########  #  
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, //          ####  
//Level: 199
0x13, 0x0D,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, //     ###########    
0x00, 0x00, 0x08, 0x00, 0x10, 0x08, 0x00, 0x08, 0x00, 0x00, //     #  .  #   #    
0x00, 0x00, 0x08, 0x08, 0x10, 0x00, 0x02, 0x08, 0x00, 0x00, //     # #.    @ #    
0x08, 0x88, 0x88, 0x08, 0x81, 0x18, 0x08, 0x88, 0x80, 0x00, // ##### ##..# ####   
0x88, 0x00, 0x80, 0x11, 0x88, 0x80, 0x00, 0x00, 0x88, 0x80, //##  # ..###     ### 
0x80, 0x40, 0x81, 0x11, 0x00, 0x04, 0x08, 0x00, 0x40, 0x80, //# $ #...   $ #  $ # 
0x80, 0x00, 0x01, 0x10, 0x88, 0x00, 0x88, 0x08, 0x80, 0x80, //#    .. ##  ## ## # 
0x88, 0x88, 0x48, 0x84, 0x80, 0x40, 0x80, 0x00, 0x80, 0x80, //####$##$# $ #   # # 
0x00, 0x88, 0x08, 0x00, 0x00, 0x84, 0x04, 0x40, 0x80, 0x80, //  ## #    #$ $$ # # 
0x00, 0x80, 0x04, 0x08, 0x08, 0x00, 0x80, 0x48, 0x80, 0x80, //  #  $ # #  # $## # 
0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //  #               # 
0x00, 0x80, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x80, //  #  ###########  # 
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x80, //  ####         #### 
//Level: 200
0x0F, 0x0C,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, // #######        
0x08, 0x00, 0x80, 0x08, 0x88, 0x88, 0x00, 0x00, // #  #  #####    
0x88, 0x00, 0x80, 0x08, 0x11, 0x18, 0x88, 0x00, //##  #  #...###  
0x80, 0x04, 0x80, 0x08, 0x11, 0x10, 0x08, 0x00, //#  $#  #...  #  
0x80, 0x40, 0x84, 0x40, 0x11, 0x10, 0x08, 0x00, //# $ #$$ ...  #  
0x80, 0x04, 0x80, 0x08, 0x11, 0x10, 0x18, 0x00, //#  $#  #... .#  
0x80, 0x00, 0x80, 0x48, 0x88, 0x88, 0x88, 0x80, //#   # $######## 
0x88, 0x40, 0x00, 0x00, 0x00, 0x40, 0x40, 0x80, //##$       $ $ # 
0x88, 0x00, 0x80, 0x04, 0x40, 0x80, 0x00, 0x80, //##  #  $$ #   # 
0x08, 0x88, 0x88, 0x80, 0x08, 0x84, 0x42, 0x80, // ######  ##$$@# 
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x08, 0x80, //      #      ## 
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, //      ########  
//Level: 201
0x13, 0x0F,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //###########         
0x81, 0x11, 0x11, 0x10, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //#......   ######### 
0x81, 0x11, 0x11, 0x10, 0x00, 0x80, 0x08, 0x80, 0x00, 0x80, //#......   #  ##   # 
0x81, 0x18, 0x88, 0x04, 0x00, 0x00, 0x40, 0x00, 0x00, 0x80, //#..### $    $     # 
0x81, 0x11, 0x04, 0x04, 0x08, 0x00, 0x08, 0x80, 0x00, 0x80, //#... $ $ #   ##   # 
0x81, 0x11, 0x84, 0x88, 0x88, 0x80, 0x00, 0x08, 0x00, 0x80, //#...#$#####    #  # 
0x88, 0x80, 0x00, 0x08, 0x00, 0x08, 0x40, 0x08, 0x40, 0x80, //###    #   #$  #$ # 
0x00, 0x80, 0x04, 0x40, 0x40, 0x40, 0x04, 0x88, 0x00, 0x80, //  #  $$ $ $  $##  # 
0x00, 0x80, 0x04, 0x00, 0x08, 0x48, 0x40, 0x88, 0x40, 0x80, //  #  $   #$#$ ##$ # 
0x00, 0x88, 0x80, 0x88, 0x08, 0x00, 0x00, 0x88, 0x00, 0x80, //  ### ## #    ##  # 
0x00, 0x08, 0x00, 0x40, 0x40, 0x88, 0x08, 0x88, 0x88, 0x80, //   #  $ $ ## ###### 
0x00, 0x08, 0x00, 0x00, 0x40, 0x04, 0x00, 0x80, 0x00, 0x00, //   #    $  $  #     
0x00, 0x08, 0x80, 0x00, 0x80, 0x80, 0x00, 0x80, 0x00, 0x00, //   ##   # #   #     
0x00, 0x00, 0x88, 0x88, 0x82, 0x88, 0x88, 0x80, 0x00, 0x00, //    #####@#####     
0x00, 0x00, 0x00, 0x00, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //        ###         
//Level: 202
0x10, 0x0C,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, // #########      
0x08, 0x00, 0x80, 0x00, 0x08, 0x88, 0x88, 0x88, // #  #    #######
0x08, 0x00, 0x00, 0x40, 0x00, 0x80, 0x00, 0x08, // #    $   #    #
0x88, 0x18, 0x88, 0x80, 0x40, 0x42, 0x48, 0x08, //##.#### $ $@$# #
0x81, 0x11, 0x18, 0x88, 0x00, 0x88, 0x04, 0x08, //#....###  ## $ #
0x81, 0x11, 0x18, 0x88, 0x84, 0x08, 0x00, 0x08, //#....####$ #   #
0x81, 0x11, 0x10, 0x00, 0x00, 0x00, 0x04, 0x08, //#....        $ #
0x88, 0x80, 0x88, 0x88, 0x48, 0x04, 0x04, 0x08, //### ####$# $ $ #
0x80, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, 0x88, //#        ##  ###
0x80, 0x44, 0x04, 0x08, 0x88, 0x88, 0x88, 0x00, //# $$ $ #######  
0x80, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //#  #####        
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //####            
//Level: 203
0x0E, 0x0C,//Size x and y
0x08, 0x88, 0x88, 0x08, 0x88, 0x88, 0x80, // ##### ###### 
0x08, 0x00, 0x08, 0x88, 0x00, 0x00, 0x80, // #   ###    # 
0x88, 0x04, 0x04, 0x08, 0x40, 0x84, 0x80, //## $ $ #$ #$# 
0x80, 0x04, 0x02, 0x04, 0x00, 0x40, 0x88, //#  $ @ $  $ ##
0x80, 0x80, 0x08, 0x80, 0x81, 0x11, 0x18, //# #  ## #....#
0x80, 0x08, 0x80, 0x40, 0x81, 0x88, 0x18, //#  ## $ #.##.#
0x88, 0x00, 0x40, 0x00, 0x01, 0x11, 0x18, //##  $    ....#
0x08, 0x04, 0x40, 0x84, 0x81, 0x11, 0x18, // # $$ #$#....#
0x08, 0x00, 0x08, 0x00, 0x08, 0x40, 0x88, // #   #   #$ ##
0x08, 0x88, 0x88, 0x04, 0x00, 0x00, 0x80, // ##### $    # 
0x00, 0x00, 0x08, 0x88, 0x80, 0x08, 0x80, //     ####  ## 
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, //        ####  
//Level: 204
0x0E, 0x0C,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x80, 0x00, //     ######   
0x08, 0x88, 0x88, 0x00, 0x00, 0x80, 0x00, // #####    #   
0x08, 0x00, 0x80, 0x04, 0x04, 0x80, 0x00, // #  #  $ $#   
0x08, 0x00, 0x40, 0x80, 0x40, 0x88, 0x80, // #  $ # $ ### 
0x88, 0x00, 0x80, 0x08, 0x00, 0x40, 0x88, //##  #  #  $ ##
0x80, 0x48, 0x00, 0x20, 0x80, 0x00, 0x08, //# $#  @ #    #
0x80, 0x00, 0x04, 0x04, 0x80, 0x44, 0x08, //#    $ $# $$ #
0x80, 0x04, 0x08, 0x41, 0x51, 0x08, 0x88, //#  $ #$.*. ###
0x88, 0x00, 0x80, 0x41, 0x11, 0x88, 0x00, //##  # $...##  
0x08, 0x88, 0x80, 0x81, 0x11, 0x18, 0x00, // #### #....#  
0x00, 0x00, 0x80, 0x01, 0x11, 0x18, 0x00, //    #  ....#  
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, //    ########  
//Level: 205
0x07, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x80, 0x41, 0x02, 0x80, //# $. @# 
0x80, 0x01, 0x00, 0x80, //#  .  # 
0x84, 0x45, 0x40, 0x80, //#$$*$ # 
0x81, 0x15, 0x11, 0x80, //#..*..# 
0x80, 0x45, 0x40, 0x80, //# $*$ # 
0x80, 0x41, 0x40, 0x80, //# $.$ # 
0x80, 0x01, 0x00, 0x80, //#  .  # 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 206
0x0B, 0x0A,//Size x and y
0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //#######     
0x80, 0x28, 0x00, 0x88, 0x88, 0x80, //# @#  ##### 
0x80, 0x44, 0x00, 0x40, 0x00, 0x80, //# $$  $   # 
0x80, 0x08, 0x18, 0x84, 0x80, 0x80, //#  #.##$# # 
0x88, 0x48, 0x11, 0x10, 0x00, 0x80, //##$#...   # 
0x88, 0x01, 0x11, 0x88, 0x48, 0x80, //## ...##$## 
0x80, 0x08, 0x81, 0x88, 0x00, 0x80, //#  ##.##  # 
0x80, 0x04, 0x00, 0x40, 0x00, 0x80, //#  $  $   # 
0x80, 0x08, 0x00, 0x08, 0x00, 0x80, //#  #   #  # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //########### 
//Level: 207
0x13, 0x0D,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, // #################  
0x08, 0x11, 0x10, 0x00, 0x80, 0x00, 0x08, 0x00, 0x08, 0x80, // #...   #    #   ## 
0x88, 0x11, 0x11, 0x10, 0x04, 0x88, 0x08, 0x08, 0x40, 0x80, //##.....  $## # #$ # 
0x81, 0x11, 0x11, 0x18, 0x00, 0x40, 0x08, 0x00, 0x00, 0x80, //#......#  $  #    # 
0x81, 0x11, 0x11, 0x18, 0x00, 0x80, 0x08, 0x08, 0x00, 0x80, //#......#  #  # #  # 
0x88, 0x88, 0x88, 0x88, 0x80, 0x40, 0x04, 0x04, 0x00, 0x80, //######### $  $ $  # 
0x00, 0x80, 0x00, 0x00, 0x84, 0x88, 0x40, 0x88, 0x48, 0x80, //  #     #$##$ ##$## 
0x08, 0x80, 0x00, 0x40, 0x00, 0x08, 0x04, 0x00, 0x00, 0x80, // ##   $    # $    # 
0x08, 0x00, 0x88, 0x08, 0x88, 0x08, 0x00, 0x88, 0x40, 0x80, // #  ## ### #  ##$ # 
0x08, 0x04, 0x04, 0x40, 0x00, 0x00, 0x40, 0x04, 0x00, 0x80, // # $ $$     $  $  # 
0x08, 0x04, 0x00, 0x00, 0x48, 0x84, 0x08, 0x88, 0x88, 0x80, // # $    $##$ ###### 
0x08, 0x88, 0x88, 0x88, 0x00, 0x20, 0x88, 0x00, 0x00, 0x00, // #######  @ ##      
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //       ######       
//Level: 208
0x10, 0x0F,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //       ####     
0x00, 0x00, 0x00, 0x08, 0x00, 0x88, 0x00, 0x00, //       #  ##    
0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x80, 0x00, //       #   ##   
0x00, 0x00, 0x00, 0x08, 0x04, 0x40, 0x88, 0x00, //       # $$ ##  
0x00, 0x00, 0x08, 0x88, 0x40, 0x04, 0x08, 0x80, //     ###$  $ ## 
0x00, 0x88, 0x88, 0x00, 0x00, 0x40, 0x00, 0x80, //  ####    $   # 
0x88, 0x80, 0x08, 0x08, 0x88, 0x88, 0x00, 0x80, //###  # #####  # 
0x80, 0x00, 0x08, 0x08, 0x11, 0x11, 0x40, 0x80, //#    # #....$ # 
0x80, 0x80, 0x00, 0x40, 0x11, 0x11, 0x80, 0x80, //# #   $ ....# # 
0x80, 0x04, 0x08, 0x08, 0x15, 0x11, 0x80, 0x80, //#  $ # #.*..# # 
0x88, 0x80, 0x08, 0x88, 0x80, 0x88, 0x80, 0x80, //###  #### ### # 
0x00, 0x88, 0x88, 0x02, 0x40, 0x08, 0x84, 0x88, //  #### @$  ##$##
0x00, 0x00, 0x08, 0x88, 0x04, 0x00, 0x00, 0x08, //     ### $     #
0x00, 0x00, 0x00, 0x08, 0x00, 0x88, 0x00, 0x08, //       #  ##   #
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, //       #########
//Level: 209
0x13, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //        ######      
0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0x08, 0x88, 0x88, 0x80, //        #  # ###### 
0x00, 0x88, 0x88, 0x80, 0x80, 0x04, 0x08, 0x11, 0x11, 0x80, //  ##### #  $ #....# 
0x08, 0x80, 0x00, 0x88, 0x80, 0x08, 0x08, 0x11, 0x11, 0x80, // ##   ###  # #....# 
0x08, 0x04, 0x04, 0x08, 0x84, 0x88, 0x08, 0x11, 0x11, 0x80, // # $ $ ##$## #....# 
0x08, 0x00, 0x80, 0x08, 0x00, 0x08, 0x08, 0x11, 0x11, 0x80, // #  #  #   # #....# 
0x08, 0x40, 0x40, 0x04, 0x24, 0x08, 0x08, 0x80, 0x08, 0x80, // #$ $  $@$ # ##  ## 
0x08, 0x04, 0x80, 0x08, 0x80, 0x88, 0x00, 0x80, 0x08, 0x00, // # $#  ## ##  #  #  
0x88, 0x00, 0x04, 0x48, 0x00, 0x88, 0x80, 0x80, 0x08, 0x00, //##   $$#  ### #  #  
0x80, 0x04, 0x00, 0x08, 0x04, 0x40, 0x00, 0x00, 0x08, 0x00, //#  $   # $$      #  
0x80, 0x40, 0x04, 0x08, 0x00, 0x88, 0x88, 0x00, 0x88, 0x00, //# $  $ #  ####  ##  
0x80, 0x00, 0x08, 0x88, 0x88, 0x80, 0x08, 0x88, 0x80, 0x00, //#    ######  ####   
0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //######              
//Level: 210
0x10, 0x12,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, //       #########
0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, //       #       #
0x00, 0x00, 0x00, 0x08, 0x04, 0x44, 0x44, 0x08, //       # $$$$$ #
0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0x00, 0x08, //       # $ $   #
0x00, 0x08, 0x88, 0x88, 0x00, 0x40, 0x40, 0x08, //   #####  $ $  #
0x00, 0x08, 0x00, 0x08, 0x88, 0x80, 0x88, 0x88, //   #   #### ####
0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, //   #         #  
0x00, 0x08, 0x88, 0x08, 0x88, 0x80, 0x08, 0x00, //   ### ####  #  
0x00, 0x00, 0x81, 0x11, 0x18, 0x80, 0x88, 0x00, //    #....## ##  
0x00, 0x00, 0x81, 0x11, 0x18, 0x00, 0x80, 0x00, //    #....#  #   
0x00, 0x00, 0x81, 0x11, 0x18, 0x00, 0x80, 0x00, //    #....#  #   
0x88, 0x88, 0x81, 0x88, 0x80, 0x00, 0x80, 0x00, //#####.###   #   
0x80, 0x08, 0x80, 0x80, 0x80, 0x88, 0x80, 0x00, //#  ## # # ###   
0x80, 0x48, 0x84, 0x88, 0x80, 0x08, 0x80, 0x00, //# $##$###  ##   
0x80, 0x00, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, //#      $   #    
0x80, 0x48, 0x00, 0x08, 0x80, 0x08, 0x00, 0x00, //# $#   ##  #    
0x88, 0x28, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, //##@#########    
0x08, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ###            
//Level: 211
0x0D, 0x09,//Size x and y
0x88, 0x88, 0x80, 0x88, 0x88, 0x88, 0x80, //##### ####### 
0x80, 0x00, 0x88, 0x80, 0x08, 0x00, 0x80, //#   ###  #  # 
0x80, 0x40, 0x00, 0x00, 0x40, 0x20, 0x80, //# $     $ @ # 
0x88, 0x08, 0x48, 0x81, 0x88, 0x00, 0x80, //## #$##.##  # 
0x08, 0x00, 0x11, 0x15, 0x10, 0x40, 0x80, // #  ...*. $ # 
0x08, 0x04, 0x80, 0x81, 0x80, 0x80, 0x80, // # $# #.# # # 
0x08, 0x80, 0x00, 0x04, 0x00, 0x00, 0x80, // ##    $    # 
0x00, 0x80, 0x08, 0x88, 0x88, 0x88, 0x80, //  #  ######## 
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //  ####        
//Level: 212
0x07, 0x09,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x80, 0x01, 0x00, 0x80, //#  .  # 
0x80, 0x01, 0x40, 0x80, //#  .$ # 
0x80, 0x45, 0x10, 0x80, //# $*. # 
0x85, 0x01, 0x45, 0x80, //#* .$*# 
0x80, 0x55, 0x40, 0x80, //# **$ # 
0x80, 0x01, 0x40, 0x80, //#  .$ # 
0x80, 0x41, 0x02, 0x80, //# $. @# 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 213
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x00, //######  
0x80, 0x00, 0x28, 0x00, //#   @#  
0x80, 0x48, 0x08, 0x88, //# $# ###
0x80, 0x50, 0x40, 0x08, //# * $  #
0x80, 0x00, 0x88, 0x08, //#   ## #
0x88, 0x10, 0x01, 0x08, //##.  . #
0x08, 0x80, 0x00, 0x88, // ##   ##
0x00, 0x88, 0x88, 0x80, //  ##### 
//Level: 214
0x10, 0x0E,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //    #####       
0x08, 0x88, 0x80, 0x00, 0x88, 0x08, 0x88, 0x88, // ####   ## #####
0x08, 0x00, 0x40, 0x00, 0x08, 0x88, 0x00, 0x08, // #  $    ###   #
0x08, 0x04, 0x24, 0x04, 0x00, 0x00, 0x40, 0x08, // # $@$ $    $  #
0x08, 0x08, 0x48, 0x88, 0x88, 0x88, 0x80, 0x88, // # #$######## ##
0x08, 0x08, 0x00, 0x40, 0x08, 0x00, 0x00, 0x08, // # #  $  #     #
0x08, 0x08, 0x04, 0x04, 0x08, 0x08, 0x00, 0x08, // # # $ $ # #   #
0x88, 0x08, 0x00, 0x48, 0x08, 0x08, 0x88, 0x88, //## #  $# # #####
0x80, 0x08, 0x80, 0x00, 0x08, 0x00, 0x00, 0x08, //#  ##    #     #
0x80, 0x00, 0x04, 0x08, 0x08, 0x88, 0x00, 0x08, //#    $ # ###   #
0x88, 0x88, 0x80, 0x88, 0x00, 0x81, 0x11, 0x18, //##### ##  #....#
0x80, 0x00, 0x04, 0x00, 0x00, 0x01, 0x11, 0x18, //#    $     ....#
0x80, 0x00, 0x00, 0x00, 0x00, 0x81, 0x11, 0x18, //#         #....#
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //################
//Level: 215
0x10, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //########        
0x80, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, //#   #  #        
0x80, 0x40, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //# $    ####     
0x88, 0x08, 0x84, 0x08, 0x20, 0x88, 0x88, 0x88, //## ##$ #@ ######
0x08, 0x00, 0x40, 0x48, 0x84, 0x00, 0x80, 0x08, // #  $ $##$  #  #
0x08, 0x08, 0x00, 0x40, 0x80, 0x40, 0x11, 0x18, // # #  $ # $ ...#
0x08, 0x04, 0x08, 0x40, 0x00, 0x08, 0x11, 0x18, // # $ #$    #...#
0x08, 0x00, 0x00, 0x08, 0x80, 0x48, 0x11, 0x18, // #     ## $#...#
0x08, 0x88, 0x04, 0x08, 0x00, 0x40, 0x11, 0x18, // ### $ #  $ ...#
0x00, 0x08, 0x88, 0x08, 0x00, 0x48, 0x11, 0x18, //   ### #  $#...#
0x00, 0x00, 0x80, 0x04, 0x40, 0x08, 0x88, 0x88, //    #  $$  #####
0x00, 0x00, 0x80, 0x00, 0x00, 0x88, 0x00, 0x00, //    #     ##    
0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //    #######     
//Level: 216
0x0E, 0x0E,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##############
0x80, 0x00, 0x00, 0x00, 0x88, 0x80, 0x08, //#       ###  #
0x80, 0x44, 0x04, 0x00, 0x00, 0x44, 0x08, //# $$ $    $$ #
0x80, 0x00, 0x00, 0x40, 0x88, 0x80, 0x08, //#     $ ###  #
0x88, 0x48, 0x88, 0x88, 0x00, 0x80, 0x88, //##$#####  # ##
0x88, 0x08, 0x01, 0x11, 0x11, 0x80, 0x08, //## # .....#  #
0x88, 0x08, 0x01, 0x11, 0x81, 0x80, 0x08, //## # ...#.#  #
0x80, 0x00, 0x81, 0x11, 0x11, 0x84, 0x08, //#   #.....#$ #
0x80, 0x00, 0x81, 0x51, 0x11, 0x42, 0x88, //#   #.*...$@##
0x80, 0x40, 0x80, 0x08, 0x88, 0x08, 0x88, //# $ #  ### ###
0x80, 0x40, 0x88, 0x80, 0x40, 0x40, 0x08, //# $ ### $ $  #
0x80, 0x44, 0x40, 0x00, 0x00, 0x44, 0x08, //# $$$     $$ #
0x80, 0x00, 0x88, 0x80, 0x00, 0x00, 0x08, //#   ###      #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##############
//Level: 217
0x0E, 0x0E,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, //        ####  
0x00, 0x88, 0x88, 0x88, 0x80, 0x08, 0x80, //  #######  ## 
0x00, 0x80, 0x00, 0x08, 0x80, 0x00, 0x80, //  #    ##   # 
0x00, 0x80, 0x80, 0x00, 0x41, 0x80, 0x88, //  # #   $.# ##
0x00, 0x80, 0x00, 0x40, 0x81, 0x02, 0x08, //  #   $ #. @ #
0x00, 0x88, 0x00, 0x88, 0x11, 0x10, 0x08, //  ##  ##...  #
0x00, 0x08, 0x84, 0x04, 0x11, 0x10, 0x88, //   ##$ $... ##
0x00, 0x88, 0x00, 0x88, 0x15, 0x18, 0x80, //  ##  ##.*.## 
0x88, 0x80, 0x40, 0x00, 0x08, 0x88, 0x00, //### $    ###  
0x80, 0x44, 0x08, 0x48, 0x48, 0x80, 0x00, //# $$ #$#$##   
0x80, 0x80, 0x00, 0x00, 0x40, 0x80, 0x00, //# #     $ #   
0x80, 0x00, 0x08, 0x80, 0x00, 0x80, 0x00, //#    ##   #   
0x88, 0x80, 0x08, 0x88, 0x88, 0x80, 0x00, //###  ######   
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //  ####        
//Level: 218
0x0E, 0x0D,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, //    ####      
0x08, 0x88, 0x80, 0x08, 0x88, 0x80, 0x00, // ####  ####   
0x08, 0x00, 0x80, 0x00, 0x40, 0x88, 0x88, // #  #   $ ####
0x08, 0x11, 0x10, 0x48, 0x40, 0x80, 0x08, // #... $#$ #  #
0x88, 0x18, 0x10, 0x08, 0x00, 0x04, 0x08, //##.#.  #   $ #
0x81, 0x11, 0x11, 0x08, 0x88, 0x40, 0x08, //#..... ###$  #
0x81, 0x11, 0x18, 0x48, 0x00, 0x40, 0x88, //#....#$#  $ ##
0x88, 0x84, 0x88, 0x04, 0x40, 0x00, 0x80, //###$## $$   # 
0x08, 0x00, 0x08, 0x00, 0x00, 0x40, 0x80, // #   #    $ # 
0x08, 0x04, 0x00, 0x24, 0x00, 0x88, 0x80, // # $  @$  ### 
0x08, 0x88, 0x84, 0x80, 0x88, 0x80, 0x00, // ####$# ###   
0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, //    #   #     
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //    #####     
//Level: 219
0x0E, 0x0E,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, // ############ 
0x88, 0x00, 0x08, 0x00, 0x80, 0x00, 0x88, //##   #  #   ##
0x80, 0x20, 0x48, 0x04, 0x04, 0x04, 0x08, //# @ $# $ $ $ #
0x80, 0x04, 0x00, 0x00, 0x80, 0x40, 0x08, //#  $    # $  #
0x80, 0x44, 0x08, 0x11, 0x80, 0x04, 0x08, //# $$ #..#  $ #
0x88, 0x80, 0x81, 0x11, 0x18, 0x80, 0x88, //### #....## ##
0x80, 0x00, 0x11, 0x88, 0x11, 0x04, 0x08, //#   ..##.. $ #
0x80, 0x40, 0x11, 0x88, 0x11, 0x00, 0x08, //# $ ..##..   #
0x88, 0x08, 0x81, 0x11, 0x18, 0x08, 0x88, //## ##....# ###
0x80, 0x40, 0x08, 0x11, 0x80, 0x40, 0x08, //# $  #..# $  #
0x80, 0x04, 0x08, 0x00, 0x04, 0x04, 0x08, //#  $ #   $ $ #
0x80, 0x40, 0x40, 0x40, 0x80, 0x40, 0x08, //# $ $ $ # $  #
0x88, 0x00, 0x08, 0x00, 0x80, 0x00, 0x88, //##   #  #   ##
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, // ############ 
//Level: 220
0x10, 0x0D,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, //  ##########    
0x00, 0x80, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, //  #    #   #    
0x00, 0x80, 0x48, 0x00, 0x04, 0x08, 0x00, 0x00, //  # $#   $ #    
0x00, 0x80, 0x40, 0x48, 0x48, 0x08, 0x00, 0x00, //  # $ $#$# #    
0x08, 0x88, 0x18, 0x11, 0x10, 0x08, 0x88, 0x88, // ###.#...  #####
0x88, 0x00, 0x11, 0x11, 0x84, 0x08, 0x00, 0x08, //##  ....#$ #   #
0x80, 0x48, 0x18, 0x85, 0x80, 0x04, 0x44, 0x08, //# $#.##*#  $$$ #
0x80, 0x00, 0x11, 0x11, 0x12, 0x80, 0x40, 0x08, //#   .....@# $  #
0x80, 0x08, 0x18, 0x11, 0x10, 0x04, 0x04, 0x08, //#  #.#...  $ $ #
0x80, 0x44, 0x00, 0x48, 0x48, 0x00, 0x40, 0x08, //# $$  $#$#  $  #
0x80, 0x00, 0x80, 0x08, 0x00, 0x80, 0x00, 0x88, //#   #  #  #   ##
0x88, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x80, //######    ##### 
0x00, 0x00, 0x08, 0x88, 0x88, 0x80, 0x00, 0x00, //     ######     
//Level: 221
0x09, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x00, //########  
0x80, 0x08, 0x11, 0x08, 0x80, //#  #.. ## 
0x80, 0x41, 0x24, 0x50, 0x80, //# $.@$* # 
0x80, 0x04, 0x04, 0x00, 0x80, //#  $ $  # 
0x80, 0x54, 0x01, 0x40, 0x80, //# *$ .$ # 
0x88, 0x01, 0x18, 0x00, 0x80, //## ..#  # 
0x08, 0x88, 0x88, 0x88, 0x80, // ######## 
//Level: 222
0x09, 0x08,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x00, //   #####  
0x00, 0x08, 0x00, 0x08, 0x00, //   #   #  
0x00, 0x08, 0x10, 0x48, 0x00, //   #. $#  
0x00, 0x08, 0x04, 0x08, 0x00, //   # $ #  
0x88, 0x88, 0x11, 0x08, 0x80, //####.. ## 
0x80, 0x40, 0x55, 0x00, 0x80, //# $ **  # 
0x80, 0x10, 0x02, 0x40, 0x80, //# .  @$ # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 223
0x0E, 0x0F,//Size x and y
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //#####         
0x80, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, //#   ##        
0x80, 0x00, 0x08, 0x00, 0x88, 0x88, 0x00, //#    #  ####  
0x80, 0x40, 0x08, 0x88, 0x80, 0x08, 0x00, //# $  ####  #  
0x80, 0x04, 0x40, 0x40, 0x00, 0x48, 0x00, //#  $$ $   $#  
0x88, 0x82, 0x08, 0x40, 0x00, 0x08, 0x80, //###@ #$    ## 
0x08, 0x00, 0x88, 0x00, 0x40, 0x40, 0x88, // #  ##  $ $ ##
0x08, 0x04, 0x00, 0x88, 0x08, 0x80, 0x18, // # $  ## ## .#
0x08, 0x00, 0x84, 0x88, 0x40, 0x08, 0x18, // #  #$##$  #.#
0x08, 0x88, 0x00, 0x04, 0x11, 0x88, 0x18, // ###   $..##.#
0x00, 0x80, 0x00, 0x08, 0x15, 0x11, 0x18, //  #    #.*...#
0x00, 0x80, 0x44, 0x08, 0x11, 0x11, 0x18, //  # $$ #.....#
0x00, 0x80, 0x08, 0x88, 0x88, 0x88, 0x88, //  #  #########
0x00, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, //  #  #        
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //  ####        
//Level: 224
0x13, 0x10,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //  ######            
0x00, 0x80, 0x00, 0x28, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //  #   @####         
0x88, 0x88, 0x80, 0x40, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //##### $   #         
0x80, 0x00, 0x88, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, //#   ##    ####      
0x80, 0x40, 0x80, 0x08, 0x80, 0x00, 0x08, 0x00, 0x00, 0x00, //# $ #  ##    #      
0x80, 0x40, 0x80, 0x08, 0x88, 0x88, 0x08, 0x00, 0x00, 0x00, //# $ #  ##### #      
0x88, 0x04, 0x00, 0x40, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, //## $  $    # #      
0x88, 0x04, 0x04, 0x08, 0x88, 0x08, 0x08, 0x00, 0x00, 0x00, //## $ $ ### # #      
0x88, 0x08, 0x00, 0x40, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, //## #  $  # # #      
0x88, 0x08, 0x08, 0x48, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, //## # #$#   # #      
0x88, 0x08, 0x88, 0x00, 0x08, 0x08, 0x08, 0x88, 0x88, 0x80, //## ###   # # ###### 
0x80, 0x04, 0x00, 0x88, 0x88, 0x08, 0x08, 0x11, 0x11, 0x80, //#  $  #### # #....# 
0x80, 0x00, 0x04, 0x00, 0x00, 0x40, 0x00, 0x11, 0x81, 0x80, //#    $    $   ..#.# 
0x88, 0x88, 0x40, 0x04, 0x80, 0x40, 0x00, 0x11, 0x11, 0x80, //####$  $# $   ....# 
0x80, 0x00, 0x00, 0x00, 0x80, 0x08, 0x80, 0x11, 0x11, 0x80, //#       #  ## ....# 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //################### 
//Level: 225
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x20, 0x80, 0x08, //#        #   #@ #  #
0x80, 0x44, 0x00, 0x84, 0x48, 0x08, 0x08, 0x00, 0x88, 0x08, //# $$  #$$# # #  ## #
0x80, 0x08, 0x04, 0x04, 0x08, 0x44, 0x08, 0x00, 0x00, 0x08, //#  # $ $ #$$ #     #
0x88, 0x08, 0x00, 0x80, 0x08, 0x08, 0x08, 0x00, 0x80, 0x08, //## #  #  # # #  #  #
0x80, 0x00, 0x88, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, //#   ##       #     #
0x80, 0x00, 0x80, 0x40, 0x80, 0x00, 0x80, 0x00, 0x80, 0x08, //#   # $ #   #   #  #
0x80, 0x40, 0x84, 0x08, 0x00, 0x08, 0x00, 0x40, 0x81, 0x18, //# $ #$ #   #  $ #..#
0x88, 0x40, 0x80, 0x08, 0x88, 0x80, 0x00, 0x08, 0x11, 0x18, //##$ #  ####    #...#
0x80, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x11, 0x18, //#  $          #....#
0x80, 0x00, 0x80, 0x08, 0x00, 0x00, 0x08, 0x11, 0x11, 0x18, //#   #  #     #.....#
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 226
0x11, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //#############     
0x81, 0x11, 0x11, 0x11, 0x18, 0x88, 0x80, 0x00, 0x00, //#........####     
0x81, 0x11, 0x88, 0x88, 0x08, 0x00, 0x88, 0x88, 0x80, //#...#### #  ##### 
0x81, 0x11, 0x80, 0x08, 0x88, 0x00, 0x00, 0x40, 0x80, //#...#  ###    $ # 
0x81, 0x11, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x80, //#...$$     $ $  # 
0x80, 0x01, 0x80, 0x04, 0x04, 0x80, 0x40, 0x08, 0x80, //#  .#  $ $# $  ## 
0x81, 0x11, 0x80, 0x84, 0x80, 0x00, 0x40, 0x08, 0x00, //#...# #$#   $  #  
0x81, 0x80, 0x80, 0x40, 0x00, 0x40, 0x00, 0x08, 0x00, //#.# # $   $    #  
0x81, 0x00, 0x84, 0x88, 0x84, 0x88, 0x88, 0x48, 0x00, //#.  #$###$####$#  
0x88, 0x00, 0x80, 0x00, 0x40, 0x40, 0x00, 0x08, 0x00, //##  #   $ $    #  
0x08, 0x00, 0x80, 0x04, 0x24, 0x00, 0x80, 0x08, 0x00, // #  #  $@$  #  #  
0x08, 0x00, 0x80, 0x88, 0x88, 0x04, 0x00, 0x48, 0x00, // #  # #### $  $#  
0x08, 0x00, 0x80, 0x00, 0x08, 0x88, 0x00, 0x08, 0x00, // #  #    ###   #  
0x08, 0x00, 0x80, 0x44, 0x08, 0x08, 0x88, 0x88, 0x00, // #  # $$ # #####  
0x08, 0x00, 0x80, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, // #  #    #        
0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, // #########        
//Level: 227
0x0F, 0x0E,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
0x80, 0x00, 0x00, 0x08, 0x11, 0x11, 0x11, 0x80, //#      #......# 
0x80, 0x44, 0x08, 0x04, 0x18, 0x11, 0x11, 0x80, //# $$ # $.#....# 
0x80, 0x00, 0x80, 0x48, 0x20, 0x81, 0x11, 0x80, //#   # $#@ #...# 
0x80, 0x48, 0x04, 0x08, 0x04, 0x08, 0x11, 0x80, //# $# $ # $ #..# 
0x80, 0x00, 0x40, 0x08, 0x44, 0x00, 0x11, 0x80, //#   $  #$$  ..# 
0x80, 0x40, 0x84, 0x08, 0x00, 0x81, 0x41, 0x80, //# $ #$ #  #.$.# 
0x80, 0x08, 0x00, 0x40, 0x40, 0x08, 0x11, 0x80, //#  #  $ $  #..# 
0x80, 0x80, 0x40, 0x08, 0x00, 0x00, 0x80, 0x80, //# # $  #    # # 
0x80, 0x00, 0x08, 0x08, 0x48, 0x00, 0x44, 0x80, //#    # #$#  $$# 
0x80, 0x00, 0x80, 0x48, 0x00, 0x80, 0x00, 0x80, //#   # $#  #   # 
0x80, 0x08, 0x00, 0x04, 0x40, 0x08, 0x00, 0x80, //#  #   $$  #  # 
0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x80, //#      #      # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
//Level: 228
0x0B, 0x0A,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x00, 0x00, //   #####    
0x08, 0x88, 0x00, 0x08, 0x88, 0x00, // ###   ###  
0x88, 0x02, 0x04, 0x04, 0x08, 0x00, //## @ $ $ #  
0x80, 0x08, 0x80, 0x88, 0x08, 0x80, //#  ## ## ## 
0x80, 0x41, 0x81, 0x40, 0x00, 0x80, //# $.#.$   # 
0x80, 0x81, 0x85, 0x80, 0x00, 0x80, //# #.#*#   # 
0x80, 0x41, 0x11, 0x00, 0x88, 0x80, //# $...  ### 
0x88, 0x84, 0x80, 0x88, 0x80, 0x00, //###$# ###   
0x00, 0x80, 0x00, 0x80, 0x00, 0x00, //  #   #     
0x00, 0x88, 0x88, 0x80, 0x00, 0x00, //  #####     
//Level: 229
0x0F, 0x0F,//Size x and y
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //####            
0x80, 0x08, 0x88, 0x80, 0x08, 0x88, 0x88, 0x00, //#  ####  #####  
0x80, 0x40, 0x00, 0x88, 0x88, 0x00, 0x08, 0x00, //# $   ####   #  
0x80, 0x40, 0x00, 0x08, 0x80, 0x00, 0x08, 0x00, //# $    ##    #  
0x80, 0x88, 0x84, 0x04, 0x00, 0x40, 0x08, 0x80, //# ###$ $  $  ## 
0x80, 0x80, 0x40, 0x04, 0x08, 0x80, 0x00, 0x80, //# # $  $ ##   # 
0x80, 0x04, 0x08, 0x44, 0x80, 0x00, 0x80, 0x80, //#  $ #$$#   # # 
0x88, 0x00, 0x08, 0x00, 0x84, 0x00, 0x00, 0x80, //##   #  #$    # 
0x08, 0x80, 0x08, 0x80, 0x04, 0x08, 0x08, 0x80, // ##  ##  $ # ## 
0x88, 0x88, 0x18, 0x88, 0x00, 0x48, 0x08, 0x00, //####.###  $# #  
0x80, 0x08, 0x18, 0x11, 0x08, 0x00, 0x08, 0x00, //#  #.#.. #   #  
0x80, 0x08, 0x11, 0x11, 0x02, 0x08, 0x88, 0x00, //#  #.... @ ###  
0x80, 0x40, 0x11, 0x11, 0x80, 0x88, 0x00, 0x00, //# $ ....# ##    
0x80, 0x00, 0x88, 0x11, 0x00, 0x80, 0x00, 0x00, //#   ##..  #     
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //###########     
//Level: 230
0x09, 0x08,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x00, //   #####  
0x88, 0x88, 0x00, 0x28, 0x80, //####  @## 
0x80, 0x40, 0x40, 0x00, 0x80, //# $ $   # 
0x80, 0x81, 0x51, 0x80, 0x80, //# #.*.# # 
0x80, 0x81, 0x51, 0x80, 0x80, //# #.*.# # 
0x80, 0x00, 0x40, 0x40, 0x80, //#   $ $ # 
0x88, 0x00, 0x08, 0x88, 0x80, //##   #### 
0x08, 0x88, 0x88, 0x00, 0x00, // #####    
//Level: 231
0x0A, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x00, //  ######  
0x88, 0x80, 0x00, 0x18, 0x00, //###   .#  
0x80, 0x04, 0x18, 0x88, 0x88, //#  $.#####
0x80, 0x44, 0x18, 0x20, 0x08, //# $$.#@  #
0x80, 0x00, 0x88, 0x44, 0x08, //#   ##$$ #
0x80, 0x01, 0x41, 0x00, 0x08, //#  .$.   #
0x88, 0x84, 0x08, 0x88, 0x18, //###$ ###.#
0x00, 0x81, 0x08, 0x08, 0x88, //  #. # ###
0x00, 0x88, 0x88, 0x00, 0x00, //  ####    
//Level: 232
0x08, 0x08,//Size x and y
0x08, 0x88, 0x88, 0x80, // ###### 
0x88, 0x21, 0x00, 0x80, //##@.  # 
0x80, 0x44, 0x50, 0x80, //# $$* # 
0x80, 0x08, 0x00, 0x88, //#  #  ##
0x80, 0x08, 0x00, 0x18, //#  #  .#
0x88, 0x88, 0x08, 0x08, //#### # #
0x00, 0x08, 0x00, 0x08, //   #   #
0x00, 0x08, 0x88, 0x88, //   #####
//Level: 233
0x13, 0x0F,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, //          ####      
0x00, 0x00, 0x08, 0x88, 0x80, 0x80, 0x08, 0x00, 0x00, 0x00, //     #### #  #      
0x00, 0x08, 0x88, 0x02, 0x88, 0x84, 0x08, 0x00, 0x00, 0x00, //   ### @###$ #      
0x00, 0x88, 0x00, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x00, //  ##      $  #      
0x08, 0x80, 0x04, 0x04, 0x48, 0x80, 0x88, 0x00, 0x00, 0x00, // ##  $ $$## ##      
0x08, 0x00, 0x84, 0x88, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, // #  #$##     #      
0x08, 0x08, 0x04, 0x04, 0x40, 0x80, 0x88, 0x80, 0x00, 0x00, // # # $ $$ # ###     
0x08, 0x00, 0x04, 0x08, 0x00, 0x80, 0x40, 0x88, 0x88, 0x80, // #   $ #  # $ ##### 
0x88, 0x88, 0x00, 0x00, 0x80, 0x04, 0x40, 0x80, 0x00, 0x80, //####    #  $$ #   # 
0x88, 0x88, 0x08, 0x80, 0x40, 0x00, 0x00, 0x00, 0x00, 0x80, //#### ## $         # 
0x81, 0x00, 0x00, 0x88, 0x80, 0x08, 0x88, 0x88, 0x88, 0x80, //#.    ###  ######## 
0x81, 0x10, 0x11, 0x80, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //#.. ..# ####        
0x81, 0x11, 0x81, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //#...#.#             
0x81, 0x11, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //#.....#             
0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //#######             
//Level: 234
0x12, 0x0B,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //         ####     
0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x88, 0x00, 0x00, // #########  ##    
0x88, 0x00, 0x40, 0x00, 0x00, 0x04, 0x08, 0x88, 0x88, //##  $      $ #####
0x80, 0x00, 0x88, 0x08, 0x80, 0x00, 0x88, 0x11, 0x18, //#   ## ##   ##...#
0x80, 0x84, 0x40, 0x40, 0x44, 0x84, 0x88, 0x11, 0x18, //# #$$ $ $$#$##...#
0x80, 0x80, 0x00, 0x20, 0x00, 0x80, 0x00, 0x11, 0x18, //# #   @   #   ...#
0x80, 0x04, 0x80, 0x88, 0x84, 0x40, 0x00, 0x11, 0x18, //#  $# ###$$   ...#
0x80, 0x40, 0x04, 0x40, 0x04, 0x08, 0x81, 0x11, 0x18, //# $  $$  $ ##....#
0x88, 0x84, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, //###$       #######
0x00, 0x80, 0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //  #  #######      
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //  ####            
//Level: 235
0x10, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //################
0x81, 0x11, 0x18, 0x00, 0x00, 0x00, 0x00, 0x08, //#....#         #
0x81, 0x11, 0x18, 0x08, 0x08, 0x80, 0x08, 0x08, //#....# # ##  # #
0x81, 0x11, 0x10, 0x04, 0x08, 0x00, 0x80, 0x08, //#....  $ #  #  #
0x88, 0x00, 0x80, 0x04, 0x00, 0x08, 0x00, 0x08, //##  #  $   #   #
0x80, 0x00, 0x08, 0x44, 0x44, 0x80, 0x08, 0x08, //#    #$$$$#  # #
0x80, 0x88, 0x04, 0x00, 0x00, 0x40, 0x88, 0x08, //# ## $    $ ## #
0x80, 0x00, 0x04, 0x08, 0x80, 0x44, 0x40, 0x08, //#    $ ## $$$  #
0x80, 0x84, 0x44, 0x08, 0x80, 0x40, 0x08, 0x08, //# #$$$ ## $  # #
0x80, 0x80, 0x04, 0x00, 0x00, 0x40, 0x00, 0x08, //# #  $    $    #
0x80, 0x00, 0x88, 0x44, 0x44, 0x80, 0x08, 0x88, //#   ##$$$$#  ###
0x80, 0x08, 0x00, 0x00, 0x40, 0x08, 0x11, 0x18, //#  #    $  #...#
0x80, 0x00, 0x00, 0x80, 0x48, 0x00, 0x11, 0x18, //#     # $#  ...#
0x80, 0x88, 0x08, 0x08, 0x08, 0x00, 0x11, 0x18, //# ## # # #  ...#
0x82, 0x00, 0x00, 0x00, 0x00, 0x08, 0x11, 0x18, //#@         #...#
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //################
//Level: 236
0x14, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //  ##################
0x00, 0x80, 0x00, 0x00, 0x00, 0x88, 0x11, 0x18, 0x00, 0x08, //  #       ##...#   #
0x00, 0x80, 0x84, 0x84, 0x80, 0x88, 0x81, 0x11, 0x04, 0x08, //  # #$#$# ###... $ #
0x00, 0x80, 0x02, 0x40, 0x04, 0x00, 0x01, 0x18, 0x04, 0x08, //  #  @$  $   ..# $ #
0x88, 0x88, 0x84, 0x84, 0x80, 0x80, 0x01, 0x10, 0x08, 0x88, //#####$#$# #  ..  ###
0x80, 0x00, 0x40, 0x40, 0x80, 0x88, 0x88, 0x88, 0x08, 0x80, //#   $ $ # ###### ## 
0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, //# # # # #         # 
0x80, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x80, //#       #######   # 
0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x88, 0x88, 0x80, //#########     ##### 
//Level: 237
0x0E, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //#########     
0x80, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, //#       ##    
0x80, 0x84, 0x84, 0x82, 0x08, 0x88, 0x88, //# #$#$#@ #####
0x80, 0x40, 0x00, 0x04, 0x08, 0x00, 0x08, //# $    $ #   #
0x88, 0x08, 0x88, 0x80, 0x88, 0x08, 0x08, //## #### ## # #
0x80, 0x08, 0x00, 0x80, 0x00, 0x00, 0x08, //#  #  #      #
0x80, 0x48, 0x00, 0x40, 0x08, 0x88, 0x88, //# $#  $  #####
0x81, 0x14, 0x00, 0x88, 0x08, 0x00, 0x08, //#..$  ## #   #
0x81, 0x18, 0x00, 0x80, 0x00, 0x44, 0x08, //#..#  #   $$ #
0x81, 0x18, 0x88, 0x80, 0x04, 0x00, 0x08, //#..####  $   #
0x85, 0x11, 0x18, 0x04, 0x04, 0x04, 0x08, //#*...# $ $ $ #
0x81, 0x11, 0x18, 0x00, 0x00, 0x00, 0x08, //#....#       #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##############
//Level: 238
0x0F, 0x0F,//Size x and y
0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //#######         
0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //#     #         
0x80, 0x40, 0x44, 0x80, 0x00, 0x00, 0x00, 0x00, //# $ $$#         
0x82, 0x04, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, //#@ $  #         
0x80, 0x40, 0x40, 0x88, 0x88, 0x80, 0x00, 0x00, //# $ $ #####     
0x80, 0x40, 0x05, 0x11, 0x11, 0x80, 0x00, 0x00, //# $  *....#     
0x88, 0x88, 0x81, 0x88, 0x81, 0x80, 0x00, 0x00, //#####.###.#     
0x00, 0x08, 0x81, 0x80, 0x81, 0x80, 0x00, 0x00, //   ##.# #.#     
0x00, 0x08, 0x01, 0x88, 0x81, 0x88, 0x88, 0x80, //   # .###.##### 
0x00, 0x08, 0x01, 0x11, 0x15, 0x00, 0x40, 0x80, //   # ....*  $ # 
0x00, 0x08, 0x00, 0x08, 0x80, 0x40, 0x40, 0x80, //   #   ## $ $ # 
0x00, 0x08, 0x88, 0x88, 0x80, 0x04, 0x00, 0x80, //   ######  $  # 
0x00, 0x00, 0x00, 0x00, 0x84, 0x40, 0x40, 0x80, //        #$$ $ # 
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80, //        #     # 
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //        ####### 
//Level: 239
0x09, 0x08,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x80, //   ###### 
0x88, 0x88, 0x10, 0x02, 0x80, //####.  @# 
0x80, 0x04, 0x44, 0x00, 0x80, //#  $$$  # 
0x81, 0x88, 0x18, 0x81, 0x80, //#.##.##.# 
0x80, 0x00, 0x40, 0x00, 0x80, //#   $   # 
0x80, 0x04, 0x18, 0x08, 0x80, //#  $.# ## 
0x88, 0x80, 0x00, 0x08, 0x00, //###    #  
0x00, 0x88, 0x88, 0x88, 0x00, //  ######  
//Level: 240
0x0A, 0x08,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x80, // ######## 
0x08, 0x00, 0x82, 0x00, 0x88, // #  #@  ##
0x88, 0x04, 0x88, 0x80, 0x08, //## $###  #
0x80, 0x00, 0x50, 0x50, 0x08, //#   * *  #
0x80, 0x05, 0x05, 0x05, 0x08, //#  * * * #
0x80, 0x10, 0x50, 0x50, 0x08, //# . * *  #
0x88, 0x88, 0x00, 0x08, 0x88, //####   ###
0x00, 0x08, 0x88, 0x88, 0x00, //   #####  
//Level: 241
0x06, 0x07,//Size x and y
0x88, 0x88, 0x00, //####  
0x82, 0x08, 0x88, //#@ ###
0x80, 0x44, 0x18, //# $$.#
0x80, 0x04, 0x18, //#  $.#
0x80, 0x40, 0x18, //# $ .#
0x80, 0x80, 0x18, //# # .#
0x88, 0x88, 0x88, //######
//Level: 242
0x0C, 0x0F,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //############
0x88, 0x00, 0x00, 0x08, 0x80, 0x08, //##     ##  #
0x88, 0x00, 0x04, 0x00, 0x04, 0x08, //##   $   $ #
0x88, 0x88, 0x08, 0x80, 0x44, 0x08, //#### ## $$ #
0x80, 0x00, 0x40, 0x80, 0x00, 0x08, //#   $ #    #
0x80, 0x44, 0x40, 0x80, 0x88, 0x88, //# $$$ # ####
0x80, 0x00, 0x80, 0x80, 0x40, 0x88, //#   # # $ ##
0x80, 0x08, 0x00, 0x80, 0x04, 0x08, //#  #  #  $ #
0x80, 0x48, 0x04, 0x80, 0x00, 0x08, //# $# $#    #
0x80, 0x00, 0x11, 0x80, 0x88, 0x88, //#   ..# ####
0x88, 0x88, 0x11, 0x04, 0x08, 0x28, //####.. $ #@#
0x81, 0x11, 0x11, 0x80, 0x48, 0x08, //#.....# $# #
0x88, 0x11, 0x11, 0x80, 0x04, 0x08, //##....#  $ #
0x88, 0x81, 0x18, 0x80, 0x00, 0x08, //###..##    #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //############
//Level: 243
0x12, 0x0D,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //     ########     
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, //  ####      ######
0x00, 0x80, 0x00, 0x08, 0x80, 0x40, 0x40, 0x00, 0x28, //  #    ## $ $   @#
0x00, 0x80, 0x88, 0x08, 0x84, 0x84, 0x04, 0x04, 0x88, //  # ## ##$#$ $ $##
0x88, 0x80, 0x11, 0x11, 0x11, 0x80, 0x04, 0x40, 0x88, //### ......#  $$ ##
0x80, 0x00, 0x11, 0x11, 0x11, 0x80, 0x08, 0x00, 0x08, //#   ......#  #   #
0x80, 0x80, 0x11, 0x11, 0x11, 0x84, 0x00, 0x40, 0x08, //# # ......#$  $  #
0x80, 0x84, 0x11, 0x11, 0x11, 0x04, 0x48, 0x04, 0x08, //# #$...... $$# $ #
0x80, 0x00, 0x88, 0x80, 0x88, 0x84, 0x00, 0x40, 0x88, //#   ### ###$  $ ##
0x88, 0x80, 0x04, 0x00, 0x40, 0x04, 0x00, 0x40, 0x80, //###  $  $  $  $ # 
0x00, 0x80, 0x04, 0x00, 0x40, 0x04, 0x00, 0x40, 0x80, //  #  $  $  $  $ # 
0x00, 0x88, 0x88, 0x88, 0x00, 0x08, 0x88, 0x88, 0x80, //  ######   ###### 
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, //       #####      
//Level: 244
0x0E, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, //##########    
0x80, 0x00, 0x00, 0x00, 0x08, 0x88, 0x80, //#        #### 
0x80, 0x88, 0x88, 0x88, 0x08, 0x00, 0x88, //# ###### #  ##
0x80, 0x80, 0x40, 0x40, 0x40, 0x04, 0x08, //# # $ $ $  $ #
0x80, 0x00, 0x00, 0x00, 0x84, 0x00, 0x08, //#       #$   #
0x88, 0x84, 0x00, 0x44, 0x80, 0x08, 0x88, //###$  $$#  ###
0x00, 0x80, 0x08, 0x80, 0x80, 0x48, 0x80, //  #  ## # $## 
0x00, 0x88, 0x48, 0x00, 0x04, 0x02, 0x80, //  ##$#   $ @# 
0x00, 0x08, 0x00, 0x40, 0x40, 0x88, 0x80, //   #  $ $ ### 
0x00, 0x08, 0x08, 0x00, 0x04, 0x00, 0x80, //   # #   $  # 
0x00, 0x08, 0x08, 0x80, 0x00, 0x80, 0x80, //   # ##   # # 
0x00, 0x88, 0x00, 0x88, 0x88, 0x80, 0x80, //  ##  ##### # 
0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, //  #         # 
0x00, 0x81, 0x11, 0x11, 0x11, 0x88, 0x80, //  #.......### 
0x00, 0x81, 0x11, 0x11, 0x11, 0x80, 0x00, //  #.......#   
0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //  #########   
//Level: 245
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x00, 0x12, 0x88, //##  .@##
0x88, 0x00, 0x04, 0x18, //##   $.#
0x88, 0x88, 0x58, 0x08, //####*# #
0x88, 0x00, 0x00, 0x08, //##     #
0x80, 0x04, 0x00, 0x88, //#  $  ##
0x80, 0x00, 0x88, 0x88, //#   ####
0x88, 0x88, 0x88, 0x88, //########
//Level: 246
0x0F, 0x10,//Size x and y
0x08, 0x88, 0x80, 0x88, 0x88, 0x80, 0x00, 0x00, // #### #####     
0x08, 0x00, 0x88, 0x80, 0x00, 0x88, 0x00, 0x00, // #  ###   ##    
0x08, 0x04, 0x00, 0x80, 0x80, 0x08, 0x80, 0x00, // # $  # #  ##   
0x08, 0x04, 0x80, 0x80, 0x88, 0x00, 0x88, 0x00, // # $# # ##  ##  
0x08, 0x00, 0x04, 0x00, 0x80, 0x40, 0x08, 0x80, // #   $  # $  ## 
0x08, 0x04, 0x00, 0x40, 0x84, 0x04, 0x00, 0x80, // # $  $ #$ $  # 
0x88, 0x80, 0x80, 0x88, 0x80, 0x80, 0x40, 0x80, //### # ### # $ # 
0x80, 0x00, 0x00, 0x81, 0x11, 0x18, 0x00, 0x80, //#     #....#  # 
0x80, 0x80, 0x44, 0x01, 0x11, 0x18, 0x80, 0x80, //# # $$ ....## # 
0x80, 0x80, 0x00, 0x81, 0x11, 0x10, 0x00, 0x80, //# #   #....   # 
0x80, 0x08, 0x84, 0x81, 0x11, 0x18, 0x28, 0x80, //#  ##$#....#@## 
0x80, 0x40, 0x40, 0x00, 0x80, 0x88, 0x88, 0x00, //# $ $   # ####  
0x88, 0x00, 0x00, 0x80, 0x40, 0x80, 0x00, 0x00, //##    # $ #     
0x08, 0x88, 0x88, 0x80, 0x40, 0x80, 0x00, 0x00, // ###### $ #     
0x00, 0x00, 0x00, 0x88, 0x00, 0x80, 0x00, 0x00, //      ##  #     
0x00, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //       ####     
//Level: 247
0x0E, 0x0F,//Size x and y
0x08, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, // #####        
0x88, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, //##   ##       
0x80, 0x00, 0x00, 0x88, 0x88, 0x80, 0x00, //#     #####   
0x80, 0x80, 0x00, 0x04, 0x00, 0x80, 0x00, //# #    $  #   
0x80, 0x08, 0x04, 0x08, 0x80, 0x80, 0x00, //#  # $ ## #   
0x88, 0x04, 0x48, 0x11, 0x10, 0x80, 0x00, //## $$#... #   
0x08, 0x88, 0x00, 0x11, 0x10, 0x80, 0x00, // ###  ... #   
0x00, 0x08, 0x88, 0x81, 0x18, 0x88, 0x88, //   ####..#####
0x88, 0x88, 0x88, 0x11, 0x18, 0x80, 0x08, //######...##  #
0x80, 0x08, 0x88, 0x04, 0x20, 0x84, 0x08, //#  ### $@ #$ #
0x80, 0x40, 0x80, 0x00, 0x80, 0x00, 0x08, //# $ #   #    #
0x80, 0x04, 0x00, 0x84, 0x00, 0x40, 0x88, //#  $  #$  $ ##
0x88, 0x00, 0x00, 0x40, 0x08, 0x88, 0x80, //##    $  #### 
0x08, 0x88, 0x88, 0x00, 0x88, 0x00, 0x00, // #####  ##    
0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //     ####     
//Level: 248
0x08, 0x08,//Size x and y
0x00, 0x88, 0x88, 0x88, //  ######
0x88, 0x80, 0x10, 0x08, //### .  #
0x80, 0x42, 0x81, 0x08, //# $@#. #
0x80, 0x04, 0x80, 0x88, //#  $# ##
0x80, 0x05, 0x00, 0x80, //#  *  # 
0x88, 0x00, 0x80, 0x80, //##  # # 
0x08, 0x80, 0x00, 0x80, // ##   # 
0x00, 0x88, 0x88, 0x80, //  ##### 
//Level: 249
0x13, 0x0E,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //       ###########  
0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, //       #   #     #  
0x88, 0x88, 0x80, 0x08, 0x00, 0x00, 0x04, 0x04, 0x08, 0x00, //#####  #     $ $ #  
0x80, 0x00, 0x88, 0x88, 0x80, 0x48, 0x80, 0x80, 0x88, 0x00, //#   ##### $## # ##  
0x80, 0x40, 0x88, 0x00, 0x08, 0x08, 0x80, 0x40, 0x08, 0x00, //# $ ##   # ## $  #  
0x80, 0x40, 0x02, 0x44, 0x08, 0x08, 0x84, 0x44, 0x08, 0x00, //# $  @$$ # ##$$$ #  
0x88, 0x08, 0x88, 0x00, 0x08, 0x08, 0x80, 0x00, 0x08, 0x00, //## ###   # ##    #  
0x88, 0x08, 0x00, 0x08, 0x88, 0x08, 0x88, 0x88, 0x48, 0x00, //## #   ### #####$#  
0x88, 0x08, 0x00, 0x00, 0x04, 0x00, 0x81, 0x11, 0x18, 0x00, //## #     $  #....#  
0x80, 0x08, 0x88, 0x08, 0x80, 0x40, 0x81, 0x11, 0x18, 0x80, //#  ### ## $ #....## 
0x80, 0x40, 0x00, 0x40, 0x80, 0x00, 0x81, 0x14, 0x10, 0x80, //# $   $ #   #..$. # 
0x80, 0x08, 0x80, 0x40, 0x80, 0x08, 0x81, 0x11, 0x10, 0x80, //#  ## $ #  ##.... # 
0x88, 0x88, 0x80, 0x00, 0x88, 0x88, 0x88, 0x11, 0x18, 0x80, //#####   ######...## 
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x08, 0x88, 0x88, 0x00, //    #####    #####  
//Level: 250
0x13, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x08, 0x88, 0x88, 0x80, //############ ###### 
0x80, 0x00, 0x80, 0x00, 0x08, 0x08, 0x88, 0x11, 0x11, 0x80, //#   #    # ###....# 
0x80, 0x00, 0x44, 0x80, 0x00, 0x20, 0x01, 0x11, 0x11, 0x80, //#   $$#   @  .....# 
0x80, 0x00, 0x80, 0x88, 0x80, 0x00, 0x80, 0x11, 0x11, 0x80, //#   # ###   # ....# 
0x88, 0x08, 0x80, 0x88, 0x80, 0x08, 0x00, 0x11, 0x11, 0x80, //## ## ###  #  ....# 
0x08, 0x04, 0x04, 0x00, 0x00, 0x08, 0x08, 0x08, 0x88, 0x80, // # $ $     # # #### 
0x08, 0x00, 0x40, 0x48, 0x80, 0x08, 0x00, 0x00, 0x00, 0x80, // #  $ $##  #      # 
0x88, 0x88, 0x08, 0x00, 0x88, 0x88, 0x08, 0x08, 0x80, 0x80, //#### #  #### # ## # 
0x80, 0x08, 0x08, 0x40, 0x00, 0x88, 0x08, 0x00, 0x00, 0x80, //#  # #$   ## #    # 
0x80, 0x40, 0x04, 0x00, 0x80, 0x88, 0x08, 0x00, 0x08, 0x80, //# $  $  # ## #   ## 
0x80, 0x80, 0x40, 0x40, 0x00, 0x08, 0x08, 0x00, 0x08, 0x00, //# # $ $    # #   #  
0x80, 0x04, 0x08, 0x80, 0x88, 0x08, 0x08, 0x88, 0x88, 0x00, //#  $ ## ## # #####  
0x80, 0x44, 0x00, 0x00, 0x04, 0x40, 0x08, 0x00, 0x00, 0x00, //# $$     $$  #      
0x88, 0x08, 0x80, 0x88, 0x80, 0x40, 0x08, 0x00, 0x00, 0x00, //## ## ### $  #      
0x08, 0x00, 0x00, 0x80, 0x80, 0x00, 0x08, 0x00, 0x00, 0x00, // #    # #    #      
0x08, 0x88, 0x88, 0x80, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, // ###### ######      
//Level: 251
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x08, 0x00, 0x88, 0x00, 0x00, 0x80, 0x00, 0x28, 0x88, //#  #  ##    #   @###
0x88, 0x00, 0x00, 0x40, 0x00, 0x08, 0x04, 0x88, 0x80, 0x08, //##    $    # $###  #
0x88, 0x48, 0x04, 0x08, 0x84, 0x80, 0x40, 0x40, 0x00, 0x08, //##$# $ ##$# $ $    #
0x80, 0x00, 0x48, 0x00, 0x00, 0x40, 0x00, 0x00, 0x08, 0x88, //#   $#    $      ###
0x80, 0x88, 0x00, 0x04, 0x08, 0x88, 0x00, 0x81, 0x11, 0x18, //# ##   $ ###  #....#
0x80, 0x80, 0x48, 0x08, 0x08, 0x08, 0x08, 0x11, 0x11, 0x88, //# # $# # # # #....##
0x80, 0x00, 0x04, 0x04, 0x08, 0x00, 0x81, 0x11, 0x18, 0x88, //#    $ $ #  #....###
0x88, 0x40, 0x88, 0x80, 0x04, 0x08, 0x11, 0x11, 0x88, 0x88, //##$ ###  $ #....####
0x80, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, //#  # $        ######
0x80, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x88, 0x88, 0x88, //#      # #    ######
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 252
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x08, 0x00, 0x00, 0x08, 0x00, 0x88, 0x00, 0x00, 0x88, //#  #     #  ##    ##
0x80, 0x48, 0x00, 0x04, 0x08, 0x00, 0x00, 0x08, 0x80, 0x08, //# $#   $ #     ##  #
0x80, 0x40, 0x04, 0x00, 0x81, 0x18, 0x00, 0x00, 0x04, 0x08, //# $  $  #..#     $ #
0x80, 0x40, 0x40, 0x08, 0x11, 0x11, 0x80, 0x00, 0x80, 0x88, //# $ $  #....#   # ##
0x80, 0x48, 0x00, 0x81, 0x11, 0x11, 0x18, 0x88, 0x04, 0x08, //# $#  #......### $ #
0x80, 0x00, 0x80, 0x08, 0x11, 0x11, 0x80, 0x08, 0x40, 0x08, //#   #  #....#  #$  #
0x80, 0x40, 0x08, 0x88, 0x81, 0x18, 0x00, 0x08, 0x00, 0x08, //# $  ####..#   #   #
0x88, 0x04, 0x00, 0x08, 0x80, 0x80, 0x80, 0x40, 0x04, 0x88, //## $   ## # # $  $##
0x88, 0x80, 0x40, 0x00, 0x04, 0x82, 0x40, 0x48, 0x00, 0x08, //### $    $#@$ $#   #
0x88, 0x88, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, //####   #       #   #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 253
0x0F, 0x10,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, // ############## 
0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x80, // #     #      # 
0x88, 0x08, 0x80, 0x00, 0x08, 0x08, 0x80, 0x80, //## ##    # ## # 
0x81, 0x11, 0x11, 0x01, 0x11, 0x11, 0x80, 0x80, //#..... .....# # 
0x81, 0x10, 0x18, 0x08, 0x10, 0x11, 0x80, 0x80, //#.. .# #. ..# # 
0x88, 0x88, 0x88, 0x08, 0x88, 0x88, 0x80, 0x80, //###### ###### # 
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x80, //     #        # 
0x08, 0x88, 0x88, 0x04, 0x88, 0x88, 0x80, 0x80, // ##### $##### # 
0x08, 0x00, 0x00, 0x82, 0x80, 0x00, 0x80, 0x80, // #    #@#   # # 
0x88, 0x40, 0x40, 0x84, 0x80, 0x00, 0x80, 0x80, //##$ $ #$#   # # 
0x80, 0x40, 0x04, 0x04, 0x00, 0x44, 0x40, 0x80, //# $  $ $  $$$ # 
0x80, 0x04, 0x00, 0x84, 0x80, 0x00, 0x80, 0x80, //#  $  #$#   # # 
0x80, 0x00, 0x44, 0x80, 0x84, 0x40, 0x80, 0x80, //#   $$# #$$ # # 
0x88, 0x88, 0x00, 0x00, 0x00, 0x88, 0x80, 0x80, //####      ### # 
0x00, 0x08, 0x88, 0x88, 0x80, 0x00, 0x00, 0x80, //   ######     # 
0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //        ####### 
//Level: 254
0x0F, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //###########     
0x80, 0x00, 0x88, 0x11, 0x11, 0x88, 0x88, 0x80, //#   ##....##### 
0x80, 0x04, 0x00, 0x11, 0x18, 0x80, 0x00, 0x80, //#  $  ...##   # 
0x88, 0x84, 0x40, 0x11, 0x88, 0x80, 0x80, 0x80, //###$$ ..### # # 
0x00, 0x80, 0x88, 0x11, 0x18, 0x84, 0x00, 0x80, //  # ##...##$  # 
0x00, 0x80, 0x80, 0x00, 0x88, 0x80, 0x08, 0x80, //  # #   ###  ## 
0x08, 0x80, 0x80, 0x40, 0x04, 0x04, 0x08, 0x00, // ## # $  $ $ #  
0x08, 0x00, 0x80, 0x80, 0x80, 0x00, 0x08, 0x00, // #  # # #    #  
0x08, 0x00, 0x00, 0x80, 0x40, 0x84, 0x08, 0x00, // #    # $ #$ #  
0x08, 0x04, 0x40, 0x80, 0x48, 0x00, 0x88, 0x00, // # $$ # $#  ##  
0x08, 0x88, 0x08, 0x80, 0x08, 0x08, 0x80, 0x00, // ### ##  # ##   
0x00, 0x08, 0x20, 0x00, 0x00, 0x08, 0x00, 0x00, //   #@      #    
0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, //   #########    
//Level: 255
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x80, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x28, //#   #    #   #   #@#
0x80, 0x40, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, 0x08, //# $      $   $   # #
0x88, 0x08, 0x88, 0x11, 0x88, 0x08, 0x88, 0x00, 0x00, 0x08, //## ###..## ###     #
0x80, 0x00, 0x81, 0x11, 0x18, 0x48, 0x00, 0x48, 0x88, 0x08, //#   #....#$#  $### #
0x80, 0x40, 0x81, 0x11, 0x18, 0x00, 0x40, 0x04, 0x04, 0x08, //# $ #....#  $  $ $ #
0x80, 0x00, 0x81, 0x11, 0x18, 0x08, 0x08, 0x04, 0x04, 0x08, //#   #....# # # $ $ #
0x80, 0x00, 0x88, 0x11, 0x88, 0x00, 0x08, 0x48, 0x00, 0x08, //#   ##..##   #$#   #
0x88, 0x48, 0x80, 0x00, 0x08, 0x80, 0x08, 0x00, 0x84, 0x88, //##$##    ##  #  #$##
0x80, 0x00, 0x40, 0x04, 0x00, 0x00, 0x08, 0x00, 0x80, 0x08, //#   $  $     #  #  #
0x80, 0x00, 0x80, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x08, //#   #    #   #     #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 256
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x08, //# #     #          #
0x80, 0x00, 0x00, 0x00, 0x40, 0x08, 0x80, 0x88, 0x80, 0x88, //#       $  ## ### ##
0x88, 0x88, 0x80, 0x08, 0x80, 0x00, 0x40, 0x04, 0x00, 0x08, //#####  ##   $  $   #
0x88, 0x11, 0x88, 0x00, 0x80, 0x80, 0x40, 0x80, 0x80, 0x08, //##..##  # # $ # #  #
0x81, 0x11, 0x10, 0x04, 0x00, 0x00, 0x08, 0x84, 0x80, 0x88, //#....  $     ##$# ##
0x81, 0x11, 0x10, 0x04, 0x88, 0x88, 0x80, 0x00, 0x84, 0x88, //#....  $#####   #$##
0x88, 0x11, 0x80, 0x80, 0x08, 0x00, 0x08, 0x00, 0x40, 0x08, //##..# #  #   #  $  #
0x88, 0x81, 0x80, 0x80, 0x04, 0x00, 0x04, 0x00, 0x80, 0x28, //###.# #  $   $  # @#
0x88, 0x00, 0x40, 0x04, 0x08, 0x00, 0x08, 0x00, 0x88, 0x88, //##  $  $ #   #  ####
0x88, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, //##       ###########
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 257
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x08, 0x00, 0x80, 0x80, 0x00, 0x08, 0x00, 0x80, 0x08, //#  #  # #    #  #  #
0x80, 0x00, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x08, //#   $      $ $     #
0x88, 0x08, 0x00, 0x84, 0x88, 0x84, 0x88, 0x00, 0x88, 0x08, //## #  #$###$##  ## #
0x80, 0x00, 0x40, 0x00, 0x00, 0x40, 0x08, 0x00, 0x40, 0x08, //#   $     $  #  $  #
0x80, 0x88, 0x84, 0x88, 0x48, 0x00, 0x08, 0x04, 0x00, 0x08, //# ###$##$#   # $   #
0x80, 0x80, 0x00, 0x40, 0x40, 0x08, 0x88, 0x88, 0x80, 0x48, //# #   $ $  ###### $#
0x80, 0x40, 0x04, 0x40, 0x40, 0x08, 0x28, 0x18, 0x11, 0x18, //# $  $$ $  #@#.#...#
0x80, 0x80, 0x00, 0x00, 0x80, 0x08, 0x08, 0x18, 0x11, 0x18, //# #     #  # #.#...#
0x80, 0x88, 0x88, 0x88, 0x88, 0x88, 0x08, 0x11, 0x11, 0x18, //# ########## #.....#
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x11, 0x11, 0x18, //#            #.....#
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 258
0x14, 0x0E,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //           ####     
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x20, 0x80, 0x00, 0x00, //  ##########@ #     
0x88, 0x80, 0x00, 0x80, 0x00, 0x88, 0x40, 0x88, 0x88, 0x88, //###   #   ##$ ######
0x80, 0x04, 0x40, 0x80, 0x00, 0x00, 0x40, 0x80, 0x01, 0x18, //#  $$ #     $ #  ..#
0x80, 0x80, 0x00, 0x80, 0x00, 0x88, 0x40, 0x00, 0x01, 0x18, //# #   #   ##$    ..#
0x80, 0x80, 0x00, 0x80, 0x44, 0x08, 0x00, 0x80, 0x01, 0x18, //# #   # $$ #  #  ..#
0x80, 0x80, 0x88, 0x88, 0x08, 0x08, 0x88, 0x80, 0x11, 0x18, //# # #### # #### ...#
0x80, 0x84, 0x08, 0x88, 0x08, 0x00, 0x80, 0x88, 0x88, 0x88, //# #$ ### #  # ######
0x80, 0x80, 0x08, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, //# #  #    # #       
0x80, 0x00, 0x00, 0x40, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, //#     $   # #       
0x80, 0x80, 0x08, 0x88, 0x08, 0x80, 0x80, 0x00, 0x00, 0x00, //# #  ### ## #       
0x80, 0x88, 0x88, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, //# ####      #       
0x80, 0x00, 0x00, 0x08, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //#      ######       
0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //########            
//Level: 259
0x0F, 0x0C,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //   #######      
0x00, 0x08, 0x00, 0x00, 0x08, 0x88, 0x88, 0x80, //   #     ###### 
0x00, 0x08, 0x00, 0x48, 0x00, 0x00, 0x00, 0x80, //   #  $#      # 
0x88, 0x88, 0x40, 0x04, 0x00, 0x84, 0x40, 0x80, //####$  $  #$$ # 
0x80, 0x00, 0x04, 0x40, 0x40, 0x00, 0x40, 0x80, //#    $$ $   $ # 
0x80, 0x48, 0x00, 0x88, 0x08, 0x88, 0x08, 0x80, //# $#  ## ### ## 
0x80, 0x28, 0x84, 0x04, 0x00, 0x40, 0x08, 0x00, //# @##$ $  $  #  
0x80, 0x00, 0x00, 0x40, 0x04, 0x04, 0x08, 0x00, //#     $  $ $ #  
0x88, 0x88, 0x88, 0x88, 0x88, 0x44, 0x08, 0x00, //##########$$ #  
0x00, 0x81, 0x11, 0x11, 0x11, 0x11, 0x88, 0x00, //  #.........##  
0x00, 0x81, 0x11, 0x11, 0x11, 0x11, 0x80, 0x00, //  #.........#   
0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //  ###########   
//Level: 260
0x10, 0x0E,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, // ############## 
0x08, 0x20, 0x05, 0x05, 0x05, 0x08, 0x00, 0x88, // #@  * * * #  ##
0x08, 0x48, 0x00, 0x50, 0x50, 0x08, 0x00, 0x08, // #$#  * *  #   #
0x08, 0x08, 0x05, 0x05, 0x05, 0x00, 0x00, 0x08, // # # * * *     #
0x08, 0x08, 0x00, 0x50, 0x50, 0x08, 0x80, 0x88, // # #  * *  ## ##
0x08, 0x08, 0x05, 0x05, 0x05, 0x08, 0x80, 0x80, // # # * * * ## # 
0x08, 0x08, 0x00, 0x50, 0x50, 0x08, 0x80, 0x80, // # #  * *  ## # 
0x08, 0x08, 0x05, 0x05, 0x05, 0x08, 0x80, 0x80, // # # * * * ## # 
0x08, 0x08, 0x00, 0x50, 0x50, 0x08, 0x80, 0x80, // # #  * *  ## # 
0x08, 0x08, 0x05, 0x01, 0x05, 0x08, 0x80, 0x88, // # # * . * ## ##
0x88, 0x08, 0x88, 0x88, 0x88, 0x88, 0x80, 0x08, //## ##########  #
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, //#              #
0x80, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x08, //#   #########  #
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x88, 0x88, //#####       ####
//Level: 261
0x08, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x81, 0x11, 0x11, 0x08, //#..... #
0x84, 0x08, 0x84, 0x08, //#$ ##$ #
0x80, 0x48, 0x80, 0x08, //# $##  #
0x80, 0x04, 0x24, 0x08, //#  $@$ #
0x80, 0x00, 0x00, 0x88, //#     ##
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 262
0x13, 0x0D,//Size x and y
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //#####               
0x80, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //#   ##              
0x80, 0x40, 0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //# $  #########      
0x88, 0x08, 0x08, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x80, //## # #       ###### 
0x88, 0x08, 0x00, 0x04, 0x84, 0x82, 0x00, 0x80, 0x00, 0x80, //## #   $#$#@  #   # 
0x80, 0x08, 0x00, 0x00, 0x00, 0x40, 0x80, 0x00, 0x40, 0x80, //#  #      $ #   $ # 
0x80, 0x08, 0x88, 0x08, 0x88, 0x88, 0x88, 0x88, 0x08, 0x80, //#  ### ######### ## 
0x80, 0x08, 0x80, 0x11, 0x51, 0x11, 0x11, 0x08, 0x08, 0x80, //#  ## ..*..... # ## 
0x88, 0x08, 0x80, 0x51, 0x51, 0x15, 0x15, 0x08, 0x08, 0x80, //## ## *.*..*.* # ## 
0x80, 0x48, 0x88, 0x88, 0x88, 0x88, 0x80, 0x88, 0x40, 0x80, //# $########## ##$ # 
0x80, 0x04, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04, 0x00, 0x80, //#  $   $  $    $  # 
0x80, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x80, //#  #   #   #   #  # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //################### 
//Level: 263
0x13, 0x10,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x80, //             ###### 
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x11, 0x11, 0x80, // #############....# 
0x88, 0x00, 0x08, 0x80, 0x00, 0x00, 0x88, 0x11, 0x11, 0x80, //##   ##     ##....# 
0x80, 0x04, 0x48, 0x80, 0x04, 0x02, 0x88, 0x11, 0x11, 0x80, //#  $$##  $ @##....# 
0x80, 0x00, 0x00, 0x04, 0x40, 0x48, 0x00, 0x11, 0x11, 0x80, //#      $$ $#  ....# 
0x80, 0x04, 0x08, 0x80, 0x44, 0x08, 0x08, 0x01, 0x11, 0x80, //#  $ ## $$ # # ...# 
0x80, 0x04, 0x08, 0x80, 0x40, 0x08, 0x00, 0x11, 0x11, 0x80, //#  $ ## $  #  ....# 
0x88, 0x08, 0x88, 0x88, 0x08, 0x88, 0x08, 0x81, 0x88, 0x80, //## ##### ### ##.### 
0x88, 0x00, 0x04, 0x00, 0x40, 0x88, 0x00, 0x01, 0x00, 0x80, //##   $  $ ##   .  # 
0x80, 0x48, 0x88, 0x00, 0x80, 0x88, 0x88, 0x80, 0x88, 0x80, //# $###  # ##### ### 
0x80, 0x00, 0x40, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, //#   $   #       #   
0x80, 0x04, 0x08, 0x40, 0x40, 0x48, 0x88, 0x00, 0x80, 0x00, //#  $ #$ $ $###  #   
0x80, 0x44, 0x48, 0x04, 0x00, 0x08, 0x08, 0x88, 0x80, 0x00, //# $$$# $   # ####   
0x80, 0x00, 0x08, 0x00, 0x44, 0x08, 0x00, 0x00, 0x00, 0x00, //#    #  $$ #        
0x88, 0x88, 0x88, 0x00, 0x08, 0x88, 0x00, 0x00, 0x00, 0x00, //######   ###        
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //     #####          
//Level: 264
0x10, 0x0E,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x08, 0x88, 0x88, 0x80, // ####### ###### 
0x08, 0x00, 0x00, 0x08, 0x88, 0x00, 0x00, 0x80, // #     ###    # 
0x08, 0x00, 0x88, 0x08, 0x00, 0x44, 0x80, 0x88, // #  ## #  $$# ##
0x08, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x08, // #$ $ $ $ $    #
0x08, 0x04, 0x04, 0x08, 0x00, 0x08, 0x00, 0x08, // # $ $ #   #   #
0x88, 0x00, 0x44, 0x08, 0x88, 0x88, 0x81, 0x88, //##  $$ ######.##
0x80, 0x40, 0x00, 0x08, 0x00, 0x08, 0x11, 0x18, //# $    #   #...#
0x82, 0x84, 0x40, 0x88, 0x00, 0x08, 0x11, 0x18, //#@#$$ ##   #...#
0x80, 0x04, 0x00, 0x08, 0x00, 0x08, 0x11, 0x18, //#  $   #   #...#
0x88, 0x00, 0x84, 0x08, 0x00, 0x08, 0x11, 0x18, //##  #$ #   #...#
0x08, 0x44, 0x80, 0x08, 0x88, 0x88, 0x11, 0x18, // #$$#  #####...#
0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x11, 0x18, // #     $    ...#
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x08, // ###########   #
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, //           #####
//Level: 265
0x14, 0x0E,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x80, 0x88, 0x88, 0x00, 0x00, //       #### ####    
0x00, 0x00, 0x08, 0x88, 0x00, 0x80, 0x80, 0x08, 0x00, 0x00, //     ###  # #  #    
0x00, 0x88, 0x88, 0x00, 0x40, 0x88, 0x80, 0x48, 0x00, 0x00, //  ####  $ ### $#    
0x00, 0x80, 0x40, 0x00, 0x40, 0x00, 0x00, 0x08, 0x00, 0x00, //  # $   $      #    
0x88, 0x80, 0x08, 0x80, 0x40, 0x04, 0x00, 0x48, 0x00, 0x00, //###  ## $  $  $#    
0x80, 0x00, 0x00, 0x00, 0x80, 0x40, 0x88, 0x08, 0x00, 0x00, //#       # $ ## #    
0x80, 0x84, 0x44, 0x48, 0x04, 0x40, 0x40, 0x08, 0x00, 0x00, //# #$$$$# $$ $  #    
0x80, 0x00, 0x04, 0x04, 0x40, 0x88, 0x88, 0x08, 0x88, 0x88, //#    $ $$ #### #####
0x88, 0x88, 0x00, 0x00, 0x40, 0x28, 0x80, 0x11, 0x11, 0x18, //####    $ @## .....#
0x08, 0x00, 0x44, 0x88, 0x08, 0x88, 0x80, 0x11, 0x11, 0x88, // #  $$## #### ....##
0x08, 0x04, 0x00, 0x81, 0x11, 0x18, 0x80, 0x11, 0x88, 0x80, // # $  #....## ..### 
0x08, 0x08, 0x00, 0x41, 0x11, 0x18, 0x88, 0x88, 0x80, 0x00, // # #  $....######   
0x08, 0x88, 0x80, 0x01, 0x11, 0x18, 0x00, 0x00, 0x00, 0x00, // ####  ....#        
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //    ########        
//Level: 266
0x0F, 0x0E,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //    ######      
0x08, 0x88, 0x80, 0x00, 0x08, 0x88, 0x88, 0x80, // ####    ###### 
0x08, 0x00, 0x80, 0x40, 0x00, 0x08, 0x00, 0x80, // #  # $    #  # 
0x08, 0x04, 0x00, 0x84, 0x40, 0x04, 0x40, 0x80, // # $  #$$  $$ # 
0x08, 0x00, 0x48, 0x00, 0x81, 0x18, 0x10, 0x80, // #  $#  #..#. # 
0x88, 0x40, 0x08, 0x08, 0x11, 0x15, 0x18, 0x80, //##$  # #...*.## 
0x80, 0x40, 0x80, 0x40, 0x11, 0x88, 0x10, 0x80, //# $ # $ ..##. # 
0x80, 0x84, 0x04, 0x08, 0x11, 0x11, 0x10, 0x80, //# #$ $ #..... # 
0x80, 0x00, 0x08, 0x00, 0x80, 0x08, 0x88, 0x80, //#    #  #  #### 
0x80, 0x48, 0x00, 0x80, 0x00, 0x28, 0x80, 0x00, //# $#  #   @##   
0x80, 0x00, 0x04, 0x80, 0x80, 0x08, 0x00, 0x00, //#    $# #  #    
0x88, 0x88, 0x00, 0x40, 0x88, 0x88, 0x00, 0x00, //####  $ ####    
0x00, 0x08, 0x00, 0x88, 0x80, 0x00, 0x00, 0x00, //   #  ###       
0x00, 0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //   ####         
//Level: 267
0x0D, 0x0D,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, //    ####      
0x00, 0x00, 0x80, 0x28, 0x88, 0x00, 0x00, //    # @###    
0x00, 0x88, 0x80, 0x40, 0x08, 0x80, 0x00, //  ### $  ##   
0x08, 0x80, 0x04, 0x14, 0x00, 0x80, 0x00, // ##  $.$  #   
0x08, 0x00, 0x41, 0x51, 0x40, 0x88, 0x80, // #  $.*.$ ### 
0x88, 0x04, 0x15, 0x15, 0x14, 0x00, 0x80, //## $.*.*.$  # 
0x80, 0x41, 0x51, 0x51, 0x51, 0x40, 0x80, //# $.*.*.*.$ # 
0x80, 0x04, 0x15, 0x15, 0x14, 0x08, 0x80, //#  $.*.*.$ ## 
0x88, 0x80, 0x41, 0x51, 0x40, 0x08, 0x00, //### $.*.$  #  
0x00, 0x80, 0x04, 0x14, 0x00, 0x88, 0x00, //  #  $.$  ##  
0x00, 0x88, 0x00, 0x40, 0x88, 0x80, 0x00, //  ##  $ ###   
0x00, 0x08, 0x88, 0x00, 0x80, 0x00, 0x00, //   ###  #     
0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //     ####     
//Level: 268
0x0D, 0x0B,//Size x and y
0x08, 0x88, 0x80, 0x08, 0x88, 0x88, 0x80, // ####  ###### 
0x08, 0x00, 0x88, 0x88, 0x00, 0x00, 0x80, // #  ####    # 
0x88, 0x50, 0x00, 0x50, 0x55, 0x00, 0x80, //##*   * **  # 
0x80, 0x40, 0x50, 0x00, 0x05, 0x80, 0x80, //# $ *    *# # 
0x80, 0x10, 0x00, 0x88, 0x80, 0x00, 0x80, //# .   ###   # 
0x88, 0x88, 0x88, 0x00, 0x08, 0x28, 0x80, //######   #@## 
0x80, 0x50, 0x10, 0x50, 0x05, 0x50, 0x80, //# * . *  ** # 
0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, //#   #   #   # 
0x88, 0x50, 0x00, 0x50, 0x84, 0x80, 0x80, //##*   * #$# # 
0x08, 0x00, 0x88, 0x88, 0x80, 0x00, 0x80, // #  #####   # 
0x08, 0x88, 0x80, 0x00, 0x88, 0x88, 0x80, // ####   ##### 
//Level: 269
0x09, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
0x00, 0x80, 0x00, 0x88, 0x00, //  #   ##  
0x88, 0x84, 0x00, 0x08, 0x80, //###$   ## 
0x80, 0x01, 0x41, 0x40, 0x80, //#  .$.$ # 
0x80, 0x81, 0x81, 0x80, 0x80, //# #.#.# # 
0x80, 0x05, 0x45, 0x00, 0x80, //#  *$*  # 
0x88, 0x80, 0x00, 0x88, 0x80, //###   ### 
0x00, 0x80, 0x20, 0x80, 0x00, //  # @ #   
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
//Level: 270
0x08, 0x07,//Size x and y
0x88, 0x88, 0x80, 0x00, //#####   
0x80, 0x00, 0x88, 0x80, //#   ### 
0x80, 0x80, 0x52, 0x88, //# # *@##
0x80, 0x05, 0x00, 0x08, //#  *   #
0x88, 0x84, 0x00, 0x08, //###$   #
0x00, 0x80, 0x00, 0x18, //  #   .#
0x00, 0x88, 0x88, 0x88, //  ######
//Level: 271
0x11, 0x10,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //   ########       
0x00, 0x08, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x00, //   #   #  #       
0x00, 0x08, 0x00, 0x40, 0x00, 0x80, 0x00, 0x00, 0x00, //   #  $   #       
0x08, 0x88, 0x08, 0x40, 0x00, 0x88, 0x88, 0x00, 0x00, // ### #$   ####    
0x08, 0x00, 0x40, 0x08, 0x84, 0x00, 0x08, 0x00, 0x00, // #  $  ##$   #    
0x08, 0x00, 0x80, 0x20, 0x40, 0x80, 0x48, 0x00, 0x00, // #  # @ $ # $#    
0x08, 0x00, 0x80, 0x00, 0x00, 0x04, 0x08, 0x88, 0x80, // #  #      $ #### 
0x08, 0x80, 0x88, 0x88, 0x48, 0x80, 0x00, 0x00, 0x80, // ## ####$##     # 
0x08, 0x04, 0x81, 0x11, 0x11, 0x80, 0x80, 0x00, 0x80, // # $#.....# #   # 
0x08, 0x00, 0x41, 0x15, 0x51, 0x04, 0x80, 0x88, 0x80, // #  $..**. $# ### 
0x88, 0x00, 0x81, 0x11, 0x11, 0x80, 0x00, 0x80, 0x00, //##  #.....#   #   
0x80, 0x00, 0x88, 0x80, 0x88, 0x88, 0x88, 0x80, 0x00, //#   ### #######   
0x80, 0x44, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, //# $$  #  #        
0x80, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, //#  #     #        
0x88, 0x88, 0x88, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, //######   #        
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //     #####        
//Level: 272
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x88, 0x11, 0x10, 0x00, 0x88, 0x08, 0x00, 0x00, 0x80, 0x08, //##...   ## #    #  #
0x81, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x40, 0x88, 0x08, //#....         $ ## #
0x81, 0x11, 0x18, 0x08, 0x08, 0x48, 0x88, 0x40, 0x00, 0x08, //#....# # #$###$    #
0x81, 0x11, 0x80, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x08, //#...#    #       # #
0x88, 0x18, 0x00, 0x84, 0x08, 0x00, 0x00, 0x04, 0x88, 0x08, //##.#  #$ #     $## #
0x80, 0x08, 0x00, 0x80, 0x40, 0x40, 0x88, 0x80, 0x04, 0x08, //#  #  # $ $ ###  $ #
0x80, 0x00, 0x00, 0x40, 0x04, 0x08, 0x00, 0x80, 0x88, 0x08, //#     $  $ #  # ## #
0x88, 0x08, 0x08, 0x80, 0x84, 0x48, 0x04, 0x80, 0x08, 0x08, //## # ## #$$# $#  # #
0x80, 0x08, 0x00, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00, 0x88, //#  #   $ $ #      ##
0x80, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x80, 0x00, 0x28, //#    #     #  #   @#
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 273
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x08, 0x00, 0x80, 0x80, 0x08, 0x00, 0x80, 0x08, //#    #  # #  #  #  #
0x80, 0x28, 0x08, 0x08, 0x80, 0x40, 0x00, 0x40, 0x00, 0x88, //# @# # ## $   $   ##
0x88, 0x88, 0x08, 0x00, 0x00, 0x80, 0x08, 0x04, 0x00, 0x08, //#### #    #  # $   #
0x80, 0x00, 0x08, 0x08, 0x80, 0x84, 0x08, 0x80, 0x88, 0x08, //#    # ## #$ ## ## #
0x80, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x08, //#      $   $   $   #
0x81, 0x18, 0x88, 0x44, 0x88, 0x04, 0x88, 0x40, 0x88, 0x08, //#..###$$## $##$ ## #
0x81, 0x18, 0x18, 0x00, 0x80, 0x40, 0x00, 0x40, 0x80, 0x08, //#..#.#  # $   $ #  #
0x81, 0x11, 0x18, 0x04, 0x40, 0x00, 0x88, 0x40, 0x88, 0x88, //#....# $$   ##$ ####
0x81, 0x11, 0x18, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x08, //#....#  #####      #
0x81, 0x11, 0x88, 0x80, 0x00, 0x00, 0x00, 0x08, 0x80, 0x08, //#...###        ##  #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 274
0x12, 0x0D,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, //     #########    
0x00, 0x00, 0x08, 0x00, 0x00, 0x11, 0x18, 0x00, 0x00, //     #    ...#    
0x00, 0x00, 0x08, 0x08, 0x00, 0x11, 0x18, 0x00, 0x00, //     # #  ...#    
0x00, 0x00, 0x08, 0x08, 0x80, 0x01, 0x18, 0x00, 0x00, //     # ##  ..#    
0x88, 0x88, 0x88, 0x04, 0x04, 0x08, 0x88, 0x00, 0x00, //###### $ $ ###    
0x81, 0x11, 0x40, 0x40, 0x42, 0x88, 0x00, 0x00, 0x00, //#...$ $ $@##      
0x81, 0x18, 0x04, 0x04, 0x04, 0x88, 0x88, 0x88, 0x88, //#..# $ $ $########
0x81, 0x11, 0x80, 0x40, 0x40, 0x00, 0x00, 0x00, 0x08, //#...# $ $        #
0x81, 0x11, 0x04, 0x04, 0x00, 0x84, 0x84, 0x88, 0x08, //#... $ $  #$#$## #
0x80, 0x08, 0x88, 0x80, 0x40, 0x40, 0x40, 0x80, 0x08, //#  #### $ $ $ #  #
0x80, 0x08, 0x00, 0x80, 0x04, 0x00, 0x04, 0x00, 0x08, //#  #  #  $   $   #
0x88, 0x88, 0x00, 0x88, 0x00, 0x08, 0x88, 0x88, 0x88, //####  ##   #######
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, //       #####      
//Level: 275
0x10, 0x0D,//Size x and y
0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, // ####           
0x88, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##  ############
0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, //# $ $ $ $ $ $ @#
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x40, 0x08, //# #         $  #
0x80, 0x80, 0x08, 0x88, 0x85, 0x88, 0x84, 0x88, //# #  ####*###$##
0x80, 0x80, 0x08, 0x11, 0x11, 0x18, 0x00, 0x80, //# #  #.....#  # 
0x80, 0x84, 0x08, 0x15, 0x55, 0x15, 0x00, 0x80, //# #$ #.***.*  # 
0x80, 0x80, 0x05, 0x11, 0x11, 0x18, 0x00, 0x80, //# #  *.....#  # 
0x80, 0x80, 0x48, 0x88, 0x88, 0x88, 0x44, 0x80, //# # $#######$$# 
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#             # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x80, 0x80, //########### # # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, //          #   # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, //          ##### 
//Level: 276
0x0E, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##############
0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, //#.           #
0x81, 0x40, 0x40, 0x40, 0x40, 0x40, 0x08, //#.$ $ $ $ $  #
0x81, 0x88, 0x88, 0x88, 0x88, 0x80, 0x08, //#.#########  #
0x81, 0x81, 0x50, 0x40, 0x11, 0x45, 0x88, //#.#.* $ ..$*##
0x81, 0x80, 0x40, 0x40, 0x51, 0x42, 0x80, //#.# $ $ *.$@# 
0x81, 0x81, 0x00, 0x40, 0x11, 0x44, 0x80, //#.#.  $ ..$$# 
0x81, 0x88, 0x88, 0x88, 0x88, 0x81, 0x80, //#.#########.# 
0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#.          # 
0x81, 0x84, 0x84, 0x84, 0x84, 0x84, 0x80, //#.#$#$#$#$#$# 
0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#.          # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############# 
//Level: 277
0x08, 0x08,//Size x and y
0x88, 0x88, 0x00, 0x00, //####    
0x81, 0x08, 0x00, 0x00, //#. #    
0x80, 0x48, 0x00, 0x00, //# $#    
0x80, 0x08, 0x88, 0x88, //#  #####
0x80, 0x14, 0x02, 0x08, //# .$ @ #
0x80, 0x14, 0x08, 0x08, //# .$ # #
0x88, 0x80, 0x00, 0x08, //###    #
0x00, 0x88, 0x88, 0x88, //  ######
//Level: 278
0x08, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x00, 0x00, 0x08, //#      #
0x80, 0x84, 0x00, 0x08, //# #$   #
0x80, 0x40, 0x28, 0x18, //# $ @#.#
0x88, 0x48, 0x10, 0x08, //##$#.  #
0x08, 0x00, 0x00, 0x18, // #    .#
0x08, 0x88, 0x88, 0x88, // #######
//Level: 279
0x13, 0x11,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x80, //           ######## 
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x11, 0x11, 0x11, 0x80, //           #......# 
0x00, 0x08, 0x88, 0x80, 0x00, 0x08, 0x11, 0x11, 0x11, 0x80, //   ####    #......# 
0x00, 0x08, 0x00, 0x88, 0x88, 0x88, 0x88, 0x81, 0x11, 0x80, //   #  #########...# 
0x00, 0x08, 0x04, 0x00, 0x04, 0x00, 0x00, 0x81, 0x11, 0x80, //   # $   $    #...# 
0x00, 0x08, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x80, //   #  # # # # #   # 
0x88, 0x88, 0x80, 0x80, 0x80, 0x82, 0x80, 0x80, 0x00, 0x80, //##### # # #@# #   # 
0x80, 0x00, 0x80, 0x88, 0x80, 0x88, 0x80, 0x88, 0x08, 0x80, //#   # ### ### ## ## 
0x80, 0x00, 0x04, 0x08, 0x04, 0x04, 0x04, 0x08, 0x08, 0x00, //#    $ # $ $ $ # #  
0x80, 0x44, 0x40, 0x04, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, //# $$$  $   #     #  
0x80, 0x00, 0x80, 0x88, 0x84, 0x88, 0x84, 0x88, 0x08, 0x00, //#   # ###$###$## #  
0x88, 0x80, 0x80, 0x04, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, //### #  $   #     #  
0x08, 0x80, 0x40, 0x08, 0x04, 0x04, 0x04, 0x08, 0x88, 0x00, // ## $  # $ $ $ ###  
0x08, 0x00, 0x80, 0x88, 0x80, 0x88, 0x80, 0x88, 0x00, 0x00, // #  # ### ### ##    
0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, // # $          #     
0x08, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, // #  ###########     
0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ####               
//Level: 280
0x0F, 0x0E,//Size x and y
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //####            
0x80, 0x08, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //#  ###          
0x80, 0x40, 0x08, 0x88, 0x00, 0x00, 0x00, 0x00, //# $  ###        
0x80, 0x40, 0x40, 0x08, 0x88, 0x00, 0x00, 0x00, //# $ $  ###      
0x80, 0x40, 0x40, 0x40, 0x08, 0x88, 0x00, 0x00, //# $ $ $  ###    
0x80, 0x40, 0x40, 0x40, 0x00, 0x08, 0x00, 0x00, //# $ $ $    #    
0x80, 0x40, 0x40, 0x08, 0x00, 0x08, 0x80, 0x00, //# $ $  #   ##   
0x80, 0x40, 0x08, 0x80, 0x44, 0x40, 0x80, 0x00, //# $  ## $$$ #   
0x82, 0x08, 0x88, 0x80, 0x00, 0x00, 0x88, 0x00, //#@ ####     ##  
0x88, 0x08, 0x08, 0x14, 0x44, 0x44, 0x18, 0x00, //## # #.$$$$$.#  
0x08, 0x08, 0x88, 0x11, 0x11, 0x11, 0x18, 0x80, // # ###.......## 
0x08, 0x00, 0x01, 0x55, 0x55, 0x55, 0x51, 0x80, // #   .*******.# 
0x08, 0x88, 0x81, 0x11, 0x11, 0x11, 0x11, 0x80, // ####.........# 
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //    ########### 
//Level: 281
0x10, 0x12,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //    #######     
0x00, 0x00, 0x80, 0x00, 0x82, 0x80, 0x00, 0x00, //    #   #@#     
0x08, 0x88, 0x80, 0x80, 0x80, 0x88, 0x88, 0x80, // #### # # ##### 
0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, // #    #       # 
0x08, 0x04, 0x84, 0x88, 0x88, 0x88, 0x80, 0x80, // # $#$####### # 
0x88, 0x40, 0x00, 0x81, 0x18, 0x11, 0x84, 0x88, //##$   #..#..#$##
0x80, 0x00, 0x04, 0x41, 0x11, 0x11, 0x80, 0x08, //#    $$.....#  #
0x80, 0x40, 0x40, 0x81, 0x11, 0x11, 0x44, 0x08, //# $ $ #.....$$ #
0x88, 0x00, 0x08, 0x81, 0x11, 0x81, 0x80, 0x08, //##   ##...#.#  #
0x08, 0x04, 0x00, 0x88, 0x11, 0x18, 0x84, 0x08, // # $  ##...##$ #
0x08, 0x08, 0x80, 0x88, 0x88, 0x88, 0x80, 0x08, // # ## #######  #
0x08, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x88, // #      $ $ $ ##
0x08, 0x88, 0x88, 0x80, 0x00, 0x40, 0x80, 0x80, // ######   $ # # 
0x00, 0x00, 0x00, 0x88, 0x08, 0x04, 0x00, 0x80, //      ## # $  # 
0x00, 0x00, 0x00, 0x80, 0x44, 0x04, 0x00, 0x80, //      # $$ $  # 
0x00, 0x00, 0x00, 0x80, 0x00, 0x40, 0x00, 0x80, //      #   $   # 
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x80, //      ######  # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x80, //           #### 
//Level: 282
0x0B, 0x07,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x80, // ########## 
0x88, 0x04, 0x00, 0x51, 0x50, 0x80, //## $  *.* # 
0x80, 0x04, 0x00, 0x51, 0x50, 0x80, //#  $  *.* # 
0x80, 0x04, 0x00, 0x51, 0x52, 0x80, //#  $  *.*@# 
0x80, 0x04, 0x00, 0x51, 0x50, 0x80, //#  $  *.* # 
0x80, 0x04, 0x00, 0x51, 0x50, 0x80, //#  $  *.* # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //########### 
//Level: 283
0x0F, 0x0D,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, //      ####      
0x00, 0x00, 0x00, 0x80, 0x08, 0x88, 0x88, 0x80, //      #  ###### 
0x00, 0x00, 0x00, 0x80, 0x00, 0x08, 0x00, 0x80, //      #    #  # 
0x00, 0x00, 0x00, 0x80, 0x44, 0x00, 0x00, 0x80, //      # $$    # 
0x88, 0x88, 0x88, 0x84, 0x80, 0x08, 0x00, 0x80, //#######$#  #  # 
0x80, 0x08, 0x15, 0x11, 0x08, 0x88, 0x48, 0x80, //#  #.*.. ###$## 
0x80, 0x08, 0x18, 0x51, 0x40, 0x00, 0x00, 0x80, //#  #.#*.$     # 
0x80, 0x08, 0x18, 0x15, 0x80, 0x80, 0x00, 0x80, //#  #.#.*# #   # 
0x80, 0x44, 0x11, 0x11, 0x80, 0x88, 0x88, 0x80, //# $$....# ##### 
0x80, 0x24, 0x08, 0x00, 0x00, 0x80, 0x00, 0x00, //# @$ #    #     
0x80, 0x44, 0x48, 0x00, 0x00, 0x80, 0x00, 0x00, //# $$$#    #     
0x80, 0x00, 0x08, 0x88, 0x88, 0x80, 0x00, 0x00, //#    ######     
0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //######          
//Level: 284
0x10, 0x0E,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, // #######        
0x08, 0x00, 0x00, 0x08, 0x00, 0x08, 0x88, 0x88, // #     #   #####
0x08, 0x00, 0x88, 0x08, 0x88, 0x88, 0x00, 0x08, // #  ## #####   #
0x08, 0x40, 0x40, 0x40, 0x08, 0x00, 0x08, 0x08, // #$ $ $  #   # #
0x08, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00, 0x08, // # $ $ #       #
0x88, 0x00, 0x44, 0x08, 0x88, 0x48, 0x88, 0x08, //##  $$ ###$### #
0x80, 0x40, 0x00, 0x08, 0x11, 0x11, 0x80, 0x08, //# $    #....#  #
0x82, 0x84, 0x40, 0x88, 0x11, 0x11, 0x80, 0x08, //#@#$$ ##....#  #
0x80, 0x04, 0x00, 0x08, 0x11, 0x11, 0x40, 0x08, //#  $   #....$  #
0x88, 0x00, 0x88, 0x08, 0x11, 0x11, 0x80, 0x88, //##  ## #....# ##
0x08, 0x44, 0x80, 0x08, 0x80, 0x88, 0x80, 0x08, // #$$#  ## ###  #
0x08, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x08, // #      $      #
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x08, // ############  #
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, //            ####
//Level: 285
0x10, 0x0D,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //  #########     
0x00, 0x80, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, //  #    #  #     
0x88, 0x80, 0x84, 0x00, 0x40, 0x88, 0x88, 0x00, //### #$  $ ####  
0x80, 0x04, 0x00, 0x88, 0x11, 0x80, 0x08, 0x88, //#  $  ##..#  ###
0x80, 0x80, 0x04, 0x08, 0x11, 0x40, 0x40, 0x08, //# #  $ #..$ $  #
0x80, 0x44, 0x00, 0x48, 0x11, 0x00, 0x80, 0x08, //# $$  $#..  #  #
0x88, 0x00, 0x80, 0x01, 0x11, 0x84, 0x00, 0x08, //##  #  ...#$   #
0x08, 0x40, 0x20, 0x81, 0x11, 0x80, 0x40, 0x88, // #$ @ #...# $ ##
0x08, 0x00, 0x00, 0x81, 0x11, 0x40, 0x08, 0x80, // #    #...$  ## 
0x08, 0x08, 0x84, 0x08, 0x88, 0x00, 0x08, 0x00, // # ##$ ###   #  
0x08, 0x00, 0x04, 0x00, 0x00, 0x08, 0x88, 0x00, // #   $     ###  
0x08, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, // #  ########    
0x08, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, // ####           
//Level: 286
0x09, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x82, 0x00, 0x50, 0x00, 0x80, //#@  *   # 
0x80, 0x44, 0x14, 0x00, 0x80, //# $$.$  # 
0x81, 0x11, 0x15, 0x55, 0x80, //#....***# 
0x80, 0x44, 0x14, 0x00, 0x80, //# $$.$  # 
0x80, 0x00, 0x50, 0x00, 0x80, //#   *   # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 287
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x02, 0x88, 0x00, 0x00, 0x00, 0x80, 0x00, 0x88, //#    @##      #   ##
0x80, 0x00, 0x08, 0x80, 0x00, 0x04, 0x00, 0x00, 0x40, 0x88, //#    ##    $    $ ##
0x80, 0x08, 0x88, 0x11, 0x11, 0x80, 0x80, 0x80, 0x08, 0x88, //#  ###....# # #  ###
0x80, 0x00, 0x81, 0x11, 0x18, 0x08, 0x08, 0x04, 0x00, 0x08, //#   #....# # # $   #
0x88, 0x80, 0x81, 0x11, 0x80, 0x08, 0x00, 0x00, 0x00, 0x08, //### #...#  #       #
0x88, 0x00, 0x88, 0x18, 0x00, 0x00, 0x04, 0x00, 0x04, 0x08, //##  ##.#     $   $ #
0x88, 0x00, 0x40, 0x40, 0x88, 0x80, 0x08, 0x08, 0x08, 0x88, //##  $ $ ###  # # ###
0x88, 0x04, 0x00, 0x00, 0x00, 0x08, 0x08, 0x04, 0x00, 0x08, //## $       # # $   #
0x88, 0x88, 0x04, 0x00, 0x48, 0x08, 0x08, 0x08, 0x04, 0x08, //#### $  $# # # # $ #
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x88, //####         # #  ##
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 288
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x02, 0x08, 0x88, //## @ ###
0x88, 0x01, 0x00, 0x08, //## .   #
0x81, 0x04, 0x14, 0x08, //#. $.$ #
0x88, 0x48, 0x08, 0x88, //##$# ###
0x88, 0x00, 0x08, 0x88, //##   ###
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
//Level: 289
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x20, 0x88, 0x88, //##@ ####
0x88, 0x00, 0x88, 0x88, //##  ####
0x88, 0x10, 0x88, 0x88, //##. ####
0x80, 0x44, 0x10, 0x18, //# $$. .#
0x80, 0x04, 0x08, 0x88, //#  $ ###
0x88, 0x80, 0x08, 0x88, //###  ###
0x88, 0x88, 0x88, 0x88, //########
//Level: 290
0x0A, 0x12,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x80, // ######## 
0x08, 0x11, 0x11, 0x11, 0x80, // #......# 
0x08, 0x11, 0x88, 0x11, 0x80, // #..##..# 
0x08, 0x11, 0x11, 0x11, 0x80, // #......# 
0x08, 0x11, 0x55, 0x11, 0x80, // #..**..# 
0x08, 0x88, 0x11, 0x88, 0x80, // ###..### 
0x08, 0x00, 0x44, 0x00, 0x80, // #  $$  # 
0x08, 0x00, 0x00, 0x00, 0x80, // #      # 
0x08, 0x04, 0x44, 0x40, 0x80, // # $$$$ # 
0x88, 0x80, 0x00, 0x08, 0x88, //###    ###
0x80, 0x04, 0x44, 0x40, 0x08, //#  $$$$  #
0x80, 0x00, 0x00, 0x00, 0x08, //#        #
0x80, 0x44, 0x44, 0x44, 0x08, //# $$$$$$ #
0x88, 0x00, 0x00, 0x00, 0x88, //##      ##
0x80, 0x44, 0x44, 0x44, 0x08, //# $$$$$$ #
0x80, 0x00, 0x20, 0x00, 0x08, //#   @    #
0x80, 0x08, 0x88, 0x80, 0x08, //#  ####  #
0x88, 0x88, 0x00, 0x88, 0x88, //####  ####
//Level: 291
0x0F, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x80, //#      #      # 
0x80, 0x40, 0x84, 0x08, 0x04, 0x88, 0x40, 0x80, //# $ #$ # $##$ # 
0x80, 0x80, 0x04, 0x08, 0x00, 0x00, 0x00, 0x80, //# #  $ #      # 
0x80, 0x00, 0x88, 0x48, 0x48, 0x84, 0x40, 0x80, //#   ##$#$##$$ # 
0x80, 0x80, 0x80, 0x11, 0x10, 0x80, 0x00, 0x80, //# # # ... #   # 
0x80, 0x40, 0x01, 0x08, 0x01, 0x40, 0x80, 0x80, //# $  . # .$ # # 
0x80, 0x48, 0x24, 0x11, 0x18, 0x08, 0x00, 0x80, //# $#@$...# #  # 
0x80, 0x00, 0x01, 0x08, 0x01, 0x00, 0x40, 0x80, //#    . # .  $ # 
0x80, 0x88, 0x14, 0x88, 0x84, 0x10, 0x80, 0x80, //# ##.$###$. # # 
0x80, 0x80, 0x41, 0x11, 0x11, 0x08, 0x80, 0x80, //# # $..... ## # 
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#             # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
//Level: 292
0x0F, 0x0A,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, // #############  
0x08, 0x00, 0x00, 0x80, 0x08, 0x80, 0x08, 0x00, // #    #  ##  #  
0x08, 0x44, 0x40, 0x80, 0x44, 0x00, 0x48, 0x80, // #$$$ # $$  $## 
0x08, 0x04, 0x00, 0x80, 0x01, 0x11, 0x10, 0x80, // # $  #  .... # 
0x08, 0x00, 0x40, 0x08, 0x41, 0x88, 0x10, 0x80, // #  $  #$.##. # 
0x08, 0x00, 0x80, 0x48, 0x01, 0x11, 0x18, 0x80, // #  # $# ....## 
0x88, 0x40, 0x40, 0x08, 0x41, 0x88, 0x10, 0x80, //##$ $  #$.##. # 
0x80, 0x40, 0x04, 0x02, 0x41, 0x11, 0x10, 0x80, //# $  $ @$.... # 
0x80, 0x00, 0x88, 0x80, 0x08, 0x88, 0x88, 0x80, //#   ###  ###### 
0x88, 0x88, 0x80, 0x88, 0x88, 0x00, 0x00, 0x00, //##### ####      
//Level: 293
0x09, 0x07,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
0x88, 0x80, 0x00, 0x88, 0x80, //###   ### 
0x80, 0x10, 0x40, 0x10, 0x80, //# . $ . # 
0x80, 0x81, 0x41, 0x80, 0x80, //# #.$.# # 
0x80, 0x40, 0x80, 0x40, 0x80, //# $ # $ # 
0x88, 0x80, 0x20, 0x88, 0x80, //### @ ### 
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
//Level: 294
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x82, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, //#@     #   #       #
0x88, 0x08, 0x88, 0x08, 0x80, 0x08, 0x88, 0x80, 0x80, 0x88, //## ### ##  #### # ##
0x80, 0x00, 0x08, 0x08, 0x00, 0x44, 0x00, 0x00, 0x00, 0x08, //#    # #  $$       #
0x80, 0x08, 0x08, 0x08, 0x04, 0x08, 0x04, 0x08, 0x80, 0x88, //#  # # # $ # $ ## ##
0x80, 0x00, 0x00, 0x40, 0x80, 0x08, 0x44, 0x08, 0x00, 0x08, //#     $ #  #$$ #   #
0x80, 0x08, 0x88, 0x00, 0x80, 0x00, 0x00, 0x08, 0x80, 0x88, //#  ###  #      ## ##
0x81, 0x18, 0x18, 0x04, 0x08, 0x00, 0x40, 0x80, 0x00, 0x08, //#..#.# $ #  $ #    #
0x81, 0x18, 0x18, 0x00, 0x40, 0x80, 0x88, 0x04, 0x40, 0x08, //#..#.#  $ # ## $$  #
0x81, 0x11, 0x18, 0x80, 0x00, 0x44, 0x00, 0x40, 0x08, 0x08, //#....##   $$  $  # #
0x81, 0x11, 0x11, 0x88, 0x00, 0x00, 0x00, 0x00, 0x80, 0x08, //#.....##        #  #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 295
0x0D, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############# 
0x80, 0x04, 0x04, 0x04, 0x15, 0x11, 0x80, //#  $ $ $.*..# 
0x80, 0x40, 0x40, 0x40, 0x51, 0x11, 0x80, //# $ $ $ *...# 
0x80, 0x04, 0x04, 0x04, 0x15, 0x11, 0x80, //#  $ $ $.*..# 
0x80, 0x40, 0x40, 0x40, 0x51, 0x11, 0x80, //# $ $ $ *...# 
0x80, 0x04, 0x04, 0x04, 0x15, 0x11, 0x80, //#  $ $ $.*..# 
0x80, 0x40, 0x40, 0x40, 0x51, 0x11, 0x80, //# $ $ $ *...# 
0x80, 0x04, 0x04, 0x04, 0x15, 0x11, 0x80, //#  $ $ $.*..# 
0x80, 0x40, 0x40, 0x40, 0x51, 0x11, 0x80, //# $ $ $ *...# 
0x80, 0x04, 0x04, 0x04, 0x15, 0x11, 0x80, //#  $ $ $.*..# 
0x82, 0x40, 0x40, 0x40, 0x51, 0x11, 0x80, //#@$ $ $ *...# 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############# 
//Level: 296
0x13, 0x10,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //      ############  
0x00, 0x00, 0x08, 0x81, 0x10, 0x00, 0x08, 0x00, 0x08, 0x00, //     ##..    #   #  
0x00, 0x00, 0x88, 0x11, 0x50, 0x40, 0x00, 0x04, 0x08, 0x00, //    ##..* $    $ #  
0x00, 0x08, 0x81, 0x15, 0x18, 0x08, 0x08, 0x04, 0x88, 0x00, //   ##..*.# # # $##  
0x00, 0x08, 0x11, 0x51, 0x80, 0x80, 0x80, 0x40, 0x08, 0x00, //   #..*.# # # $  #  
0x88, 0x88, 0x11, 0x18, 0x00, 0x80, 0x00, 0x08, 0x08, 0x00, //####...#  #    # #  
0x80, 0x08, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, //#  ## #          #  
0x80, 0x24, 0x04, 0x08, 0x88, 0x00, 0x80, 0x00, 0x88, 0x00, //# @$ $ ###  #   ##  
0x80, 0x40, 0x00, 0x40, 0x00, 0x80, 0x80, 0x00, 0x80, 0x00, //# $   $   # #   #   
0x88, 0x84, 0x40, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, //###$$   # # # # #   
0x00, 0x80, 0x00, 0x40, 0x00, 0x80, 0x80, 0x88, 0x88, 0x80, //  #   $   # # ##### 
0x00, 0x80, 0x48, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, 0x80, //  # $# #####      # 
0x00, 0x84, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x80, 0x80, //  #$   #   #    # # 
0x00, 0x80, 0x08, 0x88, 0x00, 0x08, 0x80, 0x00, 0x00, 0x80, //  #  ###   ##     # 
0x00, 0x80, 0x08, 0x00, 0x00, 0x00, 0x80, 0x00, 0x08, 0x80, //  #  #      #    ## 
0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x00, //  ####      ######  
//Level: 297
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x00, 0x80, 0x08, 0x11, 0x18, 0x20, 0x00, 0x08, //#     #  #...#@    #
0x80, 0x80, 0x00, 0x00, 0x00, 0x11, 0x11, 0x80, 0x00, 0x08, //# #       ....#    #
0x80, 0x04, 0x00, 0x80, 0x00, 0x81, 0x11, 0x18, 0x00, 0x08, //#  $  #   #....#   #
0x80, 0x88, 0x48, 0x88, 0x80, 0x88, 0x11, 0x11, 0x80, 0x08, //# ##$#### ##....#  #
0x80, 0x40, 0x00, 0x40, 0x08, 0x00, 0x81, 0x11, 0x80, 0x08, //# $   $  #  #...#  #
0x80, 0x44, 0x08, 0x00, 0x08, 0x00, 0x08, 0x04, 0x40, 0x08, //# $$ #   #   # $$  #
0x88, 0x80, 0x04, 0x44, 0x80, 0x00, 0x44, 0x00, 0x40, 0x08, //###  $$$#   $$  $  #
0x80, 0x40, 0x08, 0x00, 0x80, 0x00, 0x08, 0x04, 0x80, 0x08, //# $  #  #    # $#  #
0x80, 0x00, 0x48, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x08, //#   $#  #       $  #
0x80, 0x08, 0x00, 0x00, 0x80, 0x00, 0x08, 0x00, 0x80, 0x08, //#  #    #    #  #  #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 298
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x08, 0x80, 0x08, //#  ##  #
0x80, 0x10, 0x01, 0x48, //# .  .$#
0x80, 0x48, 0x04, 0x18, //# $# $.#
0x88, 0x02, 0x08, 0x08, //## @ # #
0x88, 0x88, 0x00, 0x08, //####   #
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
//Level: 299
0x08, 0x08,//Size x and y
0x00, 0x00, 0x88, 0x88, //    ####
0x00, 0x00, 0x80, 0x08, //    #  #
0x00, 0x88, 0x84, 0x18, //  ###$.#
0x00, 0x80, 0x01, 0x08, //  #  . #
0x88, 0x80, 0x08, 0x18, //###  #.#
0x80, 0x40, 0x04, 0x08, //# $  $ #
0x80, 0x00, 0x82, 0x08, //#   #@ #
0x88, 0x88, 0x88, 0x88, //########
//Level: 300
0x08, 0x06,//Size x and y
0x00, 0x88, 0x88, 0x00, //  ####  
0x88, 0x80, 0x08, 0x88, //###  ###
0x80, 0x11, 0x04, 0x18, //# .. $.#
0x80, 0x04, 0x40, 0x28, //#  $$ @#
0x88, 0x88, 0x00, 0x08, //####   #
0x00, 0x08, 0x88, 0x88, //   #####
//Level: 301
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x00, //######  
0x80, 0x01, 0x08, 0x00, //#  . #  
0x80, 0x00, 0x08, 0x88, //#    ###
0x80, 0x84, 0x41, 0x08, //# #$$. #
0x81, 0x00, 0x88, 0x08, //#.  ## #
0x82, 0x40, 0x88, 0x08, //#@$ ## #
0x88, 0x80, 0x00, 0x08, //###    #
0x00, 0x88, 0x88, 0x88, //  ######
//Level: 302
0x11, 0x12,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x80, //             #### 
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x80, //      ########  # 
0x00, 0x00, 0x08, 0x80, 0x40, 0x40, 0x00, 0x40, 0x80, //     ## $ $   $ # 
0x00, 0x00, 0x08, 0x00, 0x02, 0x84, 0x00, 0x40, 0x80, //     #   @#$  $ # 
0x00, 0x00, 0x08, 0x00, 0x40, 0x80, 0x08, 0x00, 0x80, //     #  $ #  #  # 
0x88, 0x88, 0x88, 0x88, 0x04, 0x80, 0x00, 0x00, 0x80, //######## $#     # 
0x80, 0x00, 0x40, 0x00, 0x00, 0x40, 0x40, 0x88, 0x80, //#   $     $ $ ### 
0x80, 0x00, 0x88, 0x88, 0x84, 0x88, 0x48, 0x80, 0x00, //#   #####$##$##   
0x88, 0x04, 0x40, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, //## $$         #   
0x08, 0x00, 0x88, 0x04, 0x04, 0x04, 0x00, 0x80, 0x00, // #  ## $ $ $  #   
0x08, 0x88, 0x88, 0x80, 0x80, 0x80, 0x88, 0x80, 0x00, // ###### # # ###   
0x00, 0x00, 0x08, 0x04, 0x04, 0x00, 0x80, 0x00, 0x00, //     # $ $  #     
0x00, 0x00, 0x08, 0x00, 0x40, 0x08, 0x80, 0x00, 0x00, //     #  $  ##     
0x00, 0x00, 0x88, 0x88, 0x04, 0x88, 0x80, 0x00, 0x00, //    #### $###     
0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x80, 0x00, 0x00, //    #.......#     
0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x80, 0x00, 0x00, //    #.......#     
0x00, 0x00, 0x81, 0x11, 0x11, 0x11, 0x80, 0x00, 0x00, //    #.......#     
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //    #########     
//Level: 303
0x10, 0x0D,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, //     #####      
0x88, 0x88, 0x88, 0x80, 0x00, 0x80, 0x00, 0x00, //#######   #     
0x80, 0x00, 0x88, 0x10, 0x00, 0x80, 0x00, 0x00, //#   ##.   #     
0x80, 0x04, 0x81, 0x10, 0x08, 0x88, 0x00, 0x00, //#  $#..  ###    
0x88, 0x00, 0x11, 0x18, 0x44, 0x08, 0x88, 0x88, //##  ...#$$ #####
0x08, 0x04, 0x18, 0x14, 0x00, 0x00, 0x00, 0x08, // # $.#.$       #
0x08, 0x04, 0x88, 0x84, 0x88, 0x08, 0x04, 0x08, // # $###$## # $ #
0x08, 0x00, 0x08, 0x00, 0x00, 0x04, 0x48, 0x08, // #   #     $$# #
0x08, 0x84, 0x48, 0x08, 0x84, 0x84, 0x00, 0x08, // ##$$# ##$#$   #
0x08, 0x11, 0x10, 0x42, 0x04, 0x00, 0x08, 0x88, // #... $@ $   ###
0x08, 0x11, 0x18, 0x48, 0x00, 0x08, 0x88, 0x00, // #...#$#   ###  
0x08, 0x11, 0x10, 0x08, 0x88, 0x88, 0x00, 0x00, // #...  #####    
0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, // #######        
//Level: 304
0x10, 0x0F,//Size x and y
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, //          ######
0x00, 0x08, 0x88, 0x88, 0x88, 0x80, 0x00, 0x08, //   ########    #
0x00, 0x08, 0x00, 0x04, 0x00, 0x04, 0x04, 0x08, //   #   $   $ $ #
0x00, 0x08, 0x08, 0x08, 0x08, 0x04, 0x88, 0x08, //   # # # # $## #
0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0x04, 0x08, //   #     $   $ #
0x00, 0x08, 0x88, 0x88, 0x88, 0x84, 0x08, 0x08, //   ########$ # #
0x00, 0x88, 0x00, 0x00, 0x00, 0x80, 0x00, 0x08, //  ##      #    #
0x00, 0x82, 0x40, 0x04, 0x00, 0x80, 0x40, 0x08, //  #@$  $  # $  #
0x88, 0x88, 0x88, 0x08, 0x40, 0x84, 0x84, 0x08, //###### #$ #$#$ #
0x81, 0x11, 0x18, 0x04, 0x00, 0x80, 0x00, 0x08, //#....# $  #    #
0x81, 0x51, 0x18, 0x88, 0x08, 0x80, 0x88, 0x88, //#.*..### ## ####
0x81, 0x15, 0x10, 0x40, 0x00, 0x80, 0x08, 0x00, //#..*. $   #  #  
0x81, 0x11, 0x14, 0x04, 0x00, 0x00, 0x08, 0x00, //#....$ $     #  
0x81, 0x11, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //#...##########  
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //#####           
//Level: 305
0x07, 0x06,//Size x and y
0x88, 0x88, 0x80, 0x00, //#####   
0x80, 0x00, 0x88, 0x80, //#   ### 
0x81, 0x14, 0x41, 0x80, //#..$$.# 
0x80, 0x44, 0x20, 0x80, //# $$@ # 
0x88, 0x00, 0x18, 0x80, //##  .## 
0x08, 0x88, 0x88, 0x00, // #####  
//Level: 306
0x08, 0x06,//Size x and y
0x88, 0x88, 0x88, 0x00, //######  
0x80, 0x10, 0x08, 0x00, //# .  #  
0x80, 0x18, 0x08, 0x88, //# .# ###
0x80, 0x24, 0x40, 0x08, //# @$$  #
0x80, 0x41, 0x00, 0x08, //# $.   #
0x88, 0x88, 0x88, 0x88, //########
//Level: 307
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x00, //######  
0x80, 0x00, 0x28, 0x00, //#   @#  
0x80, 0x44, 0x88, 0x88, //# $$####
0x80, 0x40, 0x10, 0x08, //# $ .  #
0x88, 0x08, 0x18, 0x08, //## #.# #
0x81, 0x00, 0x08, 0x08, //#.   # #
0x80, 0x00, 0x00, 0x08, //#      #
0x88, 0x88, 0x88, 0x88, //########
//Level: 308
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x80, 0x00, 0x88, //###   ##
0x88, 0x80, 0x81, 0x88, //### #.##
0x88, 0x80, 0x01, 0x88, //###  .##
0x82, 0x04, 0x40, 0x88, //#@ $$ ##
0x80, 0x01, 0x40, 0x88, //#  .$ ##
0x88, 0x88, 0x88, 0x88, //########
//Level: 309
0x08, 0x06,//Size x and y
0x08, 0x88, 0x80, 0x00, // ####   
0x88, 0x00, 0x88, 0x80, //##  ### 
0x80, 0x00, 0x00, 0x88, //#     ##
0x80, 0x08, 0x44, 0x28, //#  #$$@#
0x80, 0x01, 0x05, 0x18, //#  . *.#
0x88, 0x88, 0x88, 0x88, //########
//Level: 310
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x00, 0x88, 0x88, //##  ####
0x81, 0x14, 0x00, 0x18, //#..$  .#
0x80, 0x84, 0x04, 0x08, //# #$ $ #
0x82, 0x00, 0x80, 0x08, //#@  #  #
0x88, 0x88, 0x80, 0x08, //#####  #
0x88, 0x88, 0x88, 0x88, //########
//Level: 311
0x11, 0x0D,//Size x and y
0x00, 0x00, 0x08, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //     #####        
0x00, 0x00, 0x08, 0x20, 0x08, 0x88, 0x88, 0x88, 0x00, //     #@  #######  
0x00, 0x08, 0x88, 0x80, 0x40, 0x04, 0x00, 0x08, 0x00, //   #### $  $   #  
0x08, 0x88, 0x00, 0x04, 0x40, 0x40, 0x40, 0x08, 0x00, // ###   $$ $ $  #  
0x08, 0x00, 0x08, 0x00, 0x48, 0x08, 0x88, 0x88, 0x00, // #   #  $# #####  
0x08, 0x48, 0x88, 0x80, 0x04, 0x00, 0x04, 0x08, 0x00, // #$####  $   $ #  
0x08, 0x04, 0x00, 0x40, 0x04, 0x00, 0x04, 0x08, 0x00, // # $  $  $   $ #  
0x08, 0x00, 0x40, 0x08, 0x88, 0x48, 0x88, 0x08, 0x80, // #  $  ###$### ## 
0x88, 0x00, 0x88, 0x08, 0x11, 0x11, 0x18, 0x00, 0x80, //##  ## #.....#  # 
0x80, 0x04, 0x04, 0x08, 0x11, 0x11, 0x10, 0x00, 0x80, //#  $ $ #.....   # 
0x80, 0x40, 0x00, 0x40, 0x11, 0x11, 0x18, 0x88, 0x80, //# $   $ .....#### 
0x88, 0x88, 0x88, 0x88, 0x11, 0x11, 0x18, 0x00, 0x00, //########.....#    
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x00, 0x00, //       #######    
//Level: 312
0x12, 0x0E,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //########          
0x81, 0x11, 0x00, 0x08, 0x88, 0x88, 0x88, 0x80, 0x00, //#...   ########   
0x81, 0x11, 0x10, 0x00, 0x00, 0x40, 0x00, 0x88, 0x00, //#....     $   ##  
0x81, 0x11, 0x11, 0x88, 0x04, 0x08, 0x40, 0x08, 0x00, //#.....## $ #$  #  
0x81, 0x11, 0x11, 0x80, 0x08, 0x00, 0x40, 0x08, 0x00, //#.....#  #  $  #  
0x88, 0x88, 0x88, 0x84, 0x08, 0x80, 0x04, 0x08, 0x88, //#######$ ##  $ ###
0x08, 0x00, 0x00, 0x00, 0x00, 0x88, 0x80, 0x40, 0x08, // #        ### $  #
0x08, 0x00, 0x40, 0x80, 0x40, 0x08, 0x00, 0x40, 0x08, // #  $ # $  #  $  #
0x08, 0x00, 0x88, 0x80, 0x88, 0x00, 0x80, 0x88, 0x88, // #  ### ##  # ####
0x08, 0x00, 0x80, 0x04, 0x00, 0x40, 0x80, 0x00, 0x80, // #  #  $  $ #   # 
0x08, 0x88, 0x80, 0x84, 0x80, 0x08, 0x84, 0x00, 0x80, // #### #$#  ##$  # 
0x00, 0x82, 0x40, 0x00, 0x04, 0x00, 0x04, 0x00, 0x80, //  #@$    $   $  # 
0x00, 0x88, 0x88, 0x80, 0x00, 0x88, 0x88, 0x88, 0x80, //  #####   ####### 
0x00, 0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //      #####       
//Level: 313
0x0B, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //#######     
0x82, 0x00, 0x00, 0x88, 0x88, 0x80, //#@    ##### 
0x80, 0x40, 0x15, 0x10, 0x40, 0x80, //# $ .*. $ # 
0x80, 0x41, 0x50, 0x51, 0x40, 0x80, //# $.* *.$ # 
0x80, 0x40, 0x15, 0x10, 0x40, 0x80, //# $ .*. $ # 
0x88, 0x88, 0x88, 0x00, 0x00, 0x80, //######    # 
0x00, 0x00, 0x08, 0x88, 0x88, 0x80, //     ###### 
//Level: 314
0x09, 0x08,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x00, //   #####  
0x00, 0x08, 0x02, 0x08, 0x00, //   # @ #  
0x00, 0x08, 0x44, 0x48, 0x00, //   #$$$#  
0x88, 0x88, 0x00, 0x08, 0x00, //####   #  
0x80, 0x00, 0x18, 0x48, 0x80, //#   .#$## 
0x80, 0x41, 0x41, 0x01, 0x80, //# $.$. .# 
0x80, 0x08, 0x18, 0x18, 0x80, //#  #.#.## 
0x88, 0x88, 0x88, 0x88, 0x00, //########  
//Level: 315
0x09, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
0x00, 0x80, 0x00, 0x80, 0x00, //  #   #   
0x88, 0x80, 0x84, 0x80, 0x00, //### #$#   
0x80, 0x01, 0x41, 0x88, 0x80, //#  .$.### 
0x80, 0x84, 0x34, 0x00, 0x80, //# #$+$  # 
0x80, 0x01, 0x40, 0x80, 0x80, //#  .$ # # 
0x88, 0x80, 0x81, 0x00, 0x80, //### #.  # 
0x00, 0x80, 0x00, 0x88, 0x80, //  #   ### 
0x00, 0x88, 0x88, 0x80, 0x00, //  #####   
//Level: 316
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x00, 0x00, 0x08, //#      #
0x80, 0x80, 0x88, 0x58, //# # ##*#
0x80, 0x82, 0x04, 0x08, //# #@ $ #
0x81, 0x40, 0x10, 0x08, //#.$ .  #
0x88, 0x88, 0x80, 0x08, //#####  #
0x00, 0x00, 0x80, 0x08, //    #  #
0x00, 0x00, 0x88, 0x88, //    ####
//Level: 317
0x08, 0x07,//Size x and y
0x00, 0x08, 0x88, 0x88, //   #####
0x88, 0x88, 0x10, 0x28, //####. @#
0x80, 0x01, 0x40, 0x08, //#  .$  #
0x80, 0x80, 0x08, 0x88, //# #  ###
0x80, 0x40, 0x40, 0x18, //# $ $ .#
0x88, 0x88, 0x00, 0x08, //####   #
0x00, 0x08, 0x88, 0x88, //   #####
//Level: 318
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x08, 0x00, 0x08, 0x28, //#   #   #    #   #@#
0x80, 0x00, 0x40, 0x04, 0x00, 0x00, 0x08, 0x04, 0x08, 0x08, //#   $  $     # $ # #
0x88, 0x48, 0x04, 0x88, 0x80, 0x80, 0x00, 0x04, 0x48, 0x08, //##$# $### #    $$# #
0x80, 0x08, 0x00, 0x81, 0x88, 0x80, 0x08, 0x40, 0x40, 0x08, //#  #  #.###  #$ $  #
0x80, 0x08, 0x48, 0x11, 0x11, 0x80, 0x08, 0x08, 0x88, 0x08, //#  #$#....#  # ### #
0x80, 0x40, 0x08, 0x11, 0x11, 0x18, 0x80, 0x00, 0x08, 0x08, //# $  #.....##    # #
0x88, 0x40, 0x08, 0x18, 0x11, 0x11, 0x84, 0x40, 0x40, 0x08, //##$  #.#....#$$ $  #
0x80, 0x08, 0x88, 0x88, 0x81, 0x18, 0x80, 0x80, 0x08, 0x08, //#  ######..## #  # #
0x80, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x88, 0x08, //#  $         $ ### #
0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x08, 0x08, //#   #   #        # #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 319
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x10, 0x08, 0x88, //##.  ###
0x88, 0x08, 0x08, 0x88, //## # ###
0x88, 0x05, 0x40, 0x08, //## *$  #
0x88, 0x00, 0x41, 0x08, //##  $. #
0x88, 0x00, 0x28, 0x88, //##  @###
0x88, 0x88, 0x88, 0x88, //########
//Level: 320
0x08, 0x08,//Size x and y
0x00, 0x08, 0x88, 0x80, //   #### 
0x00, 0x88, 0x20, 0x88, //  ##@ ##
0x08, 0x80, 0x01, 0x18, // ##  ..#
0x88, 0x04, 0x84, 0x88, //## $#$##
0x80, 0x00, 0x41, 0x08, //#   $. #
0x80, 0x08, 0x00, 0x08, //#  #   #
0x80, 0x00, 0x08, 0x88, //#    ###
0x88, 0x88, 0x88, 0x00, //######  
//Level: 321
0x13, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //###############     
0x81, 0x11, 0x11, 0x11, 0x11, 0x10, 0x01, 0x88, 0x88, 0x00, //#..........  .####  
0x81, 0x11, 0x11, 0x11, 0x11, 0x14, 0x41, 0x80, 0x08, 0x00, //#..........$$.#  #  
0x88, 0x88, 0x88, 0x88, 0x88, 0x84, 0x08, 0x00, 0x08, 0x80, //###########$ #   ## 
0x80, 0x00, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00, 0x40, 0x80, //#      $  $     $ # 
0x88, 0x08, 0x88, 0x80, 0x00, 0x80, 0x04, 0x08, 0x00, 0x80, //## ####   #  $ #  # 
0x80, 0x00, 0x00, 0x08, 0x00, 0x08, 0x80, 0x08, 0x08, 0x80, //#      #   ##  # ## 
0x80, 0x04, 0x80, 0x08, 0x08, 0x80, 0x08, 0x88, 0x08, 0x80, //#  $#  # ##  ### ## 
0x80, 0x40, 0x84, 0x88, 0x80, 0x00, 0x08, 0x88, 0x08, 0x80, //# $ #$###    ### ## 
0x88, 0x80, 0x04, 0x08, 0x00, 0x80, 0x08, 0x88, 0x08, 0x80, //###  $ #  #  ### ## 
0x88, 0x80, 0x00, 0x04, 0x08, 0x80, 0x80, 0x08, 0x08, 0x80, //###    $ ## #  # ## 
0x08, 0x04, 0x00, 0x80, 0x04, 0x00, 0x40, 0x40, 0x00, 0x80, // # $  #  $  $ $   # 
0x08, 0x00, 0x40, 0x04, 0x84, 0x44, 0x00, 0x80, 0x00, 0x80, // #  $  $#$$$  #   # 
0x08, 0x00, 0x80, 0x04, 0x00, 0x00, 0x00, 0x88, 0x88, 0x80, // #  #  $      ##### 
0x08, 0x02, 0x88, 0x00, 0x80, 0x08, 0x00, 0x80, 0x00, 0x00, // # @##  #  #  #     
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, // ##############     
//Level: 322
0x08, 0x08,//Size x and y
0x88, 0x88, 0x80, 0x00, //#####   
0x80, 0x01, 0x88, 0x80, //#  .### 
0x80, 0x41, 0x10, 0x80, //# $.. # 
0x80, 0x08, 0x84, 0x88, //#  ##$##
0x88, 0x00, 0x80, 0x08, //##  #  #
0x08, 0x40, 0x00, 0x28, // #$   @#
0x08, 0x00, 0x88, 0x88, // #  ####
0x08, 0x88, 0x80, 0x00, // ####   
//Level: 323
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x81, 0x11, 0x18, 0x00, 0x00, 0x00, 0x08, 0x00, 0x80, 0x08, //#....#       #  #  #
0x81, 0x11, 0x18, 0x08, 0x04, 0x00, 0x40, 0x00, 0x00, 0x08, //#....# # $  $      #
0x81, 0x11, 0x10, 0x88, 0x00, 0x48, 0x08, 0x04, 0x84, 0x08, //#.... ##  $# # $#$ #
0x81, 0x11, 0x80, 0x00, 0x40, 0x00, 0x48, 0x00, 0x40, 0x08, //#...#   $   $#  $  #
0x81, 0x18, 0x88, 0x80, 0x08, 0x04, 0x00, 0x04, 0x40, 0x08, //#..####  # $   $$  #
0x80, 0x00, 0x00, 0x08, 0x88, 0x80, 0x88, 0x88, 0x08, 0x88, //#      #### #### ###
0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x08, //#        #   #     #
0x80, 0x88, 0x00, 0x08, 0x00, 0x04, 0x08, 0x04, 0x04, 0x08, //# ##   #   $ # $ $ #
0x80, 0x88, 0x00, 0x00, 0x40, 0x88, 0x04, 0x00, 0x40, 0x08, //# ##    $ ## $  $  #
0x80, 0x00, 0x00, 0x28, 0x00, 0x00, 0x08, 0x00, 0x08, 0x08, //#     @#     #   # #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 324
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x28, 0x11, 0x18, 0x88, //#     #     @#...###
0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x08, 0x81, 0x11, 0x88, //#     #      ##...##
0x80, 0x80, 0x80, 0x88, 0x48, 0x80, 0x88, 0x01, 0x11, 0x18, //# # # ##$## ## ....#
0x80, 0x00, 0x40, 0x80, 0x00, 0x44, 0x40, 0x01, 0x11, 0x18, //#   $ #   $$$  ....#
0x88, 0x84, 0x88, 0x80, 0x44, 0x00, 0x88, 0x80, 0x88, 0x18, //###$### $$  ### ##.#
0x80, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x80, 0x88, 0x88, //#     $  #    # ####
0x80, 0x04, 0x00, 0x80, 0x08, 0x88, 0x00, 0x80, 0x80, 0x08, //#  $  #  ###  # #  #
0x88, 0x08, 0x48, 0x80, 0x00, 0x04, 0x00, 0x44, 0x00, 0x08, //## #$##    $  $$   #
0x80, 0x00, 0x40, 0x88, 0x00, 0x08, 0x00, 0x80, 0x80, 0x08, //#   $ ##   #  # #  #
0x80, 0x00, 0x00, 0x80, 0x00, 0x08, 0x00, 0x80, 0x00, 0x08, //#     #    #  #    #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 325
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x88, 0x88, 0x82, 0x88, 0x81, 0x88, 0x11, 0x18, 0x80, 0x08, //#####@###.##...##  #
0x88, 0x88, 0x84, 0x00, 0x11, 0x81, 0x11, 0x80, 0x00, 0x08, //#####$  ..#...#    #
0x88, 0x88, 0x00, 0x00, 0x11, 0x11, 0x11, 0x80, 0x04, 0x08, //####    ......#  $ #
0x88, 0x80, 0x04, 0x08, 0x11, 0x11, 0x18, 0x80, 0x80, 0x88, //###  $ #.....## # ##
0x88, 0x00, 0x44, 0x80, 0x88, 0x88, 0x80, 0x04, 0x04, 0x08, //##  $$# #####  $ $ #
0x88, 0x04, 0x80, 0x40, 0x00, 0x08, 0x80, 0x04, 0x40, 0x08, //## $# $    ##  $$  #
0x88, 0x00, 0x80, 0x08, 0x00, 0x00, 0x80, 0x40, 0x04, 0x08, //##  #  #    # $  $ #
0x88, 0x00, 0x04, 0x40, 0x88, 0x80, 0x84, 0x88, 0x00, 0x08, //##   $$ ### #$##   #
0x88, 0x04, 0x80, 0x00, 0x00, 0x04, 0x04, 0x00, 0x40, 0x88, //## $#      $ $  $ ##
0x88, 0x80, 0x00, 0x08, 0x00, 0x00, 0x80, 0x00, 0x08, 0x88, //###    #    #    ###
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 326
0x0B, 0x0B,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //########### 
0x80, 0x41, 0x04, 0x01, 0x00, 0x80, //# $. $ .  # 
0x80, 0x08, 0x00, 0x41, 0x00, 0x80, //#  #  $.  # 
0x81, 0x15, 0x11, 0x85, 0x81, 0x80, //#..*..#*#.# 
0x84, 0x48, 0x44, 0x41, 0x04, 0x80, //#$$#$$$. $# 
0x80, 0x01, 0x42, 0x41, 0x00, 0x80, //#  .$@$.  # 
0x84, 0x01, 0x44, 0x48, 0x44, 0x80, //#$ .$$$#$$# 
0x81, 0x85, 0x81, 0x15, 0x11, 0x80, //#.#*#..*..# 
0x80, 0x01, 0x40, 0x08, 0x00, 0x80, //#  .$  #  # 
0x80, 0x01, 0x40, 0x41, 0x00, 0x80, //#  .$ $.  # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //########### 
//Level: 327
0x12, 0x10,//Size x and y
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x00, 0x00, //       #######    
0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x08, 0x00, 0x00, // #######     #    
0x08, 0x00, 0x00, 0x08, 0x04, 0x24, 0x08, 0x00, 0x00, // #     # $@$ #    
0x08, 0x44, 0x08, 0x00, 0x08, 0x88, 0x88, 0x88, 0x88, // #$$ #   #########
0x08, 0x08, 0x88, 0x11, 0x11, 0x11, 0x88, 0x00, 0x08, // # ###......##   #
0x08, 0x00, 0x04, 0x11, 0x11, 0x11, 0x88, 0x08, 0x08, // #   $......## # #
0x08, 0x08, 0x88, 0x11, 0x11, 0x11, 0x00, 0x00, 0x08, // # ###......     #
0x88, 0x00, 0x08, 0x88, 0x80, 0x88, 0x80, 0x84, 0x88, //##   #### ### #$##
0x80, 0x08, 0x40, 0x00, 0x80, 0x04, 0x00, 0x80, 0x80, //#  #$   #  $  # # 
0x80, 0x04, 0x04, 0x44, 0x00, 0x80, 0x48, 0x80, 0x80, //#  $ $$$  # $## # 
0x80, 0x00, 0x40, 0x40, 0x88, 0x84, 0x40, 0x80, 0x80, //#   $ $ ###$$ # # 
0x88, 0x88, 0x80, 0x00, 0x00, 0x40, 0x00, 0x80, 0x80, //#####     $   # # 
0x00, 0x00, 0x88, 0x80, 0x88, 0x80, 0x00, 0x80, 0x80, //    ### ###   # # 
0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00, 0x80, //      #     #   # 
0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x00, 0x80, //      ########  # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x80, //             #### 
//Level: 328
0x09, 0x07,//Size x and y
0x08, 0x88, 0x88, 0x00, 0x00, // #####    
0x08, 0x00, 0x08, 0x88, 0x80, // #   #### 
0x88, 0x08, 0x42, 0x00, 0x80, //## #$@  # 
0x80, 0x40, 0x04, 0x40, 0x80, //# $  $$ # 
0x80, 0x84, 0x81, 0x51, 0x80, //# #$#.*.# 
0x80, 0x00, 0x01, 0x11, 0x80, //#    ...# 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 329
0x08, 0x06,//Size x and y
0x00, 0x88, 0x88, 0x00, //  ####  
0x88, 0x81, 0x08, 0x00, //###. #  
0x80, 0x10, 0x08, 0x88, //# .  ###
0x80, 0x00, 0x44, 0x08, //#   $$ #
0x88, 0x01, 0x04, 0x28, //## . $@#
0x08, 0x88, 0x88, 0x88, // #######
//Level: 330
0x08, 0x07,//Size x and y
0x08, 0x88, 0x88, 0x88, // #######
0x88, 0x20, 0x00, 0x08, //##@    #
0x81, 0x08, 0x00, 0x08, //#. #   #
0x80, 0x44, 0x41, 0x88, //# $$$.##
0x80, 0x18, 0x00, 0x80, //# .#  # 
0x80, 0x08, 0x88, 0x80, //#  #### 
0x88, 0x88, 0x00, 0x00, //####    
//Level: 331
0x09, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x80, 0x00, 0x20, 0x00, 0x80, //#   @   # 
0x84, 0x44, 0x44, 0x44, 0x80, //#$$$$$$$# 
0x81, 0x11, 0x81, 0x11, 0x80, //#...#...# 
0x81, 0x11, 0x11, 0x11, 0x80, //#.......# 
0x84, 0x44, 0x04, 0x44, 0x80, //#$$$ $$$# 
0x80, 0x00, 0x00, 0x00, 0x80, //#       # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 332
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x00, 0x08, 0x88, //##   ###
0x80, 0x48, 0x08, 0x88, //# $# ###
0x80, 0x10, 0x28, 0x88, //# . @###
0x80, 0x50, 0x00, 0x88, //# *   ##
0x88, 0x08, 0x40, 0x88, //## #$ ##
0x88, 0x10, 0x08, 0x88, //##.  ###
0x88, 0x88, 0x88, 0x88, //########
//Level: 333
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x80, 0x80, 0x80, 0x00, 0x82, 0x88, 0x00, 0x08, 0x08, //# # # #   #@##   # #
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x08, //#             $    #
0x80, 0x08, 0x84, 0x80, 0x88, 0x88, 0x80, 0x40, 0x80, 0x88, //#  ##$# ##### $ # ##
0x88, 0x00, 0x00, 0x88, 0x11, 0x11, 0x18, 0x00, 0x80, 0x08, //##    ##.....#  #  #
0x88, 0x48, 0x84, 0x81, 0x11, 0x11, 0x88, 0x84, 0x84, 0x08, //##$##$#.....###$#$ #
0x80, 0x00, 0x80, 0x88, 0x11, 0x11, 0x18, 0x00, 0x80, 0x88, //#   # ##.....#  # ##
0x80, 0x04, 0x00, 0x00, 0x88, 0x11, 0x88, 0x00, 0x80, 0x08, //#  $    ##..##  #  #
0x80, 0x40, 0x80, 0x00, 0x40, 0x00, 0x40, 0x04, 0x44, 0x08, //# $ #   $   $  $$$ #
0x88, 0x04, 0x00, 0x48, 0x08, 0x00, 0x80, 0x04, 0x00, 0x08, //## $  $# #  #  $   #
0x80, 0x00, 0x88, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x08, //#   ##   #  #      #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 334
0x12, 0x0F,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##################
0x81, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, //#..#             #
0x81, 0x18, 0x00, 0x80, 0x40, 0x40, 0x40, 0x88, 0x08, //#..#  # $ $ $ ## #
0x81, 0x18, 0x08, 0x88, 0x08, 0x08, 0x00, 0x80, 0x08, //#..# ### # #  #  #
0x81, 0x18, 0x08, 0x04, 0x48, 0x88, 0x48, 0x84, 0x08, //#..# # $$###$##$ #
0x81, 0x18, 0x00, 0x00, 0x00, 0x04, 0x24, 0x04, 0x08, //#..#       $@$ $ #
0x81, 0x10, 0x04, 0x80, 0x40, 0x80, 0x44, 0x08, 0x08, //#..  $# $ # $$ # #
0x80, 0x08, 0x00, 0x80, 0x08, 0x88, 0x00, 0x08, 0x08, //#  #  #  ###   # #
0x80, 0x00, 0x08, 0x88, 0x00, 0x80, 0x08, 0x88, 0x08, //#    ###  #  ### #
0x81, 0x18, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x08, //#..#    $ $      #
0x81, 0x18, 0x08, 0x84, 0x00, 0x80, 0x08, 0x04, 0x08, //#..# ##$  #  # $ #
0x81, 0x18, 0x00, 0x80, 0x08, 0x88, 0x08, 0x80, 0x08, //#..#  #  ### ##  #
0x81, 0x18, 0x00, 0x88, 0x44, 0x08, 0x48, 0x84, 0x08, //#..#  ##$$ #$##$ #
0x81, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, //#..#             #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##################
//Level: 335
0x13, 0x10,//Size x and y
0x08, 0x88, 0x88, 0x80, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, // ######    ####     
0x08, 0x00, 0x00, 0x88, 0x88, 0x88, 0x00, 0x80, 0x00, 0x00, // #    ######  #     
0x08, 0x28, 0x04, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, // #@# $        ##    
0x88, 0x88, 0x84, 0x04, 0x08, 0x88, 0x80, 0x08, 0x80, 0x00, //#####$ $ ####  ##   
0x80, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00, 0x88, 0x00, //#    $   #      ##  
0x80, 0x04, 0x40, 0x80, 0x88, 0x48, 0x88, 0x44, 0x08, 0x00, //#  $$ # ##$###$$ #  
0x80, 0x00, 0x00, 0x45, 0x15, 0x11, 0x80, 0x00, 0x08, 0x00, //#     $*.*..#    #  
0x88, 0x88, 0x88, 0x81, 0x11, 0x15, 0x80, 0x40, 0x08, 0x00, //#######....*# $  #  
0x00, 0x00, 0x00, 0x85, 0x11, 0x51, 0x80, 0x84, 0x88, 0x00, //      #*..*.# #$##  
0x00, 0x00, 0x00, 0x81, 0x11, 0x15, 0x04, 0x00, 0x08, 0x00, //      #....* $   #  
0x00, 0x00, 0x00, 0x81, 0x11, 0x11, 0x80, 0x44, 0x48, 0x00, //      #.....# $$$#  
0x00, 0x00, 0x00, 0x88, 0x88, 0x80, 0x80, 0x80, 0x08, 0x80, //      ##### # #  ## 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x80, //          # # $ $ # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0x80, //          #  $    # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0x88, 0x00, 0x80, //          #  ###  # 
0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x08, 0x88, 0x80, //          #### #### 
//Level: 336
0x09, 0x08,//Size x and y
0x00, 0x08, 0x88, 0x88, 0x00, //   #####  
0x88, 0x88, 0x10, 0x08, 0x80, //####.  ## 
0x80, 0x41, 0x41, 0x00, 0x80, //# $.$.  # 
0x82, 0x48, 0x08, 0x40, 0x80, //#@$# #$ # 
0x80, 0x41, 0x01, 0x00, 0x80, //# $. .  # 
0x88, 0x88, 0x48, 0x40, 0x80, //####$#$ # 
0x00, 0x81, 0x01, 0x00, 0x80, //  #. .  # 
0x00, 0x88, 0x88, 0x88, 0x80, //  ####### 
//Level: 337
0x07, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x80, 0x00, 0x00, 0x80, //#     # 
0x81, 0x88, 0x01, 0x80, //#.## .# 
0x85, 0x00, 0x42, 0x80, //#*  $@# 
0x80, 0x08, 0x40, 0x80, //#  #$ # 
0x80, 0x08, 0x00, 0x80, //#  #  # 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 338
0x13, 0x10,//Size x and y
0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //####                
0x80, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //#  ##############   
0x80, 0x08, 0x00, 0x01, 0x18, 0x11, 0x11, 0x11, 0x80, 0x00, //#  #   ..#......#   
0x80, 0x08, 0x08, 0x08, 0x88, 0x88, 0x01, 0x11, 0x80, 0x00, //#  # # ##### ...#   
0x88, 0x48, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x80, 0x00, //##$#    ........#   
0x80, 0x00, 0x88, 0x48, 0x88, 0x88, 0x80, 0x08, 0x88, 0x80, //#   ##$######  #### 
0x80, 0x40, 0x80, 0x00, 0x00, 0x88, 0x88, 0x88, 0x20, 0x80, //# $ #     ######@ # 
0x88, 0x40, 0x80, 0x40, 0x00, 0x88, 0x88, 0x88, 0x00, 0x80, //##$ # $   ######  # 
0x80, 0x04, 0x08, 0x44, 0x48, 0x80, 0x00, 0x00, 0x00, 0x80, //#  $ #$$$##       # 
0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x84, 0x84, 0x88, 0x80, //#      #    #$#$### 
0x80, 0x88, 0x88, 0x08, 0x44, 0x44, 0x40, 0x00, 0x08, 0x00, //# #### #$$$$$    #  
0x80, 0x80, 0x00, 0x04, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, //# #    $     #   #  
0x80, 0x80, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, 0x88, 0x80, //# #   ##        ### 
0x80, 0x88, 0x88, 0x88, 0x48, 0x88, 0x88, 0x80, 0x40, 0x80, //# ######$###### $ # 
0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x80, 0x00, 0x80, //#        #    #   # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x80, //##########    ##### 
//Level: 339
0x14, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, //############        
0x80, 0x00, 0x00, 0x08, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, //#      #   ##       
0x80, 0x40, 0x04, 0x00, 0x08, 0x00, 0x88, 0x88, 0x88, 0x00, //# $  $   #  ######  
0x88, 0x88, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x08, 0x00, //####  #####      #  
0x08, 0x11, 0x00, 0x80, 0x00, 0x00, 0x88, 0x88, 0x08, 0x00, // #..  #     #### #  
0x08, 0x18, 0x88, 0x80, 0x08, 0x88, 0x80, 0x00, 0x08, 0x00, // #.####  ####    #  
0x08, 0x11, 0x11, 0x00, 0x00, 0x80, 0x04, 0x08, 0x88, 0x80, // #....    #  $ #### 
0x08, 0x01, 0x11, 0x80, 0x00, 0x80, 0x44, 0x48, 0x00, 0x88, // # ...#   # $$$#  ##
0x88, 0x81, 0x88, 0x88, 0x08, 0x80, 0x04, 0x24, 0x00, 0x08, //###.#### ##  $@$   #
0x80, 0x00, 0x00, 0x88, 0x88, 0x80, 0x40, 0x80, 0x00, 0x08, //#     ##### $ #    #
0x80, 0x81, 0x80, 0x40, 0x00, 0x00, 0x04, 0x88, 0x84, 0x08, //# #.# $      $###$ #
0x80, 0x81, 0x88, 0x88, 0x88, 0x88, 0x00, 0x80, 0x04, 0x08, //# #.########  #  $ #
0x80, 0x81, 0x10, 0x00, 0x00, 0x00, 0x08, 0x80, 0x04, 0x08, //# #..        ##  $ #
0x80, 0x80, 0x88, 0x88, 0x88, 0x80, 0x40, 0x80, 0x80, 0x08, //# # ####### $ # #  #
0x80, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x88, //#   #     #       ##
0x88, 0x88, 0x80, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, //#####     ##########
//Level: 340
0x09, 0x09,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x00, // #######  
0x88, 0x00, 0x50, 0x08, 0x80, //##  *  ## 
0x80, 0x12, 0x10, 0x10, 0x80, //# .@. . # 
0x80, 0x40, 0x50, 0x00, 0x80, //# $ *   # 
0x85, 0x44, 0x54, 0x45, 0x80, //#*$$*$$*# 
0x80, 0x00, 0x50, 0x40, 0x80, //#   * $ # 
0x80, 0x10, 0x10, 0x10, 0x80, //# . . . # 
0x88, 0x00, 0x50, 0x08, 0x80, //##  *  ## 
0x08, 0x88, 0x88, 0x88, 0x00, // #######  
//Level: 341
0x14, 0x0C,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x00, 0x88, 0x81, 0x18, 0x88, 0x00, 0x00, 0x08, //#     ###..###     #
0x80, 0x44, 0x00, 0x88, 0x81, 0x18, 0x88, 0x00, 0x42, 0x08, //# $$  ###..###  $@ #
0x80, 0x08, 0x08, 0x81, 0x11, 0x11, 0x18, 0x00, 0x40, 0x08, //#  # ##......#  $  #
0x80, 0x00, 0x00, 0x81, 0x11, 0x11, 0x18, 0x00, 0x40, 0x08, //#     #......#  $  #
0x88, 0x88, 0x00, 0x88, 0x81, 0x18, 0x88, 0x88, 0x84, 0x08, //####  ###..######$ #
0x80, 0x00, 0x44, 0x40, 0x81, 0x18, 0x00, 0x00, 0x80, 0x08, //#   $$$ #..#    #  #
0x80, 0x48, 0x00, 0x04, 0x00, 0x40, 0x04, 0x40, 0x84, 0x08, //# $#   $  $  $$ #$ #
0x80, 0x08, 0x00, 0x88, 0x04, 0x00, 0x88, 0x00, 0x80, 0x08, //#  #  ## $  ##  #  #
0x80, 0x40, 0x00, 0x04, 0x08, 0x80, 0x40, 0x00, 0x04, 0x08, //# $    $ ## $    $ #
0x80, 0x08, 0x00, 0x88, 0x00, 0x00, 0x88, 0x00, 0x80, 0x08, //#  #  ##    ##  #  #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 342
0x07, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x00, //######  
0x80, 0x00, 0x28, 0x80, //#   @## 
0x80, 0x08, 0x00, 0x80, //#  #  # 
0x81, 0x00, 0x40, 0x80, //#.  $ # 
0x80, 0x44, 0x81, 0x80, //# $$#.# 
0x88, 0x80, 0x01, 0x80, //###  .# 
0x00, 0x88, 0x88, 0x80, //  ##### 
//Level: 343
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
0x81, 0x00, 0x01, 0x08, //#.   . #
0x80, 0x80, 0x80, 0x08, //# # #  #
0x82, 0x40, 0x04, 0x18, //#@$  $.#
0x88, 0x88, 0x80, 0x48, //##### $#
0x88, 0x88, 0x80, 0x08, //#####  #
0x88, 0x88, 0x88, 0x88, //########
//Level: 344
0x0E, 0x0A,//Size x and y
0x88, 0x88, 0x00, 0x00, 0x00, 0x88, 0x88, //####      ####
0x81, 0x18, 0x88, 0x88, 0x88, 0x81, 0x18, //#..########..#
0x85, 0x15, 0x11, 0x11, 0x15, 0x15, 0x18, //#*.*.....*.*.#
0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x48, //# $ $ $ $ $ $#
0x84, 0x04, 0x04, 0x24, 0x04, 0x04, 0x08, //#$ $ $@$ $ $ #
0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x48, //# $ $ $ $ $ $#
0x84, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, //#$ $ $ $ $ $ #
0x81, 0x51, 0x51, 0x11, 0x11, 0x51, 0x58, //#.*.*.....*.*#
0x81, 0x18, 0x88, 0x88, 0x88, 0x81, 0x18, //#..########..#
0x88, 0x88, 0x00, 0x00, 0x00, 0x88, 0x88, //####      ####
//Level: 345
0x08, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x01, 0x80, 0x28, //#  .# @#
0x80, 0x80, 0x40, 0x08, //# # $  #
0x80, 0x41, 0x84, 0x08, //# $.#$ #
0x88, 0x01, 0x00, 0x08, //## .   #
0x08, 0x00, 0x88, 0x88, // #  ####
0x08, 0x88, 0x80, 0x00, // ####   
//Level: 346
0x13, 0x10,//Size x and y
0x08, 0x88, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, // ###  ############# 
0x88, 0x28, 0x88, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, //##@####       #   # 
0x80, 0x44, 0x00, 0x04, 0x40, 0x04, 0x04, 0x01, 0x11, 0x80, //# $$   $$  $ $ ...# 
0x80, 0x04, 0x44, 0x80, 0x00, 0x04, 0x00, 0x81, 0x11, 0x80, //#  $$$#    $  #...# 
0x80, 0x40, 0x00, 0x80, 0x44, 0x04, 0x40, 0x81, 0x11, 0x80, //# $   # $$ $$ #...# 
0x88, 0x80, 0x00, 0x80, 0x04, 0x00, 0x00, 0x81, 0x11, 0x80, //###   #  $    #...# 
0x80, 0x00, 0x00, 0x80, 0x40, 0x40, 0x40, 0x81, 0x11, 0x80, //#     # $ $ $ #...# 
0x80, 0x00, 0x08, 0x88, 0x88, 0x80, 0x88, 0x81, 0x11, 0x80, //#    ###### ###...# 
0x88, 0x08, 0x00, 0x80, 0x04, 0x04, 0x00, 0x81, 0x11, 0x80, //## #  #  $ $  #...# 
0x80, 0x08, 0x80, 0x80, 0x44, 0x04, 0x04, 0x88, 0x11, 0x80, //#  ## # $$ $ $##..# 
0x80, 0x11, 0x80, 0x80, 0x04, 0x00, 0x00, 0x00, 0x81, 0x80, //# ..# #  $      #.# 
0x80, 0x11, 0x80, 0x80, 0x44, 0x40, 0x44, 0x40, 0x81, 0x80, //# ..# # $$$ $$$ #.# 
0x88, 0x88, 0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0x81, 0x80, //##### #       # #.# 
0x00, 0x00, 0x80, 0x88, 0x88, 0x88, 0x88, 0x80, 0x81, 0x80, //    # ######### #.# 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x80, //    #           #.# 
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //    ############### 
//Level: 347
0x13, 0x10,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //    ##########      
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, //#####        ####   
0x80, 0x00, 0x00, 0x80, 0x00, 0x40, 0x08, 0x20, 0x80, 0x00, //#     #   $  #@ #   
0x80, 0x88, 0x88, 0x88, 0x84, 0x88, 0x88, 0x00, 0x88, 0x80, //# #######$####  ### 
0x80, 0x80, 0x00, 0x08, 0x80, 0x80, 0x08, 0x40, 0x11, 0x80, //# #    ## #  #$ ..# 
0x80, 0x80, 0x40, 0x00, 0x00, 0x80, 0x08, 0x00, 0x81, 0x80, //# # $     #  #  #.# 
0x80, 0x80, 0x40, 0x08, 0x00, 0x00, 0x08, 0x40, 0x11, 0x80, //# # $  #     #$ ..# 
0x80, 0x80, 0x08, 0x88, 0x08, 0x80, 0x00, 0x00, 0x81, 0x80, //# #  ### ##     #.# 
0x80, 0x88, 0x80, 0x08, 0x00, 0x80, 0x08, 0x40, 0x11, 0x80, //# ###  #  #  #$ ..# 
0x80, 0x80, 0x00, 0x08, 0x00, 0x88, 0x88, 0x00, 0x81, 0x80, //# #    #  ####  #.# 
0x80, 0x84, 0x00, 0x04, 0x00, 0x40, 0x08, 0x40, 0x11, 0x80, //# #$   $  $  #$ ..# 
0x80, 0x00, 0x04, 0x08, 0x04, 0x04, 0x08, 0x00, 0x81, 0x80, //#    $ # $ $ #  #.# 
0x88, 0x88, 0x04, 0x88, 0x80, 0x00, 0x08, 0x40, 0x11, 0x80, //#### $###    #$ ..# 
0x00, 0x08, 0x00, 0x00, 0x44, 0x08, 0x88, 0x11, 0x11, 0x80, //   #    $$ ###....# 
0x00, 0x08, 0x00, 0x00, 0x00, 0x88, 0x08, 0x88, 0x88, 0x80, //   #      ## ###### 
0x00, 0x08, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //   ########         
//Level: 348
0x08, 0x08,//Size x and y
0x00, 0x08, 0x88, 0x80, //   #### 
0x00, 0x08, 0x00, 0x80, //   #  # 
0x88, 0x88, 0x04, 0x88, //#### $##
0x80, 0x24, 0x10, 0x08, //# @$.  #
0x80, 0x88, 0x00, 0x08, //# ##   #
0x80, 0x00, 0x88, 0x08, //#   ## #
0x80, 0x00, 0x50, 0x18, //#   * .#
0x88, 0x88, 0x88, 0x88, //########
//Level: 349
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x08, 0x88, 0x88, //#  #####
0x80, 0x08, 0x88, 0x88, //#  #####
0x80, 0x15, 0x00, 0x08, //# .*   #
0x88, 0x40, 0x00, 0x08, //##$    #
0x88, 0x08, 0x48, 0x88, //## #$###
0x88, 0x10, 0x28, 0x88, //##. @###
0x88, 0x88, 0x88, 0x88, //########
//Level: 350
0x09, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x82, 0x00, 0x40, 0x10, 0x80, //#@  $ . # 
0x80, 0x40, 0x41, 0x40, 0x80, //# $ $.$ # 
0x81, 0x51, 0x51, 0x51, 0x80, //#.*.*.*.# 
0x80, 0x41, 0x40, 0x40, 0x80, //# $.$ $ # 
0x80, 0x10, 0x40, 0x00, 0x80, //# . $   # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 351
0x07, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x80, //####### 
0x81, 0x01, 0x01, 0x80, //#. . .# 
0x80, 0x44, 0x40, 0x80, //# $$$ # 
0x81, 0x42, 0x41, 0x80, //#.$@$.# 
0x80, 0x44, 0x40, 0x80, //# $$$ # 
0x81, 0x01, 0x01, 0x80, //#. . .# 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 352
0x09, 0x07,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
0x82, 0x01, 0x00, 0x00, 0x80, //#@ .    # 
0x80, 0x44, 0x14, 0x40, 0x80, //# $$.$$ # 
0x81, 0x51, 0x11, 0x51, 0x80, //#.*...*.# 
0x80, 0x44, 0x14, 0x40, 0x80, //# $$.$$ # 
0x80, 0x41, 0x00, 0x00, 0x80, //# $.    # 
0x88, 0x88, 0x88, 0x88, 0x80, //######### 
//Level: 353
0x14, 0x0F,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x80, 0x00, 0x08, 0x80, 0x00, 0x80, 0x00, 0x08, 0x00, 0x08, //#    ##   #    #   #
0x80, 0x04, 0x00, 0x40, 0x00, 0x00, 0x88, 0x04, 0x00, 0x08, //#  $  $     ## $   #
0x88, 0x08, 0x88, 0x88, 0x00, 0x18, 0x88, 0x88, 0x80, 0x88, //## #####  .###### ##
0x08, 0x08, 0x80, 0x08, 0x81, 0x11, 0x18, 0x88, 0x80, 0x88, // # ##  ##....#### ##
0x88, 0x08, 0x84, 0x08, 0x88, 0x11, 0x88, 0x00, 0x00, 0x08, //## ##$ ###..##     #
0x80, 0x00, 0x00, 0x08, 0x11, 0x10, 0x18, 0x04, 0x04, 0x08, //#      #... .# $ $ #
0x80, 0x40, 0x88, 0x08, 0x80, 0x10, 0x88, 0x80, 0x88, 0x88, //# $ ## ## . ### ####
0x80, 0x80, 0x40, 0x00, 0x08, 0x18, 0x80, 0x80, 0x80, 0x00, //# # $    #.## # #   
0x80, 0x40, 0x40, 0x80, 0x00, 0x18, 0x88, 0x80, 0x88, 0x00, //# $ $ #   .#### ##  
0x80, 0x80, 0x08, 0x80, 0x80, 0x88, 0x00, 0x80, 0x08, 0x80, //# #  ## # ##  #  ## 
0x88, 0x88, 0x88, 0x80, 0x04, 0x88, 0x40, 0x00, 0x40, 0x80, //#######  $##$   $ # 
0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 0x40, 0x82, 0x80, //      ##      $ #@# 
0x00, 0x00, 0x00, 0x08, 0x00, 0x88, 0x08, 0x88, 0x88, 0x80, //       #  ## ###### 
0x00, 0x00, 0x00, 0x08, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, //       #######      
//Level: 354
0x0D, 0x10,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //  #########   
0x00, 0x85, 0x15, 0x85, 0x15, 0x80, 0x00, //  #*.*#*.*#   
0x00, 0x81, 0x51, 0x51, 0x51, 0x80, 0x00, //  #.*.*.*.#   
0x00, 0x85, 0x15, 0x15, 0x15, 0x80, 0x00, //  #*.*.*.*#   
0x00, 0x81, 0x51, 0x51, 0x51, 0x80, 0x00, //  #.*.*.*.#   
0x00, 0x85, 0x15, 0x15, 0x15, 0x80, 0x00, //  #*.*.*.*#   
0x00, 0x88, 0x80, 0x00, 0x88, 0x80, 0x00, //  ###   ###   
0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, //    #   #     
0x88, 0x88, 0x88, 0x08, 0x88, 0x88, 0x80, //###### ###### 
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, //#           # 
0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, //# $ $ $ $ $ # 
0x88, 0x04, 0x04, 0x04, 0x04, 0x08, 0x80, //## $ $ $ $ ## 
0x08, 0x40, 0x40, 0x40, 0x40, 0x48, 0x00, // #$ $ $ $ $#  
0x08, 0x00, 0x04, 0x24, 0x00, 0x08, 0x00, // #   $@$   #  
0x08, 0x00, 0x88, 0x88, 0x80, 0x08, 0x00, // #  #####  #  
0x08, 0x88, 0x80, 0x00, 0x88, 0x88, 0x00, // ####   ####  
//Level: 355
0x05, 0x08,//Size x and y
0x88, 0x88, 0x00, //####  
0x80, 0x28, 0x00, //# @#  
0x80, 0x48, 0x80, //# $## 
0x80, 0x41, 0x80, //# $.# 
0x80, 0x41, 0x80, //# $.# 
0x80, 0x41, 0x80, //# $.# 
0x88, 0x81, 0x80, //###.# 
0x00, 0x88, 0x80, //  ### 
//Level: 356
0x0D, 0x0A,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, //###########   
0x82, 0x40, 0x00, 0x11, 0x11, 0x88, 0x00, //#@$   ....##  
0x80, 0x44, 0x44, 0x81, 0x11, 0x18, 0x00, //# $$$$#....#  
0x80, 0x40, 0x04, 0x11, 0x55, 0x58, 0x80, //# $  $..***## 
0x88, 0x00, 0x08, 0x08, 0x81, 0x10, 0x80, //##   # ##.. # 
0x80, 0x44, 0x48, 0x00, 0x88, 0x00, 0x80, //# $$$#  ##  # 
0x80, 0x00, 0x08, 0x80, 0x80, 0x08, 0x80, //#    ## #  ## 
0x80, 0x04, 0x40, 0x80, 0x00, 0x08, 0x00, //#  $$ #    #  
0x80, 0x00, 0x00, 0x88, 0x80, 0x08, 0x00, //#     ###  #  
0x88, 0x88, 0x88, 0x80, 0x88, 0x88, 0x00, //####### ####  
//Level: 357
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x81, 0x01, 0x88, 0x88, //#. .####
0x81, 0x84, 0x40, 0x88, //#.#$$ ##
0x80, 0x00, 0x20, 0x88, //#   @ ##
0x80, 0x48, 0x00, 0x88, //# $#  ##
0x88, 0x00, 0x08, 0x88, //##   ###
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
//Level: 358
0x13, 0x13,//Size x and y
0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, // # # # # # # # # #  
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, //# # # # # # # #.# # 
0x08, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, 0x00, // #...          $.#  
0x80, 0x04, 0x84, 0x00, 0x80, 0x80, 0x80, 0x40, 0x00, 0x80, //#  $#$  # # # $   # 
0x08, 0x10, 0x04, 0x08, 0x08, 0x08, 0x08, 0x04, 0x18, 0x00, // #.  $ # # # # $.#  
0x80, 0x80, 0x40, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, //# # $ #       #   # 
0x08, 0x00, 0x08, 0x00, 0x88, 0x88, 0x80, 0x08, 0x08, 0x00, // #   #  #####  # #  
0x80, 0x00, 0x80, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x80, //#   #  #     # #  # 
0x08, 0x08, 0x00, 0x80, 0x08, 0x88, 0x08, 0x08, 0x08, 0x00, // # #  #  ### # # #  
0x80, 0x01, 0x40, 0x10, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, //#  .$ . #         # 
0x08, 0x08, 0x40, 0x80, 0x80, 0x08, 0x08, 0x08, 0x08, 0x00, // # #$ # #  # # # #  
0x80, 0x08, 0x00, 0x80, 0x08, 0x48, 0x08, 0x08, 0x00, 0x80, //#  #  #  #$# # #  # 
0x08, 0x01, 0x80, 0x08, 0x00, 0x08, 0x08, 0x08, 0x28, 0x00, // # .#  #   # # #@#  
0x80, 0x00, 0x08, 0x00, 0x88, 0x80, 0x48, 0x08, 0x00, 0x80, //#    #  ### $# #  # 
0x08, 0x04, 0x40, 0x80, 0x00, 0x00, 0x41, 0x18, 0x48, 0x00, // # $$ #     $..#$#  
0x80, 0x81, 0x00, 0x08, 0x88, 0x88, 0x84, 0x88, 0x10, 0x80, //# #.   ######$##. # 
0x08, 0x08, 0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x00, // # #.$      .   .#  
0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, //# # # # # # # # # # 
0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, // # # # # # # # # #  
//Level: 359
0x14, 0x11,//Size x and y
0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, // ################## 
0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x11, 0x81, 0x88, // #   $       ...#.##
0x08, 0x00, 0x00, 0x00, 0x08, 0x88, 0x81, 0x11, 0x11, 0x08, // #       ####..... #
0x08, 0x08, 0x88, 0x88, 0x88, 0x00, 0x81, 0x11, 0x11, 0x08, // # #######  #..... #
0x08, 0x08, 0x00, 0x00, 0x40, 0x40, 0x88, 0x11, 0x11, 0x88, // # #    $ $ ##....##
0x08, 0x08, 0x00, 0x40, 0x80, 0x80, 0x88, 0x81, 0x11, 0x80, // # #  $ # # ###...# 
0x08, 0x08, 0x04, 0x24, 0x04, 0x00, 0x88, 0x88, 0x80, 0x80, // # # $@$ $  ##### # 
0x88, 0x08, 0x00, 0x40, 0x04, 0x04, 0x40, 0x00, 0x40, 0x80, //## #  $  $ $$   $ # 
0x80, 0x08, 0x48, 0x04, 0x80, 0x00, 0x80, 0x48, 0x80, 0x80, //#  #$# $#   # $## # 
0x80, 0x88, 0x00, 0x00, 0x88, 0x08, 0x80, 0x40, 0x80, 0x80, //# ##    ## ## $ # # 
0x80, 0x80, 0x48, 0x04, 0x04, 0x00, 0x80, 0x00, 0x00, 0x80, //# # $# $ $  #     # 
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x80, //# #         ####### 
0x80, 0x88, 0x88, 0x88, 0x88, 0x48, 0x80, 0x00, 0x80, 0x00, //# ########$##   #   
0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x40, 0x00, 0x80, 0x00, //#        #  $   #   
0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x88, 0x88, 0x80, 0x00, //########    #####   
0x00, 0x00, 0x00, 0x08, 0x88, 0x00, 0x80, 0x00, 0x00, 0x00, //       ###  #       
0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, 0x00, //         ####       
//Level: 360
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x81, 0x00, 0x88, 0x88, //#.  ####
0x80, 0x80, 0x00, 0x88, //# #   ##
0x80, 0x10, 0x80, 0x88, //# . # ##
0x80, 0x45, 0x40, 0x88, //# $*$ ##
0x88, 0x20, 0x88, 0x88, //##@ ####
0x88, 0x00, 0x88, 0x88, //##  ####
0x88, 0x88, 0x88, 0x88, //########
//Level: 361
0x13, 0x11,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //      #####         
0x00, 0x00, 0x08, 0x80, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, //     ##   ##        
0x00, 0x00, 0x88, 0x00, 0x50, 0x08, 0x80, 0x00, 0x00, 0x00, //    ##  *  ##       
0x00, 0x08, 0x80, 0x05, 0x05, 0x00, 0x88, 0x00, 0x00, 0x00, //   ##  * *  ##      
0x00, 0x88, 0x00, 0x50, 0x50, 0x50, 0x08, 0x80, 0x00, 0x00, //  ##  * * *  ##     
0x08, 0x80, 0x05, 0x05, 0x05, 0x05, 0x00, 0x88, 0x88, 0x00, // ##  * * * *  ####  
0x88, 0x00, 0x50, 0x50, 0x50, 0x50, 0x50, 0x08, 0x08, 0x80, //##  * * * * *  # ## 
0x80, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x80, //#  * * * * * *    # 
0x80, 0x50, 0x50, 0x50, 0x10, 0x50, 0x50, 0x52, 0x40, 0x80, //# * * * . * * *@$ # 
0x80, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x80, //#  * * * * * *    # 
0x88, 0x00, 0x50, 0x50, 0x50, 0x50, 0x50, 0x08, 0x08, 0x80, //##  * * * * *  # ## 
0x08, 0x80, 0x05, 0x05, 0x05, 0x05, 0x00, 0x88, 0x88, 0x00, // ##  * * * *  ####  
0x00, 0x88, 0x00, 0x50, 0x50, 0x50, 0x08, 0x80, 0x00, 0x00, //  ##  * * *  ##     
0x00, 0x08, 0x80, 0x05, 0x05, 0x00, 0x88, 0x00, 0x00, 0x00, //   ##  * *  ##      
0x00, 0x00, 0x88, 0x00, 0x50, 0x08, 0x80, 0x00, 0x00, 0x00, //    ##  *  ##       
0x00, 0x00, 0x08, 0x80, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, //     ##   ##        
0x00, 0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //      #####         
//Level: 362
0x07, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x00, //######  
0x80, 0x10, 0x08, 0x00, //# .  #  
0x80, 0x08, 0x28, 0x00, //#  #@#  
0x80, 0x04, 0x08, 0x80, //#  $ ## 
0x88, 0x48, 0x00, 0x80, //##$#  # 
0x80, 0x00, 0x80, 0x80, //#   # # 
0x81, 0x05, 0x00, 0x80, //#. *  # 
0x88, 0x88, 0x88, 0x80, //####### 
//Level: 363
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x00, 0x12, 0x08, //##  .@ #
0x88, 0x08, 0x18, 0x08, //## #.# #
0x88, 0x00, 0x04, 0x08, //##   $ #
0x88, 0x14, 0x40, 0x88, //##.$$ ##
0x88, 0x00, 0x88, 0x88, //##  ####
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
//Level: 364
0x13, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x00, 0x00, 0x08, 0x88, 0x80, 0x00, 0x00, //######     ####     
0x80, 0x00, 0x08, 0x88, 0x88, 0x88, 0x00, 0x88, 0x88, 0x80, //#    #######  ##### 
0x80, 0x00, 0x48, 0x00, 0x80, 0x04, 0x00, 0x80, 0x00, 0x80, //#   $#  #  $  #   # 
0x80, 0x04, 0x00, 0x40, 0x04, 0x08, 0x04, 0x04, 0x00, 0x80, //#  $  $  $ # $ $  # 
0x88, 0x40, 0x40, 0x00, 0x80, 0x28, 0x04, 0x00, 0x00, 0x80, //##$ $   # @# $    # 
0x80, 0x04, 0x08, 0x88, 0x88, 0x88, 0x88, 0x88, 0x08, 0x80, //#  $ ########### ## 
0x80, 0x80, 0x00, 0x81, 0x11, 0x11, 0x11, 0x80, 0x48, 0x00, //# #   #.......# $#  
0x80, 0x88, 0x00, 0x80, 0x11, 0x11, 0x11, 0x80, 0x08, 0x00, //# ##  # ......#  #  
0x80, 0x80, 0x00, 0x41, 0x11, 0x11, 0x11, 0x14, 0x08, 0x00, //# #   $........$ #  
0x80, 0x80, 0x40, 0x81, 0x11, 0x10, 0x11, 0x80, 0x08, 0x00, //# # $ #.... ..#  #  
0x80, 0x04, 0x04, 0x88, 0x88, 0x48, 0x88, 0x80, 0x48, 0x00, //#  $ $####$#### $#  
0x80, 0x40, 0x00, 0x88, 0x80, 0x40, 0x00, 0x40, 0x08, 0x80, //# $   ### $   $  ## 
0x80, 0x40, 0x00, 0x00, 0x40, 0x40, 0x04, 0x00, 0x00, 0x80, //# $     $ $  $    # 
0x88, 0x08, 0x88, 0x88, 0x80, 0x40, 0x88, 0x88, 0x80, 0x80, //## ###### $ ##### # 
0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, //#         #       # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //################### 
//Level: 365
0x14, 0x12,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x80, 0x88, 0x88, 0x88, 0x00, 0x00, //  ####### ######    
0x08, 0x80, 0x00, 0x00, 0x88, 0x80, 0x00, 0x08, 0x00, 0x00, // ##     ###    #    
0x08, 0x00, 0x88, 0x80, 0x00, 0x80, 0x44, 0x08, 0x88, 0x00, // #  ###   # $$ ###  
0x08, 0x08, 0x02, 0x08, 0x00, 0x80, 0x04, 0x00, 0x08, 0x00, // # # @ #  #  $   #  
0x08, 0x08, 0x44, 0x48, 0x08, 0x88, 0x84, 0x88, 0x08, 0x88, // # #$$$# ####$## ###
0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x11, 0x18, //##           $ #...#
0x80, 0x08, 0x48, 0x48, 0x80, 0x08, 0x00, 0x08, 0x11, 0x18, //#  #$#$##  #   #...#
0x80, 0x80, 0x04, 0x00, 0x80, 0x80, 0x88, 0x08, 0x11, 0x18, //# #  $  # # ## #...#
0x80, 0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x08, 0x11, 0x18, //# #     # #    #...#
0x80, 0x08, 0x44, 0x48, 0x80, 0x84, 0x00, 0x08, 0x11, 0x18, //#  #$$$## #$   #...#
0x88, 0x00, 0x00, 0x00, 0x00, 0x04, 0x48, 0x88, 0x11, 0x18, //##         $$###...#
0x08, 0x08, 0x48, 0x48, 0x80, 0x84, 0x00, 0x00, 0x11, 0x18, // # #$#$## #$    ...#
0x08, 0x08, 0x00, 0x00, 0x80, 0x80, 0x40, 0x00, 0x11, 0x18, // # #    # # $   ...#
0x08, 0x08, 0x00, 0x00, 0x80, 0x80, 0x08, 0x88, 0x88, 0x88, // # #    # #  #######
0x08, 0x08, 0x44, 0x48, 0x80, 0x80, 0x08, 0x00, 0x00, 0x00, // # #$$$## #  #      
0x08, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, // #        ####      
0x08, 0x88, 0x00, 0x00, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, // ###    ###         
0x00, 0x08, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //   ######           
//Level: 366
0x0E, 0x10,//Size x and y
0x00, 0x00, 0x00, 0x88, 0x80, 0x00, 0x00, //      ###     
0x08, 0x88, 0x88, 0x82, 0x88, 0x88, 0x80, // ######@##### 
0x08, 0x11, 0x11, 0x11, 0x11, 0x11, 0x80, // #..........# 
0x88, 0x15, 0x55, 0x55, 0x55, 0x51, 0x88, //##.********.##
0x81, 0x15, 0x11, 0x11, 0x11, 0x51, 0x18, //#..*......*..#
0x81, 0x15, 0x15, 0x55, 0x51, 0x51, 0x18, //#..*.****.*..#
0x88, 0x88, 0x88, 0x11, 0x88, 0x88, 0x88, //######..######
0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, // #          # 
0x08, 0x04, 0x04, 0x44, 0x40, 0x40, 0x80, // # $ $$$$ $ # 
0x08, 0x44, 0x40, 0x00, 0x04, 0x44, 0x80, // #$$$    $$$# 
0x08, 0x00, 0x04, 0x44, 0x40, 0x00, 0x80, // #   $$$$   # 
0x08, 0x40, 0x40, 0x00, 0x04, 0x04, 0x80, // #$ $    $ $# 
0x88, 0x00, 0x04, 0x44, 0x40, 0x00, 0x88, //##   $$$$   ##
0x80, 0x44, 0x40, 0x00, 0x04, 0x44, 0x08, //# $$$    $$$ #
0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x08, //#     #      #
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //##############
//Level: 367
0x14, 0x10,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
0x81, 0x18, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x08, //#..#    #          #
0x81, 0x40, 0x04, 0x00, 0x84, 0x40, 0x04, 0x88, 0x04, 0x88, //#.$  $  #$$  $## $##
0x81, 0x48, 0x00, 0x88, 0x80, 0x08, 0x80, 0x88, 0x00, 0x08, //#.$#  ###  ## ##   #
0x80, 0x08, 0x04, 0x08, 0x00, 0x44, 0x00, 0x04, 0x00, 0x08, //#  # $ #  $$   $   #
0x80, 0x88, 0x80, 0x08, 0x08, 0x00, 0x84, 0x00, 0x88, 0x88, //# ###  # #  #$  ####
0x80, 0x08, 0x80, 0x80, 0x40, 0x00, 0x82, 0x08, 0x00, 0x08, //#  ## # $   #@ #   #
0x80, 0x40, 0x00, 0x04, 0x00, 0x88, 0x18, 0x80, 0x04, 0x08, //# $    $  ##.##  $ #
0x80, 0x08, 0x04, 0x80, 0x48, 0x04, 0x00, 0x00, 0x08, 0x88, //#  # $# $# $     ###
0x80, 0x08, 0x00, 0x80, 0x08, 0x00, 0x08, 0x88, 0x00, 0x08, //#  #  #  #   ###   #
0x80, 0x08, 0x88, 0x88, 0x88, 0x80, 0x80, 0x00, 0x00, 0x08, //#  ######## #      #
0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0x18, 0x18, //#           #  #.#.#
0x88, 0x48, 0x88, 0x88, 0x88, 0x84, 0x80, 0x00, 0x11, 0x18, //##$########$#   ...#
0x80, 0x00, 0x01, 0x50, 0x08, 0x00, 0x00, 0x88, 0x18, 0x18, //#    .*  #    ##.#.#
0x80, 0x15, 0x11, 0x15, 0x00, 0x04, 0x00, 0x11, 0x11, 0x18, //# .*...*   $  .....#
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, //####################
//Level: 368
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
0x81, 0x00, 0x21, 0x88, //#.  @.##
0x80, 0x04, 0x80, 0x88, //#  $# ##
0x80, 0x80, 0x41, 0x08, //# # $. #
0x80, 0x00, 0x48, 0x08, //#   $# #
0x88, 0x88, 0x00, 0x08, //####   #
0x88, 0x88, 0x88, 0x88, //########
//Level: 369
0x0B, 0x09,//Size x and y
0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //  ######### 
0x88, 0x80, 0x00, 0x80, 0x00, 0x80, //###   #   # 
0x80, 0x04, 0x10, 0x50, 0x40, 0x80, //#  $. * $ # 
0x80, 0x81, 0x81, 0x81, 0x80, 0x80, //# #.#.#.# # 
0x80, 0x40, 0x42, 0x40, 0x40, 0x80, //# $ $@$ $ # 
0x80, 0x81, 0x81, 0x81, 0x80, 0x80, //# #.#.#.# # 
0x80, 0x40, 0x50, 0x14, 0x00, 0x80, //# $ * .$  # 
0x80, 0x00, 0x88, 0x88, 0x88, 0x80, //#   ####### 
0x88, 0x88, 0x80, 0x00, 0x00, 0x00, //#####       
//Level: 370
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x80, 0x01, 0x08, //###  . #
0x88, 0x05, 0x08, 0x08, //## * # #
0x88, 0x01, 0x40, 0x08, //## .$  #
0x88, 0x00, 0x84, 0x88, //##  #$##
0x88, 0x80, 0x20, 0x88, //### @ ##
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
//Level: 371
0x08, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, //########
0x80, 0x11, 0x88, 0x88, //# ..####
0x80, 0x40, 0x00, 0x08, //# $    #
0x80, 0x08, 0x48, 0x08, //#  #$# #
0x80, 0x20, 0x14, 0x08, //# @ .$ #
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
0x88, 0x88, 0x88, 0x88, //########
//Level: 372
0x0B, 0x08,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //##########  
0x80, 0x00, 0x00, 0x00, 0x08, 0x80, //#        ## 
0x80, 0x48, 0x48, 0x48, 0x42, 0x80, //# $#$#$#$@# 
0x81, 0x01, 0x41, 0x11, 0x41, 0x80, //#. .$...$.# 
0x81, 0x01, 0x41, 0x11, 0x41, 0x80, //#. .$...$.# 
0x80, 0x48, 0x48, 0x48, 0x48, 0x80, //# $#$#$#$## 
0x80, 0x00, 0x00, 0x00, 0x08, 0x00, //#        #  
0x88, 0x88, 0x88, 0x88, 0x88, 0x00, //##########  
//Level: 373
0x0F, 0x0D,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
0x80, 0x01, 0x11, 0x11, 0x11, 0x11, 0x00, 0x80, //#  .........  # 
0x80, 0x44, 0x44, 0x44, 0x44, 0x41, 0x40, 0x80, //# $$$$$$$$$.$ # 
0x80, 0x41, 0x11, 0x11, 0x11, 0x41, 0x40, 0x80, //# $.......$.$ # 
0x80, 0x41, 0x44, 0x44, 0x41, 0x41, 0x40, 0x80, //# $.$$$$$.$.$ # 
0x80, 0x41, 0x41, 0x11, 0x41, 0x41, 0x40, 0x80, //# $.$...$.$.$ # 
0x80, 0x41, 0x41, 0x45, 0x41, 0x41, 0x42, 0x80, //# $.$.$*$.$.$@# 
0x80, 0x41, 0x41, 0x41, 0x11, 0x41, 0x40, 0x80, //# $.$.$...$.$ # 
0x80, 0x41, 0x41, 0x44, 0x44, 0x41, 0x40, 0x80, //# $.$.$$$$$.$ # 
0x80, 0x41, 0x41, 0x11, 0x11, 0x11, 0x40, 0x80, //# $.$.......$ # 
0x80, 0x41, 0x44, 0x44, 0x44, 0x44, 0x40, 0x80, //# $.$$$$$$$$$ # 
0x80, 0x01, 0x11, 0x11, 0x11, 0x11, 0x00, 0x80, //#  .........  # 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //############### 
//Level: 374
0x11, 0x12,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, //    #########     
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, //    #       #     
0x00, 0x08, 0x80, 0x40, 0x40, 0x40, 0x88, 0x00, 0x00, //   ## $ $ $ ##    
0x88, 0x88, 0x00, 0x04, 0x04, 0x40, 0x08, 0x88, 0x80, //####   $ $$  #### 
0x80, 0x00, 0x80, 0x40, 0x04, 0x00, 0x80, 0x00, 0x80, //#   # $  $  #   # 
0x80, 0x44, 0x08, 0x04, 0x04, 0x08, 0x04, 0x40, 0x80, //# $$ # $ $ # $$ # 
0x80, 0x00, 0x40, 0x84, 0x04, 0x80, 0x04, 0x00, 0x80, //#   $ #$ $#  $  # 
0x80, 0x04, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x80, //#  $   $ $    $ # 
0x80, 0x40, 0x40, 0x80, 0x40, 0x80, 0x44, 0x00, 0x80, //# $ $ # $ # $$  # 
0x80, 0x40, 0x08, 0x88, 0x08, 0x88, 0x00, 0x40, 0x80, //# $  ### ###  $ # 
0x80, 0x00, 0x88, 0x08, 0x08, 0x08, 0x80, 0x00, 0x80, //#   ## # # ##   # 
0x88, 0x88, 0x80, 0x08, 0x28, 0x00, 0x88, 0x88, 0x80, //#####  #@#  ##### 
0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, //       # #        
0x00, 0x00, 0x00, 0x88, 0x08, 0x80, 0x00, 0x00, 0x00, //      ## ##       
0x88, 0x88, 0x88, 0x81, 0x01, 0x88, 0x88, 0x88, 0x80, //#######. .####### 
0x81, 0x11, 0x11, 0x10, 0x10, 0x11, 0x11, 0x11, 0x80, //#...... . ......# 
0x81, 0x11, 0x11, 0x11, 0x10, 0x11, 0x11, 0x11, 0x80, //#........ ......# 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //################# 
//Level: 375
0x15, 0x11,//Size x and y
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, //##################### 
0x81, 0x00, 0x81, 0x00, 0x81, 0x41, 0x80, 0x01, 0x80, 0x01, 0x80, //#.  #.  #.$.#  .#  .# 
0x80, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x80, //# #   #   #   #   # # 
0x80, 0x01, 0x80, 0x00, 0x10, 0x40, 0x10, 0x00, 0x81, 0x00, 0x80, //#  .#   . $ .   #.  # 
0x80, 0x80, 0x01, 0x84, 0x40, 0x80, 0x44, 0x81, 0x00, 0x80, 0x80, //# #  .#$$ # $$#.  # # 
0x80, 0x01, 0x80, 0x00, 0x80, 0x40, 0x80, 0x00, 0x81, 0x00, 0x80, //#  .#   # $ #   #.  # 
0x80, 0x80, 0x00, 0x84, 0x40, 0x80, 0x44, 0x80, 0x00, 0x80, 0x80, //# #   #$$ # $$#   # # 
0x80, 0x01, 0x80, 0x00, 0x80, 0x40, 0x80, 0x00, 0x81, 0x00, 0x80, //#  .#   # $ #   #.  # 
0x82, 0x80, 0x00, 0x84, 0x44, 0x54, 0x44, 0x80, 0x00, 0x80, 0x80, //#@#   #$$$*$$$#   # # 
0x80, 0x01, 0x10, 0x00, 0x80, 0x40, 0x80, 0x00, 0x11, 0x00, 0x80, //#  ..   # $ #   ..  # 
0x80, 0x80, 0x00, 0x84, 0x40, 0x80, 0x44, 0x80, 0x00, 0x80, 0x80, //# #   #$$ # $$#   # # 
0x80, 0x01, 0x80, 0x00, 0x80, 0x40, 0x80, 0x00, 0x81, 0x00, 0x80, //#  .#   # $ #   #.  # 
0x80, 0x80, 0x01, 0x84, 0x40, 0x80, 0x44, 0x81, 0x00, 0x80, 0x80, //# #  .#$$ # $$#.  # # 
0x80, 0x01, 0x80, 0x00, 0x80, 0x40, 0x80, 0x00, 0x81, 0x00, 0x80, //#  .#   # $ #   #.  # 
0x80, 0x80, 0x00, 0x84, 0x00, 0x80, 0x04, 0x80, 0x00, 0x80, 0x80, //# #   #$  #  $#   # # 
0x81, 0x00, 0x81, 0x00, 0x81, 0x41, 0x80, 0x01, 0x80, 0x01, 0x80, //#.  #.  #.$.#  .#  .# 
0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80  //##################### 
};
#else
#define SOKOBAN_LEVELS	1
const unsigned char Sokoban_Levels[] = {
//Level: 1
0x13, 0x0B,//Size x and y
0x00, 0x00, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //    #####           
0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //    #   #           
0x00, 0x00, 0x84, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, //    #$  #           
0x00, 0x88, 0x80, 0x04, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, //  ###  $##          
0x00, 0x80, 0x04, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, //  #  $ $ #          
0x88, 0x80, 0x80, 0x88, 0x08, 0x00, 0x08, 0x88, 0x88, 0x80, //### # ## #   ###### 
0x80, 0x00, 0x80, 0x88, 0x08, 0x88, 0x88, 0x00, 0x11, 0x80, //#   # ## #####  ..# 
0x80, 0x40, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x80, //# $  $          ..# 
0x88, 0x88, 0x80, 0x88, 0x80, 0x82, 0x88, 0x00, 0x11, 0x80, //##### ### #@##  ..# 
0x00, 0x00, 0x80, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x80, //    #     ######### 
0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00, 0x00, 0x00, //    #######         
};
#endif
#endif
